/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk;

import com.ironsource.sdk.IronSourceAdInstance;
import com.ironsource.sdk.IronSourceNetworkAPIUtils;
import com.ironsource.sdk.listeners.OnInterstitialListener;
import com.ironsource.sdk.utils.SDKUtils;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class IronSourceAdInstanceBuilder {
    private String mName;
    private boolean mRewarded = false;
    private boolean mInAppBidding = false;
    private Map<String, String> mExtraParams;
    private OnInterstitialListener mInterstitialListener;

    public IronSourceAdInstanceBuilder(String name, OnInterstitialListener interstitialListener) throws NullPointerException {
        this.mName = SDKUtils.requireNonEmptyOrNull(name, "Instance name can't be null");
        this.mInterstitialListener = SDKUtils.requireNonNull(interstitialListener, "InterstitialListener name can't be null");
    }

    public IronSourceAdInstanceBuilder setRewarded() {
        this.mRewarded = true;
        return this;
    }

    public IronSourceAdInstanceBuilder setInAppBidding() {
        this.mInAppBidding = true;
        return this;
    }

    public IronSourceAdInstanceBuilder setExtraParams(Map<String, String> extraParams) {
        this.mExtraParams = extraParams;
        return this;
    }

    public IronSourceAdInstance build() {
        JSONObject data = new JSONObject();
        try {
            data.put("name", (Object)this.mName);
            data.put("rewarded", this.mRewarded);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        String id = IronSourceNetworkAPIUtils.generateInstanceId(data);
        return new IronSourceAdInstance(id, this.mName, this.mRewarded, this.mInAppBidding, this.mExtraParams, this.mInterstitialListener);
    }
}

