/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdaptersCompatibilityHandler;
import com.ironsource.mediationsdk.AuctionHandler;
import com.ironsource.mediationsdk.AuctionHandlerCallback;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.ProgRvManagerListener;
import com.ironsource.mediationsdk.ProgRvSmash;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.ProgUtils;
import com.ironsource.mediationsdk.RVListenerWrapper;
import com.ironsource.mediationsdk.RvAuctionTrigger;
import com.ironsource.mediationsdk.RvAuctionTriggerCallback;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.model.RewardedVideoConfigurations;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.SessionCappingManager;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

class ProgRvManager
implements ProgRvManagerListener,
RvAuctionTriggerCallback {
    private final ConcurrentHashMap<String, ProgRvSmash> mSmashes;
    private CopyOnWriteArrayList<ProgRvSmash> mWaterfall;
    private ConcurrentHashMap<String, AuctionResponseItem> mWaterfallServerData;
    private SessionCappingManager mSessionCappingManager;
    private RvAuctionTrigger mRvAuctionTrigger;
    private AuctionHandler mAuctionHandler;
    private Context mAppContext;
    private String mCurrentPlacement;
    private String mCurrentAuctionId;
    private long mAuctionStartTime;
    private long mLastChangedAvailabilityTime;
    private int mMaxSmashesToLoad;
    private boolean mIsShowingVideo;
    private Boolean mLastReportedAvailabilityState;
    private RV_MEDIATION_STATE mState;

    public ProgRvManager(Activity activity, List<ProviderSettings> providersList, RewardedVideoConfigurations configs, String appKey, String userId) {
        this.setState(RV_MEDIATION_STATE.RV_STATE_INITIATING);
        this.mAppContext = activity.getApplicationContext();
        this.mLastReportedAvailabilityState = null;
        this.mMaxSmashesToLoad = configs.getRewardedVideoAdaptersSmartLoadAmount();
        this.mCurrentPlacement = "";
        AuctionSettings auctionSettings = configs.getRewardedVideoAuctionSettings();
        this.mIsShowingVideo = false;
        this.mWaterfall = new CopyOnWriteArrayList();
        this.mWaterfallServerData = new ConcurrentHashMap();
        this.mLastChangedAvailabilityTime = new Date().getTime();
        this.mAuctionHandler = new AuctionHandler(this.mAppContext, "rewardedVideo", auctionSettings.getBlob(), auctionSettings.getUrl());
        this.mRvAuctionTrigger = new RvAuctionTrigger(auctionSettings, this);
        this.mSmashes = new ConcurrentHashMap();
        for (ProviderSettings provider : providersList) {
            AbstractAdapter adapter = ProgUtils.loadAdapter(provider);
            if (adapter == null || !AdaptersCompatibilityHandler.getInstance().isAdapterVersionRVCompatible(adapter)) continue;
            IronSourceObject.getInstance().addToRVAdaptersList(adapter);
            ProgRvSmash smash = new ProgRvSmash(activity, appKey, userId, provider, this, configs.getRewardedVideoAdaptersSmartLoadTimeout(), adapter);
            this.mSmashes.put(smash.getInstanceName(), smash);
        }
        this.mSessionCappingManager = new SessionCappingManager(new ArrayList<ProgSmash>(this.mSmashes.values()));
        for (ProgRvSmash smash : this.mSmashes.values()) {
            if (!smash.isBidder()) continue;
            smash.initForBidding();
        }
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                ProgRvManager.this.makeAuction();
            }
        }, auctionSettings.getTimeToWaitBeforeFirstAuctionMs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void showRewardedVideo(Placement placement) {
        if (placement == null) {
            String message = "showRewardedVideo error: empty default placement in response";
            this.logInternal(message);
            IronSourceError error = new IronSourceError(1021, message);
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.sendMediationEvent(1113, new Object[][]{{"errorCode", 1021}}, false, true);
            return;
        }
        this.mCurrentPlacement = placement.getPlacementName();
        this.logApi("showRewardedVideo() placement=" + this.mCurrentPlacement);
        this.sendMediationEventWithPlacement(1100);
        if (this.mIsShowingVideo) {
            String message = "showRewardedVideo error: can't show ad while an ad is already showing. State: " + (Object)((Object)this.mState);
            this.logInternal(message);
            IronSourceError error = new IronSourceError(1022, message);
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", 1022}});
            return;
        }
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
            String message = "showRewardedVideo error: show called while no ads are available";
            this.logInternal(message);
            IronSourceError error = new IronSourceError(1023, message);
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", 1023}});
            return;
        }
        if (CappingManager.isRvPlacementCapped(this.mAppContext, this.mCurrentPlacement)) {
            String message = "placement " + this.mCurrentPlacement + " is capped";
            this.logInternal(message);
            IronSourceError error = new IronSourceError(524, message);
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", 524}});
            return;
        }
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mWaterfall) {
                if (smash.isReadyToShow()) {
                    this.mIsShowingVideo = true;
                    smash.reportShowChance(true);
                    this.showVideo(smash, placement);
                    this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_LOADED);
                    this.mRvAuctionTrigger.showStart();
                    return;
                }
                smash.reportShowChance(false);
            }
        }
        this.logApi("showRewardedVideo(): No ads to show ");
        RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError("Rewarded Video"));
        this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", 509}});
        this.mRvAuctionTrigger.showError();
    }

    private void showVideo(ProgRvSmash smash, Placement placement) {
        this.logInternal("showVideo()");
        this.mSessionCappingManager.increaseShowCounter(smash);
        if (this.mSessionCappingManager.isCapped(smash)) {
            smash.setCappedPerSession();
            this.logInternal(smash.getInstanceName() + " rewarded video is now session capped");
        }
        CappingManager.incrementRvShowCounter(this.mAppContext, placement.getPlacementName());
        if (CappingManager.isRvPlacementCapped(this.mAppContext, placement.getPlacementName())) {
            this.sendMediationEventWithPlacement(1400);
        }
        smash.showVideo(placement);
    }

    public synchronized boolean isRewardedVideoAvailable() {
        return this.isRewardedVideoAvailableInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRewardedVideoAvailableInternal() {
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW || this.mIsShowingVideo) {
            return false;
        }
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mWaterfall) {
                if (!smash.isReadyToShow()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume(Activity activity) {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mSmashes.values()) {
                smash.onResume(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPause(Activity activity) {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mSmashes.values()) {
                smash.onPause(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsent(boolean consent) {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mSmashes.values()) {
                smash.setConsent(consent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAuction() {
        this.logInternal("makeAuction()");
        this.setState(RV_MEDIATION_STATE.RV_STATE_AUCTION_IN_PROGRESS);
        this.mCurrentAuctionId = "";
        this.mAuctionStartTime = new Date().getTime();
        HashMap<String, Object> bidderCandidates = new HashMap<String, Object>();
        ArrayList<String> noBidderCandidates = new ArrayList<String>();
        StringBuilder waterfallStr = new StringBuilder();
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mSmashes.values()) {
                smash.unloadVideo();
                if (this.mSessionCappingManager.isCapped(smash)) continue;
                if (smash.isBidder() && smash.isReadyToBid()) {
                    Map<String, Object> biddingData = smash.getBiddingData();
                    if (biddingData == null) continue;
                    bidderCandidates.put(smash.getInstanceName(), biddingData);
                    waterfallStr.append("2" + smash.getInstanceName() + ",");
                    continue;
                }
                if (smash.isBidder()) continue;
                noBidderCandidates.add(smash.getInstanceName());
                waterfallStr.append("1" + smash.getInstanceName() + ",");
            }
        }
        if (bidderCandidates.keySet().size() == 0 && noBidderCandidates.size() == 0) {
            this.logInternal("makeAuction() failed - request waterfall is empty");
            this.reportAvailabilityIfNeeded(false);
            this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_LOADED);
            this.mRvAuctionTrigger.loadError();
            return;
        }
        this.logInternal("makeAuction() - request waterfall is: " + waterfallStr);
        if (waterfallStr.length() > 256) {
            waterfallStr.setLength(256);
        } else {
            waterfallStr.deleteCharAt(waterfallStr.length() - 1);
        }
        this.sendMediationEventWithoutAuctionId(1000);
        this.sendMediationEventWithoutAuctionId(1300);
        this.sendMediationEventWithoutAuctionId(1310, new Object[][]{{"ext1", waterfallStr.toString()}});
        int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(1);
        this.mAuctionHandler.executeAuction(bidderCandidates, noBidderCandidates, sessionDepth, new AuctionHandlerCallback(){

            @Override
            public void callback(boolean isSuccess, List<AuctionResponseItem> newWaterfall, String auctionId, int errorCode, String errorMessage, long elapsedTime) {
                if (isSuccess) {
                    ProgRvManager.this.logInternal("makeAuction(): success");
                    ProgRvManager.this.mCurrentAuctionId = auctionId;
                    ProgRvManager.this.sendMediationEvent(1302, new Object[][]{{"duration", elapsedTime}});
                    ProgRvManager.this.updateWaterfall(newWaterfall);
                    ProgRvManager.this.loadSmashes();
                } else {
                    ProgRvManager.this.logInternal("makeAuction(): failed");
                    if (TextUtils.isEmpty((CharSequence)errorMessage)) {
                        ProgRvManager.this.sendMediationEventWithoutAuctionId(1301, new Object[][]{{"errorCode", errorCode}, {"duration", elapsedTime}});
                    } else {
                        String errorReason = errorMessage.substring(0, Math.min(errorMessage.length(), 39));
                        ProgRvManager.this.sendMediationEventWithoutAuctionId(1301, new Object[][]{{"errorCode", errorCode}, {"reason", errorReason}, {"duration", elapsedTime}});
                    }
                    ProgRvManager.this.reportAvailabilityIfNeeded(false);
                    ProgRvManager.this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_LOADED);
                    ProgRvManager.this.mRvAuctionTrigger.loadError();
                }
            }
        });
    }

    private String getAsString(AuctionResponseItem item) {
        String isProgrammatic = TextUtils.isEmpty((CharSequence)item.getServerData()) ? "1" : "2";
        return isProgrammatic + item.getInstanceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWaterfall(List<AuctionResponseItem> waterfall) {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            this.mWaterfall.clear();
            this.mWaterfallServerData.clear();
            StringBuilder waterfallStr = new StringBuilder();
            for (AuctionResponseItem item : waterfall) {
                waterfallStr.append(this.getAsString(item) + ",");
                ProgRvSmash smash = this.mSmashes.get(item.getInstanceName());
                if (smash == null) continue;
                smash.setIsLoadCandidate(true);
                this.mWaterfall.add(smash);
                this.mWaterfallServerData.put(smash.getInstanceName(), item);
            }
            if (waterfallStr.length() > 256) {
                waterfallStr.setLength(256);
            } else {
                waterfallStr.deleteCharAt(waterfallStr.length() - 1);
            }
            this.sendMediationEvent(1311, new Object[][]{{"ext1", waterfallStr.toString()}});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSmashes() {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            this.setState(RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES);
            int loadedAdapters = 0;
            for (int i2 = 0; i2 < this.mWaterfall.size() && loadedAdapters < this.mMaxSmashesToLoad; ++i2) {
                ProgRvSmash smash = this.mWaterfall.get(i2);
                if (!smash.getIsLoadCandidate()) continue;
                String serverData = this.mWaterfallServerData.get(smash.getInstanceName()).getServerData();
                smash.loadVideo(serverData, this.mCurrentAuctionId);
                ++loadedAdapters;
            }
        }
    }

    private void setState(RV_MEDIATION_STATE state) {
        this.logInternal("current state=" + (Object)((Object)this.mState) + ", new state=" + (Object)((Object)state));
        this.mState = state;
    }

    @Override
    public synchronized void onLoadSuccess(ProgRvSmash smash, String auctionId) {
        this.logSmashCallback(smash, "onLoadSuccess ");
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES && this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
            this.logErrorInternal("onLoadSuccess was invoked at the wrong manager state: " + (Object)((Object)this.mState));
            return;
        }
        if (!auctionId.equalsIgnoreCase(this.mCurrentAuctionId)) {
            this.logInternal("onLoadSuccess was invoked with auctionId: " + auctionId + " and the current id is " + this.mCurrentAuctionId);
            return;
        }
        this.reportAvailabilityIfNeeded(true);
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
            this.setState(RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW);
            long elapsedTime = new Date().getTime() - this.mAuctionStartTime;
            this.sendMediationEvent(1003, new Object[][]{{"duration", elapsedTime}});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void onLoadError(ProgRvSmash smash, String auctionId) {
        this.logSmashCallback(smash, "onLoadError ");
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES && this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
            this.logErrorInternal("onLoadError was invoked at the wrong manager state: " + (Object)((Object)this.mState));
            return;
        }
        if (!auctionId.equalsIgnoreCase(this.mCurrentAuctionId)) {
            this.logInternal("onLoadError was invoked with auctionId:" + auctionId + " and the current id is " + this.mCurrentAuctionId);
            return;
        }
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            boolean hasLoadInProgress = false;
            boolean hasLoaded = false;
            for (ProgRvSmash waterfallSmash : this.mWaterfall) {
                if (waterfallSmash.getIsLoadCandidate()) {
                    if (this.mWaterfallServerData.get(waterfallSmash.getInstanceName()) == null) continue;
                    String serverData = this.mWaterfallServerData.get(waterfallSmash.getInstanceName()).getServerData();
                    waterfallSmash.loadVideo(serverData, this.mCurrentAuctionId);
                    return;
                }
                if (waterfallSmash.isLoadingInProgress()) {
                    hasLoadInProgress = true;
                    continue;
                }
                if (!waterfallSmash.isReadyToShow()) continue;
                hasLoaded = true;
            }
            if (!hasLoaded && !hasLoadInProgress) {
                this.logInternal("onLoadError(): No other available smashes");
                this.reportAvailabilityIfNeeded(false);
                this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_LOADED);
                this.mRvAuctionTrigger.loadError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdOpened(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdOpened");
            RVListenerWrapper.getInstance().onRewardedVideoAdOpened();
            this.mAuctionHandler.reportImpression(this.mWaterfallServerData.get(smash.getInstanceName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error, ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdShowFailed error=" + error.getErrorMessage());
            String errorReason = error.getErrorMessage().substring(0, Math.min(error.getErrorMessage().length(), 39));
            this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", errorReason}});
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.mIsShowingVideo = false;
            if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
                this.reportAvailabilityIfNeeded(false);
            }
            this.mRvAuctionTrigger.showError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdClosed(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdClosed, mediation state: " + this.mState.name());
            RVListenerWrapper.getInstance().onRewardedVideoAdClosed();
            this.mIsShowingVideo = false;
            if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
                this.reportAvailabilityIfNeeded(false);
            }
            this.mRvAuctionTrigger.showEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdStarted(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdStarted");
            RVListenerWrapper.getInstance().onRewardedVideoAdStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdEnded(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdEnded");
            RVListenerWrapper.getInstance().onRewardedVideoAdEnded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdRewarded(ProgRvSmash smash, Placement placement) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdRewarded");
            RVListenerWrapper.getInstance().onRewardedVideoAdRewarded(placement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdClicked(ProgRvSmash smash, Placement placement) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdClicked");
            RVListenerWrapper.getInstance().onRewardedVideoAdClicked(placement);
        }
    }

    private void reportAvailabilityIfNeeded(boolean isAvailable) {
        if (this.mLastReportedAvailabilityState == null || this.mLastReportedAvailabilityState != isAvailable) {
            this.mLastReportedAvailabilityState = isAvailable;
            long timeSpentInLastAvailability = new Date().getTime() - this.mLastChangedAvailabilityTime;
            this.mLastChangedAvailabilityTime = new Date().getTime();
            if (isAvailable) {
                this.sendMediationEvent(1111, new Object[][]{{"duration", timeSpentInLastAvailability}});
            } else {
                this.sendMediationEvent(1112, new Object[][]{{"duration", timeSpentInLastAvailability}});
            }
            RVListenerWrapper.getInstance().onRewardedVideoAvailabilityChanged(isAvailable);
        }
    }

    private void logSmashCallback(ProgRvSmash smash, String line) {
        String text = smash.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "ProgRvManager: " + text, 0);
    }

    private void logInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "ProgRvManager: " + text, 0);
    }

    private void logErrorInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "ProgRvManager: " + text, 3);
    }

    private void logApi(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, text, 1);
    }

    private void sendMediationEventWithoutAuctionId(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, false, false);
    }

    private void sendMediationEventWithoutAuctionId(int eventId) {
        this.sendMediationEvent(eventId, null, false, false);
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, false, true);
    }

    private void sendMediationEventWithPlacement(int eventId) {
        this.sendMediationEvent(eventId, null, true, true);
    }

    private void sendMediationEventWithPlacement(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, true, true);
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals, boolean isAddPlacement, boolean isAddAuctionId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("provider", "Mediation");
        data.put("programmatic", 1);
        if (isAddAuctionId && !TextUtils.isEmpty((CharSequence)this.mCurrentAuctionId)) {
            data.put("auctionId", this.mCurrentAuctionId);
        }
        if (isAddPlacement && !TextUtils.isEmpty((CharSequence)this.mCurrentPlacement)) {
            data.put("placement", this.mCurrentPlacement);
        }
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "ProgRvManager: RV sendMediationEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
    }

    @Override
    public synchronized void onAuctionTriggered() {
        this.logInternal("onAuctionTriggered: auction was triggered in " + (Object)((Object)this.mState) + " state");
        this.makeAuction();
    }

    private static enum RV_MEDIATION_STATE {
        RV_STATE_INITIATING,
        RV_STATE_AUCTION_IN_PROGRESS,
        RV_STATE_NOT_LOADED,
        RV_STATE_LOADING_SMASHES,
        RV_STATE_READY_TO_SHOW;

    }
}

