/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdaptersCompatibilityHandler;
import com.ironsource.mediationsdk.AuctionHandler;
import com.ironsource.mediationsdk.AuctionHandlerCallback;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.CallbackThrottler;
import com.ironsource.mediationsdk.ISListenerWrapper;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.ProgIsManagerListener;
import com.ironsource.mediationsdk.ProgIsSmash;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.ProgUtils;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.InterstitialConfigurations;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionCappingManager;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

class ProgIsManager
implements ProgIsManagerListener {
    private SessionCappingManager mSessionCappingManager;
    private MEDIATION_STATE mState;
    private final ConcurrentHashMap<String, ProgIsSmash> mSmashes;
    private CopyOnWriteArrayList<ProgIsSmash> mWaterfall;
    private ConcurrentHashMap<String, AuctionResponseItem> mWaterfallServerData;
    private String mCurrentPlacement;
    private String mCurrentAuctionId;
    private int mMaxSmashesToLoad;
    private AuctionHandler mAuctionHandler;
    private Context mAppContext;
    private long mInitMangerTime;
    private long mTimeToWaitBeforeFirstAction;
    private long mLoadStartTime;

    public ProgIsManager(Activity activity, List<ProviderSettings> providersList, InterstitialConfigurations configs, String appKey, String userId, int delayLoadFailure) {
        this.setState(MEDIATION_STATE.STATE_NOT_INITIALIZED);
        this.mSmashes = new ConcurrentHashMap();
        this.mWaterfall = new CopyOnWriteArrayList();
        this.mWaterfallServerData = new ConcurrentHashMap();
        this.mCurrentPlacement = "";
        this.mCurrentAuctionId = "";
        this.mAppContext = activity.getApplicationContext();
        this.mMaxSmashesToLoad = configs.getInterstitialAdaptersSmartLoadAmount();
        CallbackThrottler.getInstance().setDelayLoadFailureNotificationInSeconds(delayLoadFailure);
        AuctionSettings auctionSettings = configs.getInterstitialAuctionSettings();
        this.mTimeToWaitBeforeFirstAction = auctionSettings.getTimeToWaitBeforeFirstAuctionMs();
        this.mAuctionHandler = new AuctionHandler(this.mAppContext, "interstitial", auctionSettings.getBlob(), auctionSettings.getUrl());
        HashSet<String> smashesToPreInit = new HashSet<String>();
        for (ProviderSettings provider : providersList) {
            AbstractAdapter adapter = ProgUtils.loadAdapter(provider);
            if (adapter == null || !AdaptersCompatibilityHandler.getInstance().isAdapterVersionISCompatible(adapter)) continue;
            IronSourceObject.getInstance().addToISAdaptersList(adapter);
            ProgIsSmash smash = new ProgIsSmash(activity, appKey, userId, provider, this, configs.getInterstitialAdaptersSmartLoadTimeout(), adapter);
            this.mSmashes.put(smash.getInstanceName(), smash);
            smashesToPreInit.add(smash.getNameForReflection());
        }
        this.mSessionCappingManager = new SessionCappingManager(new ArrayList<ProgSmash>(this.mSmashes.values()));
        for (ProgIsSmash smash : this.mSmashes.values()) {
            if (smash.isBidder()) {
                smash.initForBidding();
                continue;
            }
            if (!smashesToPreInit.contains(smash.getNameForReflection())) continue;
            smashesToPreInit.remove(smash.getNameForReflection());
            smash.preInitInterstitial();
        }
        this.mInitMangerTime = new Date().getTime();
        this.setState(MEDIATION_STATE.STATE_READY_TO_LOAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume(Activity activity) {
        ConcurrentHashMap<String, ProgIsSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgIsSmash smash : this.mSmashes.values()) {
                smash.onResume(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPause(Activity activity) {
        ConcurrentHashMap<String, ProgIsSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgIsSmash smash : this.mSmashes.values()) {
                smash.onPause(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsent(boolean consent) {
        ConcurrentHashMap<String, ProgIsSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgIsSmash smash : this.mSmashes.values()) {
                smash.setConsent(consent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAuction() {
        this.setState(MEDIATION_STATE.STATE_AUCTION);
        this.mCurrentAuctionId = "";
        StringBuilder waterfallStr = new StringBuilder();
        long timeSinceManagerInit = new Date().getTime() - this.mInitMangerTime;
        long timeToWaitBeforeAuction = this.mTimeToWaitBeforeFirstAction - timeSinceManagerInit;
        if (timeToWaitBeforeAuction > 0L) {
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    ProgIsManager.this.makeAuction();
                }
            }, timeToWaitBeforeAuction);
            return;
        }
        this.sendMediationEvent(2000, null);
        HashMap<String, Object> bidderCandidates = new HashMap<String, Object>();
        ArrayList<String> noBidderCandidates = new ArrayList<String>();
        ConcurrentHashMap<String, ProgIsSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgIsSmash smash : this.mSmashes.values()) {
                if (this.mSessionCappingManager.isCapped(smash)) continue;
                if (smash.isBidder() && smash.isReadyToBid()) {
                    Map<String, Object> biddingData = smash.getBiddingData();
                    if (biddingData == null) continue;
                    bidderCandidates.put(smash.getInstanceName(), biddingData);
                    waterfallStr.append("2" + smash.getInstanceName() + ",");
                    continue;
                }
                if (smash.isBidder()) continue;
                noBidderCandidates.add(smash.getInstanceName());
                waterfallStr.append("1" + smash.getInstanceName() + ",");
            }
        }
        if (bidderCandidates.size() == 0 && noBidderCandidates.size() == 0) {
            this.sendMediationEvent(2300, new Object[][]{{"errorCode", 1005}, {"duration", 0}});
            CallbackThrottler.getInstance().onInterstitialAdLoadFailed(new IronSourceError(1005, "No candidates available for auctioning"));
            this.sendMediationEvent(2110, new Object[][]{{"errorCode", 1005}});
            this.setState(MEDIATION_STATE.STATE_READY_TO_LOAD);
            return;
        }
        if (waterfallStr.length() > 256) {
            waterfallStr.setLength(256);
        } else {
            waterfallStr.deleteCharAt(waterfallStr.length() - 1);
        }
        this.sendMediationEvent(2310, new Object[][]{{"ext1", waterfallStr.toString()}});
        int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(2);
        this.mAuctionHandler.executeAuction(bidderCandidates, noBidderCandidates, sessionDepth, new AuctionHandlerCallback(){

            @Override
            public void callback(boolean isSuccess, List<AuctionResponseItem> newWaterfall, String auctionId, int errorCode, String errorMessage, long elapsedTime) {
                if (isSuccess) {
                    ProgIsManager.this.mCurrentAuctionId = auctionId;
                    ProgIsManager.this.sendMediationEvent(2301, new Object[][]{{"duration", elapsedTime}});
                    ProgIsManager.this.updateWaterfall(newWaterfall);
                    ProgIsManager.this.loadSmashes();
                } else {
                    if (TextUtils.isEmpty((CharSequence)errorMessage)) {
                        ProgIsManager.this.sendMediationEvent(2300, new Object[][]{{"errorCode", errorCode}, {"duration", elapsedTime}});
                        CallbackThrottler.getInstance().onInterstitialAdLoadFailed(new IronSourceError(errorCode, "Auction failed"));
                        ProgIsManager.this.sendMediationEvent(2110, new Object[][]{{"errorCode", errorCode}});
                    } else {
                        String errorReason = errorMessage.substring(0, Math.min(errorMessage.length(), 39));
                        ProgIsManager.this.sendMediationEvent(2300, new Object[][]{{"errorCode", errorCode}, {"reason", errorReason}, {"duration", elapsedTime}});
                        CallbackThrottler.getInstance().onInterstitialAdLoadFailed(new IronSourceError(errorCode, errorMessage));
                        ProgIsManager.this.sendMediationEvent(2110, new Object[][]{{"errorCode", errorCode}, {"reason", errorReason}});
                    }
                    ProgIsManager.this.setState(MEDIATION_STATE.STATE_READY_TO_LOAD);
                }
            }
        });
    }

    private String getAsString(AuctionResponseItem item) {
        String isProgrammatic = TextUtils.isEmpty((CharSequence)item.getServerData()) ? "1" : "2";
        return isProgrammatic + item.getInstanceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWaterfall(List<AuctionResponseItem> waterfall) {
        ConcurrentHashMap<String, ProgIsSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            this.mWaterfall.clear();
            this.mWaterfallServerData.clear();
            StringBuilder waterfallStr = new StringBuilder();
            for (AuctionResponseItem item : waterfall) {
                waterfallStr.append(this.getAsString(item) + ",");
                ProgIsSmash smash = this.mSmashes.get(item.getInstanceName());
                if (smash == null) continue;
                smash.setIsLoadCandidate(true);
                this.mWaterfall.add(smash);
                this.mWaterfallServerData.put(smash.getInstanceName(), item);
            }
            if (waterfallStr.length() > 256) {
                waterfallStr.setLength(256);
            } else {
                waterfallStr.deleteCharAt(waterfallStr.length() - 1);
            }
            this.sendMediationEvent(2311, new Object[][]{{"ext1", waterfallStr.toString()}});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSmashes() {
        ConcurrentHashMap<String, ProgIsSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            this.setState(MEDIATION_STATE.STATE_LOADING_SMASHES);
            for (int i2 = 0; i2 < Math.min(this.mMaxSmashesToLoad, this.mWaterfall.size()); ++i2) {
                ProgIsSmash smash = this.mWaterfall.get(i2);
                String serverData = this.mWaterfallServerData.get(smash.getInstanceName()).getServerData();
                this.sendProviderEvent(2002, smash);
                smash.loadInterstitial(serverData);
            }
        }
    }

    public synchronized void loadInterstitial() {
        if (this.mState == MEDIATION_STATE.STATE_SHOWING) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, "loadInterstitial() cannot be invoked while showing", 3);
            return;
        }
        if (this.mState != MEDIATION_STATE.STATE_READY_TO_LOAD && this.mState != MEDIATION_STATE.STATE_READY_TO_SHOW || CallbackThrottler.getInstance().hasPendingInvocation()) {
            this.logInternal("loadInterstitial() already in progress");
            return;
        }
        this.mCurrentAuctionId = "";
        this.mCurrentPlacement = "";
        this.sendMediationEvent(2001);
        this.mLoadStartTime = new Date().getTime();
        this.makeAuction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void showInterstitial(String placementName) {
        if (this.mState != MEDIATION_STATE.STATE_READY_TO_SHOW) {
            this.logInternal("showInterstitial() error state=" + this.mState.toString());
            ISListenerWrapper.getInstance().onInterstitialAdShowFailed(new IronSourceError(509, "No ads to show"));
            return;
        }
        if (placementName == null) {
            String message = "showInterstitial error: empty default placement in response";
            this.logInternal(message);
            IronSourceError error = new IronSourceError(1020, message);
            ISListenerWrapper.getInstance().onInterstitialAdShowFailed(error);
            this.sendMediationEvent(2111, new Object[][]{{"errorCode", 1020}});
            return;
        }
        this.mCurrentPlacement = placementName;
        this.sendMediationEventWithPlacement(2100);
        if (CappingManager.isInterstitialPlacementCapped(this.mAppContext, this.mCurrentPlacement)) {
            String message = "placement " + this.mCurrentPlacement + " is capped";
            this.logInternal(message);
            IronSourceError error = new IronSourceError(524, message);
            ISListenerWrapper.getInstance().onInterstitialAdShowFailed(error);
            this.sendMediationEventWithPlacement(2111, new Object[][]{{"errorCode", 524}});
            return;
        }
        ConcurrentHashMap<String, ProgIsSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgIsSmash smash : this.mWaterfall) {
                if (smash.isReadyToShow()) {
                    this.showInterstitial(smash, this.mCurrentPlacement);
                    return;
                }
                this.logInternal("showInterstitial " + smash.getInstanceName() + " isReadyToShow() == false");
            }
        }
        ISListenerWrapper.getInstance().onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError("Interstitial"));
        this.sendMediationEventWithPlacement(2111, new Object[][]{{"errorCode", 509}});
    }

    private void showInterstitial(ProgIsSmash smash, String placementName) {
        this.setState(MEDIATION_STATE.STATE_SHOWING);
        smash.showInterstitial();
        this.sendProviderEventWithPlacement(2201, smash);
        this.mSessionCappingManager.increaseShowCounter(smash);
        if (this.mSessionCappingManager.isCapped(smash)) {
            smash.setCappedPerSession();
            this.sendProviderEvent(2401, smash);
            this.logInternal(smash.getInstanceName() + " was session capped");
        }
        CappingManager.incrementIsShowCounter(this.mAppContext, placementName);
        if (CappingManager.isInterstitialPlacementCapped(this.mAppContext, placementName)) {
            this.sendMediationEventWithPlacement(2400);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isInterstitialReady() {
        if (!IronSourceUtils.isNetworkConnected(this.mAppContext) || this.mState != MEDIATION_STATE.STATE_READY_TO_SHOW) {
            return false;
        }
        ConcurrentHashMap<String, ProgIsSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgIsSmash smash : this.mWaterfall) {
                if (!smash.isReadyToShow()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdReady(ProgIsSmash smash, long elapsedTime) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            this.logSmashCallback(smash, "onInterstitialAdReady");
            this.sendProviderEvent(2003, smash, new Object[][]{{"duration", elapsedTime}});
            if (this.mState == MEDIATION_STATE.STATE_LOADING_SMASHES) {
                this.setState(MEDIATION_STATE.STATE_READY_TO_SHOW);
                ISListenerWrapper.getInstance().onInterstitialAdReady();
                long totalLoadElapsedTime = new Date().getTime() - this.mLoadStartTime;
                this.sendMediationEvent(2004, new Object[][]{{"duration", totalLoadElapsedTime}});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdLoadFailed(IronSourceError error, ProgIsSmash smash, long elapsedTime) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            this.logSmashCallback(smash, "onInterstitialAdLoadFailed error=" + error.getErrorMessage() + " state=" + this.mState.name());
            String errorReason = error.getErrorMessage().substring(0, Math.min(error.getErrorMessage().length(), 39));
            this.sendProviderEvent(2200, smash, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", errorReason}, {"duration", elapsedTime}});
            if (this.mState != MEDIATION_STATE.STATE_LOADING_SMASHES && this.mState != MEDIATION_STATE.STATE_READY_TO_SHOW) {
                return;
            }
            ConcurrentHashMap<String, ProgIsSmash> concurrentHashMap = this.mSmashes;
            synchronized (concurrentHashMap) {
                boolean hasLoadInProgress = false;
                for (ProgIsSmash waterfallSmash : this.mWaterfall) {
                    if (waterfallSmash.getIsLoadCandidate()) {
                        String serverData = this.mWaterfallServerData.get(waterfallSmash.getInstanceName()).getServerData();
                        this.sendProviderEvent(2002, waterfallSmash);
                        waterfallSmash.loadInterstitial(serverData);
                        return;
                    }
                    if (!waterfallSmash.isLoadingInProgress()) continue;
                    hasLoadInProgress = true;
                }
                if (this.mState == MEDIATION_STATE.STATE_LOADING_SMASHES && !hasLoadInProgress) {
                    CallbackThrottler.getInstance().onInterstitialAdLoadFailed(new IronSourceError(509, "No ads to show"));
                    this.sendMediationEvent(2110, new Object[][]{{"errorCode", 509}});
                    this.setState(MEDIATION_STATE.STATE_READY_TO_LOAD);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdOpened(ProgIsSmash smash) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            this.logSmashCallback(smash, "onInterstitialAdOpened");
            ISListenerWrapper.getInstance().onInterstitialAdOpened();
            this.sendProviderEventWithPlacement(2005, smash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdClosed(ProgIsSmash smash) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            this.logSmashCallback(smash, "onInterstitialAdClosed");
            ISListenerWrapper.getInstance().onInterstitialAdClosed();
            this.sendProviderEventWithPlacement(2204, smash);
            this.setState(MEDIATION_STATE.STATE_READY_TO_LOAD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdShowSucceeded(ProgIsSmash smash) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            this.logSmashCallback(smash, "onInterstitialAdShowSucceeded");
            ISListenerWrapper.getInstance().onInterstitialAdShowSucceeded();
            this.sendProviderEventWithPlacement(2202, smash);
            if (this.mWaterfallServerData.containsKey(smash.getInstanceName())) {
                this.mAuctionHandler.reportImpression(this.mWaterfallServerData.get(smash.getInstanceName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdShowFailed(IronSourceError error, ProgIsSmash smash) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            this.logSmashCallback(smash, "onInterstitialAdShowFailed error=" + error.getErrorMessage());
            ISListenerWrapper.getInstance().onInterstitialAdShowFailed(error);
            String errorReason = error.getErrorMessage().substring(0, Math.min(error.getErrorMessage().length(), 39));
            this.sendProviderEventWithPlacement(2203, smash, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", errorReason}});
            this.setState(MEDIATION_STATE.STATE_READY_TO_LOAD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdClicked(ProgIsSmash smash) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            this.logSmashCallback(smash, "onInterstitialAdClicked");
            ISListenerWrapper.getInstance().onInterstitialAdClicked();
            this.sendProviderEventWithPlacement(2006, smash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdVisible(ProgIsSmash smash) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            this.logSmashCallback(smash, "onInterstitialAdVisible");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialInitFailed(IronSourceError error, ProgIsSmash smash) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            String errorReason = error.getErrorMessage().substring(0, Math.min(error.getErrorMessage().length(), 39));
            this.sendProviderEvent(2206, smash, new Object[][]{{"reason", errorReason}});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialInitSuccess(ProgIsSmash smash) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            this.sendProviderEvent(2205, smash);
        }
    }

    private void setState(MEDIATION_STATE state) {
        this.mState = state;
        this.logInternal("state=" + (Object)((Object)state));
    }

    private void logSmashCallback(ProgIsSmash smash, String line) {
        String text = "ProgIsManager " + smash.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }

    private void logInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "ProgIsManager " + text, 0);
    }

    private void sendMediationEvent(int eventId) {
        this.sendMediationEvent(eventId, null, false);
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, false);
    }

    private void sendMediationEventWithPlacement(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, true);
    }

    private void sendMediationEventWithPlacement(int eventId) {
        this.sendMediationEvent(eventId, null, true);
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals, boolean isAddPlacement) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("provider", "Mediation");
        data.put("programmatic", 1);
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentAuctionId)) {
            data.put("auctionId", this.mCurrentAuctionId);
        }
        if (isAddPlacement && !TextUtils.isEmpty((CharSequence)this.mCurrentPlacement)) {
            data.put("placement", this.mCurrentPlacement);
        }
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            this.logInternal("sendMediationEvent " + e2.getMessage());
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        InterstitialEventsManager.getInstance().log(event);
    }

    private void sendProviderEvent(int eventId, ProgIsSmash smash) {
        this.sendProviderEvent(eventId, smash, null, false);
    }

    private void sendProviderEvent(int eventId, ProgIsSmash smash, Object[][] keyVals) {
        this.sendProviderEvent(eventId, smash, keyVals, false);
    }

    private void sendProviderEventWithPlacement(int eventId, ProgIsSmash smash, Object[][] keyVals) {
        this.sendProviderEvent(eventId, smash, keyVals, true);
    }

    private void sendProviderEventWithPlacement(int eventId, ProgIsSmash smash) {
        this.sendProviderEvent(eventId, smash, null, true);
    }

    private void sendProviderEvent(int eventId, ProgIsSmash smash, Object[][] keyVals, boolean isAddPlacement) {
        Map<String, Object> data = smash.getProviderEventData();
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentAuctionId)) {
            data.put("auctionId", this.mCurrentAuctionId);
        }
        if (isAddPlacement && !TextUtils.isEmpty((CharSequence)this.mCurrentPlacement)) {
            data.put("placement", this.mCurrentPlacement);
        }
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "IS sendProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        InterstitialEventsManager.getInstance().log(event);
    }

    static enum MEDIATION_STATE {
        STATE_NOT_INITIALIZED,
        STATE_READY_TO_LOAD,
        STATE_AUCTION,
        STATE_LOADING_SMASHES,
        STATE_READY_TO_SHOW,
        STATE_SHOWING;

    }
}

