/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.DemandOnlySmash;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.AdapterConfig;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.DemandOnlyIsManagerListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class DemandOnlyIsSmash
extends DemandOnlySmash
implements InterstitialSmashListener {
    private DemandOnlyIsManagerListener mListener;
    private Timer mTimer;
    private int mLoadTimeoutSecs;
    private long mLoadStartTime;
    private DemandOnlySmash.SMASH_STATE mState;

    public DemandOnlyIsSmash(Activity activity, String appKey, String userId, ProviderSettings settings, DemandOnlyIsManagerListener listener, int loadTimeout, AbstractAdapter adapter) {
        super(new AdapterConfig(settings, settings.getInterstitialSettings()), adapter);
        this.mListener = listener;
        this.mTimer = null;
        this.mLoadTimeoutSecs = loadTimeout;
        this.mState = DemandOnlySmash.SMASH_STATE.NOT_LOADED;
        this.mAdapter.initInterstitial(activity, appKey, userId, this.mAdUnitSettings, this);
    }

    public synchronized void loadInterstitial() {
        this.logInternal("loadInterstitial state=" + this.mState.name());
        if (this.mState == DemandOnlySmash.SMASH_STATE.NOT_LOADED || this.mState == DemandOnlySmash.SMASH_STATE.LOADED) {
            this.mState = DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS;
            this.startTimer();
            this.mLoadStartTime = new Date().getTime();
            this.mAdapter.loadInterstitial(this.mAdUnitSettings, this);
        } else if (this.mState == DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS) {
            IronSourceError error = new IronSourceError(1050, "load already in progress");
            this.mListener.onInterstitialAdLoadFailed(error, this, 0L);
        } else {
            IronSourceError error = new IronSourceError(1050, "cannot load because show is in progress");
            this.mListener.onInterstitialAdLoadFailed(error, this, 0L);
        }
    }

    public synchronized void showInterstitial() {
        this.logInternal("showInterstitial state=" + this.mState.name());
        if (this.mState == DemandOnlySmash.SMASH_STATE.LOADED) {
            this.mState = DemandOnlySmash.SMASH_STATE.SHOW_IN_PROGRESS;
            this.mAdapter.showInterstitial(this.mAdUnitSettings, this);
        } else {
            IronSourceError error = new IronSourceError(1051, "load must be called before show");
            this.mListener.onInterstitialAdShowFailed(error, this);
        }
    }

    public synchronized boolean isInterstitialReady() {
        return this.mAdapter.isInterstitialReady(this.mAdUnitSettings);
    }

    private void stopTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    private void startTimer() {
        this.logInternal("start timer");
        this.stopTimer();
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                DemandOnlyIsSmash.this.logInternal("load timed out state=" + DemandOnlyIsSmash.this.mState.toString());
                if (DemandOnlyIsSmash.this.mState == DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS) {
                    DemandOnlyIsSmash.this.mState = DemandOnlySmash.SMASH_STATE.NOT_LOADED;
                    long elapsedTime = new Date().getTime() - DemandOnlyIsSmash.this.mLoadStartTime;
                    DemandOnlyIsSmash.this.mListener.onInterstitialAdLoadFailed(new IronSourceError(1052, "load timed out"), DemandOnlyIsSmash.this, elapsedTime);
                }
            }
        }, this.mLoadTimeoutSecs * 1000);
    }

    @Override
    public void onInterstitialInitSuccess() {
    }

    @Override
    public void onInterstitialInitFailed(IronSourceError error) {
    }

    @Override
    public synchronized void onInterstitialAdReady() {
        this.logAdapterCallback("onInterstitialAdReady state=" + this.mState.name());
        this.stopTimer();
        if (this.mState != DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS) {
            return;
        }
        this.mState = DemandOnlySmash.SMASH_STATE.LOADED;
        long elapsedTime = new Date().getTime() - this.mLoadStartTime;
        this.mListener.onInterstitialAdReady(this, elapsedTime);
    }

    @Override
    public synchronized void onInterstitialAdLoadFailed(IronSourceError error) {
        this.logAdapterCallback("onInterstitialAdLoadFailed error=" + error.getErrorMessage() + " state=" + this.mState.name());
        this.stopTimer();
        if (this.mState != DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS) {
            return;
        }
        this.mState = DemandOnlySmash.SMASH_STATE.NOT_LOADED;
        long elapsedTime = new Date().getTime() - this.mLoadStartTime;
        this.mListener.onInterstitialAdLoadFailed(error, this, elapsedTime);
    }

    @Override
    public synchronized void onInterstitialAdOpened() {
        this.logAdapterCallback("onInterstitialAdOpened");
        this.mListener.onInterstitialAdOpened(this);
    }

    @Override
    public synchronized void onInterstitialAdClosed() {
        this.mState = DemandOnlySmash.SMASH_STATE.NOT_LOADED;
        this.logAdapterCallback("onInterstitialAdClosed");
        this.mListener.onInterstitialAdClosed(this);
    }

    @Override
    public synchronized void onInterstitialAdShowSucceeded() {
    }

    @Override
    public synchronized void onInterstitialAdShowFailed(IronSourceError error) {
        this.mState = DemandOnlySmash.SMASH_STATE.NOT_LOADED;
        this.logAdapterCallback("onInterstitialAdShowFailed error=" + error.getErrorMessage());
        this.mListener.onInterstitialAdShowFailed(error, this);
    }

    @Override
    public synchronized void onInterstitialAdClicked() {
        this.logAdapterCallback("onInterstitialAdClicked");
        this.mListener.onInterstitialAdClicked(this);
    }

    @Override
    public synchronized void onInterstitialAdVisible() {
        this.logAdapterCallback("onInterstitialAdVisible");
        this.mListener.onInterstitialAdVisible(this);
    }

    private void logAdapterCallback(String line) {
        String text = "DemandOnlyInterstitialSmash " + this.mAdapterConfig.getProviderName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, text, 0);
    }

    private void logInternal(String line) {
        String text = "DemandOnlyInterstitialSmash " + this.mAdapterConfig.getProviderName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }
}

