/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.events;

import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.events.BaseEventsManager;
import com.ironsource.mediationsdk.utils.SessionDepthManager;

public class RewardedVideoEventsManager
extends BaseEventsManager {
    private static RewardedVideoEventsManager sInstance;
    private String mCurrentRVPlacment;
    private String mCurrentOWPlacment;

    private RewardedVideoEventsManager() {
        this.mFormatterType = "outcome";
        this.mAdUnitType = 3;
        this.mEventType = "RV";
        this.mCurrentRVPlacment = "";
        this.mCurrentOWPlacment = "";
    }

    public static synchronized RewardedVideoEventsManager getInstance() {
        if (sInstance == null) {
            sInstance = new RewardedVideoEventsManager();
            sInstance.initState();
        }
        return sInstance;
    }

    @Override
    protected boolean shouldExtractCurrentPlacement(EventData event) {
        return event.getEventId() == 2 || event.getEventId() == 10;
    }

    @Override
    protected boolean shouldIncludeCurrentPlacement(EventData event) {
        int eventId = event.getEventId();
        return eventId == 5 || eventId == 6 || eventId == 8 || eventId == 9 || eventId == 19 || eventId == 90019 || eventId == 20 || eventId == 305;
    }

    @Override
    protected boolean isTopPriorityEvent(EventData currentEvent) {
        int eventId = currentEvent.getEventId();
        return eventId == 1005 || eventId == 1010 || eventId == 1203 || eventId == 6 || eventId == 5 || eventId == 10 || eventId == 14 || eventId == 305;
    }

    @Override
    protected int getSessionDepth(EventData event) {
        int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(1);
        if (event.getEventId() == 15 || event.getEventId() >= 300 && event.getEventId() < 400) {
            sessionDepth = SessionDepthManager.getInstance().getSessionDepth(0);
        }
        return sessionDepth;
    }

    @Override
    protected void setCurrentPlacement(EventData event) {
        if (event.getEventId() == 15 || event.getEventId() >= 300 && event.getEventId() < 400) {
            this.mCurrentOWPlacment = event.getAdditionalDataJSON().optString("placement");
        } else {
            this.mCurrentRVPlacment = event.getAdditionalDataJSON().optString("placement");
        }
    }

    @Override
    protected String getCurrentPlacement(int eventId) {
        if (eventId == 15 || eventId >= 300 && eventId < 400) {
            return this.mCurrentOWPlacment;
        }
        return this.mCurrentRVPlacment;
    }

    @Override
    protected boolean increaseSessionDepthIfNeeded(EventData event) {
        if (event.getEventId() == 6 || event.getEventId() == 1203) {
            SessionDepthManager.getInstance().increaseSessionDepth(1);
            return false;
        }
        if (event.getEventId() == 305) {
            SessionDepthManager.getInstance().increaseSessionDepth(0);
            return false;
        }
        return false;
    }

    @Override
    protected void initConnectivitySensitiveEventsSet() {
        this.mConnectivitySensitiveEventsSet.add(7);
        this.mConnectivitySensitiveEventsSet.add(3);
        this.mConnectivitySensitiveEventsSet.add(19);
        this.mConnectivitySensitiveEventsSet.add(119);
        this.mConnectivitySensitiveEventsSet.add(1001);
        this.mConnectivitySensitiveEventsSet.add(1209);
        this.mConnectivitySensitiveEventsSet.add(1210);
        this.mConnectivitySensitiveEventsSet.add(1211);
    }
}

