/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import java.util.HashMap;
import java.util.Map;

public class CallbackThrottler {
    private static final long MAX_CALL_RATE_SEC = 15L;
    private static final String MEDIATION = "mediation";
    private static final CallbackThrottler instance = new CallbackThrottler();
    private Map<String, Long> mLastInvoked = new HashMap<String, Long>();
    private Map<String, Boolean> mIsWaitingForInvocation = new HashMap<String, Boolean>();
    private InterstitialListener mListener = null;

    public static synchronized CallbackThrottler getInstance() {
        return instance;
    }

    private CallbackThrottler() {
    }

    public void setInterstitialListener(InterstitialListener listener) {
        this.mListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInterstitialAdLoadFailed(IronSourceError error) {
        CallbackThrottler callbackThrottler = this;
        synchronized (callbackThrottler) {
            this.onInterstitialAdLoadFailedInternal(MEDIATION, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInterstitialAdLoadFailed(String instanceId, IronSourceError error) {
        CallbackThrottler callbackThrottler = this;
        synchronized (callbackThrottler) {
            this.onInterstitialAdLoadFailedInternal(instanceId, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingInvocation() {
        CallbackThrottler callbackThrottler = this;
        synchronized (callbackThrottler) {
            return this.hasPendingInvocationInternal(MEDIATION);
        }
    }

    private boolean hasPendingInvocationInternal(String instanceId) {
        if (TextUtils.isEmpty((CharSequence)instanceId)) {
            return false;
        }
        if (!this.mIsWaitingForInvocation.containsKey(instanceId)) {
            return false;
        }
        return this.mIsWaitingForInvocation.get(instanceId);
    }

    private void invokeCallback(String instanceId, IronSourceError error) {
        this.mLastInvoked.put(instanceId, System.currentTimeMillis());
        if (this.mListener != null) {
            this.mListener.onInterstitialAdLoadFailed(error);
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, "onInterstitialAdLoadFailed(" + error.toString() + ")", 1);
        }
    }

    private void onInterstitialAdLoadFailedInternal(final String instanceId, final IronSourceError error) {
        if (this.hasPendingInvocationInternal(instanceId)) {
            return;
        }
        if (!this.mLastInvoked.containsKey(instanceId)) {
            this.invokeCallback(instanceId, error);
            return;
        }
        long timeSinceLastCallMs = System.currentTimeMillis() - this.mLastInvoked.get(instanceId);
        if (timeSinceLastCallMs > 15000L) {
            this.invokeCallback(instanceId, error);
            return;
        }
        this.mIsWaitingForInvocation.put(instanceId, true);
        long nextCallMs = 15000L - timeSinceLastCallMs;
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                CallbackThrottler.this.invokeCallback(instanceId, error);
                CallbackThrottler.this.mIsWaitingForInvocation.put(instanceId, false);
            }
        }, nextCallMs);
    }
}

