/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.ironsource.environment.ApplicationContext;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.mediationsdk.AuctionHandlerCallback;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.utils.IronSourceAES;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AuctionHandler {
    private static final int SERVER_REQUEST_TIMEOUT = 15000;
    private String mAdUnit;
    private String mBlob;
    private String mUrl;
    private Context mContext;
    private String mSessionId;

    public AuctionHandler(Context context, String adUnit, String blob, String url) {
        this.mContext = context;
        this.mAdUnit = adUnit;
        this.mBlob = blob;
        this.mUrl = url;
        this.mSessionId = IronSourceObject.getInstance().getSessionId();
    }

    public void executeAuction(Map<String, Object> bidders, List<String> nonBidders, int sessionDepth, AuctionHandlerCallback callback) {
        try {
            boolean isEncryptedResponse = IronSourceUtils.getSerr() == 1;
            JSONObject requestData = this.generateRequest(this.mContext, bidders, nonBidders, sessionDepth, isEncryptedResponse);
            AuctionHttpRequestTask task = new AuctionHttpRequestTask(callback);
            task.execute(new Object[]{this.mContext, this.mUrl, requestData, isEncryptedResponse});
        }
        catch (Exception e2) {
            callback.callback(false, null, null, 1000, e2.getMessage(), 0L);
        }
    }

    public void reportImpression(AuctionResponseItem responseItem) {
        for (String url : responseItem.getWinUrls()) {
            new ImpressionHttpTask().execute(new String[]{url});
        }
    }

    private JSONObject generateRequest(Context context, Map<String, Object> bidders, List<String> nonBidders, int sessionDepth, boolean isEncryptedResponse) throws JSONException {
        JSONObject instances = new JSONObject();
        for (String instance : bidders.keySet()) {
            JSONObject bidderObject = new JSONObject();
            bidderObject.put("instanceType", 2);
            bidderObject.put("biddingAdditionalData", (Object)new JSONObject((Map)bidders.get(instance)));
            instances.put(instance, (Object)bidderObject);
        }
        for (String instance : nonBidders) {
            JSONObject nonbBidderObject = new JSONObject();
            nonbBidderObject.put("instanceType", 1);
            instances.put(instance, (Object)nonbBidderObject);
        }
        JSONObject clientParams = new JSONObject();
        clientParams.put("applicationUserId", (Object)IronSourceObject.getInstance().getIronSourceUserId());
        String gender = IronSourceObject.getInstance().getGender();
        if (TextUtils.isEmpty((CharSequence)gender)) {
            gender = "unknown";
        }
        clientParams.put("applicationUserGender", (Object)gender);
        Integer age = IronSourceObject.getInstance().getAge();
        if (age == null) {
            age = -1;
        }
        clientParams.put("applicationUserAge", (Object)age);
        clientParams.put("mobileCarrier", (Object)this.getMobileCarrier(context));
        clientParams.put("connectionType", (Object)IronSourceUtils.getConnectionType(context));
        clientParams.put("deviceOS", (Object)"android");
        clientParams.put("deviceWidth", context.getResources().getConfiguration().screenWidthDp);
        clientParams.put("deviceHeight", context.getResources().getConfiguration().screenHeightDp);
        clientParams.put("deviceOSVersion", (Object)(Build.VERSION.SDK_INT + "(" + Build.VERSION.RELEASE + ")"));
        clientParams.put("deviceModel", (Object)Build.MODEL);
        clientParams.put("deviceMake", (Object)Build.MANUFACTURER);
        clientParams.put("bundleId", (Object)context.getPackageName());
        clientParams.put("appVersion", (Object)ApplicationContext.getPublisherApplicationVersion(context, context.getPackageName()));
        clientParams.put("clientTimestamp", new Date().getTime());
        JSONObject ret = new JSONObject();
        ret.put("adUnit", (Object)this.mAdUnit);
        ret.put("auctionData", (Object)this.mBlob);
        ret.put("applicationKey", (Object)IronSourceObject.getInstance().getIronSourceAppKey());
        ret.put("SDKVersion", (Object)IronSourceUtils.getSDKVersion());
        ret.put("clientParams", (Object)clientParams);
        ret.put("sessionDepth", sessionDepth);
        ret.put("sessionId", (Object)this.mSessionId);
        ret.put("doNotEncryptResponse", (Object)(isEncryptedResponse ? "false" : "true"));
        ret.put("instances", (Object)instances);
        return ret;
    }

    private String getMobileCarrier(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                return telephonyManager.getNetworkOperatorName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    static class ImpressionHttpTask
    extends AsyncTask<String, Void, Boolean> {
        ImpressionHttpTask() {
        }

        protected Boolean doInBackground(String ... objects) {
            try {
                URL url = new URL(objects[0]);
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.setReadTimeout(15000);
                urlConnection.setConnectTimeout(15000);
                urlConnection.connect();
                int httpResponseCode = urlConnection.getResponseCode();
                urlConnection.disconnect();
                return httpResponseCode == 200;
            }
            catch (Exception e2) {
                return false;
            }
        }

        protected void onPostExecute(Boolean result) {
            super.onPostExecute((Object)result);
        }
    }

    static class AuctionHttpRequestTask
    extends AsyncTask<Object, Void, Boolean> {
        private AuctionHandlerCallback mCallback;
        private int mErrorCode;
        private String mErrorMessage;
        private String mAuctionId;
        private List<AuctionResponseItem> mWaterfall;
        private long mRequestStartTime;

        AuctionHttpRequestTask(AuctionHandlerCallback callback) {
            this.mCallback = callback;
            this.mRequestStartTime = new Date().getTime();
        }

        protected Boolean doInBackground(Object ... objects) {
            try {
                Context context = (Context)objects[0];
                URL url = new URL((String)objects[1]);
                JSONObject requestData = (JSONObject)objects[2];
                Boolean isEncryptedResponse = (Boolean)objects[3];
                JSONObject clientParams = (JSONObject)requestData.get("clientParams");
                String advertisingId = DeviceStatus.getOrGenerateOnceUniqueIdentifier(context);
                String advertisingIdType = "UUID";
                boolean isLimitAdTrackingEnabled = false;
                try {
                    String[] advertisingIdInfo = DeviceStatus.getAdvertisingIdInfo(context);
                    if (advertisingIdInfo.length == 2) {
                        isLimitAdTrackingEnabled = Boolean.valueOf(advertisingIdInfo[1]);
                        if (!TextUtils.isEmpty((CharSequence)advertisingIdInfo[0])) {
                            advertisingId = advertisingIdInfo[0];
                            advertisingIdType = "GAID";
                        }
                    }
                }
                catch (Exception advertisingIdInfo) {
                    // empty catch block
                }
                clientParams.put("advId", (Object)advertisingId);
                clientParams.put("advIdType", (Object)advertisingIdType);
                clientParams.put("isLimitAdTrackingEnabled", (Object)(isLimitAdTrackingEnabled ? "true" : "false"));
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("POST");
                urlConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                urlConnection.setConnectTimeout(15000);
                urlConnection.setDoInput(true);
                urlConnection.setDoOutput(true);
                OutputStream outputStream = urlConnection.getOutputStream();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                BufferedWriter writer = new BufferedWriter(outputStreamWriter);
                String body = requestData.toString();
                body = IronSourceAES.encode("C38FB23A402222A0C17D34A92F971D1F", body);
                body = "{\"request\" : \"" + body + "\"}";
                writer.write(body);
                writer.flush();
                writer.close();
                outputStream.close();
                int httpResponseCode = urlConnection.getResponseCode();
                if (httpResponseCode == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        stringBuilder.append(line);
                    }
                    String responseStr = stringBuilder.toString();
                    if (TextUtils.isEmpty((CharSequence)responseStr)) {
                        this.mErrorCode = 1002;
                        this.mErrorMessage = "empty response";
                        return false;
                    }
                    try {
                        JSONObject jsonObj = new JSONObject(responseStr);
                        if (isEncryptedResponse.booleanValue()) {
                            String encryptedStr = jsonObj.getString("response");
                            jsonObj = new JSONObject(IronSourceAES.decode("C38FB23A402222A0C17D34A92F971D1F", encryptedStr));
                        }
                        this.mAuctionId = jsonObj.getString("auctionId");
                        this.mWaterfall = new ArrayList<AuctionResponseItem>();
                        JSONArray waterfall = jsonObj.getJSONArray("waterfall");
                        for (int i2 = 0; i2 < waterfall.length(); ++i2) {
                            AuctionResponseItem item = new AuctionResponseItem(waterfall.getJSONObject(i2));
                            if (!item.isValid()) {
                                this.mErrorCode = 1002;
                                this.mErrorMessage = "waterfall " + i2;
                                return false;
                            }
                            this.mWaterfall.add(item);
                        }
                        if (this.mWaterfall.size() == 0) {
                            this.mErrorCode = 1004;
                            return false;
                        }
                    }
                    catch (Exception e2) {
                        this.mErrorCode = 1002;
                        return false;
                    }
                    urlConnection.disconnect();
                    return true;
                }
                this.mErrorCode = 1001;
                this.mErrorMessage = httpResponseCode + "";
                urlConnection.disconnect();
                return false;
            }
            catch (SocketTimeoutException e3) {
                this.mErrorCode = 1006;
                this.mErrorMessage = "Connection timed out";
                return false;
            }
            catch (Exception e4) {
                this.mErrorCode = 1000;
                this.mErrorMessage = e4.getMessage();
                return false;
            }
        }

        protected void onPostExecute(Boolean isSuccess) {
            long elapsedTime = new Date().getTime() - this.mRequestStartTime;
            if (isSuccess.booleanValue()) {
                this.mCallback.callback(true, this.mWaterfall, this.mAuctionId, 0, null, elapsedTime);
            } else {
                this.mCallback.callback(false, null, null, this.mErrorCode, this.mErrorMessage, elapsedTime);
            }
        }
    }
}

