/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.HashMap;
import java.util.Map;

public class AdaptersCompatibilityHandler {
    private static final AdaptersCompatibilityHandler instance = new AdaptersCompatibilityHandler();
    private Map<String, String> mAdapterNameToMinVersion = new HashMap<String, String>();

    public static synchronized AdaptersCompatibilityHandler getInstance() {
        return instance;
    }

    private AdaptersCompatibilityHandler() {
        this.mAdapterNameToMinVersion.put("adcolony", "4.1.6");
        this.mAdapterNameToMinVersion.put("vungle", "4.1.5");
        this.mAdapterNameToMinVersion.put("applovin", "4.3.3");
        this.mAdapterNameToMinVersion.put("admob", "4.3.2");
    }

    public synchronized boolean isAdapterVersionCompatible(AbstractAdapter adapter) {
        String adapterVersion;
        if (adapter == null) {
            return false;
        }
        String adapterName = adapter.getProviderName().toLowerCase();
        if (!this.mAdapterNameToMinVersion.containsKey(adapterName)) {
            return true;
        }
        String minAcceptedVersion = this.mAdapterNameToMinVersion.get(adapterName);
        boolean ret = this.isVersionGreaterOrEqual(minAcceptedVersion, adapterVersion = adapter.getVersion());
        if (!ret) {
            String message = adapter.getProviderName() + " adapter " + adapterVersion + " is incompatible with SDK version " + IronSourceUtils.getSDKVersion() + ", please update your adapter to the latest version";
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, message, 3);
        }
        return ret;
    }

    public synchronized boolean isBannerAdapterCompatible(AbstractAdapter adapter) {
        if (adapter == null) {
            return false;
        }
        String adapterVersion = adapter.getVersion();
        boolean ret = this.isVersionGreaterOrEqual("4.3.0", adapterVersion);
        if (!ret) {
            String message = adapter.getProviderName() + " adapter " + adapterVersion + " is incompatible with SDK version " + IronSourceUtils.getSDKVersion() + ", please update your adapter to the latest version";
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, message, 3);
        }
        return ret;
    }

    private boolean isVersionGreaterOrEqual(String minAcceptedVersion, String adapterVersion) {
        if (minAcceptedVersion.equalsIgnoreCase(adapterVersion)) {
            return true;
        }
        String[] minAcceptedVersionArr = minAcceptedVersion.split("\\.");
        String[] adapterVersionArr = adapterVersion.split("\\.");
        for (int i2 = 0; i2 < 3; ++i2) {
            int minDigit = Integer.parseInt(minAcceptedVersionArr[i2]);
            int adapterDigit = Integer.parseInt(adapterVersionArr[i2]);
            if (adapterDigit >= minDigit) continue;
            return false;
        }
        return true;
    }
}

