/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.ironsource;

import android.app.Activity;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import com.ironsource.sdk.IronSourceAdInstance;
import com.ironsource.sdk.IronSourceAdInstanceBuilder;
import com.ironsource.sdk.IronSourceNetwork;
import com.ironsource.sdk.listeners.OnInterstitialListener;
import com.ironsource.sdk.utils.SDKUtils;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class IronSourceAdapter
extends AbstractAdapter {
    private static final String VERSION = "6.8.4";
    private static final int IS_LOAD_EXCEPTION = 1000;
    private static final int IS_SHOW_EXCEPTION = 1001;
    private static final int RV_LOAD_EXCEPTION = 1002;
    private static final int RV_SHOW_EXCEPTION = 1003;
    private final String DYNAMIC_CONTROLLER_URL = "controllerUrl";
    private final String DYNAMIC_CONTROLLER_DEBUG_MODE = "debugMode";
    private final String DYNAMIC_CONTROLLER_CONFIG = "controllerConfig";
    private IronSourceAdInstance mInterstitialAdInstance = null;
    private InterstitialSmashListener mIsSmashListener = null;
    private IronSourceAdInstance mRewardedVideoAdInstance = null;
    private RewardedVideoSmashListener mRvSmashListener = null;
    private OnInterstitialListener interstitialListener = new OnInterstitialListener(){

        @Override
        public void onInterstitialInitSuccess() {
        }

        @Override
        public void onInterstitialInitFailed(String description) {
        }

        @Override
        public void onInterstitialLoadSuccess() {
            IronSourceAdapter.this.log("interstitialListener onInterstitialLoadSuccess");
            if (IronSourceAdapter.this.mIsSmashListener != null) {
                IronSourceAdapter.this.mIsSmashListener.onInterstitialAdReady();
            }
        }

        @Override
        public void onInterstitialLoadFailed(String description) {
            IronSourceAdapter.this.log("interstitialListener onInterstitialLoadFailed " + description);
            if (IronSourceAdapter.this.mIsSmashListener != null) {
                IronSourceAdapter.this.mIsSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError(description));
            }
        }

        @Override
        public void onInterstitialOpen() {
            IronSourceAdapter.this.log("interstitialListener onInterstitialOpen");
            if (IronSourceAdapter.this.mIsSmashListener != null) {
                IronSourceAdapter.this.mIsSmashListener.onInterstitialAdOpened();
            }
        }

        @Override
        public void onInterstitialAdRewarded(String demandSourceId, int amount) {
            IronSourceAdapter.this.log("interstitialListener onInterstitialAdRewarded demandSourceId=" + demandSourceId + " amount=" + amount);
        }

        @Override
        public void onInterstitialClose() {
            IronSourceAdapter.this.log("interstitialListener onInterstitialClose");
            if (IronSourceAdapter.this.mIsSmashListener != null) {
                IronSourceAdapter.this.mIsSmashListener.onInterstitialAdClosed();
            }
        }

        @Override
        public void onInterstitialShowSuccess() {
        }

        @Override
        public void onInterstitialShowFailed(String description) {
            IronSourceAdapter.this.log("interstitialListener onInterstitialShowFailed " + description);
            if (IronSourceAdapter.this.mIsSmashListener != null) {
                IronSourceAdapter.this.mIsSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError("Interstitial", description));
            }
        }

        @Override
        public void onInterstitialClick() {
            IronSourceAdapter.this.log("interstitialListener onInterstitialClick");
            if (IronSourceAdapter.this.mIsSmashListener != null) {
                IronSourceAdapter.this.mIsSmashListener.onInterstitialAdClicked();
            }
        }

        @Override
        public void onInterstitialEventNotificationReceived(String eventName, JSONObject extData) {
            IronSourceAdapter.this.log("interstitialListener onInterstitialEventNotificationReceived eventName=" + eventName);
            if (IronSourceAdapter.this.mIsSmashListener != null) {
                IronSourceAdapter.this.mIsSmashListener.onInterstitialAdVisible();
            }
        }
    };
    private OnInterstitialListener rewardedVideoListener = new OnInterstitialListener(){

        @Override
        public void onInterstitialInitSuccess() {
        }

        @Override
        public void onInterstitialInitFailed(String description) {
        }

        @Override
        public void onInterstitialLoadSuccess() {
            IronSourceAdapter.this.log("rewardedVideoListener onInterstitialLoadSuccess");
            if (IronSourceAdapter.this.mRvSmashListener != null) {
                IronSourceAdapter.this.mRvSmashListener.onRewardedVideoLoadSuccess();
            }
        }

        @Override
        public void onInterstitialLoadFailed(String description) {
            IronSourceAdapter.this.log("rewardedVideoListener onInterstitialLoadFailed " + description);
            if (IronSourceAdapter.this.mRvSmashListener != null) {
                IronSourceAdapter.this.mRvSmashListener.onRewardedVideoLoadFailed(ErrorBuilder.buildLoadFailedError(description));
            }
        }

        @Override
        public void onInterstitialOpen() {
            IronSourceAdapter.this.log("rewardedVideoListener onInterstitialOpen");
            if (IronSourceAdapter.this.mRvSmashListener != null) {
                IronSourceAdapter.this.mRvSmashListener.onRewardedVideoAdOpened();
            }
        }

        @Override
        public void onInterstitialAdRewarded(String demandSourceId, int amount) {
            IronSourceAdapter.this.log("rewardedVideoListener onInterstitialAdRewarded demandSourceId=" + demandSourceId + " amount=" + amount);
            if (IronSourceAdapter.this.mRvSmashListener != null) {
                IronSourceAdapter.this.mRvSmashListener.onRewardedVideoAdRewarded();
            }
        }

        @Override
        public void onInterstitialClose() {
            IronSourceAdapter.this.log("rewardedVideoListener onInterstitialClose");
            if (IronSourceAdapter.this.mRvSmashListener != null) {
                IronSourceAdapter.this.mRvSmashListener.onRewardedVideoAdClosed();
            }
        }

        @Override
        public void onInterstitialShowSuccess() {
            IronSourceAdapter.this.log("rewardedVideoListener onInterstitialShowSuccess");
        }

        @Override
        public void onInterstitialShowFailed(String description) {
            IronSourceAdapter.this.log("rewardedVideoListener onInterstitialShowSuccess " + description);
            if (IronSourceAdapter.this.mRvSmashListener != null) {
                IronSourceAdapter.this.mRvSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildShowFailedError("Rewarded Video", description));
            }
        }

        @Override
        public void onInterstitialClick() {
            IronSourceAdapter.this.log("rewardedVideoListener onInterstitialClick");
            if (IronSourceAdapter.this.mRvSmashListener != null) {
                IronSourceAdapter.this.mRvSmashListener.onRewardedVideoAdClicked();
            }
        }

        @Override
        public void onInterstitialEventNotificationReceived(String eventName, JSONObject extData) {
            IronSourceAdapter.this.log("rewardedVideoListener onInterstitialEventNotificationReceived eventName=" + eventName);
            if (IronSourceAdapter.this.mRvSmashListener != null) {
                IronSourceAdapter.this.mRvSmashListener.onRewardedVideoAdVisible();
            }
        }
    };

    public static IronSourceAdapter startAdapter(String providerName) {
        return new IronSourceAdapter(providerName);
    }

    private IronSourceAdapter(String providerName) {
        super(providerName);
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public String getCoreSDKVersion() {
        return SDKUtils.getSDKVersion();
    }

    @Override
    public void onPause(Activity activity) {
        IronSourceNetwork.onPause(activity);
    }

    @Override
    public void onResume(Activity activity) {
        IronSourceNetwork.onResume(activity);
    }

    @Override
    protected void setConsent(boolean consent) {
        JSONObject consentParams = new JSONObject();
        try {
            consentParams.put("gdprConsentStatus", (Object)String.valueOf(consent));
            consentParams.put("demandSourceName", (Object)this.getProviderName());
        }
        catch (JSONException e2) {
            this.logError("setConsent exception " + e2.getMessage());
            return;
        }
        IronSourceNetwork.updateConsentInfo(consentParams);
    }

    @Override
    public void initInterstitial(Activity activity, String appKey, String userId, JSONObject config, InterstitialSmashListener listener) {
        this.mIsSmashListener = listener;
        this.initSDK(activity, appKey, userId, config);
        this.mInterstitialAdInstance = new IronSourceAdInstanceBuilder(this.getProviderName(), this.interstitialListener).build();
        this.mIsSmashListener.onInterstitialInitSuccess();
    }

    @Override
    public void loadInterstitial(JSONObject config, InterstitialSmashListener listener) {
        try {
            IronSourceNetwork.loadAd(this.mInterstitialAdInstance);
        }
        catch (Exception e2) {
            this.logError("loadInterstitial exception " + e2.getMessage());
            this.mIsSmashListener.onInterstitialAdLoadFailed(new IronSourceError(1000, e2.getMessage()));
        }
    }

    @Override
    public void showInterstitial(JSONObject config, InterstitialSmashListener listener) {
        try {
            int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(2);
            HashMap<String, String> showParams = new HashMap<String, String>();
            showParams.put("sessionDepth", String.valueOf(sessionDepth));
            IronSourceNetwork.showAd(this.mInterstitialAdInstance, showParams);
        }
        catch (Exception e2) {
            this.logError("showInterstitial exception " + e2.getMessage());
            this.mIsSmashListener.onInterstitialAdShowFailed(new IronSourceError(1001, e2.getMessage()));
        }
    }

    @Override
    public boolean isInterstitialReady(JSONObject config) {
        return this.mInterstitialAdInstance != null && IronSourceNetwork.isAdAvailableForInstance(this.mInterstitialAdInstance);
    }

    @Override
    public void initRewardedVideo(Activity activity, String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
        this.mRvSmashListener = listener;
        this.initSDK(activity, appKey, userId, config);
        this.mRewardedVideoAdInstance = new IronSourceAdInstanceBuilder(this.getProviderName(), this.rewardedVideoListener).setRewarded().build();
    }

    @Override
    public void fetchRewardedVideo(JSONObject config) {
        try {
            IronSourceNetwork.loadAd(this.mRewardedVideoAdInstance);
        }
        catch (Exception e2) {
            this.logError("fetchRewardedVideo exception " + e2.getMessage());
            this.mRvSmashListener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
        }
    }

    @Override
    public void loadVideo(JSONObject config, RewardedVideoSmashListener listener) {
        try {
            IronSourceNetwork.loadAd(this.mRewardedVideoAdInstance);
        }
        catch (Exception e2) {
            this.logError("loadVideo exception " + e2.getMessage());
            this.mRvSmashListener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
        }
    }

    @Override
    public void showRewardedVideo(JSONObject config, RewardedVideoSmashListener listener) {
        try {
            int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(1);
            HashMap<String, String> showParams = new HashMap<String, String>();
            showParams.put("sessionDepth", String.valueOf(sessionDepth));
            IronSourceNetwork.showAd(this.mRewardedVideoAdInstance, showParams);
        }
        catch (Exception e2) {
            this.logError("showRewardedVideo exception " + e2.getMessage());
            this.mRvSmashListener.onRewardedVideoAdShowFailed(new IronSourceError(1003, e2.getMessage()));
        }
    }

    @Override
    public boolean isRewardedVideoAvailable(JSONObject config) {
        return this.mRewardedVideoAdInstance != null && IronSourceNetwork.isAdAvailableForInstance(this.mRewardedVideoAdInstance);
    }

    private synchronized void initSDK(Activity activity, String appKey, String userId, JSONObject config) {
        SDKUtils.setControllerUrl(config.optString("controllerUrl"));
        SDKUtils.setDebugMode(config.optInt("debugMode", 0));
        SDKUtils.setControllerConfig(config.optString("controllerConfig", ""));
        IronSourceNetwork.initSDK(activity, appKey, userId, null);
    }

    private void logError(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "IronSourceAdapter " + text, 3);
    }

    private void log(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "IronSourceAdapter " + text, 0);
    }
}

