/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.utils;

import com.ironsource.mediationsdk.ProgSmash;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionCappingManager {
    private Map<String, Integer> mShowCountMap = new HashMap<String, Integer>();

    public SessionCappingManager(List<ProgSmash> smashes) {
        for (ProgSmash smash : smashes) {
            this.mShowCountMap.put(smash.getInstanceName(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseShowCounter(ProgSmash smash) {
        SessionCappingManager sessionCappingManager = this;
        synchronized (sessionCappingManager) {
            String instanceName = smash.getInstanceName();
            if (this.mShowCountMap.containsKey(instanceName)) {
                this.mShowCountMap.put(instanceName, this.mShowCountMap.get(instanceName) + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCapped(ProgSmash smash) {
        SessionCappingManager sessionCappingManager = this;
        synchronized (sessionCappingManager) {
            String instanceName = smash.getInstanceName();
            if (this.mShowCountMap.containsKey(instanceName)) {
                return this.mShowCountMap.get(instanceName) >= smash.getMaxAdsPerSession();
            }
            return false;
        }
    }
}

