/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.mediationsdk.RvAuctionTiggerCallback;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import java.util.Timer;
import java.util.TimerTask;

public class RvAuctionTigger {
    private AuctionSettings mAuctionSettings;
    private RvAuctionTiggerCallback mListener;
    private Timer mTimer;

    public RvAuctionTigger(AuctionSettings auctionSettings, RvAuctionTiggerCallback listener) {
        this.mAuctionSettings = auctionSettings;
        this.mListener = listener;
        this.mTimer = new Timer();
    }

    public synchronized void showStart() {
        if (this.mAuctionSettings.getIsAuctionOnShowStart()) {
            this.mTimer.cancel();
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    RvAuctionTigger.this.mListener.onAuctionTriggered();
                }
            }, this.mAuctionSettings.getTimeToWaitBeforeAuctionMs());
        }
    }

    public synchronized void showEnd() {
        if (!this.mAuctionSettings.getIsAuctionOnShowStart()) {
            this.mTimer.cancel();
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    RvAuctionTigger.this.mListener.onAuctionTriggered();
                }
            }, this.mAuctionSettings.getTimeToWaitBeforeAuctionMs());
        }
    }

    public synchronized void showError() {
        this.mTimer.cancel();
        this.mListener.onAuctionTriggered();
    }

    public synchronized void loadError() {
        this.mTimer.cancel();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                RvAuctionTigger.this.mListener.onAuctionTriggered();
            }
        }, this.mAuctionSettings.getAuctionRetryInterval());
    }
}

