/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.RewardedVideoManagerListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashApi;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class RewardedVideoSmash
extends AbstractSmash
implements RewardedVideoSmashListener,
RewardedVideoSmashApi {
    private JSONObject mRewardedVideoAdapterConfigs;
    private RewardedVideoManagerListener mRewardedVideoManagerListener;
    private String mRequestUrl;
    private int mTimeout;
    private final String REQUEST_URL_KEY = "requestUrl";

    RewardedVideoSmash(ProviderSettings adapterConfigs, int timeout) {
        super(adapterConfigs);
        this.mRewardedVideoAdapterConfigs = adapterConfigs.getRewardedVideoSettings();
        this.mMaxAdsPerIteration = this.mRewardedVideoAdapterConfigs.optInt("maxAdsPerIteration", 99);
        this.mMaxAdsPerSession = this.mRewardedVideoAdapterConfigs.optInt("maxAdsPerSession", 99);
        this.mMaxAdsPerDay = this.mRewardedVideoAdapterConfigs.optInt("maxAdsPerDay", 99);
        this.mRequestUrl = this.mRewardedVideoAdapterConfigs.optString("requestUrl");
        this.mTimeout = timeout;
    }

    @Override
    void completeIteration() {
        this.mIterationShowCounter = 0;
        this.setMediationState(this.isRewardedVideoAvailable() ? AbstractSmash.MEDIATION_STATE.AVAILABLE : AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
    }

    @Override
    void startInitTimer() {
        try {
            this.stopInitTimer();
            this.mInitTimer = new Timer();
            this.mInitTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    this.cancel();
                    if (RewardedVideoSmash.this.mRewardedVideoManagerListener != null) {
                        RewardedVideoSmash.this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, "Timeout for " + RewardedVideoSmash.this.getInstanceName(), 0);
                        RewardedVideoSmash.this.setMediationState(AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
                        RewardedVideoSmash.this.mRewardedVideoManagerListener.onRewardedVideoAvailabilityChanged(false, RewardedVideoSmash.this);
                    }
                }
            }, this.mTimeout * 1000);
        }
        catch (Exception e2) {
            this.logException("startInitTimer", e2.getLocalizedMessage());
        }
    }

    @Override
    void startLoadTimer() {
    }

    @Override
    protected String getAdUnitString() {
        return "rewardedvideo";
    }

    @Override
    public void initRewardedVideo(Activity activity, String appKey, String userId) {
        this.startInitTimer();
        if (this.mAdapter != null) {
            this.mAdapter.addRewardedVideoListener(this);
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":initRewardedVideo()", 1);
            this.mAdapter.initRewardedVideo(activity, appKey, userId, this.mRewardedVideoAdapterConfigs, this);
        }
    }

    @Override
    public void fetchRewardedVideo() {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":fetchRewardedVideo()", 1);
            this.mAdapter.fetchRewardedVideo(this.mRewardedVideoAdapterConfigs);
        }
    }

    @Override
    public void showRewardedVideo() {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":showRewardedVideo()", 1);
            this.preShow();
            this.mAdapter.showRewardedVideo(this.mRewardedVideoAdapterConfigs, this);
        }
    }

    @Override
    public boolean isRewardedVideoAvailable() {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":isRewardedVideoAvailable()", 1);
            return this.mAdapter.isRewardedVideoAvailable(this.mRewardedVideoAdapterConfigs);
        }
        return false;
    }

    @Override
    public void setRewardedVideoManagerListener(RewardedVideoManagerListener listener) {
        this.mRewardedVideoManagerListener = listener;
    }

    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error) {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdShowFailed(error, this);
        }
    }

    @Override
    public void onRewardedVideoInitSuccess() {
    }

    @Override
    public void onRewardedVideoInitFailed(IronSourceError error) {
    }

    @Override
    public void onRewardedVideoAdOpened() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdOpened(this);
        }
    }

    @Override
    public void onRewardedVideoAdClosed() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdClosed(this);
        }
        this.fetchRewardedVideo();
    }

    @Override
    public void onRewardedVideoAvailabilityChanged(boolean available) {
        this.stopInitTimer();
        if (this.isMediationAvailable() && (available && this.mMediationState != AbstractSmash.MEDIATION_STATE.AVAILABLE || !available && this.mMediationState != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE)) {
            this.setMediationState(available ? AbstractSmash.MEDIATION_STATE.AVAILABLE : AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
            if (this.mRewardedVideoManagerListener != null) {
                this.mRewardedVideoManagerListener.onRewardedVideoAvailabilityChanged(available, this);
            }
        }
    }

    @Override
    public void onRewardedVideoAdStarted() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdStarted(this);
        }
    }

    @Override
    public void onRewardedVideoAdEnded() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdEnded(this);
        }
    }

    @Override
    public void onRewardedVideoAdRewarded() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdRewarded(this);
        }
    }

    @Override
    public void onRewardedVideoAdClicked() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdClicked(this);
        }
    }

    @Override
    public void onRewardedVideoAdVisible() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdVisible(this);
        }
    }

    @Override
    public void onRewardedVideoLoadSuccess() {
        this.logEvent(1002, null);
    }

    @Override
    public void onRewardedVideoLoadFailed(IronSourceError error) {
        String errorReason = error.getErrorMessage().substring(0, Math.min(error.getErrorMessage().length(), 39));
        this.logEvent(1200, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", errorReason}});
    }

    String getRequestUrl() {
        return this.mRequestUrl;
    }

    private void logEvent(int eventId, Object[][] keyVals) {
        JSONObject data = IronSourceUtils.getProviderAdditionalData(this, false);
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "logProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, data);
        RewardedVideoEventsManager.getInstance().log(event);
    }
}

