/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdaptersCompatibilityHandler;
import com.ironsource.mediationsdk.AuctionHandler;
import com.ironsource.mediationsdk.AuctionHandlerCallback;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.ProgRvManagerListener;
import com.ironsource.mediationsdk.ProgRvSmash;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.ProgUtils;
import com.ironsource.mediationsdk.RVListenerWrapper;
import com.ironsource.mediationsdk.RvAuctionTigger;
import com.ironsource.mediationsdk.RvAuctionTiggerCallback;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.model.RewardedVideoConfigurations;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.SessionCappingManager;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

class ProgRvManager
implements ProgRvManagerListener,
RvAuctionTiggerCallback {
    private SessionCappingManager mSessionCappingManager;
    private Boolean mLastReportedAvailabilityState;
    private RV_MEDIATION_STATE mState;
    private final ConcurrentHashMap<String, ProgRvSmash> mSmashes;
    private CopyOnWriteArrayList<ProgRvSmash> mWaterfall;
    private ConcurrentHashMap<String, AuctionResponseItem> mWaterfallServerData;
    private String mCurrentPlacement;
    private String mCurrentAuctionId;
    private int mMaxSmashesToLoad;
    private AuctionHandler mAuctionHandler;
    private Context mAppContext;
    private boolean mIsShowingVideo;
    private long mAuctionStartTime;
    private long mLastChangedAvailabilityTime;
    private RvAuctionTigger mRvAuctionTigger;

    public ProgRvManager(Activity activity, List<ProviderSettings> providersList, RewardedVideoConfigurations configs, String appKey, String userId) {
        this.setState(RV_MEDIATION_STATE.RV_STATE_INITIATING);
        this.mAppContext = activity.getApplicationContext();
        this.mLastReportedAvailabilityState = null;
        this.mMaxSmashesToLoad = configs.getRewardedVideoAdaptersSmartLoadAmount();
        this.mCurrentPlacement = "";
        AuctionSettings auctionSettings = configs.getRewardedVideoAuctionSettings();
        this.mIsShowingVideo = false;
        this.mWaterfall = new CopyOnWriteArrayList();
        this.mWaterfallServerData = new ConcurrentHashMap();
        this.mLastChangedAvailabilityTime = new Date().getTime();
        this.mAuctionHandler = new AuctionHandler(this.mAppContext, "rewardedVideo", auctionSettings.getBlob(), auctionSettings.getUrl());
        this.mRvAuctionTigger = new RvAuctionTigger(auctionSettings, this);
        this.mSmashes = new ConcurrentHashMap();
        for (ProviderSettings provider : providersList) {
            AbstractAdapter adapter = ProgUtils.loadAdapter(provider);
            if (adapter == null || !AdaptersCompatibilityHandler.getInstance().isAdapterVersionCompatible(adapter)) continue;
            IronSourceObject.getInstance().addToRVAdaptersList(adapter);
            ProgRvSmash smash = new ProgRvSmash(activity, appKey, userId, provider, this, configs.getRewardedVideoAdaptersSmartLoadTimeout(), adapter);
            this.mSmashes.put(smash.getInstanceName(), smash);
        }
        this.mSessionCappingManager = new SessionCappingManager(new ArrayList<ProgSmash>(this.mSmashes.values()));
        for (ProgRvSmash smash : this.mSmashes.values()) {
            if (!smash.isBidder()) continue;
            smash.initForBidding();
        }
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                ProgRvManager.this.makeAuction();
            }
        }, auctionSettings.getTimeToWaitBeforeFirstAuctionMs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void showRewardedVideo(Placement placement) {
        if (placement == null) {
            String message = "showRewardedVideo error: empty default placement in response";
            this.logInternal(message);
            IronSourceError error = new IronSourceError(1021, message);
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.sendMediationEvent(1113, new Object[][]{{"errorCode", 1021}});
            return;
        }
        this.logApi("showRewardedVideo() placement=" + placement.getPlacementName());
        if (this.mIsShowingVideo) {
            String message = "showRewardedVideo error: can't show ad while an ad is already showing. State: " + (Object)((Object)this.mState);
            this.logInternal(message);
            IronSourceError error = new IronSourceError(1022, message);
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.sendMediationEvent(1113, new Object[][]{{"errorCode", 1022}});
            return;
        }
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
            String message = "showRewardedVideo error: show called at wrong state " + (Object)((Object)this.mState);
            this.logInternal(message);
            IronSourceError error = new IronSourceError(1023, message);
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.sendMediationEvent(1113, new Object[][]{{"errorCode", 1023}});
            return;
        }
        this.mCurrentPlacement = placement.getPlacementName();
        this.sendMediationEventWithPlacement(1100);
        if (CappingManager.isRvPlacementCapped(this.mAppContext, this.mCurrentPlacement)) {
            String message = "showRewardedVideo() " + this.mCurrentPlacement + " is capped";
            this.logInternal(message);
            IronSourceError error = new IronSourceError(524, message);
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", 524}});
            this.mCurrentPlacement = "";
            return;
        }
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mWaterfall) {
                if (smash.isReadyToShow()) {
                    this.mIsShowingVideo = true;
                    smash.reportShowChance(true);
                    this.showVideo(smash, placement);
                    this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_LOADED);
                    this.mRvAuctionTigger.showStart();
                    return;
                }
                smash.reportShowChance(false);
            }
        }
        RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError("Rewarded Video"));
        this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", 509}});
        this.mRvAuctionTigger.showError();
    }

    private void showVideo(ProgRvSmash smash, Placement placement) {
        this.mSessionCappingManager.increaseShowCounter(smash);
        if (this.mSessionCappingManager.isCapped(smash)) {
            smash.setCappedPerSession();
            this.logInternal(smash.getInstanceName() + " was session capped");
        }
        CappingManager.incrementRvShowCounter(this.mAppContext, placement.getPlacementName());
        if (CappingManager.isRvPlacementCapped(this.mAppContext, placement.getPlacementName())) {
            this.sendMediationEventWithPlacement(1400);
        }
        this.mAuctionHandler.reportImpression(this.mWaterfallServerData.get(smash.getInstanceName()));
        smash.showVideo(placement);
    }

    public synchronized boolean isRewardedVideoAvailable() {
        if (this.isRewardedVideoAvailableInternal()) {
            this.logApi("isRewardedVideoAvailable() result = true");
            this.sendMediationEvent(1101);
            return true;
        }
        this.logApi("isRewardedVideoAvailable() result = false");
        this.sendMediationEvent(1102);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRewardedVideoAvailableInternal() {
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW || this.mIsShowingVideo) {
            return false;
        }
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mWaterfall) {
                if (!smash.isReadyToShow()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume(Activity activity) {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mSmashes.values()) {
                smash.onResume(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPause(Activity activity) {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mSmashes.values()) {
                smash.onPause(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsent(boolean consent) {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mSmashes.values()) {
                smash.setConsent(consent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAuction() {
        this.setState(RV_MEDIATION_STATE.RV_STATE_AUCTION_IN_PROGRESS);
        this.mCurrentAuctionId = "";
        this.mAuctionStartTime = new Date().getTime();
        this.sendMediationEvent(1000);
        this.sendMediationEvent(1300);
        HashMap<String, Object> bidderCandidates = new HashMap<String, Object>();
        ArrayList<String> noBidderCandidates = new ArrayList<String>();
        StringBuilder waterfallStr = new StringBuilder();
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mSmashes.values()) {
                smash.unloadVideo();
                if (this.mSessionCappingManager.isCapped(smash)) continue;
                if (smash.isBidder() && smash.isReadyToBid()) {
                    Map<String, Object> biddingData = smash.getBiddingData();
                    if (biddingData == null) continue;
                    bidderCandidates.put(smash.getInstanceName(), biddingData);
                    waterfallStr.append("2" + smash.getInstanceName() + ",");
                    continue;
                }
                if (smash.isBidder()) continue;
                noBidderCandidates.add(smash.getInstanceName());
                waterfallStr.append("1" + smash.getInstanceName() + ",");
            }
        }
        if (bidderCandidates.keySet().size() == 0 && noBidderCandidates.size() == 0) {
            this.reportAvailabilityIfNeeded(false);
            this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_LOADED);
            this.sendMediationEvent(1301, new Object[][]{{"errorCode", 1024}, {"duration", 0}});
            this.mRvAuctionTigger.loadError();
            return;
        }
        if (waterfallStr.length() > 256) {
            waterfallStr.setLength(256);
        } else {
            waterfallStr.deleteCharAt(waterfallStr.length() - 1);
        }
        this.sendMediationEvent(1310, new Object[][]{{"ext1", waterfallStr.toString()}});
        int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(1);
        this.mAuctionHandler.executeAuction(bidderCandidates, noBidderCandidates, sessionDepth, new AuctionHandlerCallback(){

            @Override
            public void callback(boolean isSuccess, List<AuctionResponseItem> newWaterfall, String auctionId, int errorCode, String errorMessage, long elapsedTime) {
                if (isSuccess) {
                    ProgRvManager.this.sendMediationEvent(1302, new Object[][]{{"duration", elapsedTime}});
                    ProgRvManager.this.mCurrentAuctionId = auctionId;
                    ProgRvManager.this.updateWaterfall(newWaterfall);
                    ProgRvManager.this.loadSmashes();
                } else {
                    if (TextUtils.isEmpty((CharSequence)errorMessage)) {
                        ProgRvManager.this.sendMediationEvent(1301, new Object[][]{{"errorCode", errorCode}, {"duration", elapsedTime}});
                    } else {
                        String errorReason = errorMessage.substring(0, Math.min(errorMessage.length(), 39));
                        ProgRvManager.this.sendMediationEvent(1301, new Object[][]{{"errorCode", errorCode}, {"reason", errorReason}, {"duration", elapsedTime}});
                    }
                    ProgRvManager.this.reportAvailabilityIfNeeded(false);
                    ProgRvManager.this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_LOADED);
                    ProgRvManager.this.mRvAuctionTigger.loadError();
                }
            }
        });
    }

    private String getAsString(AuctionResponseItem item) {
        String isProgrammatic = TextUtils.isEmpty((CharSequence)item.getServerData()) ? "1" : "2";
        return isProgrammatic + item.getInstanceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWaterfall(List<AuctionResponseItem> waterfall) {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            this.mWaterfall.clear();
            this.mWaterfallServerData.clear();
            StringBuilder waterfallStr = new StringBuilder();
            for (AuctionResponseItem item : waterfall) {
                waterfallStr.append(this.getAsString(item) + ",");
                ProgRvSmash smash = this.mSmashes.get(item.getInstanceName());
                if (smash == null) continue;
                smash.setIsLoadCandidate(true);
                this.mWaterfall.add(smash);
                this.mWaterfallServerData.put(smash.getInstanceName(), item);
            }
            if (waterfallStr.length() > 256) {
                waterfallStr.setLength(256);
            } else {
                waterfallStr.deleteCharAt(waterfallStr.length() - 1);
            }
            this.sendMediationEvent(1311, new Object[][]{{"ext1", waterfallStr.toString()}});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSmashes() {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            this.setState(RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES);
            for (int i2 = 0; i2 < Math.min(this.mMaxSmashesToLoad, this.mWaterfall.size()); ++i2) {
                ProgRvSmash smash = this.mWaterfall.get(i2);
                String serverData = this.mWaterfallServerData.get(smash.getInstanceName()).getServerData();
                smash.loadVideo(serverData, this.mCurrentAuctionId);
            }
        }
    }

    private void setState(RV_MEDIATION_STATE state) {
        this.logInternal("current state=" + (Object)((Object)this.mState) + ", new state=" + (Object)((Object)state));
        this.mState = state;
    }

    @Override
    public synchronized void onLoadSuccess(ProgRvSmash smash, String auctionId) {
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES && this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
            this.logErrorInternal("onLoadSuccess was invoked at the wrong manager state: " + (Object)((Object)this.mState));
            return;
        }
        if (!auctionId.equalsIgnoreCase(this.mCurrentAuctionId)) {
            this.logErrorInternal("onLoadSuccess was invoked with auctionId:" + auctionId + " and the current id is " + this.mCurrentAuctionId);
            return;
        }
        this.reportAvailabilityIfNeeded(true);
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
            this.setState(RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW);
            long elapsedTime = new Date().getTime() - this.mAuctionStartTime;
            this.sendMediationEvent(1003, new Object[][]{{"duration", elapsedTime}});
        }
    }

    @Override
    public synchronized void onLoadError(ProgRvSmash smash, String auctionId) {
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES && this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
            this.logErrorInternal("onRewardedVideoAvailabilityChanged was invoked at the wrong manager state: " + (Object)((Object)this.mState));
            return;
        }
        if (!auctionId.equalsIgnoreCase(this.mCurrentAuctionId)) {
            this.logErrorInternal("onLoadError was invoked with auctionId:" + auctionId + " and the current id is " + this.mCurrentAuctionId);
            return;
        }
        boolean hasLoadInProgress = false;
        boolean hasLoaded = false;
        for (ProgRvSmash waterfallSmash : this.mWaterfall) {
            if (waterfallSmash.getIsLoadCandidate()) {
                if (this.mWaterfallServerData.get(waterfallSmash.getInstanceName()) == null) continue;
                String serverData = this.mWaterfallServerData.get(waterfallSmash.getInstanceName()).getServerData();
                waterfallSmash.loadVideo(serverData, this.mCurrentAuctionId);
                return;
            }
            if (waterfallSmash.isLoadingInProgress()) {
                hasLoadInProgress = true;
                continue;
            }
            if (!waterfallSmash.isReadyToShow()) continue;
            hasLoaded = true;
        }
        if (!hasLoaded && !hasLoadInProgress) {
            this.reportAvailabilityIfNeeded(false);
            this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_LOADED);
            this.mRvAuctionTigger.loadError();
        }
    }

    @Override
    public synchronized void onRewardedVideoAvailabilityChanged(boolean available, ProgRvSmash smash) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdOpened(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdOpened");
            RVListenerWrapper.getInstance().onRewardedVideoAdOpened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error, ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdShowFailed error=" + error.getErrorMessage());
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.mIsShowingVideo = false;
            if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
                this.reportAvailabilityIfNeeded(false);
            }
            this.mRvAuctionTigger.showError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdClosed(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdClosed");
            RVListenerWrapper.getInstance().onRewardedVideoAdClosed();
            this.mIsShowingVideo = false;
            if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
                this.reportAvailabilityIfNeeded(false);
            }
            this.mRvAuctionTigger.showEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdStarted(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdStarted");
            RVListenerWrapper.getInstance().onRewardedVideoAdStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdEnded(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdEnded");
            RVListenerWrapper.getInstance().onRewardedVideoAdEnded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdRewarded(ProgRvSmash smash, Placement placement) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdRewarded");
            RVListenerWrapper.getInstance().onRewardedVideoAdRewarded(placement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdClicked(ProgRvSmash smash, Placement placement) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdClicked");
            RVListenerWrapper.getInstance().onRewardedVideoAdClicked(placement);
        }
    }

    private void reportAvailabilityIfNeeded(boolean isAvailable) {
        if (this.mLastReportedAvailabilityState == null || this.mLastReportedAvailabilityState != isAvailable) {
            this.mLastReportedAvailabilityState = isAvailable;
            long timeSpentInLastAvailability = new Date().getTime() - this.mLastChangedAvailabilityTime;
            this.mLastChangedAvailabilityTime = new Date().getTime();
            if (isAvailable) {
                this.sendMediationEvent(1111, new Object[][]{{"duration", timeSpentInLastAvailability}});
            } else {
                this.sendMediationEvent(1112, new Object[][]{{"duration", timeSpentInLastAvailability}});
            }
            RVListenerWrapper.getInstance().onRewardedVideoAvailabilityChanged(isAvailable);
        }
    }

    private void logSmashCallback(ProgRvSmash smash, String line) {
        String text = smash.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, text, 0);
    }

    private void logInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }

    private void logErrorInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 3);
    }

    private void logApi(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, text, 1);
    }

    private void sendMediationEvent(int eventId) {
        this.sendMediationEvent(eventId, null);
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, false);
    }

    private void sendMediationEventWithPlacement(int eventId) {
        this.sendMediationEvent(eventId, null, true);
    }

    private void sendMediationEventWithPlacement(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, true);
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals, boolean isAddPlacement) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentAuctionId)) {
            data.put("auctionId", this.mCurrentAuctionId);
        }
        if (isAddPlacement && !TextUtils.isEmpty((CharSequence)this.mCurrentPlacement)) {
            data.put("placement", this.mCurrentPlacement);
        }
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "RV sendMediationEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
    }

    @Override
    public void onAuctionTriggered() {
        if (this.mState == RV_MEDIATION_STATE.RV_STATE_NOT_LOADED) {
            this.makeAuction();
        }
    }

    private static enum RV_MEDIATION_STATE {
        RV_STATE_INITIATING,
        RV_STATE_AUCTION_IN_PROGRESS,
        RV_STATE_NOT_LOADED,
        RV_STATE_LOADING_SMASHES,
        RV_STATE_READY_TO_SHOW;

    }
}

