/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdaptersCompatibilityHandler;
import com.ironsource.mediationsdk.BannerCallbackThrottler;
import com.ironsource.mediationsdk.BannerSmash;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.BannerPlacement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.BannerManagerListener;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class BannerManager
implements BannerManagerListener {
    private BannerSmash mActiveSmash;
    private IronSourceBannerLayout mIronsourceBanner;
    private BannerPlacement mCurrentPlacement;
    private BANNER_STATE mState;
    private IronSourceLoggerManager mLoggerManager;
    private String mAppKey;
    private String mUserId;
    private Activity mActivity;
    private final CopyOnWriteArrayList<BannerSmash> mSmashArray = new CopyOnWriteArrayList();
    private long mReloadInterval;
    private Timer mReloadTimer;
    private Boolean mIsInForeground = true;
    AtomicBoolean mDidImplementOnResume;
    AtomicBoolean mDidImplementOnPause;

    public BannerManager() {
        this.mLoggerManager = IronSourceLoggerManager.getLogger();
        this.mState = BANNER_STATE.NOT_INITIATED;
        this.mDidImplementOnPause = new AtomicBoolean();
        this.mDidImplementOnResume = new AtomicBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConsent(boolean consent) {
        CopyOnWriteArrayList<BannerSmash> copyOnWriteArrayList = this.mSmashArray;
        synchronized (copyOnWriteArrayList) {
            for (BannerSmash smash : this.mSmashArray) {
                smash.setConsent(consent);
            }
        }
    }

    public synchronized void initBannerManager(List<ProviderSettings> adaptersConfigs, Activity activity, String appKey, String userId, long timeout, int reloadInterval) {
        this.debugLog("initBannerManager(appKey: " + appKey + ", userId: " + userId + ")");
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mActivity = activity;
        this.mReloadInterval = reloadInterval;
        for (int i2 = 0; i2 < adaptersConfigs.size(); ++i2) {
            ProviderSettings config = adaptersConfigs.get(i2);
            AbstractAdapter adapter = this.loadAdapter(config);
            if (adapter != null && AdaptersCompatibilityHandler.getInstance().isBannerAdapterCompatible(adapter)) {
                BannerSmash smash = new BannerSmash(this, config, adapter, timeout, i2 + 1);
                this.mSmashArray.add(smash);
                continue;
            }
            this.debugLog(config.getProviderInstanceName() + " can't load adapter or wrong version");
        }
        this.mCurrentPlacement = null;
        this.setState(BANNER_STATE.READY_TO_LOAD);
    }

    public synchronized IronSourceBannerLayout createBanner(Activity activity, ISBannerSize size) {
        return new IronSourceBannerLayout(activity, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadBanner(IronSourceBannerLayout banner, BannerPlacement placement) {
        try {
            if (this.mState != BANNER_STATE.READY_TO_LOAD || BannerCallbackThrottler.getInstance().hasPendingInvocation()) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "A banner is already loaded", 3);
                return;
            }
            this.setState(BANNER_STATE.FIRST_LOAD_IN_PROGRESS);
            this.mIronsourceBanner = banner;
            this.mCurrentPlacement = placement;
            this.sendMediationEvent(3001);
            if (CappingManager.isBnPlacementCapped((Context)this.mActivity, placement.getPlacementName())) {
                BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(banner, new IronSourceError(604, "placement " + placement.getPlacementName() + " is capped"));
                this.sendMediationEvent(3111, new Object[][]{{"errorCode", 604}});
                this.setState(BANNER_STATE.READY_TO_LOAD);
                return;
            }
            CopyOnWriteArrayList<BannerSmash> copyOnWriteArrayList = this.mSmashArray;
            synchronized (copyOnWriteArrayList) {
                for (BannerSmash smash : this.mSmashArray) {
                    smash.setReadyToLoad(true);
                }
                BannerSmash smash = this.mSmashArray.get(0);
                this.sendProviderEvent(3002, smash);
                smash.loadBanner(banner, this.mActivity, this.mAppKey, this.mUserId);
            }
        }
        catch (Exception e2) {
            BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(banner, new IronSourceError(605, "loadBanner() failed " + e2.getMessage()));
            String message = e2.getMessage();
            message = message.substring(0, Math.min(message.length(), 39));
            this.sendMediationEvent(3111, new Object[][]{{"errorCode", 605}, {"reason", message}});
            this.setState(BANNER_STATE.READY_TO_LOAD);
        }
    }

    public synchronized void destroyBanner(IronSourceBannerLayout banner) {
        if (banner == null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "destroyBanner banner cannot be null", 3);
            return;
        }
        if (banner.isDestroyed()) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Banner is already destroyed and can't be used anymore. Please create a new one using IronSource.createBanner API", 3);
            return;
        }
        this.sendMediationEvent(3100);
        this.stopReloadTimer();
        banner.destroyBanner();
        this.mIronsourceBanner = null;
        this.mCurrentPlacement = null;
        if (this.mActiveSmash != null) {
            this.sendProviderEvent(3305, this.mActiveSmash);
            this.mActiveSmash.destroyBanner();
            this.mActiveSmash = null;
        }
        this.setState(BANNER_STATE.READY_TO_LOAD);
    }

    private void errorLog(String text) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "BannerManager " + text, 3);
    }

    private void debugLog(String text) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "BannerManager " + text, 0);
    }

    private void setState(BANNER_STATE state) {
        this.mState = state;
        this.debugLog("state=" + state.name());
    }

    private void callbackLog(String text, BannerSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "BannerManager " + text + " " + smash.getName(), 0);
    }

    private void bindView(BannerSmash smash, View adView, FrameLayout.LayoutParams frameLayoutParams) {
        this.mActiveSmash = smash;
        this.mIronsourceBanner.addViewWithFrameLayoutParams(adView, frameLayoutParams);
    }

    @Override
    public void onBannerAdLoaded(BannerSmash smash, View adView, FrameLayout.LayoutParams frameLayoutParams) {
        this.callbackLog("onBannerAdLoaded", smash);
        if (this.mState == BANNER_STATE.FIRST_LOAD_IN_PROGRESS) {
            this.sendProviderEvent(3005, smash);
            this.bindView(smash, adView, frameLayoutParams);
            CappingManager.incrementBnShowCounter((Context)this.mActivity, this.mCurrentPlacement.getPlacementName());
            if (CappingManager.isBnPlacementCapped((Context)this.mActivity, this.mCurrentPlacement.getPlacementName())) {
                this.sendMediationEvent(3400);
            }
            this.mIronsourceBanner.sendBannerAdLoaded(smash);
            this.sendMediationEvent(3110);
            this.setState(BANNER_STATE.RELOAD_IN_PROGRESS);
            this.startReloadTimer();
        } else if (this.mState == BANNER_STATE.LOAD_IN_PROGRESS) {
            this.sendProviderEvent(3015, smash);
            this.bindView(smash, adView, frameLayoutParams);
            this.setState(BANNER_STATE.RELOAD_IN_PROGRESS);
            this.startReloadTimer();
        }
    }

    @Override
    public void onBannerAdLoadFailed(IronSourceError error, BannerSmash smash, boolean isNoFillError) {
        this.callbackLog("onBannerAdLoadFailed " + error.getErrorMessage(), smash);
        if (this.mState != BANNER_STATE.FIRST_LOAD_IN_PROGRESS && this.mState != BANNER_STATE.LOAD_IN_PROGRESS) {
            this.debugLog("onBannerAdLoadFailed " + smash.getName() + " wrong state=" + this.mState.name());
            return;
        }
        if (isNoFillError) {
            this.sendProviderEvent(3306, smash);
        } else {
            this.sendProviderEvent(3300, smash, new Object[][]{{"errorCode", error.getErrorCode()}});
        }
        if (this.loadNextSmash()) {
            return;
        }
        if (this.mState == BANNER_STATE.FIRST_LOAD_IN_PROGRESS) {
            BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(this.mIronsourceBanner, new IronSourceError(606, "No ads to show"));
            this.sendMediationEvent(3111, new Object[][]{{"errorCode", 606}});
            this.setState(BANNER_STATE.READY_TO_LOAD);
        } else {
            this.sendMediationEvent(3201);
            this.setState(BANNER_STATE.RELOAD_IN_PROGRESS);
            this.startReloadTimer();
        }
    }

    @Override
    public void onBannerAdReloaded(BannerSmash smash) {
        this.callbackLog("onBannerAdReloaded", smash);
        if (this.mState != BANNER_STATE.RELOAD_IN_PROGRESS) {
            this.debugLog("onBannerAdReloaded " + smash.getName() + " wrong state=" + this.mState.name());
            return;
        }
        IronSourceUtils.sendAutomationLog("bannerReloadSucceeded");
        this.sendProviderEvent(3015, smash);
        this.startReloadTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBannerAdReloadFailed(IronSourceError error, BannerSmash smash, boolean isNoFillError) {
        this.callbackLog("onBannerAdReloadFailed " + error.getErrorMessage(), smash);
        if (this.mState != BANNER_STATE.RELOAD_IN_PROGRESS) {
            this.debugLog("onBannerAdReloadFailed " + smash.getName() + " wrong state=" + this.mState.name());
            return;
        }
        if (isNoFillError) {
            this.sendProviderEvent(3307, smash);
        } else {
            this.sendProviderEvent(3301, smash, new Object[][]{{"errorCode", error.getErrorCode()}});
        }
        CopyOnWriteArrayList<BannerSmash> copyOnWriteArrayList = this.mSmashArray;
        synchronized (copyOnWriteArrayList) {
            if (this.mSmashArray.size() == 1) {
                this.sendMediationEvent(3201);
                this.startReloadTimer();
            }
        }
        this.setState(BANNER_STATE.LOAD_IN_PROGRESS);
        this.resetIteration();
        this.loadNextSmash();
    }

    @Override
    public void onBannerAdClicked(BannerSmash smash) {
        this.callbackLog("onBannerAdClicked", smash);
        this.sendMediationEvent(3112);
        this.mIronsourceBanner.sendBannerAdClicked();
        this.sendProviderEvent(3008, smash);
    }

    @Override
    public void onBannerAdScreenDismissed(BannerSmash smash) {
        this.callbackLog("onBannerAdScreenDismissed", smash);
        this.sendMediationEvent(3114);
        this.mIronsourceBanner.sendBannerAdScreenDismissed();
        this.sendProviderEvent(3303, smash);
    }

    @Override
    public void onBannerAdScreenPresented(BannerSmash smash) {
        this.callbackLog("onBannerAdScreenPresented", smash);
        this.sendMediationEvent(3113);
        this.mIronsourceBanner.sendBannerAdScreenPresented();
        this.sendProviderEvent(3302, smash);
    }

    @Override
    public void onBannerAdLeftApplication(BannerSmash smash) {
        this.callbackLog("onBannerAdLeftApplication", smash);
        this.sendMediationEvent(3115, null);
        this.mIronsourceBanner.sendBannerAdLeftApplication();
        this.sendProviderEvent(3304, smash, null);
    }

    private void sendMediationEvent(int eventId) {
        this.sendMediationEvent(eventId, null);
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals) {
        JSONObject data = IronSourceUtils.getMediationAdditionalData(false);
        try {
            if (this.mIronsourceBanner != null) {
                this.addEventSizeFields(data, this.mIronsourceBanner.getSize());
            }
            if (this.mCurrentPlacement != null) {
                data.put("placement", (Object)this.mCurrentPlacement.getPlacementName());
            }
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "sendMediationEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, data);
        InterstitialEventsManager.getInstance().log(event);
    }

    private void sendProviderEvent(int eventId, BannerSmash smash) {
        this.sendProviderEvent(eventId, smash, null);
    }

    private void addEventSizeFields(JSONObject data, ISBannerSize size) {
        try {
            switch (size.getDescription()) {
                case "BANNER": {
                    data.put("bannerAdSize", 1);
                    break;
                }
                case "LARGE": {
                    data.put("bannerAdSize", 2);
                    break;
                }
                case "RECTANGLE": {
                    data.put("bannerAdSize", 3);
                    break;
                }
                case "SMART": {
                    data.put("bannerAdSize", 5);
                    break;
                }
                case "CUSTOM": {
                    data.put("bannerAdSize", 6);
                    data.put("custom_banner_size", (Object)(size.getWidth() + "x" + size.getHeight()));
                }
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "sendProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
    }

    private void sendProviderEvent(int eventId, BannerSmash smash, Object[][] keyVals) {
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            if (this.mIronsourceBanner != null) {
                this.addEventSizeFields(data, this.mIronsourceBanner.getSize());
            }
            if (this.mCurrentPlacement != null) {
                data.put("placement", (Object)this.mCurrentPlacement.getPlacementName());
            }
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "sendProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, data);
        InterstitialEventsManager.getInstance().log(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIteration() {
        CopyOnWriteArrayList<BannerSmash> copyOnWriteArrayList = this.mSmashArray;
        synchronized (copyOnWriteArrayList) {
            for (BannerSmash smash : this.mSmashArray) {
                smash.setReadyToLoad(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadNextSmash() {
        CopyOnWriteArrayList<BannerSmash> copyOnWriteArrayList = this.mSmashArray;
        synchronized (copyOnWriteArrayList) {
            for (BannerSmash smash : this.mSmashArray) {
                if (!smash.isReadyToLoad() || this.mActiveSmash == smash) continue;
                if (this.mState == BANNER_STATE.FIRST_LOAD_IN_PROGRESS) {
                    this.sendProviderEvent(3002, smash);
                } else {
                    this.sendProviderEvent(3012, smash);
                }
                smash.loadBanner(this.mIronsourceBanner, this.mActivity, this.mAppKey, this.mUserId);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPause(Activity activity) {
        CopyOnWriteArrayList<BannerSmash> copyOnWriteArrayList = this.mSmashArray;
        synchronized (copyOnWriteArrayList) {
            this.mIsInForeground = false;
            for (BannerSmash smash : this.mSmashArray) {
                smash.onPause(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume(Activity activity) {
        CopyOnWriteArrayList<BannerSmash> copyOnWriteArrayList = this.mSmashArray;
        synchronized (copyOnWriteArrayList) {
            this.mIsInForeground = true;
            for (BannerSmash smash : this.mSmashArray) {
                smash.onResume(activity);
            }
        }
    }

    private void startReloadTimer() {
        try {
            this.stopReloadTimer();
            this.mReloadTimer = new Timer();
            this.mReloadTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    BannerManager.this.onReloadTimer();
                }
            }, this.mReloadInterval * 1000L);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void stopReloadTimer() {
        if (this.mReloadTimer != null) {
            this.mReloadTimer.cancel();
            this.mReloadTimer = null;
        }
    }

    private void onReloadTimer() {
        if (this.mState != BANNER_STATE.RELOAD_IN_PROGRESS) {
            this.debugLog("onReloadTimer wrong state=" + this.mState.name());
            return;
        }
        if (this.mIsInForeground.booleanValue()) {
            this.sendMediationEvent(3011);
            this.sendProviderEvent(3012, this.mActiveSmash);
            this.mActiveSmash.reloadBanner();
        } else {
            this.sendMediationEvent(3200, new Object[][]{{"errorCode", 614}});
            this.startReloadTimer();
        }
    }

    private AbstractAdapter getLoadedAdapterOrFetchByReflection(String name, String reflectionName) {
        try {
            IronSourceObject sso = IronSourceObject.getInstance();
            AbstractAdapter providerAdapter = sso.getExistingAdapter(name);
            if (providerAdapter != null) {
                this.debugLog("using previously loaded " + name);
                return providerAdapter;
            }
            this.debugLog("loading " + name + " with reflection");
            Class<?> mAdapterClass = Class.forName("com.ironsource.adapters." + reflectionName.toLowerCase() + "." + reflectionName + "Adapter");
            Method startAdapterMethod = mAdapterClass.getMethod("startAdapter", String.class);
            return (AbstractAdapter)startAdapterMethod.invoke(mAdapterClass, name);
        }
        catch (Exception ex) {
            this.errorLog("getLoadedAdapterOrFetchByReflection " + ex.getMessage());
            return null;
        }
    }

    private AbstractAdapter loadAdapter(ProviderSettings config) {
        AbstractAdapter providerAdapter;
        String name = config.isMultipleInstances() ? config.getProviderTypeForReflection() : config.getProviderName();
        String reflectionName = config.getProviderTypeForReflection();
        this.debugLog("loadAdapter(" + name + ")");
        try {
            providerAdapter = this.getLoadedAdapterOrFetchByReflection(name, reflectionName);
            if (providerAdapter == null) {
                return null;
            }
            IronSourceObject.getInstance().addToBannerAdaptersList(providerAdapter);
            providerAdapter.setLogListener(this.mLoggerManager);
        }
        catch (Throwable e2) {
            this.errorLog("loadAdapter(" + name + ") " + e2.getMessage());
            return null;
        }
        return providerAdapter;
    }

    private static enum BANNER_STATE {
        NOT_INITIATED,
        READY_TO_LOAD,
        FIRST_LOAD_IN_PROGRESS,
        LOAD_IN_PROGRESS,
        RELOAD_IN_PROGRESS;

    }
}

