/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.agent;

import android.app.Activity;
import android.content.Context;
import android.content.MutableContextWrapper;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.ironsource.sdk.ISAdSize;
import com.ironsource.sdk.ISNAdView.ISNAdView;
import com.ironsource.sdk.SSAPublisher;
import com.ironsource.sdk.controller.BannerJSAdapter;
import com.ironsource.sdk.controller.DemandSourceManager;
import com.ironsource.sdk.controller.IronSourceWebView;
import com.ironsource.sdk.controller.MOATJSAdapter;
import com.ironsource.sdk.controller.PermissionsJSAdapter;
import com.ironsource.sdk.data.AdUnitsReady;
import com.ironsource.sdk.data.DemandSource;
import com.ironsource.sdk.data.SSAEnums;
import com.ironsource.sdk.data.SSASession;
import com.ironsource.sdk.listeners.OnBannerListener;
import com.ironsource.sdk.listeners.OnInterstitialListener;
import com.ironsource.sdk.listeners.OnOfferWallListener;
import com.ironsource.sdk.listeners.OnRewardedVideoListener;
import com.ironsource.sdk.listeners.internals.DSAdProductListener;
import com.ironsource.sdk.listeners.internals.DSBannerListener;
import com.ironsource.sdk.listeners.internals.DSInterstitialListener;
import com.ironsource.sdk.listeners.internals.DSRewardedVideoListener;
import com.ironsource.sdk.utils.DeviceProperties;
import com.ironsource.sdk.utils.IronSourceAsyncHttpRequestTask;
import com.ironsource.sdk.utils.IronSourceSharedPrefHelper;
import com.ironsource.sdk.utils.Logger;
import com.ironsource.sdk.utils.SDKUtils;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class IronSourceAdsPublisherAgent
implements SSAPublisher,
DSRewardedVideoListener,
DSInterstitialListener,
DSAdProductListener,
DSBannerListener {
    private static final String TAG = "IronSourceAdsPublisherAgent";
    private final String SUPERSONIC_ADS = "SupersonicAds";
    private static IronSourceAdsPublisherAgent sInstance;
    private IronSourceWebView wvc;
    private SSASession session;
    private static MutableContextWrapper mutableContextWrapper;
    private long adViewContainerCounter;
    private DemandSourceManager mDemandSourceManager;
    private BannerJSAdapter mBannerJSAdapter;

    private IronSourceAdsPublisherAgent(final Activity activity, int debugMode) throws Exception {
        IronSourceSharedPrefHelper.getSupersonicPrefHelper((Context)activity);
        this.mDemandSourceManager = new DemandSourceManager();
        Logger.enableLogging(SDKUtils.getDebugMode());
        Logger.i(TAG, "C'tor");
        mutableContextWrapper = new MutableContextWrapper((Context)activity);
        this.adViewContainerCounter = 0L;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.wvc = new IronSourceWebView((Context)mutableContextWrapper, IronSourceAdsPublisherAgent.this.mDemandSourceManager);
                IronSourceAdsPublisherAgent.this.wvc.addMoatJSInterface(new MOATJSAdapter(activity.getApplication()));
                IronSourceAdsPublisherAgent.this.wvc.addPermissionsJSInterface(new PermissionsJSAdapter(activity.getApplicationContext()));
                IronSourceAdsPublisherAgent.this.mBannerJSAdapter = new BannerJSAdapter();
                IronSourceAdsPublisherAgent.this.mBannerJSAdapter.setCommunicationWithController(IronSourceAdsPublisherAgent.this.wvc.getControllerDelegate());
                IronSourceAdsPublisherAgent.this.wvc.addBannerJSInterface(IronSourceAdsPublisherAgent.this.mBannerJSAdapter);
                IronSourceAdsPublisherAgent.this.wvc.registerConnectionReceiver((Context)activity);
                IronSourceAdsPublisherAgent.this.wvc.setDebugMode(SDKUtils.getDebugMode());
                IronSourceAdsPublisherAgent.this.wvc.downloadController();
            }
        });
        this.startSession((Context)activity);
    }

    public static synchronized IronSourceAdsPublisherAgent getInstance(Activity activity) throws Exception {
        return IronSourceAdsPublisherAgent.getInstance(activity, 0);
    }

    public static synchronized IronSourceAdsPublisherAgent getInstance(Activity activity, int debugMode) throws Exception {
        Logger.i(TAG, "getInstance()");
        if (sInstance == null) {
            sInstance = new IronSourceAdsPublisherAgent(activity, debugMode);
        } else {
            mutableContextWrapper.setBaseContext((Context)activity);
        }
        return sInstance;
    }

    public IronSourceWebView getWebViewController() {
        return this.wvc;
    }

    private OnRewardedVideoListener getAdProductListenerAsRVListener(DemandSource demandSource) {
        if (demandSource == null) {
            return null;
        }
        return (OnRewardedVideoListener)demandSource.getListener();
    }

    private OnInterstitialListener getAdProductListenerAsISListener(DemandSource demandSource) {
        if (demandSource == null) {
            return null;
        }
        return (OnInterstitialListener)demandSource.getListener();
    }

    private OnBannerListener getAdProductListenerAsBNListener(DemandSource demandSource) {
        if (demandSource == null) {
            return null;
        }
        return (OnBannerListener)demandSource.getListener();
    }

    private void startSession(Context context) {
        this.session = new SSASession(context, SSASession.SessionType.launched);
    }

    public void resumeSession(Context context) {
        this.session = new SSASession(context, SSASession.SessionType.backFromBG);
    }

    private void endSession() {
        if (this.session != null) {
            this.session.endSession();
            IronSourceSharedPrefHelper.getSupersonicPrefHelper().addSession(this.session);
            this.session = null;
        }
    }

    @Override
    public void initRewardedVideo(String applicationKey, String userId, String demandSourceName, Map<String, String> extraParameters, OnRewardedVideoListener listener) {
        DemandSource demandSource = this.mDemandSourceManager.createDemandSource(SSAEnums.ProductType.RewardedVideo, demandSourceName, extraParameters, listener);
        this.wvc.initRewardedVideo(applicationKey, userId, demandSource, this);
    }

    @Override
    public void showRewardedVideo(JSONObject showParams) {
        this.wvc.showRewardedVideo(showParams);
    }

    @Override
    public void initOfferWall(String applicationKey, String userId, Map<String, String> extraParameters, OnOfferWallListener listener) {
        this.wvc.initOfferWall(applicationKey, userId, extraParameters, listener);
    }

    @Override
    public void showOfferWall(Map<String, String> extraParameters) {
        this.wvc.showOfferWall(extraParameters);
    }

    @Override
    public void getOfferWallCredits(String applicationKey, String userId, OnOfferWallListener listener) {
        this.wvc.getOfferWallCredits(applicationKey, userId, listener);
    }

    @Override
    public void initInterstitial(String applicationKey, String userId, String demandSourceName, Map<String, String> extraParameters, OnInterstitialListener listener) {
        DemandSource demandSource = this.mDemandSourceManager.createDemandSource(SSAEnums.ProductType.Interstitial, demandSourceName, extraParameters, listener);
        this.wvc.initInterstitial(applicationKey, userId, demandSource, this);
    }

    @Override
    public void loadInterstitial(JSONObject loadParams) {
        String demandSourceName = null;
        if (loadParams != null) {
            demandSourceName = loadParams.optString("demandSourceName");
        }
        this.wvc.loadInterstitial(demandSourceName);
    }

    @Override
    public boolean isInterstitialAdAvailable(String demandSourceName) {
        return this.wvc.isInterstitialAdAvailable(demandSourceName);
    }

    @Override
    public void showInterstitial(JSONObject showParams) {
        this.wvc.showInterstitial(showParams);
    }

    @Override
    public void initBanner(String applicationKey, String userId, String demandSourceName, Map<String, String> extraParameters, OnBannerListener listener) {
        DemandSource demandSource = this.mDemandSourceManager.createDemandSource(SSAEnums.ProductType.Banner, demandSourceName, extraParameters, listener);
        this.wvc.initBanner(applicationKey, userId, demandSource, this);
    }

    @Override
    public void loadBanner(JSONObject loadParams) {
        if (loadParams != null) {
            this.wvc.loadBanner(loadParams);
        }
    }

    @Override
    public void onResume(Activity activity) {
        mutableContextWrapper.setBaseContext((Context)activity);
        this.wvc.enterForeground();
        this.wvc.registerConnectionReceiver((Context)activity);
        if (this.session == null) {
            this.resumeSession((Context)activity);
        }
    }

    @Override
    public void onPause(Activity activity) {
        try {
            this.wvc.enterBackground();
            this.wvc.unregisterConnectionReceiver((Context)activity);
            this.endSession();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            new IronSourceAsyncHttpRequestTask().execute(new String[]{"https://www.supersonicads.com/mobile/sdk5/log?method=" + e2.getStackTrace()[0].getMethodName()});
        }
    }

    @Override
    public void release(Activity activity) {
        try {
            Logger.i(TAG, "release()");
            DeviceProperties.release();
            this.wvc.unregisterConnectionReceiver((Context)activity);
            if (Looper.getMainLooper().equals(Looper.myLooper())) {
                this.wvc.destroy();
                this.wvc = null;
            } else {
                Handler uiHandler = new Handler(Looper.getMainLooper());
                Runnable uiRunnable = new Runnable(){

                    @Override
                    public void run() {
                        IronSourceAdsPublisherAgent.this.wvc.destroy();
                        IronSourceAdsPublisherAgent.this.wvc = null;
                    }
                };
                uiHandler.post(uiRunnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        sInstance = null;
        this.endSession();
    }

    @Override
    public void onAdProductInitSuccess(SSAEnums.ProductType type, String demandSourceName, AdUnitsReady adUnitsReady) {
        DemandSource demandSource = this.getDemandSourceByName(type, demandSourceName);
        if (demandSource != null) {
            OnBannerListener listener;
            demandSource.setDemandSourceInitState(2);
            if (type == SSAEnums.ProductType.RewardedVideo) {
                OnRewardedVideoListener listener2 = this.getAdProductListenerAsRVListener(demandSource);
                if (listener2 != null) {
                    listener2.onRVInitSuccess(adUnitsReady);
                }
            } else if (type == SSAEnums.ProductType.Interstitial) {
                OnInterstitialListener listener3 = this.getAdProductListenerAsISListener(demandSource);
                if (listener3 != null) {
                    listener3.onInterstitialInitSuccess();
                }
            } else if (type == SSAEnums.ProductType.Banner && (listener = this.getAdProductListenerAsBNListener(demandSource)) != null) {
                listener.onBannerInitSuccess();
            }
        }
    }

    @Override
    public void onAdProductInitFailed(SSAEnums.ProductType type, String demandSourceName, String description) {
        DemandSource demandSource = this.getDemandSourceByName(type, demandSourceName);
        if (demandSource != null) {
            OnBannerListener listener;
            demandSource.setDemandSourceInitState(3);
            if (type == SSAEnums.ProductType.RewardedVideo) {
                OnRewardedVideoListener listener2 = this.getAdProductListenerAsRVListener(demandSource);
                if (listener2 != null) {
                    listener2.onRVInitFail(description);
                }
            } else if (type == SSAEnums.ProductType.Interstitial) {
                OnInterstitialListener listener3 = this.getAdProductListenerAsISListener(demandSource);
                if (listener3 != null) {
                    listener3.onInterstitialInitFailed(description);
                }
            } else if (type == SSAEnums.ProductType.Banner && (listener = this.getAdProductListenerAsBNListener(demandSource)) != null) {
                listener.onBannerInitFailed(description);
            }
        }
    }

    @Override
    public void onRVNoMoreOffers(String demandSourceName) {
        OnRewardedVideoListener listener;
        DemandSource demandSource = this.getDemandSourceByName(SSAEnums.ProductType.RewardedVideo, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsRVListener(demandSource)) != null) {
            listener.onRVNoMoreOffers();
        }
    }

    @Override
    public void onRVAdCredited(String demandSourceName, int credits) {
        OnRewardedVideoListener listener;
        DemandSource demandSource = this.getDemandSourceByName(SSAEnums.ProductType.RewardedVideo, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsRVListener(demandSource)) != null) {
            listener.onRVAdCredited(credits);
        }
    }

    @Override
    public void onAdProductClose(SSAEnums.ProductType type, String demandSourceName) {
        DemandSource demandSource = this.getDemandSourceByName(type, demandSourceName);
        if (demandSource != null) {
            OnInterstitialListener listener;
            if (type == SSAEnums.ProductType.RewardedVideo) {
                OnRewardedVideoListener listener2 = this.getAdProductListenerAsRVListener(demandSource);
                if (listener2 != null) {
                    listener2.onRVAdClosed();
                }
            } else if (type == SSAEnums.ProductType.Interstitial && (listener = this.getAdProductListenerAsISListener(demandSource)) != null) {
                listener.onInterstitialClose();
            }
        }
    }

    @Override
    public void onRVShowFail(String demandSourceName, String description) {
        OnRewardedVideoListener listener;
        DemandSource demandSource = this.getDemandSourceByName(SSAEnums.ProductType.RewardedVideo, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsRVListener(demandSource)) != null) {
            listener.onRVShowFail(description);
        }
    }

    @Override
    public void onAdProductClick(SSAEnums.ProductType type, String demandSourceName) {
        DemandSource demandSource = this.getDemandSourceByName(type, demandSourceName);
        if (demandSource != null) {
            OnBannerListener listener;
            if (type == SSAEnums.ProductType.RewardedVideo) {
                OnRewardedVideoListener listener2 = this.getAdProductListenerAsRVListener(demandSource);
                if (listener2 != null) {
                    listener2.onRVAdClicked();
                }
            } else if (type == SSAEnums.ProductType.Interstitial) {
                OnInterstitialListener listener3 = this.getAdProductListenerAsISListener(demandSource);
                if (listener3 != null) {
                    listener3.onInterstitialClick();
                }
            } else if (type == SSAEnums.ProductType.Banner && (listener = this.getAdProductListenerAsBNListener(demandSource)) != null) {
                listener.onBannerClick();
            }
        }
    }

    @Override
    public void onAdProductEventNotificationReceived(SSAEnums.ProductType type, String demandSourceName, String eventName, JSONObject extData) {
        DemandSource demandSource = this.getDemandSourceByName(type, demandSourceName);
        if (demandSource != null) {
            try {
                OnRewardedVideoListener listener;
                if (type == SSAEnums.ProductType.Interstitial) {
                    OnInterstitialListener listener2 = this.getAdProductListenerAsISListener(demandSource);
                    if (listener2 != null) {
                        extData.put("demandSourceName", (Object)demandSourceName);
                        listener2.onInterstitialEventNotificationReceived(eventName, extData);
                    }
                } else if (type == SSAEnums.ProductType.RewardedVideo && (listener = this.getAdProductListenerAsRVListener(demandSource)) != null) {
                    extData.put("demandSourceName", (Object)demandSourceName);
                    listener.onRVEventNotificationReceived(eventName, extData);
                }
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        }
    }

    @Override
    public void onAdProductOpen(SSAEnums.ProductType type, String demandSourceName) {
        DemandSource demandSource = this.getDemandSourceByName(type, demandSourceName);
        if (demandSource != null) {
            OnRewardedVideoListener listener;
            if (type == SSAEnums.ProductType.Interstitial) {
                OnInterstitialListener listener2 = this.getAdProductListenerAsISListener(demandSource);
                if (listener2 != null) {
                    listener2.onInterstitialOpen();
                }
            } else if (type == SSAEnums.ProductType.RewardedVideo && (listener = this.getAdProductListenerAsRVListener(demandSource)) != null) {
                listener.onRVAdOpened();
            }
        }
    }

    @Override
    public void onInterstitialLoadSuccess(String demandSourceName) {
        OnInterstitialListener listener;
        DemandSource demandSource = this.getDemandSourceByName(SSAEnums.ProductType.Interstitial, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsISListener(demandSource)) != null) {
            listener.onInterstitialLoadSuccess();
        }
    }

    @Override
    public void onInterstitialLoadFailed(String demandSourceName, String description) {
        OnInterstitialListener listener;
        DemandSource demandSource = this.getDemandSourceByName(SSAEnums.ProductType.Interstitial, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsISListener(demandSource)) != null) {
            listener.onInterstitialLoadFailed(description);
        }
    }

    @Override
    public void onInterstitialShowSuccess(String demandSourceName) {
        OnInterstitialListener listener;
        DemandSource demandSource = this.getDemandSourceByName(SSAEnums.ProductType.Interstitial, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsISListener(demandSource)) != null) {
            listener.onInterstitialShowSuccess();
        }
    }

    @Override
    public void onInterstitialShowFailed(String demandSourceName, String description) {
        OnInterstitialListener listener;
        DemandSource demandSource = this.getDemandSourceByName(SSAEnums.ProductType.Interstitial, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsISListener(demandSource)) != null) {
            listener.onInterstitialShowFailed(description);
        }
    }

    public DemandSource getDemandSourceByName(SSAEnums.ProductType type, String demandSourceName) {
        if (TextUtils.isEmpty((CharSequence)demandSourceName)) {
            return null;
        }
        return this.mDemandSourceManager.getDemandSourceByName(type, demandSourceName);
    }

    @Override
    public void setMediationState(String productType, String demandSourceName, int state) {
        DemandSource demandSource;
        SSAEnums.ProductType product;
        if (!TextUtils.isEmpty((CharSequence)productType) && !TextUtils.isEmpty((CharSequence)demandSourceName) && (product = SDKUtils.getProductType(productType)) != null && (demandSource = this.mDemandSourceManager.getDemandSourceByName(product, demandSourceName)) != null) {
            demandSource.setMediationState(state);
        }
    }

    @Override
    public void updateConsentInfo(JSONObject consentParams) {
        if (this.wvc != null) {
            this.wvc.updateConsentInfo(consentParams);
        }
    }

    @Override
    public ISNAdView createBanner(Activity activity, ISAdSize bannerSize) {
        String containerIdentifier = "SupersonicAds_" + this.adViewContainerCounter;
        ++this.adViewContainerCounter;
        ISNAdView isnAdView = new ISNAdView(activity, containerIdentifier, bannerSize);
        this.mBannerJSAdapter.setCommunicationWithAdView(isnAdView);
        return isnAdView;
    }

    @Override
    public void onBannerLoadSuccess(String demandSourceName) {
        OnBannerListener listener;
        DemandSource demandSource = this.getDemandSourceByName(SSAEnums.ProductType.Banner, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsBNListener(demandSource)) != null) {
            listener.onBannerLoadSuccess();
        }
    }

    @Override
    public void onBannerLoadFail(String demandSourceName, String description) {
        OnBannerListener listener;
        DemandSource demandSource = this.getDemandSourceByName(SSAEnums.ProductType.Banner, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsBNListener(demandSource)) != null) {
            listener.onBannerLoadFail(description);
        }
    }
}

