/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.utils;

import android.content.Context;
import android.text.TextUtils;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.ApplicationConfigurations;
import com.ironsource.mediationsdk.model.ApplicationEvents;
import com.ironsource.mediationsdk.model.ApplicationLogger;
import com.ironsource.mediationsdk.model.BannerConfigurations;
import com.ironsource.mediationsdk.model.BannerPlacement;
import com.ironsource.mediationsdk.model.Configurations;
import com.ironsource.mediationsdk.model.InterstitialConfigurations;
import com.ironsource.mediationsdk.model.InterstitialPlacement;
import com.ironsource.mediationsdk.model.OfferwallConfigurations;
import com.ironsource.mediationsdk.model.OfferwallPlacement;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.model.PlacementAvailabilitySettings;
import com.ironsource.mediationsdk.model.PlacementCappingType;
import com.ironsource.mediationsdk.model.ProviderOrder;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.model.ProviderSettingsHolder;
import com.ironsource.mediationsdk.model.RewardedVideoConfigurations;
import com.ironsource.mediationsdk.model.ServerSegmetData;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerResponseWrapper {
    public static final String APP_KEY_FIELD = "appKey";
    public static final String USER_ID_FIELD = "userId";
    public static final String RESPONSE_FIELD = "response";
    private final String ERROR_KEY = "error";
    private final int DEFAULT_LOG_LEVEL = 3;
    private final int DEFAULT_ADAPTERS_SMARTLOAD_AMOUNT = 2;
    private final int DEFAULT_ADAPTERS_SMARTLOAD_TIMEOUT = 60;
    private final int DEFAULT_BANNER_SMARTLOAD_TIMEOUT = 10000;
    private final int DEFAULT_MAX_EVENTS_PER_BATCH = 5000;
    private final int DEFAULT_MANUAL_LOAD_INTERVAL_FIELD = 300;
    private final String PROVIDER_ORDER_FIELD = "providerOrder";
    private final String PROVIDER_SETTINGS_FIELD = "providerSettings";
    private final String CONFIGURATIONS_FIELD = "configurations";
    private final String GENERIC_PARAMS_FIELD = "genericParams";
    private final String AD_UNITS_FIELD = "adUnits";
    private final String PROVIDER_LOAD_NAME_FIELD = "providerLoadName";
    private final String APPLICATION_FIELD = "application";
    private final String RV_FIELD = "rewardedVideo";
    private final String IS_FIELD = "interstitial";
    private final String OW_FIELD = "offerwall";
    private final String BN_FIELD = "banner";
    private final String INTEGRATION_FIELD = "integration";
    private final String LOGGERS_FIELD = "loggers";
    private final String SEGMENT_FIELD = "segment";
    private final String EVENTS_FIELD = "events";
    private final String MAX_NUM_OF_ADAPTERS_TO_LOAD_ON_START_FIELD = "maxNumOfAdaptersToLoadOnStart";
    private final String ADAPTER_TIMEOUT_IN_SECS_FIELD = "adapterTimeOutInSeconds";
    private final String ADAPTER_TIMEOUT_IN_MILLIS_FIELD = "atim";
    private final String DEFAULT_BANNER_LOAD_REFRESH_INTERVAL = "bannerInterval";
    private final String MANUAL_LOAD_INTERVAL_FIELD = "loadRVInterval";
    private final String SERVER_FIELD = "server";
    private final String PUBLISHER_FIELD = "publisher";
    private final String CONSOLE_FIELD = "console";
    private final String SEND_ULTRA_EVENTS_FIELD = "sendUltraEvents";
    private final String SEND_EVENTS_TOGGLE_FIELD = "sendEventsToggle";
    private final String SERVER_EVENTS_URL_FIELD = "serverEventsURL";
    private final String SERVER_EVENTS_TYPE = "serverEventsType";
    private final String BACKUP_THRESHOLD_FIELD = "backupThreshold";
    private final String MAX_NUM_OF_EVENTS_FIELD = "maxNumberOfEvents";
    private final String MAX_EVENTS_PER_BATCH = "maxEventsPerBatch";
    private final String OPT_OUT_EVENTS_FIELD = "optOut";
    private final String ALLOW_LOCATION = "allowLocation";
    private final String PLACEMENTS_FIELD = "placements";
    private final String PLACEMENT_ID_FIELD = "placementId";
    private final String PLACEMENT_NAME_FIELD = "placementName";
    private final String PLACEMENT_SETTINGS_DELIVERY_FIELD = "delivery";
    private final String PLACEMENT_SETTINGS_CAPPING_FIELD = "capping";
    private final String PLACEMENT_SETTINGS_PACING_FIELD = "pacing";
    private final String PLACEMENT_SETTINGS_ENABLED_FIELD = "enabled";
    private final String PLACEMENT_SETTINGS_CAPPING_VALUE_FIELD = "maxImpressions";
    private final String PLACEMENT_SETTINGS_PACING_VALUE_FIELD = "numOfSeconds";
    private final String PLACEMENT_SETTINGS_CAPPING_UNIT_FIELD = "unit";
    private final String VIRTUAL_ITEM_NAME_FIELD = "virtualItemName";
    private final String VIRTUAL_ITEM_COUNT_FIELD = "virtualItemCount";
    private final String BACKFILL_FIELD = "backFill";
    private final String PREMIUM_FIELD = "premium";
    private final String UUID_ENABLED_FIELD = "uuidEnabled";
    private final String AB_TESTING = "abt";
    private final String AD_SOURCE_NAME_FIELD = "adSourceName";
    private final String SUB_PROVIDER_ID_FIELD = "spId";
    private final String IS_MULTIPLE_INSTANCES_FIELD = "mpis";
    private final String AUCTION_FIELD = "auction";
    private final String AUCTION_DATA_FIELD = "auctionData";
    private final String AUCTION_URL_FIELD = "auctioneerURL";
    private final String AUCTION_PROGRAMMATIC_FIELD = "programmatic";
    private final String MIN_TIME_BEFORE_FIRST_AUCTION_FIELD = "minTimeBeforeFirstAuction";
    private final String AUCTION_RETRY_INTERVAL_FIELD = "auctionRetryInterval";
    private ProviderOrder mProviderOrder;
    private ProviderSettingsHolder mProviderSettingsHolder;
    private Configurations mConfigurations;
    private String mAppKey;
    private String mUserId;
    private JSONObject mResponse;
    private Context mContext;

    public ServerResponseWrapper(Context context, String appKey, String userId, String jsonData) {
        this.mContext = context;
        try {
            this.mResponse = TextUtils.isEmpty((CharSequence)jsonData) ? new JSONObject() : new JSONObject(jsonData);
            this.parseProviderSettings();
            this.parseConfigurations();
            this.parseProviderOrder();
            this.mAppKey = TextUtils.isEmpty((CharSequence)appKey) ? "" : appKey;
            this.mUserId = TextUtils.isEmpty((CharSequence)userId) ? "" : userId;
        }
        catch (JSONException e2) {
            e2.printStackTrace();
            this.defaultInit();
        }
    }

    public ServerResponseWrapper(ServerResponseWrapper srw) {
        try {
            this.mContext = srw.getContext();
            this.mResponse = new JSONObject(srw.mResponse.toString());
            this.mAppKey = srw.mAppKey;
            this.mUserId = srw.mUserId;
            this.mProviderOrder = srw.getProviderOrder();
            this.mProviderSettingsHolder = srw.getProviderSettingsHolder();
            this.mConfigurations = srw.getConfigurations();
        }
        catch (Exception e2) {
            this.defaultInit();
        }
    }

    private void defaultInit() {
        this.mResponse = new JSONObject();
        this.mAppKey = "";
        this.mUserId = "";
        this.mProviderOrder = new ProviderOrder();
        this.mProviderSettingsHolder = ProviderSettingsHolder.getProviderSettingsHolder();
        this.mConfigurations = new Configurations();
    }

    public String toString() {
        JSONObject resultObject = new JSONObject();
        try {
            resultObject.put(APP_KEY_FIELD, (Object)this.mAppKey);
            resultObject.put(USER_ID_FIELD, (Object)this.mUserId);
            resultObject.put(RESPONSE_FIELD, (Object)this.mResponse);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        return resultObject.toString();
    }

    public boolean isValidResponse() {
        boolean valid = this.mResponse != null;
        valid = valid && !this.mResponse.has("error");
        valid = valid && this.mProviderOrder != null;
        valid = valid && this.mProviderSettingsHolder != null;
        valid = valid && this.mConfigurations != null;
        return valid;
    }

    public List<IronSource.AD_UNIT> getInitiatedAdUnits() {
        if (this.mResponse == null || this.mConfigurations == null) {
            return null;
        }
        ArrayList<IronSource.AD_UNIT> adUnits = new ArrayList<IronSource.AD_UNIT>();
        if (this.mConfigurations.getRewardedVideoConfigurations() != null && this.mProviderOrder != null && this.mProviderOrder.getRewardedVideoProviderOrder().size() > 0) {
            adUnits.add(IronSource.AD_UNIT.REWARDED_VIDEO);
        }
        if (this.mConfigurations.getInterstitialConfigurations() != null && this.mProviderOrder != null && this.mProviderOrder.getInterstitialProviderOrder().size() > 0) {
            adUnits.add(IronSource.AD_UNIT.INTERSTITIAL);
        }
        if (this.mConfigurations.getOfferwallConfigurations() != null) {
            adUnits.add(IronSource.AD_UNIT.OFFERWALL);
        }
        if (this.mConfigurations.getBannerConfigurations() != null) {
            adUnits.add(IronSource.AD_UNIT.BANNER);
        }
        return adUnits;
    }

    private void parseProviderOrder() {
        try {
            ProviderSettings settings;
            String providerName;
            int i2;
            String premiumProviderName;
            String backFillProviderName;
            JSONObject providerOrderSection = this.getSection(this.mResponse, "providerOrder");
            JSONArray rvOrderSection = providerOrderSection.optJSONArray("rewardedVideo");
            JSONArray isOrderSection = providerOrderSection.optJSONArray("interstitial");
            JSONArray bnOrderSection = providerOrderSection.optJSONArray("banner");
            this.mProviderOrder = new ProviderOrder();
            if (rvOrderSection != null && this.getConfigurations() != null && this.getConfigurations().getRewardedVideoConfigurations() != null) {
                backFillProviderName = this.getConfigurations().getRewardedVideoConfigurations().getBackFillProviderName();
                premiumProviderName = this.getConfigurations().getRewardedVideoConfigurations().getPremiumProviderName();
                for (i2 = 0; i2 < rvOrderSection.length(); ++i2) {
                    providerName = rvOrderSection.optString(i2);
                    if (providerName.equals(backFillProviderName)) {
                        this.mProviderOrder.setRVBackFillProvider(backFillProviderName);
                        continue;
                    }
                    if (providerName.equals(premiumProviderName)) {
                        this.mProviderOrder.setRVPremiumProvider(premiumProviderName);
                    }
                    this.mProviderOrder.addRewardedVideoProvider(providerName);
                    settings = ProviderSettingsHolder.getProviderSettingsHolder().getProviderSettings(providerName);
                    if (settings == null) continue;
                    settings.setRewardedVideoPriority(i2);
                }
            }
            if (isOrderSection != null && this.getConfigurations() != null && this.getConfigurations().getInterstitialConfigurations() != null) {
                backFillProviderName = this.getConfigurations().getInterstitialConfigurations().getBackFillProviderName();
                premiumProviderName = this.getConfigurations().getInterstitialConfigurations().getPremiumProviderName();
                for (i2 = 0; i2 < isOrderSection.length(); ++i2) {
                    providerName = isOrderSection.optString(i2);
                    if (providerName.equals(backFillProviderName)) {
                        this.mProviderOrder.setISBackFillProvider(backFillProviderName);
                        continue;
                    }
                    if (providerName.equals(premiumProviderName)) {
                        this.mProviderOrder.setISPremiumProvider(premiumProviderName);
                    }
                    this.mProviderOrder.addInterstitialProvider(providerName);
                    settings = ProviderSettingsHolder.getProviderSettingsHolder().getProviderSettings(providerName);
                    if (settings == null) continue;
                    settings.setInterstitialPriority(i2);
                }
            }
            if (bnOrderSection != null) {
                for (int i3 = 0; i3 < bnOrderSection.length(); ++i3) {
                    String providerName2 = bnOrderSection.optString(i3);
                    this.mProviderOrder.addBannerProvider(providerName2);
                    ProviderSettings settings2 = ProviderSettingsHolder.getProviderSettingsHolder().getProviderSettings(providerName2);
                    if (settings2 == null) continue;
                    settings2.setBannerPriority(i3);
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void parseProviderSettings() {
        try {
            this.mProviderSettingsHolder = ProviderSettingsHolder.getProviderSettingsHolder();
            JSONObject providerSettingsSection = this.getSection(this.mResponse, "providerSettings");
            Iterator keys = providerSettingsSection.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JSONObject concreteProviderSettingsSection = providerSettingsSection.optJSONObject(key);
                if (concreteProviderSettingsSection == null) continue;
                boolean isMultipleInstances = concreteProviderSettingsSection.optBoolean("mpis", false);
                String subProviderId = concreteProviderSettingsSection.optString("spId", "0");
                String adSourceName = concreteProviderSettingsSection.optString("adSourceName", null);
                String nameForReflection = concreteProviderSettingsSection.optString("providerLoadName", key);
                JSONObject adUnitSection = this.getSection(concreteProviderSettingsSection, "adUnits");
                JSONObject appSection = this.getSection(concreteProviderSettingsSection, "application");
                JSONObject rvSection = this.getSection(adUnitSection, "rewardedVideo");
                JSONObject isSection = this.getSection(adUnitSection, "interstitial");
                JSONObject bnSection = this.getSection(adUnitSection, "banner");
                JSONObject rewardedVideoSettings = IronSourceUtils.mergeJsons(rvSection, appSection);
                JSONObject interstitialSettings = IronSourceUtils.mergeJsons(isSection, appSection);
                JSONObject bannerSettings = IronSourceUtils.mergeJsons(bnSection, appSection);
                if (this.mProviderSettingsHolder.containsProviderSettings(key)) {
                    ProviderSettings providerLocalSettings = this.mProviderSettingsHolder.getProviderSettings(key);
                    JSONObject providerLocalRVSettings = providerLocalSettings.getRewardedVideoSettings();
                    JSONObject providerLocalISSettings = providerLocalSettings.getInterstitialSettings();
                    JSONObject providerLocalBNSettings = providerLocalSettings.getBannerSettings();
                    providerLocalSettings.setRewardedVideoSettings(IronSourceUtils.mergeJsons(providerLocalRVSettings, rewardedVideoSettings));
                    providerLocalSettings.setInterstitialSettings(IronSourceUtils.mergeJsons(providerLocalISSettings, interstitialSettings));
                    providerLocalSettings.setBannerSettings(IronSourceUtils.mergeJsons(providerLocalBNSettings, bannerSettings));
                    providerLocalSettings.setIsMultipleInstances(isMultipleInstances);
                    providerLocalSettings.setSubProviderId(subProviderId);
                    providerLocalSettings.setAdSourceNameForEvents(adSourceName);
                    continue;
                }
                if (this.mProviderSettingsHolder.containsProviderSettings("Mediation") && ("SupersonicAds".toLowerCase().equals(nameForReflection.toLowerCase()) || "RIS".toLowerCase().equals(nameForReflection.toLowerCase()))) {
                    ProviderSettings mediationLocalSettings = this.mProviderSettingsHolder.getProviderSettings("Mediation");
                    JSONObject mediationLocalRVSettings = mediationLocalSettings.getRewardedVideoSettings();
                    JSONObject mediationLocalISSettings = mediationLocalSettings.getInterstitialSettings();
                    JSONObject mediationLocalBNSettings = mediationLocalSettings.getBannerSettings();
                    JSONObject mergedRVSettings = new JSONObject(mediationLocalRVSettings.toString());
                    JSONObject mergedISSettings = new JSONObject(mediationLocalISSettings.toString());
                    JSONObject mergedBNSettings = new JSONObject(mediationLocalBNSettings.toString());
                    rewardedVideoSettings = IronSourceUtils.mergeJsons(mergedRVSettings, rewardedVideoSettings);
                    interstitialSettings = IronSourceUtils.mergeJsons(mergedISSettings, interstitialSettings);
                    bannerSettings = IronSourceUtils.mergeJsons(mergedBNSettings, bannerSettings);
                    ProviderSettings settings = new ProviderSettings(key, nameForReflection, appSection, rewardedVideoSettings, interstitialSettings, bannerSettings);
                    settings.setIsMultipleInstances(isMultipleInstances);
                    settings.setSubProviderId(subProviderId);
                    settings.setAdSourceNameForEvents(adSourceName);
                    this.mProviderSettingsHolder.addProviderSettings(settings);
                    continue;
                }
                ProviderSettings settings = new ProviderSettings(key, nameForReflection, appSection, rewardedVideoSettings, interstitialSettings, bannerSettings);
                settings.setIsMultipleInstances(isMultipleInstances);
                settings.setSubProviderId(subProviderId);
                settings.setAdSourceNameForEvents(adSourceName);
                this.mProviderSettingsHolder.addProviderSettings(settings);
            }
            this.mProviderSettingsHolder.fillSubProvidersDetails();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void parseConfigurations() {
        try {
            JSONObject eventParamsSection;
            JSONObject batchParamsSection;
            JSONArray optOutJsonArray;
            int[] optOutEvents;
            String abt;
            JSONObject configurationsSection = this.getSection(this.mResponse, "configurations");
            JSONObject adUnitSection = this.getSection(configurationsSection, "adUnits");
            JSONObject appSection = this.getSection(configurationsSection, "application");
            JSONObject rvSection = this.getSection(adUnitSection, "rewardedVideo");
            JSONObject isSection = this.getSection(adUnitSection, "interstitial");
            JSONObject owSection = this.getSection(adUnitSection, "offerwall");
            JSONObject bnSection = this.getSection(adUnitSection, "banner");
            JSONObject appEventsSection = this.getSection(appSection, "events");
            JSONObject loggerSection = this.getSection(appSection, "loggers");
            JSONObject segmentSection = this.getSection(appSection, "segment");
            JSONObject auctionSection = this.getSection(appSection, "auction");
            RewardedVideoConfigurations rvConfig = null;
            InterstitialConfigurations isConfig = null;
            OfferwallConfigurations owConfig = null;
            BannerConfigurations bannerConfig = null;
            if (appSection != null) {
                boolean isUuidEnabled = appSection.optBoolean("uuidEnabled", true);
                IronSourceUtils.saveBooleanToSharedPrefs(this.mContext, "uuidEnabled", isUuidEnabled);
            }
            if (appEventsSection != null && !TextUtils.isEmpty((CharSequence)(abt = appEventsSection.optString("abt")))) {
                InterstitialEventsManager.getInstance().setABT(abt);
                RewardedVideoEventsManager.getInstance().setABT(abt);
            }
            if (rvSection != null) {
                String premiumProviderName;
                String backFillProviderName;
                AuctionSettings rvAuctionSettings;
                JSONArray rvPlacementsSection = rvSection.optJSONArray("placements");
                JSONObject rvEventsSection = this.getSection(rvSection, "events");
                int rvSmartLoadAmount = this.getIntConfigValue(rvSection, appSection, "maxNumOfAdaptersToLoadOnStart", 2);
                int rvSmartLoadTimeout = this.getIntConfigValue(rvSection, appSection, "adapterTimeOutInSeconds", 60);
                int rvManualLoadInterval = this.getIntConfigValue(rvSection, appSection, "loadRVInterval", 300);
                JSONObject rewardedVideoCombinedEvents = IronSourceUtils.mergeJsons(rvEventsSection, appEventsSection);
                boolean rvUltraEvents = rewardedVideoCombinedEvents.optBoolean("sendUltraEvents", false);
                boolean rvEventsToggle = rewardedVideoCombinedEvents.optBoolean("sendEventsToggle", false);
                String rvEventsUrl = rewardedVideoCombinedEvents.optString("serverEventsURL", "");
                String rvEventsType = rewardedVideoCombinedEvents.optString("serverEventsType", "");
                int rvBackupThreshold = rewardedVideoCombinedEvents.optInt("backupThreshold", -1);
                int rvMaxNumOfEvents = rewardedVideoCombinedEvents.optInt("maxNumberOfEvents", -1);
                int rvMaxEventsPerBatch = rewardedVideoCombinedEvents.optInt("maxEventsPerBatch", 5000);
                optOutEvents = null;
                optOutJsonArray = rewardedVideoCombinedEvents.optJSONArray("optOut");
                if (optOutJsonArray != null) {
                    optOutEvents = new int[optOutJsonArray.length()];
                    for (int i2 = 0; i2 < optOutJsonArray.length(); ++i2) {
                        optOutEvents[i2] = optOutJsonArray.optInt(i2);
                    }
                }
                ApplicationEvents rvEvents = new ApplicationEvents(rvUltraEvents, rvEventsToggle, rvEventsUrl, rvEventsType, rvBackupThreshold, rvMaxNumOfEvents, rvMaxEventsPerBatch, optOutEvents);
                if (auctionSection != null) {
                    JSONObject rvAuctionSection = this.getSection(auctionSection, "rewardedVideo");
                    String auctionData = auctionSection.optString("auctionData", "");
                    String auctioneerURL = auctionSection.optString("auctioneerURL", "");
                    boolean isRvProgrammatic = rvAuctionSection.optBoolean("programmatic", false);
                    int rvAuctionInterval = rvAuctionSection.optInt("minTimeBeforeFirstAuction", 0);
                    int rvAuctionRetryInterval = rvAuctionSection.optInt("auctionRetryInterval", 0);
                    rvAuctionSettings = new AuctionSettings(auctionData, auctioneerURL, isRvProgrammatic, rvAuctionInterval, rvAuctionRetryInterval);
                } else {
                    rvAuctionSettings = new AuctionSettings();
                }
                rvConfig = new RewardedVideoConfigurations(rvSmartLoadAmount, rvSmartLoadTimeout, rvManualLoadInterval, rvEvents, rvAuctionSettings);
                if (rvPlacementsSection != null) {
                    for (int i3 = 0; i3 < rvPlacementsSection.length(); ++i3) {
                        JSONObject singlePlacementJson = rvPlacementsSection.optJSONObject(i3);
                        Placement placement = this.parseSingleRVPlacement(singlePlacementJson);
                        if (placement == null) continue;
                        rvConfig.addRewardedVideoPlacement(placement);
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)(backFillProviderName = rvSection.optString("backFill")))) {
                    rvConfig.setBackFillProviderName(backFillProviderName);
                }
                if (!TextUtils.isEmpty((CharSequence)(premiumProviderName = rvSection.optString("premium")))) {
                    rvConfig.setPremiumProviderName(premiumProviderName);
                }
            }
            if (isSection != null) {
                String premiumProviderName;
                String backFillProviderName;
                AuctionSettings isAuctionSettings;
                JSONArray isPlacementsSection = isSection.optJSONArray("placements");
                JSONObject isEventsSection = this.getSection(isSection, "events");
                int isSmartLoadAmount = this.getIntConfigValue(isSection, appSection, "maxNumOfAdaptersToLoadOnStart", 2);
                int isSmartLoadTimeout = this.getIntConfigValue(isSection, appSection, "adapterTimeOutInSeconds", 60);
                JSONObject interstitialCombinedEvents = IronSourceUtils.mergeJsons(isEventsSection, appEventsSection);
                boolean isEventsToggle = interstitialCombinedEvents.optBoolean("sendEventsToggle", false);
                String isEventsUrl = interstitialCombinedEvents.optString("serverEventsURL", "");
                String isEventsType = interstitialCombinedEvents.optString("serverEventsType", "");
                int isBackupThreshold = interstitialCombinedEvents.optInt("backupThreshold", -1);
                int isMaxNumOfEvents = interstitialCombinedEvents.optInt("maxNumberOfEvents", -1);
                int isMaxEventsPerBatch = interstitialCombinedEvents.optInt("maxEventsPerBatch", 5000);
                int[] optOutEvents2 = null;
                JSONArray optOutJsonArray2 = interstitialCombinedEvents.optJSONArray("optOut");
                if (optOutJsonArray2 != null) {
                    optOutEvents2 = new int[optOutJsonArray2.length()];
                    for (int i4 = 0; i4 < optOutJsonArray2.length(); ++i4) {
                        optOutEvents2[i4] = optOutJsonArray2.optInt(i4);
                    }
                }
                ApplicationEvents isEvents = new ApplicationEvents(false, isEventsToggle, isEventsUrl, isEventsType, isBackupThreshold, isMaxNumOfEvents, isMaxEventsPerBatch, optOutEvents2);
                if (auctionSection != null) {
                    JSONObject isAuctionSection = this.getSection(auctionSection, "interstitial");
                    String auctionData = auctionSection.optString("auctionData", "");
                    String auctioneerURL = auctionSection.optString("auctioneerURL", "");
                    boolean isProgrammatic = isAuctionSection.optBoolean("programmatic", false);
                    int minTimeToWaitBeforeFirstAuction = isAuctionSection.optInt("minTimeBeforeFirstAuction", 0);
                    isAuctionSettings = new AuctionSettings(auctionData, auctioneerURL, isProgrammatic, minTimeToWaitBeforeFirstAuction, 0);
                } else {
                    isAuctionSettings = new AuctionSettings();
                }
                isConfig = new InterstitialConfigurations(isSmartLoadAmount, isSmartLoadTimeout, isEvents, isAuctionSettings);
                if (isPlacementsSection != null) {
                    for (int i5 = 0; i5 < isPlacementsSection.length(); ++i5) {
                        JSONObject singlePlacementJson = isPlacementsSection.optJSONObject(i5);
                        InterstitialPlacement placement = this.parseSingleISPlacement(singlePlacementJson);
                        if (placement == null) continue;
                        isConfig.addInterstitialPlacement(placement);
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)(backFillProviderName = isSection.optString("backFill")))) {
                    isConfig.setBackFillProviderName(backFillProviderName);
                }
                if (!TextUtils.isEmpty((CharSequence)(premiumProviderName = isSection.optString("premium")))) {
                    isConfig.setPremiumProviderName(premiumProviderName);
                }
            }
            if (bnSection != null) {
                JSONArray bnPlacementsSection = bnSection.optJSONArray("placements");
                JSONObject bnEventsSection = this.getSection(bnSection, "events");
                int bnSmartLoadAmount = this.getIntConfigValue(bnSection, appSection, "maxNumOfAdaptersToLoadOnStart", 1);
                long bnSmartLoadTimeout = this.getLongConfigValue(bnSection, appSection, "atim", 10000L);
                int bnIntervalTime = this.getIntConfigValue(bnSection, appSection, "bannerInterval", 60);
                JSONObject bannerCombinedEvents = IronSourceUtils.mergeJsons(bnEventsSection, appEventsSection);
                boolean bnEventsToggle = bannerCombinedEvents.optBoolean("sendEventsToggle", false);
                String bnEventsUrl = bannerCombinedEvents.optString("serverEventsURL", "");
                String bnEventsType = bannerCombinedEvents.optString("serverEventsType", "");
                int bnBackupThreshold = bannerCombinedEvents.optInt("backupThreshold", -1);
                int bnMaxNumOfEvents = bannerCombinedEvents.optInt("maxNumberOfEvents", -1);
                int bnMaxEventsPerBatch = bannerCombinedEvents.optInt("maxEventsPerBatch", 5000);
                optOutEvents = null;
                optOutJsonArray = bannerCombinedEvents.optJSONArray("optOut");
                if (optOutJsonArray != null) {
                    optOutEvents = new int[optOutJsonArray.length()];
                    for (int i6 = 0; i6 < optOutJsonArray.length(); ++i6) {
                        optOutEvents[i6] = optOutJsonArray.optInt(i6);
                    }
                }
                ApplicationEvents bnEvents = new ApplicationEvents(false, bnEventsToggle, bnEventsUrl, bnEventsType, bnBackupThreshold, bnMaxNumOfEvents, bnMaxEventsPerBatch, optOutEvents);
                bannerConfig = new BannerConfigurations(bnSmartLoadAmount, bnSmartLoadTimeout, bnEvents, bnIntervalTime);
                if (bnPlacementsSection != null) {
                    for (int i7 = 0; i7 < bnPlacementsSection.length(); ++i7) {
                        JSONObject singlePlacementJson = bnPlacementsSection.optJSONObject(i7);
                        BannerPlacement placement = this.parseSingleBNPlacement(singlePlacementJson);
                        if (placement == null) continue;
                        bannerConfig.addBannerPlacement(placement);
                    }
                }
            }
            if (owSection != null) {
                JSONArray owPlacementsSection = owSection.optJSONArray("placements");
                owConfig = new OfferwallConfigurations();
                if (owPlacementsSection != null) {
                    for (int i8 = 0; i8 < owPlacementsSection.length(); ++i8) {
                        JSONObject singlePlacementJson = owPlacementsSection.optJSONObject(i8);
                        OfferwallPlacement placement = this.parseSingleOWPlacement(singlePlacementJson);
                        if (placement == null) continue;
                        owConfig.addOfferwallPlacement(placement);
                    }
                }
            }
            int serverLoggerLevel = loggerSection.optInt("server", 3);
            int publisherLoggerLevel = loggerSection.optInt("publisher", 3);
            int consoleLoggerLevel = loggerSection.optInt("console", 3);
            ApplicationLogger logger = new ApplicationLogger(serverLoggerLevel, publisherLoggerLevel, consoleLoggerLevel);
            ServerSegmetData segmentData = null;
            if (segmentSection != null) {
                String segmentName = segmentSection.optString("name", "");
                String segmentId = segmentSection.optString("id", "-1");
                JSONObject customSegments = segmentSection.optJSONObject("custom");
                segmentData = new ServerSegmetData(segmentName, segmentId, customSegments);
            }
            boolean isIntegration = appSection.optBoolean("integration", false);
            ApplicationConfigurations appConfig = new ApplicationConfigurations(logger, segmentData, isIntegration);
            boolean allowLocation = appSection.optBoolean("allowLocation", false);
            IronSourceUtils.saveBooleanToSharedPrefs(this.mContext, "GeneralProperties.ALLOW_LOCATION_SHARED_PREFS_KEY", allowLocation);
            this.mConfigurations = new Configurations(rvConfig, isConfig, owConfig, bannerConfig, appConfig);
            JSONObject copyOfBatchParams = batchParamsSection = this.getSection(appEventsSection, "genericParams");
            if (copyOfBatchParams != null && (eventParamsSection = this.getSection(copyOfBatchParams, "events")) != null) {
                copyOfBatchParams.remove("events");
                Map<String, String> genericParamsEventsMap = IronSourceUtils.parseJsonToStringMap(eventParamsSection);
                RewardedVideoEventsManager.getInstance().setEventGenericParams(genericParamsEventsMap);
                InterstitialEventsManager.getInstance().setEventGenericParams(genericParamsEventsMap);
            }
            if (batchParamsSection != null) {
                Map<String, String> genericParamsBatchMap = IronSourceUtils.parseJsonToStringMap(copyOfBatchParams);
                RewardedVideoEventsManager.getInstance().setBatchParams(genericParamsBatchMap);
                InterstitialEventsManager.getInstance().setBatchParams(genericParamsBatchMap);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private int getIntConfigValue(JSONObject mainJson, JSONObject secondaryJson, String key, int defaultValue) {
        int result = 0;
        if (mainJson.has(key)) {
            result = mainJson.optInt(key, 0);
        } else if (secondaryJson.has(key)) {
            result = secondaryJson.optInt(key, 0);
        }
        if (result == 0) {
            result = defaultValue;
        }
        return result;
    }

    private long getLongConfigValue(JSONObject mainJson, JSONObject secondaryJson, String key, long defaultValue) {
        long result = 0L;
        if (mainJson.has(key)) {
            result = mainJson.optLong(key, 0L);
        } else if (secondaryJson.has(key)) {
            result = secondaryJson.optLong(key, 0L);
        }
        if (result == 0L) {
            result = defaultValue;
        }
        return result;
    }

    private Placement parseSingleRVPlacement(JSONObject placementJson) {
        Placement result = null;
        if (placementJson != null) {
            int placementId = placementJson.optInt("placementId", -1);
            String placementName = placementJson.optString("placementName", "");
            String virtualItemName = placementJson.optString("virtualItemName", "");
            int virtualItemCount = placementJson.optInt("virtualItemCount", -1);
            PlacementAvailabilitySettings settings = this.getPlacementAvailabilitySettings(placementJson);
            if (placementId >= 0 && !TextUtils.isEmpty((CharSequence)placementName) && !TextUtils.isEmpty((CharSequence)virtualItemName) && virtualItemCount > 0) {
                result = new Placement(placementId, placementName, virtualItemName, virtualItemCount, settings);
                if (settings != null) {
                    CappingManager.addCappingInfo(this.mContext, result);
                }
            }
        }
        return result;
    }

    private InterstitialPlacement parseSingleISPlacement(JSONObject placementJson) {
        InterstitialPlacement result = null;
        if (placementJson != null) {
            int placementId = placementJson.optInt("placementId", -1);
            String placementName = placementJson.optString("placementName", "");
            PlacementAvailabilitySettings settings = this.getPlacementAvailabilitySettings(placementJson);
            if (placementId >= 0 && !TextUtils.isEmpty((CharSequence)placementName)) {
                result = new InterstitialPlacement(placementId, placementName, settings);
                if (settings != null) {
                    CappingManager.addCappingInfo(this.mContext, result);
                }
            }
        }
        return result;
    }

    private OfferwallPlacement parseSingleOWPlacement(JSONObject placementJson) {
        OfferwallPlacement result = null;
        if (placementJson != null) {
            int placementId = placementJson.optInt("placementId", -1);
            String placementName = placementJson.optString("placementName", "");
            if (placementId >= 0 && !TextUtils.isEmpty((CharSequence)placementName)) {
                result = new OfferwallPlacement(placementId, placementName);
            }
        }
        return result;
    }

    private BannerPlacement parseSingleBNPlacement(JSONObject placementJson) {
        BannerPlacement result = null;
        if (placementJson != null) {
            int placementId = placementJson.optInt("placementId", -1);
            String placementName = placementJson.optString("placementName", "");
            PlacementAvailabilitySettings settings = this.getPlacementAvailabilitySettings(placementJson);
            if (placementId >= 0 && !TextUtils.isEmpty((CharSequence)placementName)) {
                result = new BannerPlacement(placementId, placementName, settings);
                if (settings != null) {
                    CappingManager.addCappingInfo(this.mContext, result);
                }
            }
        }
        return result;
    }

    private PlacementAvailabilitySettings getPlacementAvailabilitySettings(JSONObject placementJson) {
        JSONObject pacingJson;
        if (placementJson == null) {
            return null;
        }
        PlacementAvailabilitySettings.PlacementAvailabilitySettingsBuilder settingsBuilder = new PlacementAvailabilitySettings.PlacementAvailabilitySettingsBuilder();
        boolean delivery = placementJson.optBoolean("delivery", true);
        settingsBuilder.delivery(delivery);
        JSONObject cappingJson = placementJson.optJSONObject("capping");
        if (cappingJson != null) {
            PlacementCappingType cappingType = null;
            String cappingUnitString = cappingJson.optString("unit");
            if (!TextUtils.isEmpty((CharSequence)cappingUnitString)) {
                if (PlacementCappingType.PER_DAY.toString().equals(cappingUnitString)) {
                    cappingType = PlacementCappingType.PER_DAY;
                } else if (PlacementCappingType.PER_HOUR.toString().equals(cappingUnitString)) {
                    cappingType = PlacementCappingType.PER_HOUR;
                }
            }
            int cappingValue = cappingJson.optInt("maxImpressions", 0);
            boolean isCappingEnabled = cappingJson.optBoolean("enabled", false) && cappingValue > 0;
            settingsBuilder.capping(isCappingEnabled, cappingType, cappingValue);
        }
        if ((pacingJson = placementJson.optJSONObject("pacing")) != null) {
            int pacingValue = pacingJson.optInt("numOfSeconds", 0);
            boolean isPacingEnabled = pacingJson.optBoolean("enabled", false) && pacingValue > 0;
            settingsBuilder.pacing(isPacingEnabled, pacingValue);
        }
        return settingsBuilder.build();
    }

    private JSONObject getSection(JSONObject json, String sectionName) {
        JSONObject result = null;
        if (json != null) {
            result = json.optJSONObject(sectionName);
        }
        return result;
    }

    public String getRVBackFillProvider() {
        try {
            return this.mProviderOrder.getRVBackFillProvider();
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.INTERNAL, "getRVBackFillProvider", e2);
            return null;
        }
    }

    public String getRVPremiumProvider() {
        try {
            return this.mProviderOrder.getRVPremiumProvider();
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.INTERNAL, "getRVPremiumProvider", e2);
            return null;
        }
    }

    public ProviderSettingsHolder getProviderSettingsHolder() {
        return this.mProviderSettingsHolder;
    }

    public ProviderOrder getProviderOrder() {
        return this.mProviderOrder;
    }

    public Configurations getConfigurations() {
        return this.mConfigurations;
    }

    private Context getContext() {
        return this.mContext;
    }
}

