/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.ProviderSettings;
import java.lang.reflect.Method;

public class ProgUtils {
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractAdapter loadAdapter(ProviderSettings config) {
        Object object = lock;
        synchronized (object) {
            AbstractAdapter providerAdapter;
            String name = config.getProviderInstanceName();
            String reflectionName = config.isMultipleInstances() ? config.getProviderTypeForReflection() : config.getProviderName();
            try {
                providerAdapter = ProgUtils.getLoadedAdapterOrFetchByReflection(name, reflectionName);
                if (providerAdapter == null) {
                    return null;
                }
                providerAdapter.setLogListener(IronSourceLoggerManager.getLogger());
            }
            catch (Throwable e2) {
                ProgUtils.logErrorInternal("loadAdapter(" + name + ") " + e2.getMessage());
                return null;
            }
            return providerAdapter;
        }
    }

    private static AbstractAdapter getLoadedAdapterOrFetchByReflection(String name, String reflectionName) {
        try {
            IronSourceObject sso = IronSourceObject.getInstance();
            AbstractAdapter providerAdapter = sso.getExistingAdapter(name);
            if (providerAdapter != null) {
                return providerAdapter;
            }
            Class<?> mAdapterClass = Class.forName("com.ironsource.adapters." + reflectionName.toLowerCase() + "." + reflectionName + "Adapter");
            Method startAdapterMethod = mAdapterClass.getMethod("startAdapter", String.class);
            return (AbstractAdapter)startAdapterMethod.invoke(mAdapterClass, name);
        }
        catch (Exception ex) {
            ProgUtils.logErrorInternal("getLoadedAdapterOrFetchByReflection " + ex.getMessage());
            return null;
        }
    }

    private static void logErrorInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 3);
    }
}

