/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.ProgRvManagerListener;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.config.ConfigFile;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.AdapterConfig;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class ProgRvSmash
extends ProgSmash
implements RewardedVideoSmashListener {
    private ProgRvManagerListener mListener;
    private boolean mIsMuted;
    private Timer mTimer;
    private int mLoadTimeoutSecs;
    private Activity mActivity;
    private String mAppKey;
    private String mUserId;

    public ProgRvSmash(Activity activity, String appKey, String userId, ProviderSettings settings, ProgRvManagerListener listener, int loadTimeoutSecs, AbstractAdapter adapter) {
        super(new AdapterConfig(settings, settings.getRewardedVideoSettings()), adapter);
        this.mActivity = activity;
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mListener = listener;
        this.mTimer = null;
        this.mLoadTimeoutSecs = loadTimeoutSecs;
        this.mAdapter.addRewardedVideoListener(this);
        this.setCustomParams();
    }

    public Map<String, Object> getBiddingData() {
        return this.isBidder() ? this.mAdapter.getRvBiddingData(this.mAdUnitSettings) : null;
    }

    public void initForBidding() {
        this.logInternal("initForBidding()");
        this.mIsMuted = true;
        this.setState(ProgSmash.SMASH_STATE.INIT_IN_PROGRESS);
        this.mAdapter.initRvForBidding(this.mActivity, this.mAppKey, this.mUserId, this.mAdUnitSettings, this);
    }

    public boolean isReadyToShow() {
        return this.mAdapter.isRewardedVideoAvailable(this.mAdUnitSettings);
    }

    public void loadVideo(String serverData) {
        this.logInternal("loadVideo()");
        this.mIsMuted = false;
        this.setIsLoadCandidate(false);
        if (this.isBidder()) {
            this.setState(ProgSmash.SMASH_STATE.LOAD_IN_PROGRESS);
            this.startLoadTimer();
            this.mAdapter.loadVideo(this.mAdUnitSettings, this, serverData);
            return;
        }
        if (this.mState == ProgSmash.SMASH_STATE.INIT_IN_PROGRESS || this.mState == ProgSmash.SMASH_STATE.LOAD_IN_PROGRESS) {
            this.logInternal("loadVideo already in progress");
            return;
        }
        if (this.mState == ProgSmash.SMASH_STATE.NO_INIT) {
            this.logInternal("loadVideo try to load adapter");
            this.setState(ProgSmash.SMASH_STATE.LOAD_IN_PROGRESS);
            this.startLoadTimer();
            this.mAdapter.initRewardedVideo(this.mActivity, this.mAppKey, this.mUserId, this.mAdUnitSettings, this);
            return;
        }
        if (this.mAdapter.isRewardedVideoAvailable(this.mAdUnitSettings)) {
            this.logInternal("loadVideo already loaded");
            this.setState(ProgSmash.SMASH_STATE.LOADED);
            this.mListener.onRewardedVideoAvailabilityChanged(true, this);
        } else {
            this.startLoadTimer();
            this.mAdapter.fetchRewardedVideo(this.mAdUnitSettings);
        }
    }

    public void unloadVideo() {
        this.mIsMuted = true;
    }

    public void showVideo() {
        this.mAdapter.showRewardedVideo(this.mAdUnitSettings, this);
    }

    public void setCappedPerSession() {
        this.mIsMuted = true;
        this.mAdapter.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION, "rewardedvideo");
    }

    private void setState(ProgSmash.SMASH_STATE state) {
        if (state != this.mState) {
            this.logInternal("state=" + (Object)((Object)state));
            this.mState = state;
        }
    }

    private void setCustomParams() {
        try {
            Boolean consent;
            String pluginType;
            String segment;
            String gender;
            Integer age = IronSourceObject.getInstance().getAge();
            if (age != null) {
                this.mAdapter.setAge(age);
            }
            if (!TextUtils.isEmpty((CharSequence)(gender = IronSourceObject.getInstance().getGender()))) {
                this.mAdapter.setGender(gender);
            }
            if (!TextUtils.isEmpty((CharSequence)(segment = IronSourceObject.getInstance().getMediationSegment()))) {
                this.mAdapter.setMediationSegment(segment);
            }
            if (!TextUtils.isEmpty((CharSequence)(pluginType = ConfigFile.getConfigFile().getPluginType()))) {
                this.mAdapter.setPluginData(pluginType, ConfigFile.getConfigFile().getPluginFrameworkVersion());
            }
            if ((consent = IronSourceObject.getInstance().getConsent()) != null) {
                this.logInternal("setConsent(" + consent + ")");
                this.mAdapter.setConsent(consent);
            }
        }
        catch (Exception e2) {
            this.logInternal(":setCustomParams():" + e2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAvailabilityChanged(boolean available) {
        ProgRvSmash progRvSmash = this;
        synchronized (progRvSmash) {
            this.stopLoadTimer();
            this.logAdapterCallback("onRewardedVideoAvailabilityChanged available=" + available);
            this.setState(available ? ProgSmash.SMASH_STATE.LOADED : ProgSmash.SMASH_STATE.LOAD_FAILED);
            if (!this.mIsMuted) {
                this.mListener.onRewardedVideoAvailabilityChanged(available, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error) {
        ProgRvSmash progRvSmash = this;
        synchronized (progRvSmash) {
            this.logAdapterCallback("onRewardedVideoAdShowFailed error=" + error.getErrorMessage());
            this.mListener.onRewardedVideoAdShowFailed(error, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoInitSuccess() {
        ProgRvSmash progRvSmash = this;
        synchronized (progRvSmash) {
            this.logAdapterCallback("onRewardedVideoInitSuccess");
            this.setState(ProgSmash.SMASH_STATE.INIT_SUCCESS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoInitFailed(IronSourceError error) {
        ProgRvSmash progRvSmash = this;
        synchronized (progRvSmash) {
            this.logAdapterCallback("onRewardedVideoInitFailed error=" + error.getErrorMessage());
            this.setState(ProgSmash.SMASH_STATE.NO_INIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdOpened() {
        ProgRvSmash progRvSmash = this;
        synchronized (progRvSmash) {
            this.logAdapterCallback("onRewardedVideoAdOpened");
            this.mListener.onRewardedVideoAdOpened(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdStarted() {
        ProgRvSmash progRvSmash = this;
        synchronized (progRvSmash) {
            this.logAdapterCallback("onRewardedVideoAdStarted");
            this.mListener.onRewardedVideoAdStarted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdVisible() {
        ProgRvSmash progRvSmash = this;
        synchronized (progRvSmash) {
            this.logAdapterCallback("onRewardedVideoAdVisible");
            this.mListener.onRewardedVideoAdVisible(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdClosed() {
        ProgRvSmash progRvSmash = this;
        synchronized (progRvSmash) {
            this.logAdapterCallback("onRewardedVideoAdClosed");
            this.mListener.onRewardedVideoAdClosed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdEnded() {
        ProgRvSmash progRvSmash = this;
        synchronized (progRvSmash) {
            this.logAdapterCallback("onRewardedVideoAdEnded");
            this.mListener.onRewardedVideoAdEnded(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdRewarded() {
        ProgRvSmash progRvSmash = this;
        synchronized (progRvSmash) {
            this.logAdapterCallback("onRewardedVideoAdRewarded");
            this.mListener.onRewardedVideoAdClosed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdClicked() {
        ProgRvSmash progRvSmash = this;
        synchronized (progRvSmash) {
            this.logAdapterCallback("onRewardedVideoAdClicked");
            this.mListener.onRewardedVideoAdClicked(this);
        }
    }

    private void stopLoadTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    private void startLoadTimer() {
        this.stopLoadTimer();
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ProgRvSmash.this.logInternal("timer ticked - timedout");
                ProgRvSmash.this.setState(ProgSmash.SMASH_STATE.LOAD_FAILED);
                ProgRvSmash.this.mListener.onRewardedVideoAvailabilityChanged(false, ProgRvSmash.this);
            }
        }, this.mLoadTimeoutSecs * 1000);
    }

    private void logAdapterCallback(String line) {
        String text = this.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, text, 0);
    }

    private void logInternal(String line) {
        String text = this.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }
}

