/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AuctionHandler;
import com.ironsource.mediationsdk.AuctionHandlerCallback;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.ProgRvManagerListener;
import com.ironsource.mediationsdk.ProgRvSmash;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.ProgUtils;
import com.ironsource.mediationsdk.RVListenerWrapper;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.model.RewardedVideoConfigurations;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionCappingManager;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

class ProgRvManager
implements ProgRvManagerListener {
    private SessionCappingManager mSessionCappingManager;
    private Boolean mLastReportedAvailabilityState;
    private RV_MEDIATION_STATE mState;
    private final ConcurrentHashMap<String, ProgRvSmash> mSmashes;
    private CopyOnWriteArrayList<ProgRvSmash> mWaterfall;
    private ConcurrentHashMap<String, AuctionResponseItem> mWaterfallServerData;
    private Placement mCurrentPlacement;
    private String mCurrentAuctionId;
    private int mMaxSmashesToLoad;
    private AuctionHandler mAuctionHandler;
    private long mTimeToWaitAfterFailedAuctionMs;
    private Activity mActivity;
    private String mAppKey;
    private boolean mIsShowingVideo;

    public ProgRvManager(Activity activity, List<ProviderSettings> providersList, RewardedVideoConfigurations configs, String appKey, String userId) {
        this.setState(RV_MEDIATION_STATE.RV_STATE_INITIATING);
        this.mActivity = activity;
        this.mAppKey = appKey;
        this.mLastReportedAvailabilityState = null;
        this.mMaxSmashesToLoad = configs.getRewardedVideoAdaptersSmartLoadAmount();
        this.mCurrentPlacement = null;
        AuctionSettings auctionSettings = configs.getRewardedVideoAuctionSettings();
        this.mTimeToWaitAfterFailedAuctionMs = auctionSettings.getAuctionRetryInterval();
        this.mIsShowingVideo = false;
        this.mWaterfall = new CopyOnWriteArrayList();
        this.mWaterfallServerData = new ConcurrentHashMap();
        this.mAuctionHandler = new AuctionHandler((Context)this.mActivity, "rewardedVideo", auctionSettings.getBlob(), auctionSettings.getUrl());
        this.mSmashes = new ConcurrentHashMap();
        for (ProviderSettings provider : providersList) {
            AbstractAdapter adaper = ProgUtils.loadAdapter(provider);
            if (adaper == null) continue;
            IronSourceObject.getInstance().addToRVAdaptersList(adaper);
            ProgRvSmash smash = new ProgRvSmash(activity, appKey, userId, provider, this, configs.getRewardedVideoAdaptersSmartLoadTimeout(), adaper);
            this.mSmashes.put(smash.getInstanceName(), smash);
        }
        this.mSessionCappingManager = new SessionCappingManager(new ArrayList<ProgSmash>(this.mSmashes.values()));
        for (ProgRvSmash smash : this.mSmashes.values()) {
            if (!smash.isBidder()) continue;
            smash.initForBidding();
        }
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                ProgRvManager.this.makeAuction();
            }
        }, auctionSettings.getTimeToWaitBeforeFirstAuctionMs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showRewardedVideo(Placement placement) {
        this.logApi("showRewardedVideo() placement=" + placement.getPlacementName());
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_AVAILABLE) {
            this.logInternal("showRewardedVideo() error state=" + this.mState.toString());
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError("Rewarded Video"));
            return;
        }
        this.mCurrentPlacement = placement;
        this.sendMediationEventWithPlacement(1100);
        if (CappingManager.isRvPlacementCapped((Context)this.mActivity, placement.getPlacementName())) {
            String message = "showRewardedVideo() " + this.mCurrentPlacement + " is capped";
            this.logInternal(message);
            IronSourceError error = new IronSourceError(524, message);
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.sendMediationEvent(1112, new Object[][]{{"errorCode", 524}, {"placement", this.mCurrentPlacement}});
            return;
        }
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mWaterfall) {
                if (!smash.isReadyToShow()) continue;
                this.showVideo(smash, placement.getPlacementName());
                return;
            }
        }
        RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError("Rewarded Video"));
        this.sendMediationEvent(1112, new Object[][]{{"errorCode", 509}, {"placement", this.mCurrentPlacement}});
    }

    private void showVideo(ProgRvSmash smash, String placementName) {
        this.setState(RV_MEDIATION_STATE.RV_STATE_PREPARE_TO_SHOW_VIDEO);
        smash.showVideo();
        this.sendProviderEventWithPlacement(1200, smash);
        this.reportAvailabilityIdNeeded(false);
        this.mSessionCappingManager.increaseShowCounter(smash);
        if (this.mSessionCappingManager.isCapped(smash)) {
            smash.setCappedPerSession();
            this.sendProviderEvent(1401, smash, null);
            this.logInternal(smash.getInstanceName() + " was session capped");
        }
        CappingManager.incrementRvShowCounter((Context)this.mActivity, placementName);
        if (CappingManager.isRvPlacementCapped((Context)this.mActivity, placementName)) {
            this.sendMediationEventWithPlacement(1400);
        }
        this.mAuctionHandler.reportImpression(this.mWaterfallServerData.get(smash.getInstanceName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRewardedVideoAvailable() {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mWaterfall) {
                if (!smash.isReadyToShow()) continue;
                this.logApi("isRewardedVideoAvailable() result = true");
                this.sendMediationEvent(1101, new Object[][]{{"result", "true"}});
                return true;
            }
            this.logApi("isRewardedVideoAvailable() result = false");
            this.sendMediationEvent(1101, new Object[][]{{"result", "false"}});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume(Activity activity) {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            if (activity != null) {
                this.mActivity = activity;
            }
            for (ProgRvSmash smash : this.mSmashes.values()) {
                smash.onResume(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPause(Activity activity) {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mSmashes.values()) {
                smash.onPause(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsent(boolean consent) {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mSmashes.values()) {
                smash.setConsent(consent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAuction() {
        this.setState(RV_MEDIATION_STATE.RV_STATE_AUCTION);
        this.mCurrentAuctionId = "";
        this.sendMediationEvent(1000, null);
        HashMap<String, Object> bidderCandidates = new HashMap<String, Object>();
        ArrayList<String> noBidderCandidates = new ArrayList<String>();
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            for (ProgRvSmash smash : this.mSmashes.values()) {
                if (this.mSessionCappingManager.isCapped(smash)) continue;
                if (smash.isBidder() && smash.isReadyToBid()) {
                    Map<String, Object> biddingData = smash.getBiddingData();
                    if (biddingData == null) continue;
                    bidderCandidates.put(smash.getInstanceName(), biddingData);
                    smash.unloadVideo();
                    continue;
                }
                if (smash.isBidder()) continue;
                noBidderCandidates.add(smash.getInstanceName());
                smash.unloadVideo();
            }
        }
        if (bidderCandidates.keySet().size() == 0 && noBidderCandidates.size() == 0) {
            this.reportAvailabilityIdNeeded(false);
            this.setState(RV_MEDIATION_STATE.RV_STATE_AUCTION_FAILED);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    ProgRvManager.this.makeAuction();
                }
            }, this.mTimeToWaitAfterFailedAuctionMs);
            return;
        }
        int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(1);
        this.mAuctionHandler.executeAuction(bidderCandidates, noBidderCandidates, sessionDepth, new AuctionHandlerCallback(){

            @Override
            public void callback(boolean isSuccess, List<AuctionResponseItem> newWaterfall, String auctionId, int errorCode, String errorMessage, long elapsedTime) {
                if (isSuccess) {
                    ProgRvManager.this.mCurrentAuctionId = auctionId;
                    ProgRvManager.this.updateWaterfall(newWaterfall);
                    ProgRvManager.this.loadSmashes();
                } else {
                    if (TextUtils.isEmpty((CharSequence)errorMessage)) {
                        ProgRvManager.this.sendMediationEvent(1300, new Object[][]{{"errorCode", errorCode}});
                    } else {
                        String errorReason = errorMessage.substring(0, Math.min(errorMessage.length(), 39));
                        ProgRvManager.this.sendMediationEvent(1300, new Object[][]{{"errorCode", errorCode}, {"reason", errorReason}});
                    }
                    ProgRvManager.this.reportAvailabilityIdNeeded(false);
                    ProgRvManager.this.setState(RV_MEDIATION_STATE.RV_STATE_AUCTION_FAILED);
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            ProgRvManager.this.makeAuction();
                        }
                    }, ProgRvManager.this.mTimeToWaitAfterFailedAuctionMs);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWaterfall(List<AuctionResponseItem> waterfall) {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            this.mWaterfall.clear();
            this.mWaterfallServerData.clear();
            for (AuctionResponseItem item : waterfall) {
                ProgRvSmash smash = this.mSmashes.get(item.getInstanceName());
                if (smash == null) continue;
                smash.setIsLoadCandidate(true);
                this.mWaterfall.add(smash);
                this.mWaterfallServerData.put(smash.getInstanceName(), item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSmashes() {
        ConcurrentHashMap<String, ProgRvSmash> concurrentHashMap = this.mSmashes;
        synchronized (concurrentHashMap) {
            this.setState(RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES);
            for (int i2 = 0; i2 < Math.min(this.mMaxSmashesToLoad, this.mWaterfall.size()); ++i2) {
                ProgRvSmash smash = this.mWaterfall.get(i2);
                String serverData = this.mWaterfallServerData.get(smash.getInstanceName()).getServerData();
                smash.loadVideo(serverData);
                this.sendProviderEvent(1002, smash, null);
            }
        }
    }

    private void setState(RV_MEDIATION_STATE state) {
        this.mState = state;
        this.logInternal("state=" + (Object)((Object)state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAvailabilityChanged(boolean available, ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            try {
                this.logSmashCallback(smash, "onRewardedVideoAvailabilityChanged available=" + available);
                if (available) {
                    this.sendProviderEvent(1003, smash, null);
                    if (this.mState == RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES || this.mState == RV_MEDIATION_STATE.RV_STATE_NOT_AVAILABLE) {
                        this.reportAvailabilityIdNeeded(true);
                        this.setState(RV_MEDIATION_STATE.RV_STATE_AVAILABLE);
                        this.sendMediationEvent(1004, null);
                    }
                    return;
                }
                this.sendProviderEvent(1202, smash, null);
                if (this.mState == RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES || this.mState == RV_MEDIATION_STATE.RV_STATE_AVAILABLE) {
                    boolean hasLoadInProgress = false;
                    boolean hasLoaded = false;
                    for (ProgRvSmash waterfallSmash : this.mWaterfall) {
                        if (waterfallSmash.getIsLoadCandidate()) {
                            if (this.mWaterfallServerData.get(waterfallSmash.getInstanceName()) == null) continue;
                            String serverData = this.mWaterfallServerData.get(waterfallSmash.getInstanceName()).getServerData();
                            waterfallSmash.loadVideo(serverData);
                            return;
                        }
                        if (waterfallSmash.isLoadingInProgress()) {
                            hasLoadInProgress = true;
                            continue;
                        }
                        if (!waterfallSmash.isReadyToShow()) continue;
                        hasLoaded = true;
                    }
                    if (!hasLoaded && !hasLoadInProgress) {
                        this.reportAvailabilityIdNeeded(false);
                        this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_AVAILABLE);
                        this.sendMediationEvent(1301, null);
                        new Timer().schedule(new TimerTask(){

                            @Override
                            public void run() {
                                ProgRvManager.this.makeAuction();
                            }
                        }, this.mTimeToWaitAfterFailedAuctionMs);
                    }
                }
            }
            catch (Throwable e2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onRewardedVideoAvailabilityChanged error=" + e2.getMessage(), 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdOpened(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdOpened");
            RVListenerWrapper.getInstance().onRewardedVideoAdOpened();
            this.sendMediationEventWithPlacement(1113);
            this.sendProviderEventWithPlacement(1005, smash);
            this.mIsShowingVideo = true;
            this.makeAuction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error, ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdShowFailed error=" + error.getErrorMessage());
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.sendMediationEvent(1112, new Object[][]{{"errorCode", 509}, {"placement", this.mCurrentPlacement}});
            this.sendProviderEvent(1201, smash, new Object[][]{{"errorCode", 509}, {"placement", this.mCurrentPlacement}});
            this.mIsShowingVideo = false;
            this.reportAvailabilityIdNeeded(false);
            this.makeAuction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdClosed(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdClosed");
            RVListenerWrapper.getInstance().onRewardedVideoAdClosed();
            this.sendMediationEventWithPlacement(1114);
            this.sendProviderEventWithPlacement(1203, smash);
            this.mIsShowingVideo = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdStarted(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdStarted");
            RVListenerWrapper.getInstance().onRewardedVideoAdStarted();
            this.sendMediationEventWithPlacement(1115);
            this.sendProviderEventWithPlacement(1204, smash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdEnded(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdEnded");
            RVListenerWrapper.getInstance().onRewardedVideoAdEnded();
            this.sendMediationEventWithPlacement(1116);
            this.sendProviderEventWithPlacement(1205, smash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdRewarded(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdRewarded");
            RVListenerWrapper.getInstance().onRewardedVideoAdRewarded(this.mCurrentPlacement);
            this.sendMediationEvent(1111, new Object[][]{{"placement", this.mCurrentPlacement.getPlacementName()}, {"rewardName", this.mCurrentPlacement.getRewardName()}, {"rewardAmount", this.mCurrentPlacement.getRewardAmount()}});
            ArrayList<Object[]> data = new ArrayList<Object[]>();
            data.add(new Object[]{"placement", this.mCurrentPlacement.getPlacementName()});
            data.add(new Object[]{"rewardName", this.mCurrentPlacement.getRewardName()});
            data.add(new Object[]{"rewardAmount", this.mCurrentPlacement.getRewardAmount()});
            String transId = Long.toString(new Date().getTime()) + this.mAppKey + smash.getInstanceName();
            data.add(new Object[]{"transId", IronSourceUtils.getTransId(transId)});
            if (!TextUtils.isEmpty((CharSequence)IronSourceObject.getInstance().getDynamicUserId())) {
                data.add(new Object[]{"dynamicUserId", IronSourceObject.getInstance().getDynamicUserId()});
            }
            if (IronSourceObject.getInstance().getRvServerParams() != null) {
                for (String key : IronSourceObject.getInstance().getRvServerParams().keySet()) {
                    data.add(new Object[]{"custom_" + key, IronSourceObject.getInstance().getRvServerParams().get(key)});
                }
            }
            this.sendProviderEvent(1106, smash, (Object[][])data.toArray((T[])new Object[2][data.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdClicked(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdClicked");
            RVListenerWrapper.getInstance().onRewardedVideoAdClicked(this.mCurrentPlacement);
            this.sendMediationEventWithPlacement(1117);
            this.sendProviderEventWithPlacement(1008, smash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdVisible(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdVisible");
            this.sendProviderEventWithPlacement(1206, smash);
        }
    }

    private void reportAvailabilityIdNeeded(boolean isAvailable) {
        if (this.mLastReportedAvailabilityState == null) {
            this.reportAvailability(isAvailable);
            return;
        }
        if (this.mLastReportedAvailabilityState.booleanValue() && !isAvailable) {
            this.reportAvailability(false);
            return;
        }
        if (!this.mLastReportedAvailabilityState.booleanValue() && isAvailable) {
            this.reportAvailability(true);
        }
    }

    private void reportAvailability(boolean isAvailable) {
        this.mLastReportedAvailabilityState = isAvailable;
        RVListenerWrapper.getInstance().onRewardedVideoAvailabilityChanged(isAvailable);
        this.sendMediationEvent(1110, new Object[][]{{"result", isAvailable ? "true" : "false"}, {"placement", this.mCurrentPlacement}});
    }

    private void logSmashCallback(ProgRvSmash smash, String line) {
        String text = smash.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, text, 0);
    }

    private void logInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }

    private void logErrorInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 3);
    }

    private void logApi(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, text, 1);
    }

    private void sendMediationEventWithPlacement(int eventId) {
        this.sendMediationEvent(eventId, new Object[][]{{"placement", this.mCurrentPlacement}});
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentAuctionId)) {
            data.put("auctionId", this.mCurrentAuctionId);
        }
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "RV sendMediationEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
    }

    private void sendProviderEventWithPlacement(int eventId, ProgRvSmash smash) {
        this.sendProviderEvent(eventId, smash, new Object[][]{{"placement", this.mCurrentPlacement}});
    }

    private void sendProviderEvent(int eventId, ProgRvSmash smash, Object[][] keyVals) {
        Map<String, Object> data = smash.getProviderEventData();
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentAuctionId)) {
            data.put("auctionId", this.mCurrentAuctionId);
        }
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "RV sendProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
    }

    private static enum RV_MEDIATION_STATE {
        RV_STATE_INITIATING,
        RV_STATE_AUCTION,
        RV_STATE_AUCTION_FAILED,
        RV_STATE_LOADING_SMASHES,
        RV_STATE_NOT_AVAILABLE,
        RV_STATE_AVAILABLE,
        RV_STATE_PREPARE_TO_SHOW_VIDEO;

    }
}

