/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.ProgIsManagerListener;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.config.ConfigFile;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.AdapterConfig;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class ProgIsSmash
extends ProgSmash
implements InterstitialSmashListener {
    private ProgIsManagerListener mListener;
    private Timer mTimer;
    private int mLoadTimeoutSecs;
    private Activity mActivity;
    private String mAppKey;
    private String mUserId;
    private long mLoadStartTime;

    public ProgIsSmash(Activity activity, String appKey, String userId, ProviderSettings settings, ProgIsManagerListener listener, int loadTimeout, AbstractAdapter adapter) {
        super(new AdapterConfig(settings, settings.getInterstitialSettings()), adapter);
        this.mActivity = activity;
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mListener = listener;
        this.mTimer = null;
        this.mLoadTimeoutSecs = loadTimeout;
        this.mAdapter.addInterstitialListener(this);
    }

    public synchronized Map<String, Object> getBiddingData() {
        return this.isBidder() ? this.mAdapter.getIsBiddingData(this.mAdUnitSettings) : null;
    }

    public synchronized void initForBidding() {
        this.logInternal("initForBidding()");
        this.setState(ProgSmash.SMASH_STATE.INIT_IN_PROGRESS);
        this.setCustomParams();
        this.mAdapter.initInterstitialForBidding(this.mActivity, this.mAppKey, this.mUserId, this.mAdUnitSettings, this);
    }

    public synchronized void loadInterstitial(String serverData) {
        this.mLoadStartTime = new Date().getTime();
        this.logInternal("loadInterstitial");
        this.setIsLoadCandidate(false);
        if (this.isBidder()) {
            this.startTimer();
            this.setState(ProgSmash.SMASH_STATE.LOAD_IN_PROGRESS);
            this.mAdapter.loadInterstitial(this.mAdUnitSettings, this, serverData);
            return;
        }
        if (this.mState == ProgSmash.SMASH_STATE.NO_INIT) {
            this.startTimer();
            this.setState(ProgSmash.SMASH_STATE.INIT_IN_PROGRESS);
            this.setCustomParams();
            this.mAdapter.initInterstitial(this.mActivity, this.mAppKey, this.mUserId, this.mAdUnitSettings, this);
            return;
        }
        if (this.mState == ProgSmash.SMASH_STATE.LOADED && this.isReadyToShow()) {
            long elapsedTime = new Date().getTime() - this.mLoadStartTime;
            this.mListener.onInterstitialAdReady(this, elapsedTime);
            return;
        }
        this.startTimer();
        this.setState(ProgSmash.SMASH_STATE.LOAD_IN_PROGRESS);
        this.mAdapter.loadInterstitial(this.mAdUnitSettings, this);
    }

    public synchronized void showInterstitial() {
        this.mAdapter.showInterstitial(this.mAdUnitSettings, this);
    }

    public synchronized void setCappedPerSession() {
        this.mAdapter.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION, "interstitial");
    }

    public synchronized boolean isReadyToShow() {
        return this.mAdapter.isInterstitialReady(this.mAdUnitSettings);
    }

    private void setState(ProgSmash.SMASH_STATE state) {
        this.logInternal("state=" + (Object)((Object)state));
        this.mState = state;
    }

    private void setCustomParams() {
        try {
            Boolean consent;
            String pluginType;
            String segment;
            String gender;
            Integer age = IronSourceObject.getInstance().getAge();
            if (age != null) {
                this.mAdapter.setAge(age);
            }
            if (!TextUtils.isEmpty((CharSequence)(gender = IronSourceObject.getInstance().getGender()))) {
                this.mAdapter.setGender(gender);
            }
            if (!TextUtils.isEmpty((CharSequence)(segment = IronSourceObject.getInstance().getMediationSegment()))) {
                this.mAdapter.setMediationSegment(segment);
            }
            if (!TextUtils.isEmpty((CharSequence)(pluginType = ConfigFile.getConfigFile().getPluginType()))) {
                this.mAdapter.setPluginData(pluginType, ConfigFile.getConfigFile().getPluginFrameworkVersion());
            }
            if ((consent = IronSourceObject.getInstance().getConsent()) != null) {
                this.logInternal("setConsent(" + consent + ")");
                this.mAdapter.setConsent(consent);
            }
        }
        catch (Exception e2) {
            this.logInternal("setCustomParams() " + e2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialInitSuccess() {
        ProgIsSmash progIsSmash = this;
        synchronized (progIsSmash) {
            this.logAdapterCallback("onInterstitialInitSuccess state=" + this.mState.name());
            this.stopTimer();
            if (this.mState != ProgSmash.SMASH_STATE.INIT_IN_PROGRESS) {
                return;
            }
            if (!this.isBidder()) {
                this.setState(ProgSmash.SMASH_STATE.LOAD_IN_PROGRESS);
                this.startTimer();
                this.mAdapter.loadInterstitial(this.mAdUnitSettings, this);
            } else {
                this.setState(ProgSmash.SMASH_STATE.INIT_SUCCESS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialInitFailed(IronSourceError error) {
        ProgIsSmash progIsSmash = this;
        synchronized (progIsSmash) {
            this.logAdapterCallback("onInterstitialInitFailed error" + error.getErrorMessage() + " state=" + this.mState.name());
            this.stopTimer();
            if (this.mState != ProgSmash.SMASH_STATE.INIT_IN_PROGRESS) {
                return;
            }
            this.setState(ProgSmash.SMASH_STATE.NO_INIT);
            if (!this.isBidder()) {
                long elapsedTime = new Date().getTime() - this.mLoadStartTime;
                this.mListener.onInterstitialAdLoadFailed(error, this, elapsedTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdReady() {
        ProgIsSmash progIsSmash = this;
        synchronized (progIsSmash) {
            this.logAdapterCallback("onInterstitialAdReady state=" + this.mState.name());
            this.stopTimer();
            if (this.mState != ProgSmash.SMASH_STATE.LOAD_IN_PROGRESS) {
                return;
            }
            this.setState(ProgSmash.SMASH_STATE.LOADED);
            long elapsedTime = new Date().getTime() - this.mLoadStartTime;
            this.mListener.onInterstitialAdReady(this, elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdLoadFailed(IronSourceError error) {
        ProgIsSmash progIsSmash = this;
        synchronized (progIsSmash) {
            this.logAdapterCallback("onInterstitialAdLoadFailed error=" + error.getErrorMessage() + " state=" + this.mState.name());
            this.stopTimer();
            if (this.mState != ProgSmash.SMASH_STATE.LOAD_IN_PROGRESS) {
                return;
            }
            this.setState(ProgSmash.SMASH_STATE.LOAD_FAILED);
            long elapsedTime = new Date().getTime() - this.mLoadStartTime;
            this.mListener.onInterstitialAdLoadFailed(error, this, elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdOpened() {
        ProgIsSmash progIsSmash = this;
        synchronized (progIsSmash) {
            this.logAdapterCallback("onInterstitialAdOpened");
            this.mListener.onInterstitialAdOpened(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdClosed() {
        ProgIsSmash progIsSmash = this;
        synchronized (progIsSmash) {
            this.logAdapterCallback("onInterstitialAdClosed");
            this.mListener.onInterstitialAdClosed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdShowSucceeded() {
        ProgIsSmash progIsSmash = this;
        synchronized (progIsSmash) {
            this.logAdapterCallback("onInterstitialAdShowSucceeded");
            this.mListener.onInterstitialAdShowSucceeded(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdShowFailed(IronSourceError error) {
        ProgIsSmash progIsSmash = this;
        synchronized (progIsSmash) {
            this.logAdapterCallback("onInterstitialAdShowFailed error=" + error.getErrorMessage());
            this.mListener.onInterstitialAdShowFailed(error, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdClicked() {
        ProgIsSmash progIsSmash = this;
        synchronized (progIsSmash) {
            this.logAdapterCallback("onInterstitialAdClicked");
            this.mListener.onInterstitialAdClicked(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdVisible() {
        ProgIsSmash progIsSmash = this;
        synchronized (progIsSmash) {
            this.logAdapterCallback("onInterstitialAdVisible");
            this.mListener.onInterstitialAdVisible(this);
        }
    }

    private void stopTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    private void startTimer() {
        this.logInternal("start timer");
        this.stopTimer();
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ProgIsSmash.this.logInternal("timed out state=" + ProgIsSmash.this.mState.name() + " isBidder=" + ProgIsSmash.this.isBidder());
                if (ProgIsSmash.this.mState == ProgSmash.SMASH_STATE.INIT_IN_PROGRESS && ProgIsSmash.this.isBidder()) {
                    ProgIsSmash.this.setState(ProgSmash.SMASH_STATE.NO_INIT);
                } else {
                    ProgIsSmash.this.setState(ProgSmash.SMASH_STATE.LOAD_FAILED);
                    long elapsedTime = new Date().getTime() - ProgIsSmash.this.mLoadStartTime;
                    ProgIsSmash.this.mListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError("Timeout"), ProgIsSmash.this, elapsedTime);
                }
            }
        }, this.mLoadTimeoutSecs * 1000);
    }

    private void logAdapterCallback(String line) {
        String text = "ProgIsSmash " + this.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, text, 0);
    }

    private void logInternal(String line) {
        String text = "ProgIsSmash " + this.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }
}

