/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.config.ConfigFile;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.BannerManagerListener;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import java.util.Timer;
import java.util.TimerTask;

public class BannerSmash
implements BannerSmashListener {
    private AbstractAdapter mAdapter;
    private Timer mTimer;
    private long mLoadTimeoutMilisecs;
    private ProviderSettings mAdapterConfigs;
    private BANNER_SMASH_STATE mState = BANNER_SMASH_STATE.NO_INIT;
    private BannerManagerListener mListener;
    private boolean mIsReadyToLoad;
    private IronSourceBannerLayout mBannerLayout;
    private int mProviderPriority;

    BannerSmash(BannerManagerListener listener, ProviderSettings adapterConfigs, AbstractAdapter adapter, long timeout, int providerPriority) {
        this.mProviderPriority = providerPriority;
        this.mListener = listener;
        this.mAdapter = adapter;
        this.mAdapterConfigs = adapterConfigs;
        this.mLoadTimeoutMilisecs = timeout;
        this.mAdapter.addBannerListener(this);
    }

    public boolean isReadyToLoad() {
        return this.mIsReadyToLoad;
    }

    public void setReadyToLoad(boolean isReadyToLoad) {
        this.mIsReadyToLoad = isReadyToLoad;
    }

    public int getProviderPriority() {
        return this.mProviderPriority;
    }

    public String getName() {
        if (this.mAdapterConfigs.isMultipleInstances()) {
            return this.mAdapterConfigs.getProviderTypeForReflection();
        }
        return this.mAdapterConfigs.getProviderName();
    }

    public String getAdSourceNameForEvents() {
        if (!TextUtils.isEmpty((CharSequence)this.mAdapterConfigs.getAdSourceNameForEvents())) {
            return this.mAdapterConfigs.getAdSourceNameForEvents();
        }
        return this.getName();
    }

    public String getSubProviderId() {
        return this.mAdapterConfigs.getSubProviderId();
    }

    public AbstractAdapter getAdapter() {
        return this.mAdapter;
    }

    public void loadBanner(IronSourceBannerLayout bannerLayout, Activity activity, String appKey, String userId) {
        this.log("loadBanner()");
        this.mIsReadyToLoad = false;
        if (bannerLayout == null) {
            this.mListener.onBannerAdLoadFailed(new IronSourceError(610, "banner==null"), this);
            return;
        }
        if (this.mAdapter == null) {
            this.mListener.onBannerAdLoadFailed(new IronSourceError(611, "adapter==null"), this);
            return;
        }
        this.mBannerLayout = bannerLayout;
        this.startLoadTimer();
        if (this.mState == BANNER_SMASH_STATE.NO_INIT) {
            this.setState(BANNER_SMASH_STATE.INIT_IN_PROGRESS);
            this.setCustomParams();
            this.mAdapter.initBanners(activity, appKey, userId, this.mAdapterConfigs.getBannerSettings(), this);
        } else {
            this.setState(BANNER_SMASH_STATE.LOAD_IN_PROGRESS);
            this.mAdapter.loadBanner(bannerLayout, this.mAdapterConfigs.getBannerSettings(), this);
        }
    }

    public void reloadBanner() {
        this.log("reloadBanner()");
        this.startLoadTimer();
        this.mAdapter.reloadBanner(this.mAdapterConfigs.getBannerSettings());
    }

    public void destroyBanner() {
        this.log("destroyBanner()");
        if (this.mAdapter == null) {
            this.log("destroyBanner() mAdapter == null");
            return;
        }
        this.mAdapter.destroyBanner(this.mAdapterConfigs.getBannerSettings());
        this.setState(BANNER_SMASH_STATE.DESTROYED);
    }

    private void setCustomParams() {
        if (this.mAdapter == null) {
            return;
        }
        try {
            Boolean consent;
            String pluginType;
            String segment;
            String gender;
            Integer age = IronSourceObject.getInstance().getAge();
            if (age != null) {
                this.mAdapter.setAge(age);
            }
            if (!TextUtils.isEmpty((CharSequence)(gender = IronSourceObject.getInstance().getGender()))) {
                this.mAdapter.setGender(gender);
            }
            if (!TextUtils.isEmpty((CharSequence)(segment = IronSourceObject.getInstance().getMediationSegment()))) {
                this.mAdapter.setMediationSegment(segment);
            }
            if (!TextUtils.isEmpty((CharSequence)(pluginType = ConfigFile.getConfigFile().getPluginType()))) {
                this.mAdapter.setPluginData(pluginType, ConfigFile.getConfigFile().getPluginFrameworkVersion());
            }
            if ((consent = IronSourceObject.getInstance().getConsent()) != null) {
                this.log("setConsent(" + consent + ")");
                this.mAdapter.setConsent(consent);
            }
        }
        catch (Exception e2) {
            this.log(":setCustomParams():" + e2.toString());
        }
    }

    private void setState(BANNER_SMASH_STATE state) {
        this.mState = state;
        this.log("state=" + state.name());
    }

    private void stopLoadTimer() {
        try {
            if (this.mTimer != null) {
                this.mTimer.cancel();
            }
        }
        catch (Exception e2) {
            this.logException("stopLoadTimer", e2.getLocalizedMessage());
        }
        finally {
            this.mTimer = null;
        }
    }

    private void startLoadTimer() {
        try {
            this.stopLoadTimer();
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    this.cancel();
                    if (BannerSmash.this.mState == BANNER_SMASH_STATE.INIT_IN_PROGRESS) {
                        BannerSmash.this.log("init timed out");
                        BannerSmash.this.mListener.onBannerAdLoadFailed(new IronSourceError(607, "Timed out"), BannerSmash.this);
                    } else if (BannerSmash.this.mState == BANNER_SMASH_STATE.LOAD_IN_PROGRESS) {
                        BannerSmash.this.log("load timed out");
                        BannerSmash.this.mListener.onBannerAdLoadFailed(new IronSourceError(608, "Timed out"), BannerSmash.this);
                    } else if (BannerSmash.this.mState == BANNER_SMASH_STATE.LOADED) {
                        BannerSmash.this.log("reload timed out");
                        BannerSmash.this.mListener.onBannerAdReloadFailed(new IronSourceError(609, "Timed out"), BannerSmash.this);
                    }
                    BannerSmash.this.setState(BANNER_SMASH_STATE.LOAD_FAILED);
                }
            }, this.mLoadTimeoutMilisecs);
        }
        catch (Exception e2) {
            this.logException("startLoadTimer", e2.getLocalizedMessage());
        }
    }

    @Override
    public void onBannerInitSuccess() {
        this.stopLoadTimer();
        if (this.mState == BANNER_SMASH_STATE.INIT_IN_PROGRESS) {
            this.startLoadTimer();
            this.setState(BANNER_SMASH_STATE.LOAD_IN_PROGRESS);
            this.mAdapter.loadBanner(this.mBannerLayout, this.mAdapterConfigs.getBannerSettings(), this);
        }
    }

    @Override
    public void onBannerInitFailed(IronSourceError error) {
        this.stopLoadTimer();
        if (this.mState == BANNER_SMASH_STATE.INIT_IN_PROGRESS) {
            this.mListener.onBannerAdLoadFailed(new IronSourceError(612, "Banner init failed"), this);
            this.setState(BANNER_SMASH_STATE.NO_INIT);
        }
    }

    @Override
    public void onBannerAdLoaded(View adView, FrameLayout.LayoutParams frameLayoutParams) {
        this.log("onBannerAdLoaded()");
        this.stopLoadTimer();
        if (this.mState == BANNER_SMASH_STATE.LOAD_IN_PROGRESS) {
            this.setState(BANNER_SMASH_STATE.LOADED);
            this.mListener.onBannerAdLoaded(this, adView, frameLayoutParams);
        } else if (this.mState == BANNER_SMASH_STATE.LOADED) {
            this.mListener.onBannerAdReloaded(this);
        }
    }

    @Override
    public void onBannerAdLoadFailed(IronSourceError error) {
        this.log("onBannerAdLoadFailed()");
        this.stopLoadTimer();
        if (this.mState == BANNER_SMASH_STATE.LOAD_IN_PROGRESS) {
            this.setState(BANNER_SMASH_STATE.LOAD_FAILED);
            this.mListener.onBannerAdLoadFailed(error, this);
        } else if (this.mState == BANNER_SMASH_STATE.LOADED) {
            this.mListener.onBannerAdReloadFailed(error, this);
        }
    }

    @Override
    public void onBannerAdClicked() {
        if (this.mListener != null) {
            this.mListener.onBannerAdClicked(this);
        }
    }

    @Override
    public void onBannerAdScreenPresented() {
        if (this.mListener != null) {
            this.mListener.onBannerAdScreenPresented(this);
        }
    }

    @Override
    public void onBannerAdScreenDismissed() {
        if (this.mListener != null) {
            this.mListener.onBannerAdScreenDismissed(this);
        }
    }

    @Override
    public void onBannerAdLeftApplication() {
        if (this.mListener != null) {
            this.mListener.onBannerAdLeftApplication(this);
        }
    }

    public void setConsent(boolean consent) {
        if (this.mAdapter != null) {
            this.log("setConsent(" + consent + ")");
            this.mAdapter.setConsent(consent);
        }
    }

    public void onPause(Activity activity) {
        if (this.mAdapter != null) {
            this.mAdapter.onPause(activity);
        }
    }

    public void onResume(Activity activity) {
        if (this.mAdapter != null) {
            this.mAdapter.onResume(activity);
        }
    }

    private void log(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "BannerSmash " + this.getName() + " " + text, 1);
    }

    private void logException(String methodName, String errorMessage) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, methodName + " Banner exception: " + this.getName() + " | " + errorMessage, 3);
    }

    protected static enum BANNER_SMASH_STATE {
        NO_INIT,
        INIT_IN_PROGRESS,
        LOAD_IN_PROGRESS,
        LOADED,
        LOAD_FAILED,
        DESTROYED;

    }
}

