/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.analytics.moat;

import android.app.Application;
import android.webkit.WebView;
import com.moat.analytics.mobile.iro.MoatAnalytics;
import com.moat.analytics.mobile.iro.MoatFactory;
import com.moat.analytics.mobile.iro.MoatOptions;
import com.moat.analytics.mobile.iro.TrackerListener;
import com.moat.analytics.mobile.iro.WebAdTracker;
import org.json.JSONObject;

public class MOATManager {
    private static WebAdTracker webAdTracker;
    private static EventsListener mEventsListener;
    private static final String loggingEnabled = "loggingEnabled";
    private static final String autoTrackGMAInterstitials = "autoTrackGMAInterstitials";
    private static final String disableAdIdCollection = "disableAdIdCollection";
    private static final String disableLocationService = "disableLocationServices";
    private static TrackerListener moatCallbacks;

    public static void setEventListener(EventsListener eventsListener) {
        mEventsListener = eventsListener;
    }

    public static void init(Application application) throws Exception {
        MOATManager.initWithOptions(null, application);
    }

    public static void initWithOptions(JSONObject options, Application application) throws Exception {
        MoatOptions o2 = null;
        if (options != null && options.length() > 0) {
            o2 = MOATManager.createMoatOptions(options);
        }
        MoatAnalytics.getInstance().start(o2, application);
    }

    private static MoatOptions createMoatOptions(JSONObject options) {
        MoatOptions mo = new MoatOptions();
        mo.loggingEnabled = options.optBoolean(loggingEnabled);
        mo.autoTrackGMAInterstitials = options.optBoolean(autoTrackGMAInterstitials);
        mo.disableAdIdCollection = options.optBoolean(disableAdIdCollection);
        mo.disableLocationServices = options.optBoolean(disableLocationService);
        return mo;
    }

    public static void createAdTracker(WebView webView) throws Exception {
        MoatFactory factory = MoatFactory.create();
        webAdTracker = factory.createWebAdTracker(webView);
    }

    public static void startTracking() throws Exception {
        if (webAdTracker != null) {
            webAdTracker.setListener(moatCallbacks);
            webAdTracker.startTracking();
        }
    }

    public static void stopTracking() throws Exception {
        if (webAdTracker != null) {
            webAdTracker.stopTracking();
        }
    }

    static {
        moatCallbacks = new TrackerListener(){

            @Override
            public void onTrackingStarted(String s2) {
                if (mEventsListener != null) {
                    mEventsListener.onTrackingStarted(s2);
                }
            }

            @Override
            public void onTrackingFailedToStart(String s2) {
                if (mEventsListener != null) {
                    mEventsListener.onTrackingFailedToStart(s2);
                }
            }

            @Override
            public void onTrackingStopped(String s2) {
                if (mEventsListener != null) {
                    mEventsListener.onTrackingStopped(s2);
                }
            }
        };
    }

    public static interface EventsListener
    extends TrackerListener {
    }
}

