/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyInterstitialListener;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import java.util.HashMap;
import java.util.Map;

public class CallbackThrotteler {
    private static final long MAX_CALL_RATE_SEC = 15L;
    private static final String MEDIATION = "mediation";
    private Map<String, Long> mLastInvoked = new HashMap<String, Long>();
    private Map<String, Boolean> mIsWaitingForInvocation = new HashMap<String, Boolean>();
    private InterstitialListener mListener = null;
    private ISDemandOnlyInterstitialListener mDemandOnlyListener = null;

    public void setInterstitialListener(InterstitialListener listener) {
        this.mListener = listener;
    }

    public void setISDemandOnlyInterstitialListener(ISDemandOnlyInterstitialListener listener) {
        this.mDemandOnlyListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInterstitialAdLoadFailed(IronSourceError error) {
        CallbackThrotteler callbackThrotteler = this;
        synchronized (callbackThrotteler) {
            this.onInterstitialAdLoadFailedInternal(MEDIATION, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInterstitialAdLoadFailed(String instanceId, IronSourceError error) {
        CallbackThrotteler callbackThrotteler = this;
        synchronized (callbackThrotteler) {
            this.onInterstitialAdLoadFailedInternal(instanceId, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingInvocation(String instanceId) {
        CallbackThrotteler callbackThrotteler = this;
        synchronized (callbackThrotteler) {
            return this.hasPendingInvocationInternal(instanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingInvocation() {
        CallbackThrotteler callbackThrotteler = this;
        synchronized (callbackThrotteler) {
            return this.hasPendingInvocationInternal(MEDIATION);
        }
    }

    private boolean hasPendingInvocationInternal(String instanceId) {
        if (TextUtils.isEmpty((CharSequence)instanceId)) {
            return false;
        }
        if (!this.mIsWaitingForInvocation.containsKey(instanceId)) {
            return false;
        }
        return this.mIsWaitingForInvocation.get(instanceId);
    }

    private void invokeCallback(String instanceId, IronSourceError error) {
        this.mLastInvoked.put(instanceId, System.currentTimeMillis());
        if (instanceId.equalsIgnoreCase(MEDIATION)) {
            if (this.mListener != null) {
                this.mListener.onInterstitialAdLoadFailed(error);
            }
        } else if (this.mDemandOnlyListener != null) {
            this.mDemandOnlyListener.onInterstitialAdLoadFailed(instanceId, error);
        }
    }

    private void onInterstitialAdLoadFailedInternal(final String instanceId, final IronSourceError error) {
        if (this.hasPendingInvocationInternal(instanceId)) {
            return;
        }
        if (!this.mLastInvoked.containsKey(instanceId)) {
            this.invokeCallback(instanceId, error);
            return;
        }
        long timeSinceLastCallMs = System.currentTimeMillis() - this.mLastInvoked.get(instanceId);
        if (timeSinceLastCallMs > 15000L) {
            this.invokeCallback(instanceId, error);
            return;
        }
        this.mIsWaitingForInvocation.put(instanceId, true);
        long nextCallMs = 15000L - timeSinceLastCallMs;
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                CallbackThrotteler.this.invokeCallback(instanceId, error);
                CallbackThrotteler.this.mIsWaitingForInvocation.put(instanceId, false);
            }
        }, nextCallMs);
    }
}

