/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.environment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import com.ironsource.environment.ApplicationContext;
import java.util.List;

public class LocationService {
    private static String TAG = LocationService.class.getSimpleName();

    public static Location getLastLocation(Context context) {
        Location bestLocation = null;
        long bestLocationTime = Long.MIN_VALUE;
        if (!ApplicationContext.isPermissionGranted(context, "android.permission.ACCESS_FINE_LOCATION") && !ApplicationContext.isPermissionGranted(context, "android.permission.ACCESS_COARSE_LOCATION")) {
            Log.d((String)TAG, (String)"Location Permission Not Granted (ACCESS_FINE_LOCATION or ACCESS_COARSE_LOCATION)");
            return null;
        }
        try {
            List providers;
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            List list = providers = locationManager != null ? locationManager.getAllProviders() : null;
            if (providers != null) {
                for (String provider : providers) {
                    try {
                        long currentTime;
                        Location location = locationManager.getLastKnownLocation(provider);
                        if (location == null || (currentTime = location.getTime()) <= bestLocationTime) continue;
                        bestLocation = location;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bestLocation;
    }

    @SuppressLint(value={"MissingPermission"})
    public static void getPreciseLocation(Context context, final ISLocationListener isLocationListener) {
        if (!ApplicationContext.isPermissionGranted(context, "android.permission.ACCESS_FINE_LOCATION")) {
            Log.d((String)TAG, (String)"Location Permission Not Granted (ACCESS_FINE_LOCATION)");
            if (isLocationListener != null) {
                isLocationListener.onLocationChanged(null);
                return;
            }
        }
        try {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            if (isLocationListener != null && !locationManager.isProviderEnabled("gps")) {
                Log.d((String)TAG, (String)"GPS Provider is turned off");
                isLocationListener.onLocationChanged(null);
                return;
            }
            LocationListener locationListener = new LocationListener(){

                public void onLocationChanged(Location location) {
                    Log.d((String)"LocationService", (String)("onLocationChanged " + location.getProvider()));
                    if (isLocationListener != null) {
                        isLocationListener.onLocationChanged(location);
                    }
                }

                public void onStatusChanged(String provider, int status, Bundle extras) {
                    Log.d((String)"LocationService", (String)("onStatusChanged " + provider));
                }

                public void onProviderEnabled(String provider) {
                    Log.d((String)"LocationService", (String)("onProviderEnabled " + provider));
                }

                public void onProviderDisabled(String provider) {
                    Log.d((String)"LocationService", (String)("onProviderDisabled " + provider));
                }
            };
            Criteria c2 = new Criteria();
            locationManager.requestSingleUpdate(c2, locationListener, Looper.myLooper());
            return;
        }
        catch (Exception exception) {
            if (isLocationListener != null) {
                isLocationListener.onLocationChanged(null);
            }
            return;
        }
    }

    public static boolean locationServicesEnabled(Context context) {
        try {
            if (!ApplicationContext.isPermissionGranted(context, "android.permission.ACCESS_FINE_LOCATION") && !ApplicationContext.isPermissionGranted(context, "android.permission.ACCESS_COARSE_LOCATION")) {
                Log.d((String)TAG, (String)"Location Permission Not Granted (ACCESS_FINE_LOCATION or ACCESS_COARSE_LOCATION)");
                return false;
            }
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            boolean gps_enabled = false;
            boolean network_enabled = false;
            try {
                gps_enabled = locationManager.isProviderEnabled("gps");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                network_enabled = locationManager.isProviderEnabled("network");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return gps_enabled || network_enabled;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static interface ISLocationListener {
        public void onLocationChanged(Location var1);
    }
}

