/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.supersonicads;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import com.ironsource.adapters.supersonicads.SupersonicConfig;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.AdapterUtils;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InternalOfferwallListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.OfferwallAdapterApi;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import com.ironsource.sdk.ISAdSize;
import com.ironsource.sdk.ISNAdView.ISNAdView;
import com.ironsource.sdk.SSAFactory;
import com.ironsource.sdk.SSAPublisher;
import com.ironsource.sdk.data.AdUnitsReady;
import com.ironsource.sdk.data.SSAEnums;
import com.ironsource.sdk.listeners.OnBannerListener;
import com.ironsource.sdk.listeners.OnInterstitialListener;
import com.ironsource.sdk.listeners.OnOfferWallListener;
import com.ironsource.sdk.listeners.OnRewardedVideoListener;
import com.ironsource.sdk.utils.SDKUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class SupersonicAdsAdapter
extends AbstractAdapter
implements OfferwallAdapterApi,
OnOfferWallListener,
OnInterstitialListener,
OnRewardedVideoListener,
OnBannerListener {
    private static final String VERSION = "6.8.0.1";
    private final String TIMESTAMP = "timestamp";
    private final String ITEM_SIGNATURE = "itemSignature";
    private final String SDK_PLUGIN_TYPE = "SDKPluginType";
    private final String OW_PLACEMENT_ID = "placementId";
    private SSAPublisher mSSAPublisher;
    private InternalOfferwallListener mOfferwallListener;
    private boolean mIsRVAvailable = false;
    private boolean mDidSetInitParams = false;
    private String mUserAgeGroup;
    private String mUserGender;
    private String mMediationSegment;
    private boolean mConsent;
    private boolean mDidSetConsent;
    private final String SUPERSONIC_ADS = "SupersonicAds";
    private final String DYNAMIC_CONTROLLER_URL = "controllerUrl";
    private final String DYNAMIC_CONTROLLER_DEBUG_MODE = "debugMode";
    private final String DYNAMIC_CONTROLLER_CONFIG = "controllerConfig";
    private final String APPLICATION_USER_GENDER = "applicationUserGender";
    private final String APPLICATION_USER_AGE_GROUP = "applicationUserAgeGroup";
    private final String LANGUAGE = "language";
    private final String MAX_VIDEO_LENGTH = "maxVideoLength";
    private final String CAMPAIGN_ID = "campaignId";
    private final String CUSTOM_PARAM_PREFIX = "custom_";
    private final String CUSTOM_SEGMENT = "custom_Segment";
    private final String ITEM_NAME = "itemName";
    private final String ITEM_COUNT = "itemCount";
    private final String APPLICATION_PRIVATE_KEY = "privateKey";
    private final String CLIENT_SIDE_CALLBACKS = "useClientSideCallbacks";
    private final String AD_VISIBLE_EVENT_NAME = "impressions";
    private static Handler mUIThreadHandler;
    private ISNAdView mIsnAdView;

    public static SupersonicAdsAdapter startAdapter(String providerName) {
        return new SupersonicAdsAdapter(providerName);
    }

    private SupersonicAdsAdapter(String providerName) {
        super(providerName);
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        IntegrationData ret = new IntegrationData("SupersonicAds", VERSION);
        ret.activities = new String[]{"com.ironsource.sdk.controller.ControllerActivity", "com.ironsource.sdk.controller.InterstitialActivity", "com.ironsource.sdk.controller.OpenUrlActivity"};
        return ret;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public String getCoreSDKVersion() {
        return SDKUtils.getSDKVersion();
    }

    @Override
    public void onPause(Activity activity) {
        if (this.mSSAPublisher != null) {
            this.mSSAPublisher.onPause(activity);
        }
    }

    @Override
    public void onResume(Activity activity) {
        if (this.mSSAPublisher != null) {
            this.mSSAPublisher.onResume(activity);
        }
    }

    @Override
    public void setAge(int age) {
        this.mUserAgeGroup = age >= 13 && age <= 17 ? "1" : (age >= 18 && age <= 20 ? "2" : (age >= 21 && age <= 24 ? "3" : (age >= 25 && age <= 34 ? "4" : (age >= 35 && age <= 44 ? "5" : (age >= 45 && age <= 54 ? "6" : (age >= 55 && age <= 64 ? "7" : (age > 65 && age <= 120 ? "8" : "0")))))));
    }

    @Override
    public void setGender(String gender) {
        this.mUserGender = gender;
    }

    @Override
    public void setMediationSegment(String segment) {
        this.mMediationSegment = segment;
    }

    @Override
    public void initRewardedVideo(final Activity activity, final String appKey, final String userId, final JSONObject config, RewardedVideoSmashListener listener) {
        if (!this.mDidSetInitParams) {
            this.setParamsBeforeInit(config);
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    SupersonicAdsAdapter.this.mSSAPublisher = SSAFactory.getPublisherInstance(activity);
                    HashMap rewardedVideoExtraParams = SupersonicAdsAdapter.this.getRewardedVideoExtraParams(config);
                    if (SupersonicAdsAdapter.this.mDidSetConsent) {
                        SupersonicAdsAdapter.this.applyConsent(SupersonicAdsAdapter.this.mConsent);
                    }
                    SupersonicAdsAdapter.this.mSSAPublisher.initRewardedVideo(appKey, userId, SupersonicAdsAdapter.this.getProviderName(), rewardedVideoExtraParams, SupersonicAdsAdapter.this);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    SupersonicAdsAdapter.this.onRVInitFail("initRewardedVideo");
                }
            }
        });
    }

    @Override
    public void fetchRewardedVideo(JSONObject config) {
    }

    @Override
    public void showRewardedVideo(JSONObject config, RewardedVideoSmashListener listener) {
        this.mActiveRewardedVideoSmash = listener;
        if (this.mSSAPublisher != null) {
            int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(1);
            JSONObject showParams = new JSONObject();
            try {
                showParams.put("demandSourceName", (Object)this.getProviderName());
                showParams.put("sessionDepth", sessionDepth);
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
            this.mSSAPublisher.showRewardedVideo(showParams);
        } else {
            this.mIsRVAvailable = false;
            if (this.mActiveRewardedVideoSmash != null) {
                this.mActiveRewardedVideoSmash.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError("Rewarded Video"));
            }
            for (RewardedVideoSmashListener smash : this.mAllRewardedVideoSmashes) {
                if (smash == null) continue;
                smash.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    @Override
    public synchronized boolean isRewardedVideoAvailable(JSONObject config) {
        return this.mIsRVAvailable;
    }

    @Override
    public void initInterstitial(final Activity activity, final String appKey, final String userId, JSONObject config, InterstitialSmashListener listener) {
        if (!this.mDidSetInitParams) {
            this.setParamsBeforeInit(config);
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    SupersonicAdsAdapter.this.mSSAPublisher = SSAFactory.getPublisherInstance(activity);
                    HashMap interstitialExtraParams = SupersonicAdsAdapter.this.getInterstitialExtraParams();
                    if (SupersonicAdsAdapter.this.mDidSetConsent) {
                        SupersonicAdsAdapter.this.applyConsent(SupersonicAdsAdapter.this.mConsent);
                    }
                    SupersonicAdsAdapter.this.mSSAPublisher.initInterstitial(appKey, userId, SupersonicAdsAdapter.this.getProviderName(), interstitialExtraParams, SupersonicAdsAdapter.this);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    SupersonicAdsAdapter.this.onInterstitialInitFailed(e2.getMessage());
                }
            }
        });
    }

    @Override
    public void loadInterstitial(JSONObject config, InterstitialSmashListener listener) {
        if (this.mSSAPublisher != null) {
            JSONObject loadParams = new JSONObject();
            try {
                loadParams.put("demandSourceName", (Object)this.getProviderName());
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
            this.mSSAPublisher.loadInterstitial(loadParams);
        } else {
            this.log(IronSourceLogger.IronSourceTag.NATIVE, "Please call initInterstitial before calling loadInterstitial", 2);
            for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
                if (smash == null) continue;
                smash.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError("Load was called before Init"));
            }
        }
    }

    @Override
    public void showInterstitial(JSONObject config, InterstitialSmashListener listener) {
        this.mActiveInterstitialSmash = listener;
        if (this.mSSAPublisher != null) {
            int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(2);
            JSONObject showParams = new JSONObject();
            try {
                showParams.put("demandSourceName", (Object)this.getProviderName());
                showParams.put("sessionDepth", sessionDepth);
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
            this.mSSAPublisher.showInterstitial(showParams);
        } else {
            this.log(IronSourceLogger.IronSourceTag.NATIVE, "Please call loadInterstitial before calling showInterstitial", 2);
            if (this.mActiveInterstitialSmash != null) {
                this.mActiveInterstitialSmash.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError("Interstitial"));
            }
        }
    }

    @Override
    public boolean isInterstitialReady(JSONObject config) {
        return this.mSSAPublisher != null && this.mSSAPublisher.isInterstitialAdAvailable(this.getProviderName());
    }

    @Override
    public void setInternalOfferwallListener(InternalOfferwallListener listener) {
        this.mOfferwallListener = listener;
    }

    @Override
    public void initOfferwall(final Activity activity, final String appKey, final String userId, final JSONObject config) {
        if (!this.mDidSetInitParams) {
            this.setParamsBeforeInit(config);
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    HashMap offerwallExtraParams = SupersonicAdsAdapter.this.getOfferwallExtraParams(config);
                    SupersonicAdsAdapter.this.mSSAPublisher = SSAFactory.getPublisherInstance(activity);
                    if (SupersonicAdsAdapter.this.mDidSetConsent) {
                        SupersonicAdsAdapter.this.applyConsent(SupersonicAdsAdapter.this.mConsent);
                    }
                    SupersonicAdsAdapter.this.mSSAPublisher.initOfferWall(appKey, userId, offerwallExtraParams, SupersonicAdsAdapter.this);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.ADAPTER_API, SupersonicAdsAdapter.this.getProviderName() + ":initOfferwall(userId:" + userId + ")", e2);
                    SupersonicAdsAdapter.this.mOfferwallListener.onOfferwallAvailable(false, ErrorBuilder.buildInitFailedError("Adapter initialization failure - " + SupersonicAdsAdapter.this.getProviderName() + " - " + e2.getMessage(), "Offerwall"));
                }
            }
        });
    }

    @Override
    public void getOfferwallCredits() {
        if (this.mSSAPublisher != null) {
            String appKey = IronSourceObject.getInstance().getIronSourceAppKey();
            String userId = IronSourceObject.getInstance().getIronSourceUserId();
            this.mSSAPublisher.getOfferWallCredits(appKey, userId, this);
        } else {
            this.log(IronSourceLogger.IronSourceTag.NATIVE, "Please call init before calling getOfferwallCredits", 2);
        }
    }

    @Override
    public void showOfferwall(String placementId, JSONObject config) {
        HashMap<String, String> offerwallExtraParams = this.getOfferwallExtraParams(config);
        if (offerwallExtraParams != null) {
            offerwallExtraParams.put("placementId", placementId);
        }
        if (this.mSSAPublisher != null) {
            this.mSSAPublisher.showOfferWall(offerwallExtraParams);
        } else {
            this.log(IronSourceLogger.IronSourceTag.NATIVE, "Please call init before calling showOfferwall", 2);
        }
    }

    @Override
    public boolean isOfferwallAvailable() {
        return true;
    }

    @Override
    public void initBanners(final Activity activity, final String appKey, final String userId, final JSONObject config, BannerSmashListener listener) {
        if (!this.mDidSetInitParams) {
            this.setParamsBeforeInit(config);
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    HashMap bannerExtraParams = SupersonicAdsAdapter.this.getBannerExtraParams(config);
                    SupersonicAdsAdapter.this.mSSAPublisher = SSAFactory.getPublisherInstance(activity);
                    if (SupersonicAdsAdapter.this.mDidSetConsent) {
                        SupersonicAdsAdapter.this.applyConsent(SupersonicAdsAdapter.this.mConsent);
                    }
                    SupersonicAdsAdapter.this.mSSAPublisher.initBanner(appKey, userId, SupersonicAdsAdapter.this.getProviderName(), bannerExtraParams, SupersonicAdsAdapter.this);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    SupersonicAdsAdapter.this.onBannerInitFailed(e2.getMessage());
                }
            }
        });
    }

    @Override
    public void loadBanner(final IronSourceBannerLayout banner, JSONObject config, BannerSmashListener listener) {
        try {
            if (this.mSSAPublisher == null) {
                this.log(IronSourceLogger.IronSourceTag.NATIVE, "Please call initBanner before calling loadBanner", 2);
                for (BannerSmashListener smash : this.mAllBannerSmashes) {
                    if (smash == null) continue;
                    smash.onBannerAdLoadFailed(ErrorBuilder.buildLoadFailedError("Load was called before Init"));
                }
            }
            if (banner == null) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "SupersonicAds loadBanner banner == null", 3);
                return;
            }
            this.mActiveBannerSmash = listener;
            if (this.mIsnAdView != null) {
                this.mIsnAdView.performCleanup();
                this.mIsnAdView = null;
            }
            final JSONObject loadParams = new JSONObject();
            loadParams.put("demandSourceName", (Object)this.getProviderName());
            loadParams.put("productType", (Object)SSAEnums.ProductType.Banner);
            if (mUIThreadHandler == null) {
                mUIThreadHandler = new Handler(Looper.getMainLooper());
            }
            mUIThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            SupersonicAdsAdapter.this.mIsnAdView = SupersonicAdsAdapter.this.createBanner(banner.getActivity(), banner.getSize(), SupersonicAdsAdapter.this.mActiveBannerSmash);
                            if (SupersonicAdsAdapter.this.mIsnAdView != null) {
                                SupersonicAdsAdapter.this.mIsnAdView.loadAd(loadParams);
                            }
                        }
                        catch (Exception e2) {
                            String errorString = "Banner Load Fail, " + SupersonicAdsAdapter.this.getProviderName() + " - " + e2.getMessage();
                            IronSourceError error = ErrorBuilder.buildLoadFailedError(errorString);
                            if (SupersonicAdsAdapter.this.mActiveBannerSmash == null) break block3;
                            SupersonicAdsAdapter.this.mActiveBannerSmash.onBannerAdLoadFailed(error);
                        }
                    }
                }
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void reloadBanner(JSONObject config) {
        try {
            if (this.mIsnAdView != null) {
                this.mIsnAdView.loadAd(config);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.log(IronSourceLogger.IronSourceTag.NATIVE, this.getProviderName() + " reloadBanner Failed to reload banner ad", 2);
        }
    }

    @Override
    public void destroyBanner(JSONObject config) {
        if (this.mIsnAdView != null) {
            this.mIsnAdView.performCleanup();
            this.mIsnAdView = null;
        }
    }

    private synchronized void setParamsBeforeInit(JSONObject config) {
        this.mDidSetInitParams = true;
        SDKUtils.setControllerUrl(config.optString("controllerUrl"));
        if (this.isAdaptersDebugEnabled()) {
            SDKUtils.setDebugMode(3);
        } else {
            SDKUtils.setDebugMode(config.optInt("debugMode", 0));
        }
        SDKUtils.setControllerConfig(config.optString("controllerConfig", ""));
    }

    private HashMap<String, String> getGenenralExtraParams() {
        String pluginType;
        HashMap<String, String> params = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)this.mUserAgeGroup)) {
            params.put("applicationUserAgeGroup", this.mUserAgeGroup);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUserGender)) {
            params.put("applicationUserGender", this.mUserGender);
        }
        if (!TextUtils.isEmpty((CharSequence)(pluginType = this.getPluginType()))) {
            params.put("SDKPluginType", pluginType);
        }
        return params;
    }

    private HashMap<String, String> getRewardedVideoExtraParams(JSONObject config) {
        String campaignId;
        String maxVideoLength;
        HashMap<String, String> rvExtraParams = this.getGenenralExtraParams();
        String language = config.optString("language");
        if (!TextUtils.isEmpty((CharSequence)language)) {
            rvExtraParams.put("language", language);
        }
        if (!TextUtils.isEmpty((CharSequence)(maxVideoLength = config.optString("maxVideoLength")))) {
            rvExtraParams.put("maxVideoLength", maxVideoLength);
        }
        if (!TextUtils.isEmpty((CharSequence)(campaignId = config.optString("campaignId")))) {
            rvExtraParams.put("campaignId", campaignId);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mMediationSegment)) {
            rvExtraParams.put("custom_Segment", this.mMediationSegment);
        }
        this.addItemNameCountSignature(rvExtraParams, config);
        Map<String, String> customParams = SupersonicConfig.getConfigObj().getRewardedVideoCustomParams();
        if (customParams != null && !customParams.isEmpty()) {
            rvExtraParams.putAll(customParams);
        }
        return rvExtraParams;
    }

    private HashMap<String, String> getInterstitialExtraParams() {
        return this.getGenenralExtraParams();
    }

    private HashMap<String, String> getOfferwallExtraParams(JSONObject config) {
        HashMap<String, String> owExtraParams = this.getGenenralExtraParams();
        String language = config.optString("language");
        if (!TextUtils.isEmpty((CharSequence)language)) {
            owExtraParams.put("language", language);
        }
        boolean clientSideCallbacks = SupersonicConfig.getConfigObj().getClientSideCallbacks();
        owExtraParams.put("useClientSideCallbacks", String.valueOf(clientSideCallbacks));
        Map<String, String> customParams = SupersonicConfig.getConfigObj().getOfferwallCustomParams();
        if (customParams != null && !customParams.isEmpty()) {
            owExtraParams.putAll(customParams);
        }
        this.addItemNameCountSignature(owExtraParams, config);
        return owExtraParams;
    }

    private HashMap<String, String> getBannerExtraParams(JSONObject config) {
        return this.getGenenralExtraParams();
    }

    private void addItemNameCountSignature(HashMap<String, String> params, JSONObject config) {
        try {
            String itemName = config.optString("itemName");
            int itemCount = config.optInt("itemCount", -1);
            String privateKey = config.optString("privateKey");
            boolean shouldAddSignature = true;
            if (TextUtils.isEmpty((CharSequence)itemName)) {
                shouldAddSignature = false;
            } else {
                params.put("itemName", itemName);
            }
            if (TextUtils.isEmpty((CharSequence)privateKey)) {
                shouldAddSignature = false;
            }
            if (itemCount == -1) {
                shouldAddSignature = false;
            } else {
                params.put("itemCount", String.valueOf(itemCount));
            }
            if (shouldAddSignature) {
                int timestamp = IronSourceUtils.getCurrentTimestamp();
                params.put("timestamp", String.valueOf(timestamp));
                params.put("itemSignature", this.createItemSig(timestamp, itemName, itemCount, privateKey));
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.ADAPTER_API, " addItemNameCountSignature", e2);
        }
    }

    private String createItemSig(int timestamp, String itemName, int itemCount, String privateKey) {
        return IronSourceUtils.getMD5(timestamp + itemName + itemCount + privateKey);
    }

    private String createMinimumOfferCommissionSig(double min, String privateKey) {
        return IronSourceUtils.getMD5(min + privateKey);
    }

    private String createUserCreationDateSig(String userid, String uCreationDate, String privateKey) {
        return IronSourceUtils.getMD5(userid + uCreationDate + privateKey);
    }

    private ISNAdView createBanner(Activity activity, ISBannerSize bannerSize, BannerSmashListener listener) {
        String BANNER = "BANNER";
        String LARGE = "LARGE";
        String RECTANGLE = "RECTANGLE";
        String SMART = "SMART";
        String CUSTOM = "CUSTOM";
        int STANDARD_SCREEN_BANNER_WIDTH = 320;
        int STANDARD_BANNER_SIZE_HEIGHT = 50;
        int LARGE_SCREEN_BANNER_WIDTH = 728;
        int LARGE_BANNER_SIZE_HEIGHT = 90;
        String sizeLabel = bannerSize.getDescription();
        int widthDp = 320;
        int heightDp = 50;
        switch (sizeLabel) {
            case "BANNER": {
                widthDp = 320;
                heightDp = 50;
                break;
            }
            case "LARGE": {
                widthDp = 320;
                heightDp = 90;
                break;
            }
            case "SMART": {
                boolean isLargeScreen = AdapterUtils.isLargeScreen(activity);
                widthDp = isLargeScreen ? 728 : 320;
                heightDp = isLargeScreen ? 90 : 50;
                break;
            }
            case "CUSTOM": {
                widthDp = bannerSize.getWidth();
                heightDp = bannerSize.getHeight();
                if (widthDp >= 320 && (heightDp == 50 || heightDp == 90)) break;
                if (listener != null) {
                    listener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize("SupersonicAds"));
                }
                return null;
            }
            default: {
                if (listener != null) {
                    listener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize("SupersonicAds"));
                }
                return null;
            }
        }
        int widthPixels = AdapterUtils.dpToPixels(activity, widthDp);
        int heightPixels = AdapterUtils.dpToPixels(activity, heightDp);
        ISAdSize bannerAdSize = new ISAdSize(widthPixels, heightPixels, sizeLabel);
        return this.mSSAPublisher.createBanner(activity, bannerAdSize);
    }

    @Override
    public void onRVNoMoreOffers() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onRVNoMoreOffers ", 1);
        this.mIsRVAvailable = false;
        for (RewardedVideoSmashListener smash : this.mAllRewardedVideoSmashes) {
            if (smash == null) continue;
            smash.onRewardedVideoAvailabilityChanged(false);
        }
    }

    @Override
    public void onRVInitSuccess(AdUnitsReady aur) {
        boolean availability;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onRVInitSuccess ", 1);
        int numOfAdUnits = 0;
        try {
            numOfAdUnits = Integer.parseInt(aur.getNumOfAdUnits());
        }
        catch (NumberFormatException e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "onRVInitSuccess:parseInt()", e2);
        }
        this.mIsRVAvailable = availability = numOfAdUnits > 0;
        for (RewardedVideoSmashListener smash : this.mAllRewardedVideoSmashes) {
            if (smash == null) continue;
            smash.onRewardedVideoAvailabilityChanged(availability);
        }
    }

    @Override
    public void onRVInitFail(String error) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onRVInitFail ", 1);
        for (RewardedVideoSmashListener smash : this.mAllRewardedVideoSmashes) {
            if (smash == null) continue;
            smash.onRewardedVideoAvailabilityChanged(false);
        }
    }

    @Override
    public void onRVAdClicked() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onRVAdClicked ", 1);
        if (this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdClicked();
        }
    }

    @Override
    public void onRVEventNotificationReceived(String eventName, JSONObject extData) {
        if (extData != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onRVEventNotificationReceived: " + eventName + " extData: " + extData.toString(), 1);
        }
        if (!TextUtils.isEmpty((CharSequence)eventName) && "impressions".equals(eventName) && this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdVisible();
        }
    }

    @Override
    public void onRVShowFail(String error) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onRVShowFail ", 1);
        if (this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdShowFailed(new IronSourceError(509, error));
        }
    }

    @Override
    public void onRVAdCredited(int amount) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onRVAdCredited ", 1);
        if (this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdRewarded();
        }
    }

    @Override
    public void onRVAdClosed() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onRVAdClosed ", 1);
        if (this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdClosed();
        }
    }

    @Override
    public void onRVAdOpened() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onRVAdOpened ", 1);
        if (this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdOpened();
        }
    }

    @Override
    public void onInterstitialInitSuccess() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onInterstitialInitSuccess ", 1);
        for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
            if (smash == null) continue;
            smash.onInterstitialInitSuccess();
        }
    }

    @Override
    public void onInterstitialInitFailed(String description) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onInterstitialInitFailed ", 1);
        for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
            if (smash == null) continue;
            smash.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError(description, "Interstitial"));
        }
    }

    @Override
    public void onInterstitialLoadSuccess() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onInterstitialLoadSuccess ", 1);
        for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
            if (smash == null) continue;
            smash.onInterstitialAdReady();
        }
    }

    @Override
    public void onInterstitialLoadFailed(String description) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onInterstitialAdLoadFailed ", 1);
        for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
            if (smash == null) continue;
            smash.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError(description));
        }
    }

    @Override
    public void onInterstitialOpen() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onInterstitialAdOpened ", 1);
        if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdOpened();
        }
    }

    @Override
    public void onInterstitialClose() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onInterstitialAdClosed ", 1);
        if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdClosed();
        }
    }

    @Override
    public void onInterstitialShowSuccess() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onInterstitialAdShowSucceeded ", 1);
        if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdShowSucceeded();
        }
    }

    @Override
    public void onInterstitialShowFailed(String description) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onInterstitialAdShowFailed ", 1);
        if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError("Interstitial", description));
        }
    }

    @Override
    public void onInterstitialClick() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onInterstitialAdClicked ", 1);
        if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdClicked();
        }
    }

    @Override
    public void onInterstitialEventNotificationReceived(String eventName, JSONObject extData) {
        if (extData != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onInterstitialEventNotificationReceived: " + eventName + " extData: " + extData.toString(), 1);
            if (!TextUtils.isEmpty((CharSequence)eventName) && "impressions".equals(eventName) && this.mActiveInterstitialSmash != null) {
                this.mActiveInterstitialSmash.onInterstitialAdVisible();
            }
        }
    }

    @Override
    public void onOfferwallInitSuccess() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onOfferwallInitSuccess ", 1);
        if (this.mOfferwallListener != null) {
            this.mOfferwallListener.onOfferwallAvailable(true);
        }
    }

    @Override
    public void onOfferwallInitFail(String description) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onOfferwallInitFail ", 1);
        if (this.mOfferwallListener != null) {
            IronSourceError sse = ErrorBuilder.buildGenericError(description);
            this.mOfferwallListener.onOfferwallAvailable(false, sse);
        }
    }

    @Override
    public void onOfferwallEventNotificationReceived(String eventName, JSONObject extData) {
        if (extData != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onOfferwallEventNotificationReceived ", 1);
        }
    }

    @Override
    public void onOWShowSuccess(String placementId) {
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ":onOWShowSuccess()", 1);
        } else {
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ":onOWShowSuccess(placementId:" + placementId + ")", 1);
        }
        if (this.mOfferwallListener != null) {
            this.mOfferwallListener.onOfferwallOpened();
        }
    }

    @Override
    public void onOWShowFail(String desc) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onOWShowFail ", 1);
        if (this.mOfferwallListener != null) {
            IronSourceError sse = ErrorBuilder.buildGenericError(desc);
            this.mOfferwallListener.onOfferwallShowFailed(sse);
        }
    }

    @Override
    public void onOWGeneric(String arg0, String arg1) {
    }

    @Override
    public boolean onOWAdCredited(int credits, int totalCredits, boolean totalCreditsFlag) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onOWAdCredited ", 1);
        return this.mOfferwallListener != null && this.mOfferwallListener.onOfferwallAdCredited(credits, totalCredits, totalCreditsFlag);
    }

    @Override
    public void onOWAdClosed() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onOWAdClosed ", 1);
        if (this.mOfferwallListener != null) {
            this.mOfferwallListener.onOfferwallClosed();
        }
    }

    @Override
    public void onGetOWCreditsFailed(String desc) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onGetOWCreditsFailed ", 1);
        if (this.mOfferwallListener != null) {
            IronSourceError sse = ErrorBuilder.buildGenericError(desc);
            this.mOfferwallListener.onGetOfferwallCreditsFailed(sse);
        }
    }

    @Override
    public void onBannerInitSuccess() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onBannerInitSuccess ", 1);
        for (BannerSmashListener smash : this.mAllBannerSmashes) {
            if (smash == null) continue;
            smash.onBannerInitSuccess();
        }
    }

    @Override
    public void onBannerInitFailed(String description) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onBannerInitFailed ", 1);
        for (BannerSmashListener smash : this.mAllBannerSmashes) {
            if (smash == null) continue;
            smash.onBannerInitFailed(ErrorBuilder.buildInitFailedError(description, "Banner"));
        }
    }

    @Override
    public void onBannerClick() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onBannerAdClicked ", 1);
        if (this.mActiveBannerSmash != null) {
            this.mActiveBannerSmash.onBannerAdClicked();
        }
    }

    @Override
    public void onBannerLoadSuccess() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onBannerLoadSuccess ", 1);
        for (BannerSmashListener smash : this.mAllBannerSmashes) {
            if (smash == null || this.mIsnAdView == null) continue;
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.mIsnAdView.getAdViewSize().getWidth(), this.mIsnAdView.getAdViewSize().getHeight());
            layoutParams.gravity = 17;
            smash.onBannerAdLoaded((View)this.mIsnAdView, layoutParams);
        }
    }

    @Override
    public void onBannerLoadFail(String description) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onBannerLoadFail", 1);
        for (BannerSmashListener smash : this.mAllBannerSmashes) {
            if (smash == null) continue;
            smash.onBannerAdLoadFailed(ErrorBuilder.buildInitFailedError(description, "Banner"));
        }
    }

    @Override
    protected void addBannerListener(BannerSmashListener listener) {
        this.mAllBannerSmashes.add(listener);
    }

    @Override
    protected void removeBannerListener(BannerSmashListener listener) {
        this.mAllBannerSmashes.remove(listener);
    }

    @Override
    protected void setMediationState(AbstractSmash.MEDIATION_STATE state, String adUnit) {
        if (this.mSSAPublisher != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :setMediationState(" + adUnit + " , " + this.getProviderName() + " , " + state.getValue() + ")", 1);
            this.mSSAPublisher.setMediationState(adUnit, this.getProviderName(), state.getValue());
        }
    }

    @Override
    protected void setConsent(boolean consent) {
        this.mDidSetConsent = true;
        this.mConsent = consent;
        this.applyConsent(consent);
    }

    private void applyConsent(boolean consent) {
        if (this.mSSAPublisher == null) {
            return;
        }
        JSONObject consentParams = new JSONObject();
        try {
            consentParams.put("gdprConsentStatus", (Object)String.valueOf(consent));
            consentParams.put("demandSourceName", (Object)this.getProviderName());
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        this.mSSAPublisher.updateConsentInfo(consentParams);
    }
}

