/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import android.text.TextUtils;
import com.ironsource.sdk.data.DemandSource;
import com.ironsource.sdk.data.SSAEnums;
import com.ironsource.sdk.listeners.OnAdProductListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class DemandSourceManager {
    private Map<String, DemandSource> mRewardedVideoDemandSourceMap = new LinkedHashMap<String, DemandSource>();
    private Map<String, DemandSource> mInterstitialDemandSourceMap = new LinkedHashMap<String, DemandSource>();

    private Map<String, DemandSource> getMapByProductType(SSAEnums.ProductType productType) {
        if (productType.name().equalsIgnoreCase(SSAEnums.ProductType.RewardedVideo.name())) {
            return this.mRewardedVideoDemandSourceMap;
        }
        if (productType.name().equalsIgnoreCase(SSAEnums.ProductType.Interstitial.name())) {
            return this.mInterstitialDemandSourceMap;
        }
        return null;
    }

    public Collection<DemandSource> getDemandSources(SSAEnums.ProductType productType) {
        Map<String, DemandSource> productDemandMap = this.getMapByProductType(productType);
        if (productDemandMap != null) {
            return productDemandMap.values();
        }
        return new ArrayList<DemandSource>();
    }

    public DemandSource getDemandSourceByName(SSAEnums.ProductType productType, String demandSourceName) {
        Map<String, DemandSource> productDemandMap;
        if (!TextUtils.isEmpty((CharSequence)demandSourceName) && (productDemandMap = this.getMapByProductType(productType)) != null) {
            return productDemandMap.get(demandSourceName);
        }
        return null;
    }

    private void put(SSAEnums.ProductType productType, String demandSourceName, DemandSource demandSource) {
        Map<String, DemandSource> productDemandMap;
        if (!TextUtils.isEmpty((CharSequence)demandSourceName) && demandSource != null && (productDemandMap = this.getMapByProductType(productType)) != null) {
            productDemandMap.put(demandSourceName, demandSource);
        }
    }

    public DemandSource createDemandSource(SSAEnums.ProductType type, String demandSourceName, Map<String, String> demandExtParam, OnAdProductListener listener) {
        DemandSource demandSource = new DemandSource(demandSourceName, demandExtParam, listener);
        this.put(type, demandSourceName, demandSource);
        return demandSource;
    }
}

