/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.EBannerSize;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.BannerLayoutListener;
import com.ironsource.mediationsdk.sdk.BannerManagerListener;
import com.ironsource.mediationsdk.sdk.BannerSmashApi;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class BannerSmash
extends AbstractSmash
implements BannerSmashListener,
BannerSmashApi {
    private final String TAG = this.getClass().getName();
    private JSONObject mBannerAdapterConfigs;
    private BannerManagerListener mBannerManagerListener;
    private BannerLayoutListener mBannerLayoutListener;
    private long mTimeoutInMillis;
    private boolean mIsReload;
    private Handler mHandler;
    private ReloadBannerRunnable mReloadBannerRunnable;
    private IronSourceBannerLayout mBannerLayout;
    private long mBannerLoadRefreshInterval;
    private EBannerSize mSize = null;

    BannerSmash(ProviderSettings adapterConfigs, long timeout, int interval) {
        super(adapterConfigs);
        this.mBannerAdapterConfigs = adapterConfigs.getBannerSettings();
        this.mIsMultipleInstances = adapterConfigs.isMultipleInstances();
        this.mSpId = adapterConfigs.getSubProviderId();
        this.mTimeoutInMillis = timeout;
        this.mBannerLoadRefreshInterval = interval * 1000;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mReloadBannerRunnable = new ReloadBannerRunnable();
    }

    void initBanners(Activity activity, String appKey, String userId) {
        this.startInitTimer();
        if (this.mAdapter != null) {
            this.mAdapter.addBannerListener(this);
            this.mAdapter.initBanners(activity, appKey, userId, this.mBannerAdapterConfigs, this);
        }
    }

    @Override
    boolean isExhausted() {
        return false;
    }

    @Override
    boolean isCappedPerSession() {
        return false;
    }

    @Override
    void completeIteration() {
    }

    @Override
    void startInitTimer() {
        try {
            this.mInitTimerTask = new TimerTask(){

                @Override
                public void run() {
                    if (BannerSmash.this.mMediationState == AbstractSmash.MEDIATION_STATE.INIT_PENDING && BannerSmash.this.mBannerManagerListener != null) {
                        BannerSmash.this.onBannerInitFailed(ErrorBuilder.buildInitFailedError("Timeout", "Banner"));
                    }
                }
            };
            Timer timer = new Timer();
            if (this.mInitTimerTask != null) {
                timer.schedule(this.mInitTimerTask, this.mTimeoutInMillis);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    void startLoadTimer() {
        try {
            this.mLoadTimerTask = new TimerTask(){

                @Override
                public void run() {
                    if (BannerSmash.this.mMediationState == AbstractSmash.MEDIATION_STATE.LOAD_PENDING && BannerSmash.this.mBannerManagerListener != null) {
                        BannerSmash.this.onBannerAdLoadFailed(new IronSourceError(603, "Timeout"));
                    }
                }
            };
            Timer timer = new Timer();
            if (this.mLoadTimerTask != null) {
                timer.schedule(this.mLoadTimerTask, this.mTimeoutInMillis);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    protected String getAdUnitString() {
        return "banner";
    }

    @Override
    public IronSourceBannerLayout createBanner(Activity activity, EBannerSize size) {
        return null;
    }

    @Override
    public void loadBanner(IronSourceBannerLayout banner) {
        if (banner != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":loadBanner()", 1);
            this.mIsReload = false;
            this.cancelRefresh();
            this.startLoadTimer();
            this.mBannerLayoutListener = banner;
            this.mBannerLayout = banner;
            this.mSize = banner.getSize();
            this.mBannerLayout.bindSmash(this);
            if (this.mAdapter != null) {
                this.preShow();
                this.mAdapter.loadBanner(banner, this.mBannerAdapterConfigs, this);
            }
        }
    }

    @Override
    public void destroyBanner(IronSourceBannerLayout banner) {
        this.cancelRefresh();
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":destroyBanner()", 1);
            this.mAdapter.destroyBanner(banner, this.mBannerAdapterConfigs);
        } else {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":destroyBanner wasn't called. adapter is null", 1);
        }
    }

    private void reloadBanner() {
        this.mIsReload = true;
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":reloadBanner()", 1);
            this.mAdapter.reloadBanner(this.mBannerAdapterConfigs);
            this.mBannerManagerListener.onBannerReloadAd(this);
        }
    }

    void setBannerManagerListener(BannerManagerListener manager) {
        this.mBannerManagerListener = manager;
    }

    @Override
    public void onBannerAdLoaded() {
        this.stopLoadTimer();
        this.scheduleRefresh(this.mBannerLoadRefreshInterval);
        if (this.mIsReload && this.mBannerLayoutListener != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":onBannerAdReloaded()", 1);
            this.mBannerLayoutListener.onBannerAdReloaded(this);
            return;
        }
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":onBannerAdLoaded()", 1);
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.LOAD_PENDING && this.mBannerLayoutListener != null) {
            this.mBannerLayoutListener.onBannerAdLoaded(this);
        }
    }

    @Override
    public void onBannerAdLoadFailed(IronSourceError error) {
        if (this.mIsReload && this.mBannerLayoutListener != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":onBannerAdReloadFailed()", 1);
            this.cancelRefresh();
            this.mBannerLayoutListener.onBannerAdReloadFailed(this);
            return;
        }
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":onBannerAdLoadFailed()", 1);
        this.stopLoadTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.LOAD_PENDING && this.mBannerLayoutListener != null) {
            this.mBannerLayoutListener.onBannerAdLoadFailed(error, this);
        }
    }

    @Override
    public void onBannerAdClicked() {
        if (this.mBannerLayoutListener != null) {
            this.mBannerLayoutListener.onBannerAdClicked(this);
        }
    }

    @Override
    public void onBannerAdScreenPresented() {
        if (this.mIsReload) {
            return;
        }
        if (this.mBannerLayoutListener != null) {
            this.mBannerLayoutListener.onBannerAdScreenPresented(this);
        }
    }

    @Override
    public void onBannerAdScreenDismissed() {
        if (this.mIsReload) {
            return;
        }
        if (this.mBannerLayoutListener != null) {
            this.mBannerLayoutListener.onBannerAdScreenDismissed(this);
        }
    }

    @Override
    public void onBannerAdLeftApplication() {
        if (this.mBannerLayoutListener != null) {
            this.mBannerLayoutListener.onBannerAdLeftApplication(this);
        }
    }

    @Override
    public void onBannerInitSuccess() {
        this.stopInitTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.INIT_PENDING) {
            this.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
            if (this.mBannerManagerListener != null) {
                this.mBannerManagerListener.onBannerInitSuccess(this);
            }
        }
    }

    @Override
    public void onBannerInitFailed(IronSourceError error) {
        this.stopInitTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.INIT_PENDING) {
            this.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
            if (this.mBannerManagerListener != null) {
                this.mBannerManagerListener.onBannerInitFailed(error, this);
            }
        }
    }

    private void scheduleRefresh(long refreshInterval) {
        if (this.mHandler != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, this.TAG + ":refreshing banner in " + refreshInterval + " milliseconds ", 1);
            this.mReloadBannerRunnable = new ReloadBannerRunnable();
            this.mHandler.postDelayed((Runnable)this.mReloadBannerRunnable, refreshInterval);
        }
    }

    private void cancelRefresh() {
        if (this.mHandler != null && this.mReloadBannerRunnable != null) {
            this.mHandler.removeCallbacks((Runnable)this.mReloadBannerRunnable);
        }
    }

    public EBannerSize getSize() {
        return this.mSize;
    }

    private class ReloadBannerRunnable
    implements Runnable {
        private ReloadBannerRunnable() {
        }

        @Override
        public void run() {
            if (BannerSmash.this.mBannerLayout != null) {
                if (BannerSmash.this.mBannerLayout.isShown() && BannerSmash.this.mIsInForeground) {
                    BannerSmash.this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, BannerSmash.this.TAG + ": refreshing banner for : " + BannerSmash.this.getInstanceName(), 1);
                    BannerSmash.this.reloadBanner();
                } else {
                    BannerSmash.this.scheduleRefresh(BannerSmash.this.mBannerLoadRefreshInterval);
                }
            }
        }
    }
}

