/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.View;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.logger.LogListener;
import com.ironsource.mediationsdk.logger.LoggingApi;
import com.ironsource.mediationsdk.sdk.BannerAdapterApi;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.BaseApi;
import com.ironsource.mediationsdk.sdk.InterstitialAdapterApi;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialApi;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoAdapterApi;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public abstract class AbstractAdapter
implements BaseApi,
InterstitialAdapterApi,
RewardedVideoAdapterApi,
BannerAdapterApi,
LoggingApi,
RewardedInterstitialApi {
    private IronSourceLoggerManager mLoggerManager = IronSourceLoggerManager.getLogger();
    protected RewardedVideoSmashListener mActiveRewardedVideoSmash;
    protected CopyOnWriteArrayList<RewardedVideoSmashListener> mAllRewardedVideoSmashes = new CopyOnWriteArrayList();
    protected ConcurrentHashMap<String, RewardedVideoSmashListener> mRewardedVideoPlacementToListenerMap;
    protected InterstitialSmashListener mActiveInterstitialSmash;
    protected CopyOnWriteArrayList<InterstitialSmashListener> mAllInterstitialSmashes = new CopyOnWriteArrayList();
    protected ConcurrentHashMap<String, InterstitialSmashListener> mInterstitialPlacementToListenerMap;
    protected BannerSmashListener mActiveBannerSmash;
    protected CopyOnWriteArrayList<BannerSmashListener> mAllBannerSmashes;
    protected View mCurrentAdNetworkBanner;
    private String mPluginType;
    private String mPluginFrameworkVersion;
    private String mProviderName;
    protected RewardedInterstitialListener mRewardedInterstitial;
    protected IronSourceBannerLayout mIronSourceBanner;

    public AbstractAdapter(String providerName) {
        this.mRewardedVideoPlacementToListenerMap = new ConcurrentHashMap();
        this.mInterstitialPlacementToListenerMap = new ConcurrentHashMap();
        this.mProviderName = providerName;
    }

    public String getProviderName() {
        return this.mProviderName;
    }

    protected String getDynamicUserId() {
        return IronSourceObject.getInstance().getDynamicUserId();
    }

    void setPluginData(String pluginType, String pluginFrameworkVersion) {
        this.mPluginType = pluginType;
        this.mPluginFrameworkVersion = pluginFrameworkVersion;
    }

    public String getPluginType() {
        return this.mPluginType;
    }

    public String getPluginFrameworkVersion() {
        return this.mPluginFrameworkVersion;
    }

    protected void log(IronSourceLogger.IronSourceTag tag, String message, int logLevel) {
        this.mLoggerManager.onLog(tag, message, logLevel);
    }

    public abstract String getVersion();

    public abstract String getCoreSDKVersion();

    protected void removeBannerViews() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AbstractAdapter.this.mIronSourceBanner != null && AbstractAdapter.this.mCurrentAdNetworkBanner != null && AbstractAdapter.this.mCurrentAdNetworkBanner.getParent() == AbstractAdapter.this.mIronSourceBanner) {
                        AbstractAdapter.this.mIronSourceBanner.removeView(AbstractAdapter.this.mCurrentAdNetworkBanner);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
    }

    @Override
    public void setLogListener(LogListener logListener) {
    }

    @Override
    public void setRewardedInterstitialListener(RewardedInterstitialListener listener) {
        this.mRewardedInterstitial = listener;
    }

    protected boolean isAdaptersDebugEnabled() {
        return this.mLoggerManager.isDebugEnabled();
    }

    public void initBanners(Activity activity, String appKey, String userId, JSONObject config) {
    }

    @Override
    public void loadBanner(IronSourceBannerLayout banner, JSONObject config, BannerSmashListener listener) {
    }

    @Override
    public void destroyBanner(IronSourceBannerLayout banner) {
    }

    @Override
    public void reloadBanner() {
    }

    protected void addBannerListener(BannerSmashListener listener) {
    }

    protected void removeBannerListener(BannerSmashListener listener) {
    }

    @Override
    public void addRewardedVideoListener(RewardedVideoSmashListener listener) {
        this.mAllRewardedVideoSmashes.add(listener);
    }

    @Override
    public void removeRewardedVideoListener(RewardedVideoSmashListener listener) {
        this.mAllRewardedVideoSmashes.remove(listener);
    }

    @Override
    public void addInterstitialListener(InterstitialSmashListener listener) {
        this.mAllInterstitialSmashes.add(listener);
    }

    @Override
    public void removeInterstitialListener(InterstitialSmashListener listener) {
        this.mAllInterstitialSmashes.remove(listener);
    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void setAge(int age) {
    }

    @Override
    public void setGender(String gender) {
    }

    @Override
    public void setMediationSegment(String segment) {
    }

    protected boolean isLargeScreen(Activity activity) {
        DisplayMetrics displayMetrics = activity.getResources().getDisplayMetrics();
        float dpHeight = (float)displayMetrics.heightPixels / displayMetrics.density;
        return dpHeight > 720.0f;
    }

    protected int getScreenWidthPixels(Activity activity) {
        return activity.getResources().getDisplayMetrics().widthPixels;
    }

    protected void setMediationState(AbstractSmash.MEDIATION_STATE state, String adUnit) {
    }
}

