/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdUnitManager;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.CallbackThrotteler;
import com.ironsource.mediationsdk.InterstitialSmash;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.MediationInitializer;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.model.InterstitialPlacement;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyInterstitialListener;
import com.ironsource.mediationsdk.sdk.InterstitialApi;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import com.ironsource.mediationsdk.sdk.InterstitialManagerListener;
import com.ironsource.mediationsdk.sdk.ListenersWrapper;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialApi;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialListener;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialManagerListener;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.DailyCappingListener;
import com.ironsource.mediationsdk.utils.DailyCappingManager;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.json.JSONObject;

class InterstitialManager
extends AbstractAdUnitManager
implements InterstitialApi,
InterstitialManagerListener,
MediationInitializer.OnMediationInitializationListener,
RewardedInterstitialManagerListener,
RewardedInterstitialApi,
DailyCappingListener {
    private final String TAG = this.getClass().getName();
    private ListenersWrapper mInterstitialListenersWrapper;
    private RewardedInterstitialListener mRewardedInterstitialListenerWrapper;
    private ISDemandOnlyInterstitialListener mISDemandOnlyInterstitialListener;
    private boolean mDidCallLoadInterstitial = false;
    private boolean mIsLoadInterstitialInProgress = false;
    private boolean mDidFinishToInitInterstitial;
    private InterstitialPlacement mCurrentPlacement;
    private CallbackThrotteler mCallbackThrotteler;
    private boolean mShouldSendAdReadyEvent = false;
    private Map<String, InterstitialSmash> mInstanceIdToSmashMap;
    private CopyOnWriteArraySet<String> mInstancesToLoad = new CopyOnWriteArraySet();

    InterstitialManager() {
        this.mInstanceIdToSmashMap = new ConcurrentHashMap<String, InterstitialSmash>();
        this.mCallbackThrotteler = new CallbackThrotteler();
        this.mDailyCappingManager = new DailyCappingManager("interstitial", this);
    }

    @Override
    public void setInterstitialListener(InterstitialListener listener) {
        this.mInterstitialListenersWrapper = (ListenersWrapper)listener;
        this.mCallbackThrotteler.setInterstitialListener(listener);
    }

    @Override
    public void setRewardedInterstitialListener(RewardedInterstitialListener listener) {
        this.mRewardedInterstitialListenerWrapper = listener;
    }

    @Override
    public synchronized void initInterstitial(Activity activity, String appKey, String userId) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, this.TAG + ":initInterstitial(appKey: " + appKey + ", userId: " + userId + ")", 1);
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mActivity = activity;
        if (this.mIsInISDemandOnlyMode) {
            this.mSmartLoadAmount = this.mSmashArray.size();
            for (AbstractSmash smash : this.mSmashArray) {
                if (this.startAdapter((InterstitialSmash)smash) == null) {
                    smash.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
                }
                this.mInstanceIdToSmashMap.put(smash.getSubProviderId(), (InterstitialSmash)smash);
            }
        } else {
            this.mDailyCappingManager.setContext((Context)this.mActivity);
            int dailyCappedCount = 0;
            for (AbstractSmash smash : this.mSmashArray) {
                if (this.mDailyCappingManager.shouldSendCapReleasedEvent(smash)) {
                    this.logProviderEvent(250, smash, new Object[][]{{"status", "false"}});
                }
                if (!this.mDailyCappingManager.isCapped(smash)) continue;
                smash.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY);
                ++dailyCappedCount;
            }
            if (dailyCappedCount == this.mSmashArray.size()) {
                this.mDidFinishToInitInterstitial = true;
            }
            for (int i2 = 0; i2 < this.mSmartLoadAmount && this.startNextAdapter() != null; ++i2) {
            }
        }
    }

    @Override
    public synchronized void loadInterstitial() {
        block12: {
            try {
                if (this.mIsLoadInterstitialInProgress || this.mCallbackThrotteler.hasPendingInvocation()) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Load Interstitial is already in progress", 1);
                    return;
                }
                MediationInitializer.EInitStatus initStatus = MediationInitializer.getInstance().getCurrentInitStatus();
                if (initStatus == MediationInitializer.EInitStatus.NOT_INIT) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() must be called before loadInterstitial()", 3);
                    return;
                }
                if (initStatus == MediationInitializer.EInitStatus.INIT_IN_PROGRESS) {
                    if (MediationInitializer.getInstance().isInProgressMoreThan15Secs()) {
                        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() had failed", 3);
                        this.mCallbackThrotteler.onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
                    } else {
                        this.logMediationEvent(22, null);
                        this.mDidCallLoadInterstitial = true;
                        this.mShouldSendAdReadyEvent = true;
                    }
                    return;
                }
                if (initStatus == MediationInitializer.EInitStatus.INIT_FAILED) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() had failed", 3);
                    this.mCallbackThrotteler.onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
                    return;
                }
                if (this.mSmashArray.size() == 0) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "the server response does not contain interstitial data", 3);
                    this.mCallbackThrotteler.onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError("the server response does not contain interstitial data", "Interstitial"));
                    return;
                }
                this.logMediationEvent(22, null);
                this.mShouldSendAdReadyEvent = true;
                this.changeStateToInitiated();
                if (this.smashesCount(AbstractSmash.MEDIATION_STATE.INITIATED) == 0) {
                    if (!this.mDidFinishToInitInterstitial) {
                        return;
                    }
                    IronSourceError error = ErrorBuilder.buildGenericError("no ads to load");
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, error.getErrorMessage(), 1);
                    this.mCallbackThrotteler.onInterstitialAdLoadFailed(error);
                    this.logMediationEvent(227, new Object[][]{{"errorCode", error.getErrorCode()}});
                    this.mShouldSendAdReadyEvent = false;
                    return;
                }
                this.mDidCallLoadInterstitial = true;
                this.mIsLoadInterstitialInProgress = true;
                int loading = 0;
                for (AbstractSmash smash : this.mSmashArray) {
                    if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED) continue;
                    smash.setMediationState(AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
                    this.loadAdapterAndSendEvent((InterstitialSmash)smash);
                    if (++loading < this.mSmartLoadAmount) continue;
                    return;
                }
            }
            catch (Exception e2) {
                IronSourceError error = ErrorBuilder.buildLoadFailedError("loadInterstitial exception " + e2.getMessage());
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, error.getErrorMessage(), 3);
                this.mCallbackThrotteler.onInterstitialAdLoadFailed(error);
                if (!this.mShouldSendAdReadyEvent) break block12;
                this.mShouldSendAdReadyEvent = false;
                this.logMediationEvent(227, new Object[][]{{"errorCode", error.getErrorCode()}});
            }
        }
    }

    @Override
    public void showInterstitial(String placementName) {
        if (this.mShouldTrackNetworkState && this.mActivity != null && !IronSourceUtils.isNetworkConnected((Context)this.mActivity)) {
            this.mInterstitialListenersWrapper.onInterstitialAdShowFailed(ErrorBuilder.buildNoInternetConnectionShowFailError("Interstitial"));
            return;
        }
        if (!this.mDidCallLoadInterstitial) {
            this.mInterstitialListenersWrapper.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError("Interstitial", "showInterstitial failed - You need to load interstitial before showing it"));
            return;
        }
        for (int i2 = 0; i2 < this.mSmashArray.size(); ++i2) {
            AbstractSmash smash = (AbstractSmash)this.mSmashArray.get(i2);
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            CappingManager.incrementShowCounter((Context)this.mActivity, this.mCurrentPlacement);
            this.logProviderEvent(23, smash, new Object[][]{{"placement", placementName}});
            this.sendShowChanceEvents(smash, i2, placementName);
            ((InterstitialSmash)smash).showInterstitial();
            this.mDailyCappingManager.increaseShowCounter(smash);
            if (this.mDailyCappingManager.isCapped(smash)) {
                smash.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY);
                this.logProviderEvent(250, smash, new Object[][]{{"status", "true"}});
            }
            this.mDidCallLoadInterstitial = false;
            if (!smash.isMediationAvailable()) {
                this.startNextAdapter();
            }
            return;
        }
        this.mInterstitialListenersWrapper.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError("Interstitial", "showInterstitial failed - No adapters ready to show"));
    }

    @Override
    public synchronized boolean isInterstitialReady() {
        if (this.mShouldTrackNetworkState && this.mActivity != null && !IronSourceUtils.isNetworkConnected((Context)this.mActivity)) {
            return false;
        }
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE || !((InterstitialSmash)smash).isInterstitialReady()) continue;
            return true;
        }
        return false;
    }

    public void setISDemandOnlyInterstitialListener(ISDemandOnlyInterstitialListener listener) {
        this.mISDemandOnlyInterstitialListener = listener;
        this.mCallbackThrotteler.setISDemandOnlyInterstitialListener(listener);
    }

    public synchronized void loadInterstitial(String instanceId) {
        try {
            if (this.mCallbackThrotteler.hasPendingInvocation(instanceId)) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Load Interstitial for " + instanceId + " is already in progress", 1);
                return;
            }
            MediationInitializer.EInitStatus initStatus = MediationInitializer.getInstance().getCurrentInitStatus();
            if (initStatus == MediationInitializer.EInitStatus.NOT_INIT) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() must be called before loadInterstitial()", 3);
                return;
            }
            if (initStatus == MediationInitializer.EInitStatus.INIT_IN_PROGRESS) {
                if (MediationInitializer.getInstance().isInProgressMoreThan15Secs()) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() had failed", 3);
                    this.mCallbackThrotteler.onInterstitialAdLoadFailed(instanceId, ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
                } else {
                    this.mInstancesToLoad.add(instanceId);
                }
                return;
            }
            if (initStatus == MediationInitializer.EInitStatus.INIT_FAILED) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() had failed", 3);
                this.mCallbackThrotteler.onInterstitialAdLoadFailed(instanceId, ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
                return;
            }
            if (!this.mInstanceIdToSmashMap.containsKey(instanceId)) {
                IronSourceError error = ErrorBuilder.buildNonExistentInstanceError("Interstitial");
                this.mCallbackThrotteler.onInterstitialAdLoadFailed(instanceId, error);
                this.logMediationEvent(22, null);
                this.logMediationEvent(227, new Object[][]{{"errorCode", error.getErrorCode()}});
                return;
            }
            InterstitialSmash smash = this.mInstanceIdToSmashMap.get(instanceId);
            if (smash.getMediationState() == AbstractSmash.MEDIATION_STATE.INIT_PENDING) {
                this.mInstancesToLoad.add(instanceId);
            } else {
                smash.setMediationState(AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
                this.loadAdapterAndSendEvent(smash);
            }
        }
        catch (Exception e2) {
            IronSourceError error = ErrorBuilder.buildLoadFailedError("loadInterstitial exception");
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, error.getErrorMessage(), 3);
            this.mCallbackThrotteler.onInterstitialAdLoadFailed(error);
        }
    }

    public void showInterstitial(String instanceId, String placementName) {
        if (this.mShouldTrackNetworkState && this.mActivity != null && !IronSourceUtils.isNetworkConnected((Context)this.mActivity)) {
            this.mISDemandOnlyInterstitialListener.onInterstitialAdShowFailed(instanceId, ErrorBuilder.buildNoInternetConnectionShowFailError("Interstitial"));
            return;
        }
        boolean existingInstanceId = false;
        for (int i2 = 0; i2 < this.mSmashArray.size(); ++i2) {
            AbstractSmash smash = (AbstractSmash)this.mSmashArray.get(i2);
            if (!smash.getSubProviderId().equals(instanceId)) continue;
            existingInstanceId = true;
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            CappingManager.incrementShowCounter((Context)this.mActivity, this.mCurrentPlacement);
            this.logProviderEvent(23, smash, new Object[][]{{"placement", placementName}});
            this.sendShowChanceEvents(smash, i2, placementName);
            ((InterstitialSmash)smash).showInterstitial();
            this.changeStateToInitiatedForInstanceId(instanceId);
            return;
        }
        if (!existingInstanceId) {
            this.mISDemandOnlyInterstitialListener.onInterstitialAdShowFailed(instanceId, ErrorBuilder.buildNonExistentInstanceError("no ads to show"));
        } else {
            this.mISDemandOnlyInterstitialListener.onInterstitialAdShowFailed(instanceId, ErrorBuilder.buildShowFailedError("Interstitial", "no ads to show"));
        }
    }

    public synchronized boolean isInterstitialReady(String instanceId) {
        if (this.mShouldTrackNetworkState && this.mActivity != null && !IronSourceUtils.isNetworkConnected((Context)this.mActivity)) {
            return false;
        }
        for (AbstractSmash smash : this.mSmashArray) {
            if (!smash.getSubProviderId().equals(instanceId)) continue;
            return smash.getMediationState() == AbstractSmash.MEDIATION_STATE.AVAILABLE && ((InterstitialSmash)smash).isInterstitialReady();
        }
        return false;
    }

    @Override
    public synchronized void onInterstitialInitSuccess(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + " :onInterstitialInitSuccess()", 1);
        this.mDidFinishToInitInterstitial = true;
        if (this.mIsInISDemandOnlyMode) {
            String instanceId = smash.getSubProviderId();
            if (this.mInstancesToLoad.contains(instanceId)) {
                this.mInstancesToLoad.remove(instanceId);
                this.loadInterstitial(instanceId);
            }
        } else if (this.mDidCallLoadInterstitial && this.smashesCount(AbstractSmash.MEDIATION_STATE.AVAILABLE, AbstractSmash.MEDIATION_STATE.LOAD_PENDING) < this.mSmartLoadAmount) {
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
            this.loadAdapterAndSendEvent(smash);
        }
    }

    @Override
    public synchronized void onInterstitialInitFailed(IronSourceError error, InterstitialSmash smash) {
        try {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialInitFailed(" + error + ")", 1);
            if (this.mIsInISDemandOnlyMode) {
                String instanceId = smash.getSubProviderId();
                if (this.mInstancesToLoad.contains(instanceId)) {
                    this.mInstancesToLoad.remove(instanceId);
                    this.mCallbackThrotteler.onInterstitialAdLoadFailed(instanceId, ErrorBuilder.buildGenericError("no ads to show"));
                    this.logMediationEvent(227, new Object[][]{{"errorCode", 510}});
                    this.logProviderEvent(227, smash, new Object[][]{{"errorCode", 510}});
                }
            } else if (this.smashesCount(AbstractSmash.MEDIATION_STATE.INIT_FAILED) >= this.mSmashArray.size()) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, "Smart Loading - initialization failed - no adapters are initiated and no more left to init, error: " + error.getErrorMessage(), 2);
                if (this.mDidCallLoadInterstitial) {
                    this.mCallbackThrotteler.onInterstitialAdLoadFailed(ErrorBuilder.buildGenericError("no ads to show"));
                    this.logMediationEvent(227, new Object[][]{{"errorCode", 510}});
                    this.mShouldSendAdReadyEvent = false;
                }
                this.mDidFinishToInitInterstitial = true;
            } else {
                this.startNextAdapter();
                this.completeIterationRound();
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onInterstitialInitFailed(error:" + error + ", provider:" + smash.getName() + ")", e2);
        }
    }

    @Override
    public synchronized void onInterstitialAdReady(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdReady()", 1);
        this.logProviderEvent(27, smash, new Object[][]{{"status", "true"}});
        if (this.mIsInISDemandOnlyMode) {
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.AVAILABLE);
            this.mISDemandOnlyInterstitialListener.onInterstitialAdReady(smash.getSubProviderId());
            this.logMediationEvent(27, new Object[][]{{"status", "true"}});
        } else {
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.AVAILABLE);
            this.mIsLoadInterstitialInProgress = false;
            if (this.mShouldSendAdReadyEvent) {
                this.mShouldSendAdReadyEvent = false;
                this.mInterstitialListenersWrapper.onInterstitialAdReady();
                this.logMediationEvent(27, new Object[][]{{"status", "true"}});
            }
        }
    }

    @Override
    public synchronized void onInterstitialAdLoadFailed(IronSourceError error, InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdLoadFailed(" + error + ")", 1);
        this.logProviderEvent(227, smash, new Object[][]{{"errorCode", error.getErrorCode()}});
        if (this.mIsInISDemandOnlyMode) {
            this.mCallbackThrotteler.onInterstitialAdLoadFailed(smash.getSubProviderId(), error);
            this.logMediationEvent(227, new Object[][]{{"errorCode", error.getErrorCode()}});
        } else {
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
            int availableOrLoadPending = this.smashesCount(AbstractSmash.MEDIATION_STATE.AVAILABLE, AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
            if (availableOrLoadPending >= this.mSmartLoadAmount) {
                return;
            }
            for (AbstractSmash asmash : this.mSmashArray) {
                if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED) continue;
                asmash.setMediationState(AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
                this.loadAdapterAndSendEvent((InterstitialSmash)asmash);
                return;
            }
            if (this.startNextAdapter() != null) {
                return;
            }
            if (this.mDidCallLoadInterstitial && availableOrLoadPending == 0) {
                this.completeIterationRound();
                this.mCallbackThrotteler.onInterstitialAdLoadFailed(error);
                this.logMediationEvent(227, new Object[][]{{"errorCode", error.getErrorCode()}});
            }
        }
    }

    @Override
    public void onInterstitialAdOpened(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdOpened()", 1);
        this.logProviderEvent(25, smash, null);
        if (this.mIsInISDemandOnlyMode) {
            this.mISDemandOnlyInterstitialListener.onInterstitialAdOpened(smash.getSubProviderId());
        } else {
            this.mInterstitialListenersWrapper.onInterstitialAdOpened();
        }
    }

    @Override
    public void onInterstitialAdClosed(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdClosed()", 1);
        this.logProviderEvent(26, smash, null);
        if (this.mIsInISDemandOnlyMode) {
            this.mISDemandOnlyInterstitialListener.onInterstitialAdClosed(smash.getSubProviderId());
        } else {
            this.mInterstitialListenersWrapper.onInterstitialAdClosed();
        }
    }

    @Override
    public void onInterstitialAdShowSucceeded(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdShowSucceeded()", 1);
        if (this.mIsInISDemandOnlyMode) {
            this.mISDemandOnlyInterstitialListener.onInterstitialAdShowSucceeded(smash.getSubProviderId());
        } else {
            boolean hasAvailable = false;
            for (AbstractSmash asmash : this.mSmashArray) {
                if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
                hasAvailable = true;
                this.completeAdapterShow(asmash);
            }
            if (!(hasAvailable || smash.getMediationState() != AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.EXHAUSTED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY)) {
                this.completeIterationRound();
            }
            this.changeStateToInitiated();
            this.mInterstitialListenersWrapper.onInterstitialAdShowSucceeded();
        }
    }

    @Override
    public void onInterstitialAdShowFailed(IronSourceError error, InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdShowFailed(" + error + ")", 1);
        if (this.mIsInISDemandOnlyMode) {
            this.mISDemandOnlyInterstitialListener.onInterstitialAdShowFailed(smash.getSubProviderId(), error);
        } else {
            this.completeAdapterShow(smash);
            for (AbstractSmash asmash : this.mSmashArray) {
                if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
                this.mDidCallLoadInterstitial = true;
                this.showInterstitial(this.mCurrentPlacement.getPlacementName());
                return;
            }
            this.mInterstitialListenersWrapper.onInterstitialAdShowFailed(error);
        }
    }

    @Override
    public void onInterstitialAdClicked(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdClicked()", 1);
        this.logProviderEvent(28, smash, null);
        if (this.mIsInISDemandOnlyMode) {
            this.mISDemandOnlyInterstitialListener.onInterstitialAdClicked(smash.getSubProviderId());
        } else {
            this.mInterstitialListenersWrapper.onInterstitialAdClicked();
        }
    }

    @Override
    public void onInterstitialAdVisible(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdVisible()", 1);
        this.logProviderEvent(31, smash, new Object[][]{{"placement", this.mCurrentPlacement.getPlacementName()}});
    }

    @Override
    public void onInterstitialAdRewarded(InterstitialSmash smash) {
        this.logProviderEvent(290, smash, null);
        if (this.mRewardedInterstitialListenerWrapper != null) {
            this.mRewardedInterstitialListenerWrapper.onInterstitialAdRewarded();
        }
    }

    @Override
    void shouldTrackNetworkState(Context context, boolean track) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, this.TAG + " Should Track Network State: " + track, 0);
        this.mShouldTrackNetworkState = track;
    }

    @Override
    public void onInitSuccess(List<IronSource.AD_UNIT> adUnits, boolean revived) {
    }

    @Override
    public void onInitFailed(String reason) {
        if (this.mIsInISDemandOnlyMode) {
            for (String instanceId : this.mInstancesToLoad) {
                this.mCallbackThrotteler.onInterstitialAdLoadFailed(instanceId, ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
            }
            this.mInstancesToLoad.clear();
        } else if (this.mDidCallLoadInterstitial) {
            this.mCallbackThrotteler.onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
            this.mDidCallLoadInterstitial = false;
            this.mIsLoadInterstitialInProgress = false;
        }
    }

    @Override
    public void onStillInProgressAfter15Secs() {
        if (this.mIsInISDemandOnlyMode) {
            for (String instanceId : this.mInstancesToLoad) {
                this.mCallbackThrotteler.onInterstitialAdLoadFailed(instanceId, ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
            }
            this.mInstancesToLoad.clear();
        } else if (this.mDidCallLoadInterstitial) {
            IronSourceError error = ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial");
            this.mCallbackThrotteler.onInterstitialAdLoadFailed(error);
            this.mDidCallLoadInterstitial = false;
            this.mIsLoadInterstitialInProgress = false;
            if (this.mShouldSendAdReadyEvent) {
                this.logMediationEvent(227, new Object[][]{{"errorCode", error.getErrorCode()}});
                this.mShouldSendAdReadyEvent = false;
            }
        }
    }

    private boolean isIterationRoundComplete() {
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_INITIATED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INIT_PENDING && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.LOAD_PENDING && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            return false;
        }
        return true;
    }

    private void completeIterationRound() {
        if (this.isIterationRoundComplete()) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Reset Iteration", 0);
            for (AbstractSmash smash : this.mSmashArray) {
                if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.EXHAUSTED) continue;
                smash.completeIteration();
            }
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "End of Reset Iteration", 0);
        }
    }

    private void completeAdapterShow(AbstractSmash smash) {
        if (!smash.isMediationAvailable()) {
            this.startNextAdapter();
            this.completeIterationRound();
        } else {
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
        }
    }

    private AbstractAdapter startNextAdapter() {
        AbstractAdapter initiatedAdapter = null;
        int activeAdapters = 0;
        for (int i2 = 0; i2 < this.mSmashArray.size() && initiatedAdapter == null; ++i2) {
            if (((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() == AbstractSmash.MEDIATION_STATE.AVAILABLE || ((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() == AbstractSmash.MEDIATION_STATE.INITIATED || ((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() == AbstractSmash.MEDIATION_STATE.INIT_PENDING || ((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() == AbstractSmash.MEDIATION_STATE.LOAD_PENDING) {
                if (++activeAdapters < this.mSmartLoadAmount) continue;
                break;
            }
            if (((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_INITIATED || (initiatedAdapter = this.startAdapter((InterstitialSmash)this.mSmashArray.get(i2))) != null) continue;
            ((AbstractSmash)this.mSmashArray.get(i2)).setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
        }
        return initiatedAdapter;
    }

    private synchronized AbstractAdapter startAdapter(InterstitialSmash smash) {
        AbstractAdapter providerAdapter;
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, this.TAG + ":startAdapter(" + smash.getName() + ")", 1);
        try {
            providerAdapter = this.getLoadedAdapterOrFetchByReflection(smash);
            if (providerAdapter == null) {
                return null;
            }
            IronSourceObject.getInstance().addToISAdaptersList(providerAdapter);
            providerAdapter.setLogListener(this.mLoggerManager);
            smash.setAdapterForSmash(providerAdapter);
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_PENDING);
            if (this.mRewardedInterstitialListenerWrapper != null) {
                smash.setRewardedInterstitialManagerListener(this);
            }
            this.setCustomParams(smash);
            smash.initInterstitial(this.mActivity, this.mAppKey, this.mUserId);
        }
        catch (Throwable e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, this.TAG + ":startAdapter(" + smash.getName() + ")", e2);
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
            IronSourceError error = ErrorBuilder.buildInitFailedError(smash.getName() + " initialization failed - please verify that required dependencies are in you build path.", "Interstitial");
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, error.toString(), 2);
            return null;
        }
        return providerAdapter;
    }

    void setCurrentPlacement(InterstitialPlacement currentPlacement) {
        this.mCurrentPlacement = currentPlacement;
    }

    private synchronized void loadAdapterAndSendEvent(InterstitialSmash smash) {
        if (this.mIsInISDemandOnlyMode) {
            this.logMediationEvent(22, null);
        }
        this.logProviderEvent(22, smash, null);
        smash.loadInterstitial();
    }

    private synchronized void changeStateToInitiatedForInstanceId(String instanceId) {
        for (AbstractSmash smash : this.mSmashArray) {
            if (!smash.getSubProviderId().equals(instanceId) || smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.LOAD_PENDING && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
            break;
        }
    }

    private synchronized void changeStateToInitiated() {
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.LOAD_PENDING && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
        }
    }

    private void sendShowChanceEvent(AbstractSmash smash, String placementName, boolean status) {
        this.logProviderEvent(219, smash, new Object[][]{{"placement", placementName}, {"status", status ? "true" : "false"}});
    }

    private void sendShowChanceEvents(AbstractSmash selectedSmash, int priority, String placementName) {
        this.sendShowChanceEvent(selectedSmash, placementName, true);
        if (!this.mIsInISDemandOnlyMode) {
            for (int i2 = 0; i2 < this.mSmashArray.size() && i2 < priority; ++i2) {
                AbstractSmash smash = (AbstractSmash)this.mSmashArray.get(i2);
                if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
                this.sendShowChanceEvent(smash, placementName, false);
            }
        }
    }

    private void logMediationEvent(int eventId, Object[][] keyVals) {
        JSONObject data = IronSourceUtils.getMediationAdditionalData(this.mIsInISDemandOnlyMode);
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "InterstitialManager logMediationEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, data);
        InterstitialEventsManager.getInstance().log(event);
    }

    private void logProviderEvent(int eventId, AbstractSmash smash, Object[][] keyVals) {
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash, this.mIsInISDemandOnlyMode);
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "InterstitialManager logProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, data);
        InterstitialEventsManager.getInstance().log(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int smashesCount(AbstractSmash.MEDIATION_STATE ... states) {
        CopyOnWriteArrayList copyOnWriteArrayList = this.mSmashArray;
        synchronized (copyOnWriteArrayList) {
            int ret = 0;
            for (AbstractSmash smash : this.mSmashArray) {
                for (AbstractSmash.MEDIATION_STATE state : states) {
                    if (smash.getMediationState() != state) continue;
                    ++ret;
                }
            }
            return ret;
        }
    }

    @Override
    public void onDailyCapReleased() {
        if (this.mSmashArray != null) {
            for (AbstractSmash smash : this.mSmashArray) {
                if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY) continue;
                this.logProviderEvent(250, smash, new Object[][]{{"status", "false"}});
                if (smash.isCappedPerSession()) {
                    smash.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION);
                    continue;
                }
                if (smash.isExhausted()) {
                    smash.setMediationState(AbstractSmash.MEDIATION_STATE.EXHAUSTED);
                    continue;
                }
                smash.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
            }
        }
    }
}

