/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.BaseApi;
import java.util.HashSet;
import java.util.TimerTask;

public abstract class AbstractSmash
implements BaseApi {
    MEDIATION_STATE mMediationState;
    AbstractAdapter mAdapter;
    ProviderSettings mAdapterConfigs;
    String mName;
    String mNameForReflection;
    String mInstanceName;
    boolean mIsMultipleInstances;
    String mSpId;
    int mSessionShowCounter;
    int mIterationShowCounter;
    TimerTask mInitTimerTask;
    TimerTask mLoadTimerTask;
    int mMaxAdsPerIteration;
    int mMaxAdsPerSession;
    IronSourceLoggerManager mLoggerManager;
    final String MAX_ADS_PER_SESSION_KEY = "maxAdsPerSession";
    final String MAX_ADS_PER_ITERATION_KEY = "maxAdsPerIteration";

    AbstractSmash(ProviderSettings adapterConfigs) {
        this.mNameForReflection = adapterConfigs.getProviderTypeForReflection();
        this.mInstanceName = adapterConfigs.getProviderInstanceName();
        this.mIsMultipleInstances = adapterConfigs.isMultipleInstances();
        this.mAdapterConfigs = adapterConfigs;
        this.mSpId = adapterConfigs.getSubProviderId();
        this.mIterationShowCounter = 0;
        this.mSessionShowCounter = 0;
        this.mMediationState = MEDIATION_STATE.NOT_INITIATED;
        this.mLoggerManager = IronSourceLoggerManager.getLogger();
        this.mName = this.mIsMultipleInstances ? this.mNameForReflection : adapterConfigs.getProviderName();
    }

    void setAdapterForSmash(AbstractAdapter adapter) {
        this.mAdapter = adapter;
    }

    boolean isExhausted() {
        return this.mIterationShowCounter >= this.mMaxAdsPerIteration;
    }

    boolean isCappedPerSession() {
        return this.mSessionShowCounter >= this.mMaxAdsPerSession;
    }

    boolean isMediationAvailable() {
        return !this.isExhausted() && !this.isCappedPerSession();
    }

    void preShow() {
        ++this.mIterationShowCounter;
        ++this.mSessionShowCounter;
        if (this.isCappedPerSession()) {
            this.setMediationState(MEDIATION_STATE.CAPPED_PER_SESSION);
        } else if (this.isExhausted()) {
            this.setMediationState(MEDIATION_STATE.EXHAUSTED);
        }
    }

    void stopInitTimer() {
        try {
            if (this.mInitTimerTask != null) {
                this.mInitTimerTask.cancel();
                this.mInitTimerTask = null;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    void stopLoadTimer() {
        try {
            if (this.mLoadTimerTask != null) {
                this.mLoadTimerTask.cancel();
                this.mLoadTimerTask = null;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    void setPluginData(String pluginType, String pluginFrameworkVersion) {
        if (this.mAdapter != null) {
            this.mAdapter.setPluginData(pluginType, pluginFrameworkVersion);
        }
    }

    abstract void completeIteration();

    abstract void startInitTimer();

    abstract void startLoadTimer();

    MEDIATION_STATE getMediationState() {
        return this.mMediationState;
    }

    String getNameForReflection() {
        return this.mNameForReflection;
    }

    String getInstanceName() {
        return this.mInstanceName;
    }

    public String getName() {
        return this.mName;
    }

    public String getSubProviderId() {
        return this.mSpId;
    }

    int getMaxAdsPerSession() {
        return this.mMaxAdsPerSession;
    }

    int getMaxAdsPerIteration() {
        return this.mMaxAdsPerIteration;
    }

    public AbstractAdapter getAdapter() {
        return this.mAdapter;
    }

    synchronized void setMediationState(MEDIATION_STATE state) {
        this.mMediationState = state;
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Smart Loading - " + this.getInstanceName() + " state changed to " + state.toString(), 0);
        if (this.mAdapter != null && state == MEDIATION_STATE.CAPPED_PER_SESSION) {
            this.mAdapter.setMediationState(state, this.getAdUnitString());
        }
    }

    @Override
    public void onResume(Activity activity) {
        if (this.mAdapter != null) {
            this.mAdapter.onResume(activity);
        }
    }

    @Override
    public void onPause(Activity activity) {
        if (this.mAdapter != null) {
            this.mAdapter.onPause(activity);
        }
    }

    @Override
    public void setAge(int age) {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getName() + ":setAge(age:" + age + ")", 1);
            this.mAdapter.setAge(age);
        }
    }

    @Override
    public void setGender(String gender) {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getName() + ":setGender(gender:" + gender + ")", 1);
            this.mAdapter.setGender(gender);
        }
    }

    @Override
    public void setMediationSegment(String segment) {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getName() + ":setMediationSegment(segment:" + segment + ")", 1);
            this.mAdapter.setMediationSegment(segment);
        }
    }

    public HashSet<String> getAllSettingsForProvider(String fieldName) {
        return IronSourceObject.getInstance().getAllSettingsForProvider(this.mNameForReflection, fieldName);
    }

    protected abstract String getAdUnitString();

    public static enum MEDIATION_STATE {
        NOT_INITIATED(0),
        INIT_FAILED(1),
        INITIATED(2),
        AVAILABLE(3),
        NOT_AVAILABLE(4),
        EXHAUSTED(5),
        CAPPED_PER_SESSION(6),
        INIT_PENDING(7),
        LOAD_PENDING(8);

        private int mValue;

        private MEDIATION_STATE(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }
}

