/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdUnitManager;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.BannerSmash;
import com.ironsource.mediationsdk.EBannerSize;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.MediationInitializer;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.BannerPlacement;
import com.ironsource.mediationsdk.sdk.BannerApi;
import com.ironsource.mediationsdk.sdk.BannerManagerListener;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.List;
import org.json.JSONObject;

public class BannerManager
extends AbstractAdUnitManager
implements BannerApi,
BannerManagerListener,
MediationInitializer.OnMediationInitializationListener {
    private final String TAG = this.getClass().getName();
    private static final long LOAD_FAILED_COOLDOWN_IN_MILLIS = 15000L;
    private boolean mDidCallLoad = false;
    private boolean mLoadInProgress = false;
    private HandlerThread mHandlerThread = new HandlerThread("IronSourceBannerHandler");
    private Handler mHandler;
    private LoadFailedRunnable mLoadFailedRunnable;
    private long mLastLoadFailTimestamp;
    private boolean mDidFinishToInitBanner;
    private IronSourceBannerLayout mPendingToLoadBannerLayout;
    private boolean isFirstLoad;
    private BannerPlacement mCurrentPlacement;

    public BannerManager() {
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.isFirstLoad = true;
    }

    public void initBanners(Activity activity, String appKey, String userId) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, this.TAG + ":initBanners(appKey: " + appKey + ", userId: " + userId + ")", 1);
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mActivity = activity;
        this.startNextAdapter();
    }

    private AbstractAdapter startNextAdapter() {
        AbstractAdapter initiatedAdapter = null;
        int activeAdapters = 0;
        for (int i2 = 0; i2 < this.mSmashArray.size() && initiatedAdapter == null; ++i2) {
            if (((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() == AbstractSmash.MEDIATION_STATE.AVAILABLE || ((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() == AbstractSmash.MEDIATION_STATE.INITIATED || ((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() == AbstractSmash.MEDIATION_STATE.INIT_PENDING || ((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() == AbstractSmash.MEDIATION_STATE.LOAD_PENDING) {
                if (++activeAdapters < this.mSmartLoadAmount) continue;
                break;
            }
            if (((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_INITIATED || (initiatedAdapter = this.startAdapter((BannerSmash)this.mSmashArray.get(i2))) != null) continue;
            ((AbstractSmash)this.mSmashArray.get(i2)).setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
        }
        return initiatedAdapter;
    }

    private AbstractAdapter startAdapter(BannerSmash smash) {
        AbstractAdapter providerAdapter;
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, this.TAG + ":startAdapter(" + smash.getName() + ")", 1);
        try {
            providerAdapter = this.getLoadedAdapterOrFetchByReflection(smash);
            if (providerAdapter == null) {
                return null;
            }
            IronSourceObject.getInstance().addToBannerAdaptersList(providerAdapter);
            providerAdapter.setLogListener(this.mLoggerManager);
            smash.setAdapterForSmash(providerAdapter);
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_PENDING);
            this.setCustomParams(smash);
            smash.initBanners(this.mActivity, this.mAppKey, this.mUserId);
        }
        catch (Throwable e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, this.TAG + ":startAdapter(" + smash.getName() + ")", e2);
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
            IronSourceError error = ErrorBuilder.buildInitFailedError(smash.getName() + " initialization failed - please verify that required dependencies are in you build path.", "Banner");
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, error.toString(), 2);
            return null;
        }
        return providerAdapter;
    }

    @Override
    public IronSourceBannerLayout createBanner(Activity activity, EBannerSize size) {
        return new IronSourceBannerLayout(activity, size, this);
    }

    @Override
    public void loadBanner(IronSourceBannerLayout banner, String placementName) {
        try {
            if (banner == null) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Load Banner can't be called on null object", 1);
                return;
            }
            if (banner.isDestroyed()) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Banner is already destroyed and can't be used anymore. Please create a new one using IronSource.createBanner API", 1);
                return;
            }
            if (this.mLoadInProgress) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Load Banner is already in progress", 1);
                return;
            }
            this.resetLoadRound(true);
            this.mDidCallLoad = true;
            this.mPendingToLoadBannerLayout = banner;
            this.mLoadInProgress = true;
            MediationInitializer.EInitStatus currentInitStatus = MediationInitializer.getInstance().getCurrentInitStatus();
            String loadFailMsg = "Load Banner can't be called before the Banner ad unit initialization completed successfully";
            if (currentInitStatus == MediationInitializer.EInitStatus.INIT_FAILED || currentInitStatus == MediationInitializer.EInitStatus.NOT_INIT) {
                this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildLoadFailedError(loadFailMsg), false);
                return;
            }
            if (currentInitStatus == MediationInitializer.EInitStatus.INIT_IN_PROGRESS) {
                this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildLoadFailedError(loadFailMsg), true);
                return;
            }
            if (!IronSourceUtils.isNetworkConnected((Context)this.mActivity)) {
                this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildNoInternetConnectionLoadFailError("Banner"), false);
                return;
            }
            this.isFirstLoad = false;
            this.mCurrentPlacement = IronSourceObject.getInstance().validateBannerPlacement(placementName);
            this.sendMediationLevelLoadEvent(banner, this.mCurrentPlacement.getPlacementName());
            CappingManager.ECappingStatus status = IronSourceObject.getInstance().getBannerCappingStatus(this.mCurrentPlacement.getPlacementName());
            String cappedMessage = IronSourceObject.getInstance().getCappingMessage(this.mCurrentPlacement.getPlacementName(), status);
            if (!TextUtils.isEmpty((CharSequence)cappedMessage)) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, cappedMessage, 1);
                this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildCappedPerPlacementError("Banner", cappedMessage), false);
                return;
            }
            banner.setPlacementName(this.mCurrentPlacement.getPlacementName());
            for (AbstractSmash smash : this.mSmashArray) {
                if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED) continue;
                smash.setMediationState(AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
                this.loadAdapterAndSendEvent((BannerSmash)smash, banner);
                return;
            }
            if (!this.mDidFinishToInitBanner) {
                return;
            }
            this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildGenericError("no ads to show"), false);
        }
        catch (Exception e2) {
            IronSourceError error = ErrorBuilder.buildLoadFailedError("loadBanner exception");
            this.sendOrScheduleLoadFailedCallback(error, false);
        }
    }

    private void sendMediationLevelLoadEvent(IronSourceBannerLayout banner, String placementName) {
        JSONObject data = IronSourceUtils.getMediationAdditionalData(false);
        try {
            int bannerSizeData = 0;
            if (banner != null) {
                bannerSizeData = banner.getSize().getValue();
            }
            data.put("bannerAdSize", bannerSizeData);
            data.put("placement", (Object)placementName);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        EventData event = new EventData(402, data);
        InterstitialEventsManager.getInstance().log(event);
    }

    private synchronized void sendOrScheduleLoadFailedCallback(IronSourceError error, boolean shouldWait) {
        long timeFromPreviousLoadFailed;
        this.removeScheduledLoadFailedCallback();
        this.mLoadFailedRunnable = new LoadFailedRunnable(error);
        long currentTimestamp = System.currentTimeMillis();
        long l2 = timeFromPreviousLoadFailed = shouldWait ? 0L : currentTimestamp - this.mLastLoadFailTimestamp;
        if (timeFromPreviousLoadFailed >= 15000L) {
            if (this.mHandler != null) {
                this.mHandler.post((Runnable)this.mLoadFailedRunnable);
            }
        } else {
            long timeToNextLoadFailed = 15000L - timeFromPreviousLoadFailed;
            if (this.mHandler != null) {
                this.mHandler.postDelayed((Runnable)this.mLoadFailedRunnable, timeToNextLoadFailed);
            }
        }
    }

    @Override
    public void onInitSuccess(List<IronSource.AD_UNIT> adUnits, boolean revived) {
    }

    @Override
    public void onInitFailed(String reason) {
        if (this.mDidCallLoad) {
            this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildGenericError("no ads to show"), false);
        }
    }

    private synchronized void removeScheduledLoadFailedCallback() {
        if (this.mHandler != null && this.mLoadFailedRunnable != null) {
            this.mHandler.removeCallbacks((Runnable)this.mLoadFailedRunnable);
        }
    }

    private synchronized void resetLoadRound(boolean changeStateToInitiated) {
        if (changeStateToInitiated) {
            this.changeStateToInitiated();
        }
        this.mLoadInProgress = false;
        this.mDidCallLoad = false;
        this.mPendingToLoadBannerLayout = null;
        if (this.mLoadFailedRunnable != null) {
            this.mHandler.removeCallbacks((Runnable)this.mLoadFailedRunnable);
        }
    }

    private synchronized void changeStateToInitiated() {
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.LOAD_PENDING && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
        }
    }

    @Override
    public void destroyBanner(IronSourceBannerLayout banner) {
        if (banner != null) {
            if (banner.isDestroyed()) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Banner is already destroyed and can't be used anymore. Please create a new one using IronSource.createBanner API", 1);
                return;
            }
            JSONObject data = IronSourceUtils.getMediationAdditionalData(false);
            EventData event = new EventData(406, data);
            InterstitialEventsManager.getInstance().log(event);
            this.mLoadInProgress = false;
            this.mDidCallLoad = false;
            banner.destroyBanner();
        }
    }

    @Override
    void shouldTrackNetworkState(Context context, boolean track) {
    }

    private synchronized void loadAdapterAndSendEvent(BannerSmash smash, IronSourceBannerLayout bannerLayout) {
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash, false);
        try {
            if (bannerLayout != null && !TextUtils.isEmpty((CharSequence)bannerLayout.getPlacementName())) {
                data.put("placement", (Object)bannerLayout.getPlacementName());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        EventData event = new EventData(402, data);
        InterstitialEventsManager.getInstance().log(event);
        smash.loadBanner(bannerLayout);
    }

    @Override
    public synchronized void onBannerInitSuccess(BannerSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + " :onBannerInitSuccess()", 1);
        this.mDidFinishToInitBanner = true;
        if (!this.mDidCallLoad) {
            return;
        }
        for (AbstractSmash asmash : this.mSmashArray) {
            if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.LOAD_PENDING && asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            return;
        }
        if (this.mPendingToLoadBannerLayout != null) {
            if (this.isFirstLoad) {
                this.isFirstLoad = false;
                BannerPlacement placement = IronSourceObject.getInstance().validateBannerPlacement(this.mPendingToLoadBannerLayout.getPlacementName());
                this.mPendingToLoadBannerLayout.setPlacementName(placement.getPlacementName());
                this.sendMediationLevelLoadEvent(this.mPendingToLoadBannerLayout, this.mPendingToLoadBannerLayout.getPlacementName());
                CappingManager.ECappingStatus status = IronSourceObject.getInstance().getBannerCappingStatus(this.mPendingToLoadBannerLayout.getPlacementName());
                String cappedMessage = IronSourceObject.getInstance().getCappingMessage(this.mPendingToLoadBannerLayout.getPlacementName(), status);
                if (!TextUtils.isEmpty((CharSequence)cappedMessage)) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, cappedMessage, 1);
                    this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildCappedPerPlacementError("Banner", cappedMessage), false);
                    return;
                }
            }
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
            this.loadAdapterAndSendEvent(smash, this.mPendingToLoadBannerLayout);
        }
    }

    @Override
    public synchronized void onBannerInitFailed(IronSourceError error, BannerSmash smash) {
        try {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onBannerInitFailed(" + error + ")", 1);
            int initFailed = 0;
            for (AbstractSmash asmash : this.mSmashArray) {
                if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.INIT_FAILED || ++initFailed < this.mSmashArray.size()) continue;
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, "Smart Loading - initialization failed - no adapters are initiated and no more left to init, error: " + error.getErrorMessage(), 2);
                if (this.mDidCallLoad) {
                    this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildGenericError("no ads to show"), false);
                }
                this.mDidFinishToInitBanner = true;
                return;
            }
            this.startNextAdapter();
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onBannerInitFailed(error:" + error + ", " + "provider:" + smash.getName() + ")", e2);
        }
    }

    @Override
    public void onBannerImpression(IronSourceBannerLayout banner, BannerSmash smash) {
        if (smash == null || smash.getAdapter() == null || banner == null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, this.TAG + ":onBannerImpression error: adapter or banner is null", 2);
            return;
        }
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash, false);
        try {
            int bannerSizeData = banner.getSize().getValue();
            data.put("bannerAdSize", bannerSizeData);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        EventData event = new EventData(405, data);
        InterstitialEventsManager.getInstance().log(event);
        this.changeStateToInitiated();
    }

    @Override
    public void onBannerAdLoaded(BannerSmash smash) {
        if (this.mDidCallLoad) {
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.AVAILABLE);
        }
        this.removeScheduledLoadFailedCallback();
        this.mLoadInProgress = false;
    }

    @Override
    public void onBannerAdLoadFailed(IronSourceError error, BannerSmash smash) {
        smash.setMediationState(AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
        for (AbstractSmash asmash : this.mSmashArray) {
            if (asmash.getMediationState() == AbstractSmash.MEDIATION_STATE.AVAILABLE || asmash.getMediationState() == AbstractSmash.MEDIATION_STATE.LOAD_PENDING) {
                return;
            }
            if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED || this.mPendingToLoadBannerLayout == null) continue;
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
            this.loadAdapterAndSendEvent((BannerSmash)asmash, this.mPendingToLoadBannerLayout);
            return;
        }
        AbstractAdapter initiatedAdapter = this.startNextAdapter();
        if (this.mDidCallLoad && initiatedAdapter == null) {
            JSONObject data = IronSourceUtils.getMediationAdditionalData(false);
            try {
                data.put("status", (Object)"false");
                data.put("errorCode", error.getErrorCode());
                if (this.mPendingToLoadBannerLayout != null && this.mPendingToLoadBannerLayout.getSize() != null) {
                    int bannerSizeData = this.mPendingToLoadBannerLayout.getSize().getValue();
                    data.put("bannerAdSize", bannerSizeData);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            EventData event = new EventData(407, data);
            InterstitialEventsManager.getInstance().log(event);
            this.sendOrScheduleLoadFailedCallback(error, false);
        }
    }

    private class LoadFailedRunnable
    implements Runnable {
        IronSourceError error;

        LoadFailedRunnable(IronSourceError error) {
            this.error = error;
        }

        @Override
        public void run() {
            BannerManager.this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Load Banner failed: " + this.error.getErrorMessage(), 1);
            BannerManager.this.mLastLoadFailTimestamp = System.currentTimeMillis();
            if (BannerManager.this.mPendingToLoadBannerLayout != null && BannerManager.this.mPendingToLoadBannerLayout.getBannerListener() != null) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, "onBannerAdLoadFailed(), error: " + this.error.getErrorMessage(), 1);
                JSONObject data = IronSourceUtils.getMediationAdditionalData(false);
                try {
                    int bannerSizeData = BannerManager.this.mPendingToLoadBannerLayout.getSize().getValue();
                    data.put("status", (Object)"false");
                    data.put("errorCode", this.error.getErrorCode());
                    data.put("bannerAdSize", bannerSizeData);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                EventData event = new EventData(407, data);
                InterstitialEventsManager.getInstance().log(event);
                BannerManager.this.mPendingToLoadBannerLayout.getBannerListener().onBannerAdLoadFailed(this.error);
            }
            BannerManager.this.resetLoadRound(true);
        }
    }
}

