/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.BannerSmash;
import com.ironsource.mediationsdk.EBannerSize;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BannerLayoutListener;
import com.ironsource.mediationsdk.sdk.BannerListener;
import com.ironsource.mediationsdk.sdk.BannerManagerListener;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import org.json.JSONObject;

public class IronSourceBannerLayout
extends FrameLayout
implements BannerLayoutListener {
    private BannerSmash mSmash;
    private View mBannerView;
    private Activity mActivity;
    private EBannerSize mSize;
    private String mPlacementName;
    private boolean isImpressionReported = false;
    private boolean isAdLoaded = false;
    private boolean isDestroyed = false;
    private BannerManagerListener mBannerManager;
    private BannerListener mBannerListener;

    public IronSourceBannerLayout(Activity activity, EBannerSize size, BannerManagerListener bannerManager) {
        super((Context)activity);
        this.mBannerManager = bannerManager;
        this.mActivity = activity;
        if (size == null) {
            size = EBannerSize.BANNER;
        }
        this.mSize = size;
    }

    @Override
    public void attachSmashToBanner(BannerSmash smash, View bannerView) {
        this.mSmash = smash;
        this.mBannerView = bannerView;
        this.resetBannerImpression();
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (IronSourceBannerLayout.this.isShown()) {
                    if (Build.VERSION.SDK_INT < 16) {
                        IronSourceBannerLayout.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        IronSourceBannerLayout.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    if (IronSourceBannerLayout.this.isAdLoaded) {
                        IronSourceBannerLayout.this.reportBannerImpression();
                    }
                }
            }
        });
    }

    protected void destroyBanner() {
        this.isDestroyed = true;
        if (this.mSmash != null) {
            this.mSmash.destroyBanner(this);
        }
        this.resetBannerImpression();
        this.mBannerManager = null;
        this.mBannerListener = null;
        this.mActivity = null;
        this.mSize = null;
        this.mPlacementName = null;
        this.mBannerView = null;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public View getBannerView() {
        return this.mBannerView;
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public EBannerSize getSize() {
        return this.mSize;
    }

    public String getPlacementName() {
        return this.mPlacementName;
    }

    public void setPlacementName(String placementName) {
        this.mPlacementName = placementName;
    }

    public void setBannerListener(BannerListener listener) {
        String logMessage = "setBannerListener()";
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
        this.mBannerListener = listener;
    }

    public void removeBannerListener() {
        String logMessage = "removeBannerListener()";
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
        this.mBannerListener = null;
    }

    public BannerListener getBannerListener() {
        return this.mBannerListener;
    }

    @Override
    public void onBannerAdLoaded(BannerSmash smash) {
        if (this.shoudIgnoreThisCallback(smash) || this.isAdLoaded) {
            return;
        }
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onBannerAdLoaded() | internal | adapter: " + smash.getName(), 0);
        JSONObject providerData = IronSourceUtils.getProviderAdditionalData(smash);
        JSONObject mediationData = IronSourceUtils.getMediationAdditionalData();
        try {
            int bannerSizeData = this.getSize().getValue();
            providerData.put("status", (Object)"true");
            mediationData.put("status", (Object)"true");
            providerData.put("bannerAdSize", bannerSizeData);
            mediationData.put("bannerAdSize", bannerSizeData);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        EventData providerEvent = new EventData(407, providerData);
        EventData mediationEvent = new EventData(407, mediationData);
        InterstitialEventsManager.getInstance().log(providerEvent);
        InterstitialEventsManager.getInstance().log(mediationEvent);
        this.isAdLoaded = true;
        if (this.isShown()) {
            this.reportBannerImpression();
        }
        if (this.mBannerManager != null) {
            this.mBannerManager.onBannerAdLoaded(smash);
        }
        if (this.mBannerListener != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, "onBannerAdLoaded()", 1);
            this.mBannerListener.onBannerAdLoaded();
        }
    }

    @Override
    public void onBannerAdLoadFailed(IronSourceError error, BannerSmash smash) {
        if (this.shoudIgnoreThisCallback(smash)) {
            return;
        }
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onBannerAdLoadFailed() | internal | adapter: " + smash.getName(), 0);
        this.mSmash = null;
        try {
            if (this.mBannerView != null) {
                this.removeView(this.mBannerView);
                this.mBannerView = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            int bannerSizeData = this.getSize().getValue();
            data.put("status", (Object)"false");
            data.put("errorCode", error.getErrorCode());
            data.put("bannerAdSize", bannerSizeData);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        EventData event = new EventData(407, data);
        InterstitialEventsManager.getInstance().log(event);
        if (this.mBannerManager != null) {
            this.mBannerManager.onBannerAdLoadFailed(error, smash);
        }
    }

    @Override
    public void onBannerAdClicked(BannerSmash smash) {
        if (this.shoudIgnoreThisCallback(smash)) {
            return;
        }
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onBannerAdClicked() | internal | adapter: " + smash.getName(), 0);
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            int bannerSizeData = this.getSize().getValue();
            data.put("bannerAdSize", bannerSizeData);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        EventData event = new EventData(408, data);
        InterstitialEventsManager.getInstance().log(event);
        if (this.mBannerListener != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, "onBannerAdClicked()", 1);
            this.mBannerListener.onBannerAdClicked();
        }
    }

    @Override
    public void onBannerAdScreenPresented(BannerSmash smash) {
        if (this.shoudIgnoreThisCallback(smash)) {
            return;
        }
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onBannerAdScreenPresented() | internal | adapter: " + smash.getName(), 0);
        if (this.mBannerListener != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, "onBannerAdScreenPresented()", 1);
            this.mBannerListener.onBannerAdScreenPresented();
        }
    }

    @Override
    public void onBannerAdScreenDismissed(BannerSmash smash) {
        if (this.shoudIgnoreThisCallback(smash)) {
            return;
        }
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onBannerAdScreenDismissed() | internal | adapter: " + smash.getName(), 0);
        if (this.mBannerListener != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, "onBannerAdScreenDismissed()", 1);
            this.mBannerListener.onBannerAdScreenDismissed();
        }
    }

    @Override
    public void onBannerAdLeftApplication(BannerSmash smash) {
        if (this.shoudIgnoreThisCallback(smash)) {
            return;
        }
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onBannerAdLeftApplication() | internal | adapter: " + smash.getName(), 0);
        if (this.mBannerListener != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, "onBannerAdLeftApplication()", 1);
            this.mBannerListener.onBannerAdLeftApplication();
        }
    }

    private boolean shoudIgnoreThisCallback(BannerSmash smash) {
        return this.mSmash == null || smash == null || !this.mSmash.getName().equals(smash.getName());
    }

    private synchronized void resetBannerImpression() {
        this.isImpressionReported = false;
        this.isAdLoaded = false;
    }

    private synchronized void reportBannerImpression() {
        if (!this.isImpressionReported) {
            this.isImpressionReported = true;
            CappingManager.incrementShowCounter((Context)this.mActivity, this.mPlacementName);
            if (this.mBannerManager != null && this.mSmash != null) {
                this.mBannerManager.onBannerImpression(this, this.mSmash);
            }
        }
    }
}

