/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdUnitManager;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.InterstitialSmash;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.MediationInitializer;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.model.InterstitialPlacement;
import com.ironsource.mediationsdk.sdk.InterstitialApi;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import com.ironsource.mediationsdk.sdk.InterstitialManagerListener;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialApi;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialListener;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialManagerListener;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

class InterstitialManager
extends AbstractAdUnitManager
implements InterstitialApi,
InterstitialManagerListener,
MediationInitializer.OnMediationInitializationListener,
RewardedInterstitialManagerListener,
RewardedInterstitialApi {
    private final String TAG = this.getClass().getName();
    private static final long LOAD_FAILED_COOLDOWN_IN_MILLIS = 15000L;
    private InterstitialListener mInterstitialListenersWrapper;
    private RewardedInterstitialListener mRewardedInterstitialListenerWrapper;
    private boolean mDidCallLoad = false;
    private boolean mLoadInProgress = false;
    private HandlerThread mHandlerThread = new HandlerThread("IronSourceInterstitialHandler");
    private Handler mHandler;
    LoadFailedRunnable mLoadFailedRunnable;
    private long mLastLoadFailTimestamp;
    private boolean mDidFinishToInitInterstitial;
    private InterstitialPlacement mCurrentPlacement;

    InterstitialManager() {
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mLastLoadFailTimestamp = 0L;
    }

    @Override
    public void setInterstitialListener(InterstitialListener listener) {
        this.mInterstitialListenersWrapper = listener;
    }

    @Override
    public void setRewardedInterstitialListener(RewardedInterstitialListener listener) {
        this.mRewardedInterstitialListenerWrapper = listener;
    }

    @Override
    public synchronized void initInterstitial(Activity activity, String appKey, String userId) {
        AbstractAdapter lastLoadedAdapter;
        this.removeScheduledLoadFailedCallback();
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, this.TAG + ":initInterstitial(appKey: " + appKey + ", userId: " + userId + ")", 1);
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mActivity = activity;
        for (int i2 = 0; i2 < this.mSmartLoadAmount && (lastLoadedAdapter = this.startNextAdapter()) != null; ++i2) {
        }
    }

    @Override
    public synchronized void loadInterstitial() {
        try {
            if (this.mLoadInProgress) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Load Interstitial is already in progress", 1);
                return;
            }
            this.resetLoadRound(true);
            this.mDidCallLoad = true;
            this.mLoadInProgress = true;
            EventData event = new EventData(22, IronSourceUtils.getMediationAdditionalData());
            InterstitialEventsManager.getInstance().log(event);
            MediationInitializer.EInitStatus currentInitStatus = MediationInitializer.getInstance().getCurrentInitStatus();
            String loadFailMsg = "Load Interstitial can't be called before the Interstitial ad unit initialization completed successfully";
            if (currentInitStatus == MediationInitializer.EInitStatus.INIT_FAILED || currentInitStatus == MediationInitializer.EInitStatus.NOT_INIT) {
                this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildLoadFailedError(loadFailMsg), false);
                return;
            }
            if (currentInitStatus == MediationInitializer.EInitStatus.INIT_IN_PROGRESS) {
                this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildLoadFailedError(loadFailMsg), true);
                return;
            }
            if (!IronSourceUtils.isNetworkConnected((Context)this.mActivity)) {
                this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildNoInternetConnectionLoadFailError("Interstitial"), false);
                return;
            }
            boolean hasInitiated = false;
            int cappedOrNotInitiated = 0;
            for (AbstractSmash smash : this.mSmashArray) {
                if (smash.getMediationState() == AbstractSmash.MEDIATION_STATE.INITIATED) {
                    hasInitiated = true;
                    continue;
                }
                if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_INITIATED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION) continue;
                ++cappedOrNotInitiated;
            }
            if (!hasInitiated) {
                if (!this.mDidFinishToInitInterstitial) {
                    return;
                }
                if (cappedOrNotInitiated == this.mSmashArray.size()) {
                    this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildCappedPerSessionError("Interstitial"), false);
                    return;
                }
                this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildGenericError("no ads to show"), false);
                return;
            }
            int loading = 0;
            for (AbstractSmash smash : this.mSmashArray) {
                if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED) continue;
                smash.setMediationState(AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
                this.loadAdapterAndSendEvent((InterstitialSmash)smash);
                if (++loading < this.mSmartLoadAmount) continue;
                return;
            }
        }
        catch (Exception e2) {
            IronSourceError error = ErrorBuilder.buildLoadFailedError("loadInterstitial exception");
            this.sendOrScheduleLoadFailedCallback(error, false);
        }
    }

    private void sendShowChanceEvent(AbstractSmash smash, int priority, String placementName, boolean status) {
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            data.put("placement", (Object)placementName);
            data.put("status", (Object)(status ? "true" : "false"));
            data.put("providerPriority", priority);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        EventData event = new EventData(219, data);
        InterstitialEventsManager.getInstance().log(event);
    }

    private void sendShowChanceEvents(AbstractSmash selectedSmash, int priority, String placementName) {
        this.sendShowChanceEvent(selectedSmash, priority, placementName, true);
        for (int i2 = 0; i2 < this.mSmashArray.size() && i2 < priority; ++i2) {
            AbstractSmash smash = (AbstractSmash)this.mSmashArray.get(i2);
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
            this.sendShowChanceEvent(smash, i2, placementName, false);
        }
    }

    @Override
    public void showInterstitial(String placementName) {
        if (this.mShouldTrackNetworkState && this.mActivity != null && !IronSourceUtils.isNetworkConnected((Context)this.mActivity)) {
            this.mInterstitialListenersWrapper.onInterstitialAdShowFailed(ErrorBuilder.buildNoInternetConnectionShowFailError("Interstitial"));
            return;
        }
        if (!this.mDidCallLoad) {
            this.mInterstitialListenersWrapper.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError("Interstitial", "showInterstitial failed - You need to load interstitial before showing it"));
            return;
        }
        for (int i2 = 0; i2 < this.mSmashArray.size(); ++i2) {
            AbstractSmash smash = (AbstractSmash)this.mSmashArray.get(i2);
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            CappingManager.incrementShowCounter((Context)this.mActivity, this.mCurrentPlacement);
            JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
            try {
                data.put("placement", (Object)placementName);
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
            EventData event = new EventData(23, data);
            InterstitialEventsManager.getInstance().log(event);
            this.sendShowChanceEvents(smash, i2, placementName);
            ((InterstitialSmash)smash).showInterstitial();
            this.resetLoadRound(false);
            if (!smash.isMediationAvailable()) {
                this.startNextAdapter();
            }
            return;
        }
        this.mInterstitialListenersWrapper.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError("Interstitial", "showInterstitial failed - No adapters ready to show"));
    }

    @Override
    public boolean isInterstitialReady() {
        if (this.mShouldTrackNetworkState && this.mActivity != null && !IronSourceUtils.isNetworkConnected((Context)this.mActivity)) {
            return false;
        }
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE || !((InterstitialSmash)smash).isInterstitialReady()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void onInterstitialInitSuccess(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + " :onInterstitialInitSuccess()", 1);
        this.mDidFinishToInitInterstitial = true;
        if (!this.mDidCallLoad) {
            return;
        }
        int readyOrLoading = 0;
        for (AbstractSmash asmash : this.mSmashArray) {
            if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE && asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.LOAD_PENDING || ++readyOrLoading < this.mSmartLoadAmount) continue;
            return;
        }
        smash.setMediationState(AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
        this.loadAdapterAndSendEvent(smash);
    }

    @Override
    public synchronized void onInterstitialInitFailed(IronSourceError error, InterstitialSmash smash) {
        try {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialInitFailed(" + error + ")", 1);
            int initFailed = 0;
            for (AbstractSmash asmash : this.mSmashArray) {
                if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.INIT_FAILED || ++initFailed < this.mSmashArray.size()) continue;
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, "Smart Loading - initialization failed - no adapters are initiated and no more left to init, error: " + error.getErrorMessage(), 2);
                if (this.mDidCallLoad) {
                    this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildGenericError("no ads to show"), false);
                }
                this.mDidFinishToInitInterstitial = true;
                return;
            }
            this.startNextAdapter();
            this.completeIterationRound();
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onInterstitialInitFailed(error:" + error + ", " + "provider:" + smash.getName() + ")", e2);
        }
    }

    @Override
    public synchronized void onInterstitialAdReady(InterstitialSmash smash) {
        boolean shouldReportReady = true;
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdReady()", 1);
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            data.put("status", (Object)"true");
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        EventData event = new EventData(27, data);
        InterstitialEventsManager.getInstance().log(event);
        if (this.mDidCallLoad) {
            for (AbstractSmash asmash : this.mSmashArray) {
                if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
                shouldReportReady = false;
                break;
            }
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.AVAILABLE);
        }
        this.removeScheduledLoadFailedCallback();
        this.mLoadInProgress = false;
        if (shouldReportReady) {
            this.mInterstitialListenersWrapper.onInterstitialAdReady();
        }
    }

    @Override
    public synchronized void onInterstitialAdLoadFailed(IronSourceError error, InterstitialSmash smash) {
        boolean shouldReportFailed = false;
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdLoadFailed(" + error + ")", 1);
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            data.put("status", (Object)"false");
            data.put("errorCode", error.getErrorCode());
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        EventData event = new EventData(27, data);
        InterstitialEventsManager.getInstance().log(event);
        smash.setMediationState(AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
        int availableOrLoadPending = 0;
        for (AbstractSmash asmash : this.mSmashArray) {
            if (asmash.getMediationState() == AbstractSmash.MEDIATION_STATE.AVAILABLE || asmash.getMediationState() == AbstractSmash.MEDIATION_STATE.LOAD_PENDING) {
                if (++availableOrLoadPending < this.mSmartLoadAmount) continue;
                return;
            }
            if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED) continue;
            asmash.setMediationState(AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
            this.loadAdapterAndSendEvent((InterstitialSmash)asmash);
            return;
        }
        AbstractAdapter initiatedAdapter = this.startNextAdapter();
        if (initiatedAdapter == null && this.mDidCallLoad && availableOrLoadPending == 0) {
            shouldReportFailed = true;
            this.completeIterationRound();
        }
        if (shouldReportFailed) {
            this.sendOrScheduleLoadFailedCallback(error, false);
        }
    }

    @Override
    public void onInterstitialAdOpened(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdOpened()", 1);
        EventData event = new EventData(25, IronSourceUtils.getProviderAdditionalData(smash));
        InterstitialEventsManager.getInstance().log(event);
        this.mInterstitialListenersWrapper.onInterstitialAdOpened();
    }

    @Override
    public void onInterstitialAdClosed(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdClosed()", 1);
        EventData event = new EventData(26, IronSourceUtils.getProviderAdditionalData(smash));
        InterstitialEventsManager.getInstance().log(event);
        this.mInterstitialListenersWrapper.onInterstitialAdClosed();
    }

    @Override
    public void onInterstitialAdShowSucceeded(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdShowSucceeded()", 1);
        boolean hasAvailable = false;
        for (AbstractSmash asmash : this.mSmashArray) {
            if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            hasAvailable = true;
            this.completeAdapterShow(asmash);
        }
        if (!(hasAvailable || smash.getMediationState() != AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.EXHAUSTED)) {
            this.completeIterationRound();
        }
        this.changeStateToInitiated();
        this.mInterstitialListenersWrapper.onInterstitialAdShowSucceeded();
    }

    @Override
    public void onInterstitialAdShowFailed(IronSourceError error, InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdShowFailed(" + error + ")", 1);
        this.completeAdapterShow(smash);
        for (AbstractSmash asmash : this.mSmashArray) {
            if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            this.mDidCallLoad = true;
            this.showInterstitial(this.mCurrentPlacement.getPlacementName());
            return;
        }
        this.mInterstitialListenersWrapper.onInterstitialAdShowFailed(error);
    }

    @Override
    public void onInterstitialAdClicked(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdClicked()", 1);
        EventData event = new EventData(28, IronSourceUtils.getProviderAdditionalData(smash));
        InterstitialEventsManager.getInstance().log(event);
        this.mInterstitialListenersWrapper.onInterstitialAdClicked();
    }

    @Override
    public void onInterstitialAdVisible(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdVisible()", 1);
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            data.put("placement", (Object)this.mCurrentPlacement.getPlacementName());
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        EventData event = new EventData(31, data);
        InterstitialEventsManager.getInstance().log(event);
    }

    @Override
    public void onInterstitialAdRewarded(InterstitialSmash smash) {
        EventData event = new EventData(290, IronSourceUtils.getProviderAdditionalData(smash));
        InterstitialEventsManager.getInstance().log(event);
        if (this.mRewardedInterstitialListenerWrapper != null) {
            this.mRewardedInterstitialListenerWrapper.onInterstitialAdRewarded();
        }
    }

    @Override
    void shouldTrackNetworkState(Context context, boolean track) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, this.TAG + " Should Track Network State: " + track, 0);
        this.mShouldTrackNetworkState = track;
    }

    @Override
    public void onInitSuccess(List<IronSource.AD_UNIT> adUnits, boolean revived) {
    }

    @Override
    public void onInitFailed(String reason) {
        if (this.mDidCallLoad) {
            this.sendOrScheduleLoadFailedCallback(ErrorBuilder.buildGenericError("no ads to show"), false);
        }
    }

    private boolean isIterationRoundComplete() {
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_INITIATED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INIT_PENDING && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.LOAD_PENDING && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            return false;
        }
        return true;
    }

    private void completeIterationRound() {
        if (this.isIterationRoundComplete()) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Reset Iteration", 0);
            for (AbstractSmash smash : this.mSmashArray) {
                if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.EXHAUSTED) continue;
                smash.completeIteration();
            }
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "End of Reset Iteration", 0);
        }
    }

    private void completeAdapterShow(AbstractSmash smash) {
        if (!smash.isMediationAvailable()) {
            this.startNextAdapter();
            this.completeIterationRound();
        } else {
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
        }
    }

    private AbstractAdapter startNextAdapter() {
        AbstractAdapter initiatedAdapter = null;
        int activeAdapters = 0;
        for (int i2 = 0; i2 < this.mSmashArray.size() && initiatedAdapter == null; ++i2) {
            if (((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() == AbstractSmash.MEDIATION_STATE.AVAILABLE || ((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() == AbstractSmash.MEDIATION_STATE.INITIATED || ((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() == AbstractSmash.MEDIATION_STATE.INIT_PENDING || ((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() == AbstractSmash.MEDIATION_STATE.LOAD_PENDING) {
                if (++activeAdapters < this.mSmartLoadAmount) continue;
                break;
            }
            if (((AbstractSmash)this.mSmashArray.get(i2)).getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_INITIATED || (initiatedAdapter = this.startAdapter((InterstitialSmash)this.mSmashArray.get(i2))) != null) continue;
            ((AbstractSmash)this.mSmashArray.get(i2)).setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
        }
        return initiatedAdapter;
    }

    private synchronized AbstractAdapter startAdapter(InterstitialSmash smash) {
        AbstractAdapter providerAdapter;
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, this.TAG + ":startAdapter(" + smash.getName() + ")", 1);
        try {
            providerAdapter = this.getLoadedAdapterOrFetchByReflection(smash);
            if (providerAdapter == null) {
                return null;
            }
            IronSourceObject.getInstance().addToISAdaptersList(providerAdapter);
            providerAdapter.setLogListener(this.mLoggerManager);
            smash.setAdapterForSmash(providerAdapter);
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_PENDING);
            if (this.mRewardedInterstitialListenerWrapper != null) {
                smash.setRewardedInterstitialManagerListener(this);
            }
            this.setCustomParams(smash);
            smash.initInterstitial(this.mActivity, this.mAppKey, this.mUserId);
        }
        catch (Throwable e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, this.TAG + ":startAdapter(" + smash.getName() + ")", e2);
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
            IronSourceError error = ErrorBuilder.buildInitFailedError(smash.getName() + " initialization failed - please verify that required dependencies are in you build path.", "Interstitial");
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, error.toString(), 2);
            return null;
        }
        return providerAdapter;
    }

    void setCurrentPlacement(InterstitialPlacement currentPlacement) {
        this.mCurrentPlacement = currentPlacement;
    }

    private synchronized void loadAdapterAndSendEvent(InterstitialSmash smash) {
        EventData event = new EventData(22, IronSourceUtils.getProviderAdditionalData(smash));
        InterstitialEventsManager.getInstance().log(event);
        smash.loadInterstitial();
    }

    private synchronized void resetLoadRound(boolean changeStateToInitiated) {
        if (changeStateToInitiated) {
            this.changeStateToInitiated();
        }
        this.mLoadInProgress = false;
        this.mDidCallLoad = false;
        if (this.mLoadFailedRunnable != null) {
            this.mHandler.removeCallbacks((Runnable)this.mLoadFailedRunnable);
        }
    }

    private synchronized void changeStateToInitiated() {
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.LOAD_PENDING && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
        }
    }

    private synchronized void sendOrScheduleLoadFailedCallback(IronSourceError error, boolean shouldWait) {
        long timeFromPreviousLoadFailed;
        this.removeScheduledLoadFailedCallback();
        this.mLoadFailedRunnable = new LoadFailedRunnable(error);
        long currentTimestamp = System.currentTimeMillis();
        long l2 = timeFromPreviousLoadFailed = shouldWait ? 0L : currentTimestamp - this.mLastLoadFailTimestamp;
        if (timeFromPreviousLoadFailed >= 15000L) {
            if (this.mHandler != null) {
                this.mHandler.post((Runnable)this.mLoadFailedRunnable);
            }
        } else {
            long timeToNextLoadFailed = 15000L - timeFromPreviousLoadFailed;
            if (this.mHandler != null) {
                this.mHandler.postDelayed((Runnable)this.mLoadFailedRunnable, timeToNextLoadFailed);
            }
        }
    }

    private synchronized void removeScheduledLoadFailedCallback() {
        if (this.mHandler != null && this.mLoadFailedRunnable != null) {
            this.mHandler.removeCallbacks((Runnable)this.mLoadFailedRunnable);
        }
    }

    private class LoadFailedRunnable
    implements Runnable {
        IronSourceError error;

        LoadFailedRunnable(IronSourceError error) {
            this.error = error;
        }

        @Override
        public void run() {
            InterstitialManager.this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Load Interstitial failed: " + this.error.getErrorMessage(), 1);
            InterstitialManager.this.mLastLoadFailTimestamp = System.currentTimeMillis();
            InterstitialManager.this.mInterstitialListenersWrapper.onInterstitialAdLoadFailed(this.error);
            InterstitialManager.this.resetLoadRound(true);
        }
    }
}

