/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.integration;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class IntegrationHelper {
    private static final String TAG = "IntegrationHelper";
    private static final String SDK_COMPATIBILITY_VERSION = "4.1";
    private static final String BANNER_COMPATIBILITY_VERSION = "4.2";

    public static void validateIntegration(Activity activity) {
        String[] adapters;
        Log.i((String)TAG, (String)"Verifying Integration:");
        IntegrationHelper.validatePermissions(activity);
        for (String adapter : adapters = new String[]{"SupersonicAds", "AdColony", "AppLovin", "Chartboost", "HyprMX", "UnityAds", "Vungle", "InMobi", "Facebook", "Fyber", "MediaBrix", "Tapjoy", "AdMob", "MoPub", "Maio"}) {
            if (IntegrationHelper.isAdapterValid(activity, adapter)) {
                if (adapter.equalsIgnoreCase("SupersonicAds")) {
                    Log.i((String)TAG, (String)">>>> IronSource - VERIFIED");
                    continue;
                }
                Log.i((String)TAG, (String)(">>>> " + adapter + " - VERIFIED"));
                continue;
            }
            if (adapter.equalsIgnoreCase("SupersonicAds")) {
                Log.e((String)TAG, (String)">>>> IronSource - NOT VERIFIED");
                continue;
            }
            Log.e((String)TAG, (String)(">>>> " + adapter + " - NOT VERIFIED"));
        }
        IntegrationHelper.validateGooglePlayServices(activity);
    }

    private static boolean isAdapterValid(Activity activity, String adapterName) {
        try {
            if (adapterName.equalsIgnoreCase("SupersonicAds")) {
                Log.i((String)TAG, (String)"--------------- IronSource  --------------");
            } else {
                Log.i((String)TAG, (String)("--------------- " + adapterName + " --------------"));
            }
            String className = "com.ironsource.adapters." + adapterName.toLowerCase() + "." + adapterName + "Adapter";
            IntegrationData data = IntegrationHelper.getIntegrationData(activity, className);
            if (data == null) {
                return false;
            }
            if (!adapterName.equalsIgnoreCase("SupersonicAds") && !IntegrationHelper.isAdapterVersionValid(data)) {
                return false;
            }
            IntegrationHelper.verifyBannerAdapterVersion(data);
            boolean ret = true;
            if (!IntegrationHelper.isAdapterSdkValid(data.sdkName)) {
                ret = false;
            }
            if (!IntegrationHelper.isActivitiesValid(activity, data.activities)) {
                ret = false;
            }
            if (!IntegrationHelper.isExternalLibsValid(data.externalLibs)) {
                ret = false;
            }
            if (!IntegrationHelper.isBroadcastReceiversValid(activity, data.broadcastReceivers)) {
                ret = false;
            }
            if (!IntegrationHelper.isServicesValid(activity, data.services)) {
                ret = false;
            }
            if (data.validateWriteExternalStorage && Build.VERSION.SDK_INT <= 18) {
                PackageManager pm = activity.getPackageManager();
                if (pm.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", activity.getPackageName()) == 0) {
                    Log.i((String)TAG, (String)"android.permission.WRITE_EXTERNAL_STORAGE - VERIFIED");
                } else {
                    Log.e((String)TAG, (String)"android.permission.WRITE_EXTERNAL_STORAGE - MISSING");
                    ret = false;
                }
            }
            return ret;
        }
        catch (Exception e2) {
            Log.e((String)TAG, (String)("isAdapterValid " + adapterName), (Throwable)e2);
            return false;
        }
    }

    private static boolean isBroadcastReceiversValid(Activity activity, String[] broadcastReceivers) {
        if (broadcastReceivers == null) {
            return true;
        }
        PackageManager packageManager = activity.getPackageManager();
        Log.i((String)TAG, (String)"*** Broadcast Receivers ***");
        boolean ret = true;
        for (String broadcastReceiver : broadcastReceivers) {
            try {
                Class<?> localClass = Class.forName(broadcastReceiver);
                Intent intent = new Intent((Context)activity, localClass);
                List list = packageManager.queryBroadcastReceivers(intent, 65536);
                if (list.size() > 0) {
                    Log.i((String)TAG, (String)(broadcastReceiver + " - VERIFIED"));
                    continue;
                }
                ret = false;
                Log.e((String)TAG, (String)(broadcastReceiver + " - MISSING"));
            }
            catch (ClassNotFoundException e2) {
                ret = false;
                Log.e((String)TAG, (String)(broadcastReceiver + " - MISSING"));
            }
        }
        return ret;
    }

    private static boolean isServicesValid(Activity activity, String[] services) {
        if (services == null) {
            return true;
        }
        PackageManager packageManager = activity.getPackageManager();
        Log.i((String)TAG, (String)"*** Services ***");
        boolean ret = true;
        for (String service : services) {
            try {
                Class<?> localClass = Class.forName(service);
                Intent intent = new Intent((Context)activity, localClass);
                List list = packageManager.queryIntentServices(intent, 65536);
                if (list.size() > 0) {
                    Log.i((String)TAG, (String)(service + " - VERIFIED"));
                    continue;
                }
                ret = false;
                Log.e((String)TAG, (String)(service + " - MISSING"));
            }
            catch (ClassNotFoundException e2) {
                ret = false;
                Log.e((String)TAG, (String)(service + " - MISSING"));
            }
        }
        return ret;
    }

    private static boolean isExternalLibsValid(ArrayList<Pair<String, String>> externalLibs) {
        if (externalLibs == null) {
            return true;
        }
        Log.i((String)TAG, (String)"*** External Libraries ***");
        boolean ret = true;
        for (Pair<String, String> externalLibrary : externalLibs) {
            try {
                Class<?> c2 = Class.forName((String)externalLibrary.first);
                Log.i((String)TAG, (String)((String)externalLibrary.second + " - VERIFIED"));
            }
            catch (ClassNotFoundException e2) {
                ret = false;
                Log.e((String)TAG, (String)((String)externalLibrary.second + " - MISSING"));
            }
        }
        return ret;
    }

    private static boolean isActivitiesValid(Activity activity, String[] activities) {
        if (activities == null) {
            return true;
        }
        Log.i((String)TAG, (String)"*** Activities ***");
        boolean ret = true;
        for (String act : activities) {
            try {
                Class<?> localClass = Class.forName(act);
                Intent intent = new Intent((Context)activity, localClass);
                List list = activity.getPackageManager().queryIntentActivities(intent, 65536);
                if (list.size() > 0) {
                    Log.i((String)TAG, (String)(act + " - VERIFIED"));
                    continue;
                }
                ret = false;
                Log.e((String)TAG, (String)(act + " - MISSING"));
            }
            catch (ClassNotFoundException e2) {
                ret = false;
                Log.e((String)TAG, (String)(act + " - MISSING"));
            }
        }
        return ret;
    }

    private static void validatePermissions(Activity activity) {
        Log.i((String)TAG, (String)"*** Permissions ***");
        PackageManager pm = activity.getPackageManager();
        if (pm.checkPermission("android.permission.INTERNET", activity.getPackageName()) == 0) {
            Log.i((String)TAG, (String)"android.permission.INTERNET - VERIFIED");
        } else {
            Log.e((String)TAG, (String)"android.permission.INTERNET - MISSING");
        }
        if (pm.checkPermission("android.permission.ACCESS_NETWORK_STATE", activity.getPackageName()) == 0) {
            Log.i((String)TAG, (String)"android.permission.ACCESS_NETWORK_STATE - VERIFIED");
        } else {
            Log.e((String)TAG, (String)"android.permission.ACCESS_NETWORK_STATE - MISSING");
        }
    }

    private static boolean isAdapterSdkValid(String sdkName) {
        if (sdkName == null) {
            return true;
        }
        try {
            Class<?> c2 = Class.forName(sdkName);
            Log.i((String)TAG, (String)"SDK - VERIFIED");
            return true;
        }
        catch (Exception e2) {
            Log.e((String)TAG, (String)"SDK - MISSING");
            return false;
        }
    }

    private static void verifyBannerAdapterVersion(IntegrationData data) {
        if (!(data.name.equalsIgnoreCase("AppLovin") || data.name.equalsIgnoreCase("AdMob") || data.name.equalsIgnoreCase("Facebook") || data.name.equalsIgnoreCase("InMobi") || data.name.equalsIgnoreCase("Fyber"))) {
            return;
        }
        if (!data.version.startsWith(BANNER_COMPATIBILITY_VERSION)) {
            Log.e((String)TAG, (String)(data.name + " adapter " + data.version + " is incompatible for showing banners with SDK version " + IronSourceUtils.getSDKVersion() + ", please update your adapter to version " + BANNER_COMPATIBILITY_VERSION + ".*"));
        }
    }

    private static boolean isAdapterVersionValid(IntegrationData data) {
        if (data.version.startsWith(SDK_COMPATIBILITY_VERSION) || data.version.startsWith(BANNER_COMPATIBILITY_VERSION)) {
            Log.i((String)TAG, (String)"Adapter version - VERIFIED");
            return true;
        }
        Log.e((String)TAG, (String)(data.name + " adapter " + data.version + " is incompatible with SDK version " + IronSourceUtils.getSDKVersion() + ", please update your adapter to version " + SDK_COMPATIBILITY_VERSION + ".*"));
        return false;
    }

    private static IntegrationData getIntegrationData(Activity activity, String className) {
        try {
            Class<?> c2 = Class.forName(className);
            Method method = c2.getMethod("getIntegrationData", Activity.class);
            IntegrationData ret = (IntegrationData)method.invoke(null, activity);
            Log.i((String)TAG, (String)"Adapter - VERIFIED");
            return ret;
        }
        catch (ClassNotFoundException cnfe) {
            Log.e((String)TAG, (String)"Adapter - MISSING");
        }
        catch (Exception e2) {
            Log.e((String)TAG, (String)"Adapter version - NOT VERIFIED");
        }
        return null;
    }

    private static void validateGooglePlayServices(final Activity activity) {
        String mGooglePlayServicesMetaData = "com.google.android.gms.version";
        String mGooglePlayServices = "Google Play Services";
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Log.w((String)IntegrationHelper.TAG, (String)"--------------- Google Play Services --------------");
                    PackageManager packageManager = activity.getPackageManager();
                    ApplicationInfo ai = packageManager.getApplicationInfo(activity.getPackageName(), 128);
                    Bundle bundle = ai.metaData;
                    boolean exists = bundle.containsKey("com.google.android.gms.version");
                    if (exists) {
                        Log.i((String)IntegrationHelper.TAG, (String)"Google Play Services - VERIFIED");
                        String gaid = IronSourceObject.getInstance().getAdvertiserId((Context)activity);
                        if (!TextUtils.isEmpty((CharSequence)gaid)) {
                            Log.i((String)IntegrationHelper.TAG, (String)("GAID is: " + gaid + " (use this for test devices)"));
                        }
                    } else {
                        Log.e((String)IntegrationHelper.TAG, (String)"Google Play Services - MISSING");
                    }
                }
                catch (Exception e2) {
                    Log.e((String)IntegrationHelper.TAG, (String)"Google Play Services - MISSING");
                }
            }
        };
        thread.start();
    }
}

