/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.environment;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ApplicationContext {
    public static String getPackageName(Context context) {
        return context.getPackageName();
    }

    public static int getAppOrientation(Activity a2) {
        return a2.getRequestedOrientation();
    }

    public static String getDiskCacheDirPath(Context context) {
        String path = null;
        File internalFile = context.getCacheDir();
        if (internalFile != null) {
            path = internalFile.getPath();
        }
        return path;
    }

    public static boolean isValidPermission(Context context, String permissionToCheck) {
        boolean isPermissionValid = false;
        String permission2 = "";
        if (!TextUtils.isEmpty((CharSequence)permissionToCheck)) {
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
                if (packageInfo.requestedPermissions != null) {
                    for (int i2 = 0; i2 < packageInfo.requestedPermissions.length && !isPermissionValid; ++i2) {
                        permission2 = packageInfo.requestedPermissions[i2];
                        isPermissionValid = permissionToCheck.equals(permission2);
                    }
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return isPermissionValid;
    }

    public static boolean isPermissionGranted(Context context, String permission2) {
        int res = context.checkCallingOrSelfPermission(permission2);
        return res == 0;
    }

    public static JSONObject getPermissions(Context context, JSONArray permissionsFromController) {
        String GRANTED = "Granted";
        String REJECTED = "Rejected";
        String NOT_FOUND = "notFoundInManifest";
        JSONObject allPermissions = new JSONObject();
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
                if (permissionsFromController.length() == 0) {
                    for (int index = 0; index < packageInfo.requestedPermissions.length; ++index) {
                        String permissionStatus = (packageInfo.requestedPermissionsFlags[index] & 2) != 0 ? GRANTED : REJECTED;
                        allPermissions.put(packageInfo.requestedPermissions[index], (Object)permissionStatus);
                    }
                } else {
                    List<String> permissionsList = Arrays.asList(packageInfo.requestedPermissions);
                    for (int index = 0; index < permissionsFromController.length(); ++index) {
                        String permission2 = permissionsFromController.getString(index);
                        int indexOfPermission = permissionsList.indexOf(permission2);
                        if (indexOfPermission != -1) {
                            String permissionStatus = (packageInfo.requestedPermissionsFlags[indexOfPermission] & 2) != 0 ? GRANTED : REJECTED;
                            allPermissions.put(permission2, (Object)permissionStatus);
                            continue;
                        }
                        allPermissions.put(permission2, (Object)NOT_FOUND);
                    }
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return allPermissions;
    }

    static PackageInfo getAppPackageInfo(Context context) throws PackageManager.NameNotFoundException {
        return context.getPackageManager().getPackageInfo(ApplicationContext.getPackageName(context), 0);
    }

    public static long getFirstInstallTime(Context context) {
        try {
            PackageInfo packageInfo = ApplicationContext.getAppPackageInfo(context);
            return packageInfo.firstInstallTime;
        }
        catch (PackageManager.NameNotFoundException e2) {
            e2.printStackTrace();
            return -1L;
        }
    }

    public static long getLastUpdateTime(Context context) {
        try {
            PackageInfo packageInfo = ApplicationContext.getAppPackageInfo(context);
            return packageInfo.lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException e2) {
            e2.printStackTrace();
            return -1L;
        }
    }

    public static String getApplicationVersionName(Context context) {
        try {
            PackageInfo packageInfo = ApplicationContext.getAppPackageInfo(context);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e2) {
            e2.printStackTrace();
            return "";
        }
    }

    public static String getPublisherApplicationVersion(Context context, String packageName) {
        String result = "";
        try {
            result = context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionName;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

