/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import android.text.TextUtils;
import com.ironsource.sdk.data.DemandSource;
import com.ironsource.sdk.data.SSAEnums;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class DemandSourceManager {
    private Map<String, DemandSource> mRewardedVideoDemandSourceMap = new LinkedHashMap<String, DemandSource>();

    public Collection<DemandSource> getDemandSources(SSAEnums.ProductType productType) {
        if (productType.name().equalsIgnoreCase(SSAEnums.ProductType.RewardedVideo.name())) {
            return this.mRewardedVideoDemandSourceMap.values();
        }
        return new ArrayList<DemandSource>();
    }

    public DemandSource getDemandSourceByName(SSAEnums.ProductType productType, String demandSourceName) {
        if (!TextUtils.isEmpty((CharSequence)demandSourceName) && productType.name().equalsIgnoreCase(SSAEnums.ProductType.RewardedVideo.name())) {
            return this.mRewardedVideoDemandSourceMap.get(demandSourceName);
        }
        return null;
    }

    public void put(SSAEnums.ProductType productType, String demandSourceName, DemandSource demandSource) {
        if (!TextUtils.isEmpty((CharSequence)demandSourceName) && demandSource != null && productType.name().equalsIgnoreCase(SSAEnums.ProductType.RewardedVideo.name())) {
            this.mRewardedVideoDemandSourceMap.put(demandSourceName, demandSource);
        }
    }
}

