/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.view.View;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.EBannerSize;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.BannerLayoutListener;
import com.ironsource.mediationsdk.sdk.BannerManagerListener;
import com.ironsource.mediationsdk.sdk.BannerSmashApi;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class BannerSmash
extends AbstractSmash
implements BannerSmashListener,
BannerSmashApi {
    private JSONObject mBannerAdapterConfigs;
    private BannerManagerListener mBannerManagerListener;
    private BannerLayoutListener mBannerLayoutListener;
    private long mTimeoutInMillis;

    BannerSmash(ProviderSettings adapterConfigs, long timeout) {
        super(adapterConfigs);
        this.mBannerAdapterConfigs = adapterConfigs.getBannerSettings();
        this.mIsMultipleInstances = adapterConfigs.isMultipleInstances();
        this.mSpId = adapterConfigs.getSubProviderId();
        this.mTimeoutInMillis = timeout;
    }

    void initBanners(Activity activity, String appKey, String userId) {
        this.startInitTimer();
        if (this.mAdapter != null) {
            this.mAdapter.addBannerListener(this);
            this.mAdapter.initBanners(activity, appKey, userId, this.mBannerAdapterConfigs);
        }
    }

    @Override
    boolean isExhausted() {
        return false;
    }

    @Override
    boolean isCappedPerSession() {
        return false;
    }

    @Override
    void completeIteration() {
    }

    @Override
    void startInitTimer() {
        try {
            this.mInitTimerTask = new TimerTask(){

                @Override
                public void run() {
                    if (BannerSmash.this.mMediationState == AbstractSmash.MEDIATION_STATE.INIT_PENDING && BannerSmash.this.mBannerManagerListener != null) {
                        BannerSmash.this.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
                        BannerSmash.this.mBannerManagerListener.onBannerInitFailed(ErrorBuilder.buildInitFailedError("Timeout", "Banner"), BannerSmash.this);
                    }
                }
            };
            Timer timer = new Timer();
            if (this.mInitTimerTask != null) {
                timer.schedule(this.mInitTimerTask, this.mTimeoutInMillis);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    void startLoadTimer() {
        try {
            this.mLoadTimerTask = new TimerTask(){

                @Override
                public void run() {
                    BannerSmash.this.mAdapter.removeBannerViews();
                    if (BannerSmash.this.mMediationState == AbstractSmash.MEDIATION_STATE.LOAD_PENDING && BannerSmash.this.mBannerManagerListener != null) {
                        BannerSmash.this.setMediationState(AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
                        BannerSmash.this.mBannerManagerListener.onBannerAdLoadFailed(ErrorBuilder.buildLoadFailedError("Timeout"), BannerSmash.this);
                    }
                }
            };
            Timer timer = new Timer();
            if (this.mLoadTimerTask != null) {
                timer.schedule(this.mLoadTimerTask, this.mTimeoutInMillis);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public IronSourceBannerLayout createBanner(Activity activity, EBannerSize size) {
        return null;
    }

    @Override
    public void loadBanner(IronSourceBannerLayout banner) {
        this.startLoadTimer();
        this.mBannerLayoutListener = banner;
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":loadBanner()", 1);
            this.postShow();
            this.mAdapter.loadBanner(banner, this.mBannerAdapterConfigs, this);
        }
    }

    @Override
    public void destroyBanner(IronSourceBannerLayout banner) {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":destroyBanner()", 1);
            this.mAdapter.destroyBanner(banner);
        } else {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":destroyBanner wasn't called. adapter is null", 1);
        }
    }

    void setBannerManagerListener(BannerManagerListener manager) {
        this.mBannerManagerListener = manager;
    }

    @Override
    public void onBannerAdLoaded() {
        this.stopLoadTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.LOAD_PENDING && this.mBannerLayoutListener != null) {
            this.mBannerLayoutListener.onBannerAdLoaded(this);
        }
    }

    @Override
    public void onBannerAdLoadFailed(IronSourceError error) {
        this.stopLoadTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.LOAD_PENDING && this.mBannerLayoutListener != null) {
            this.mBannerLayoutListener.onBannerAdLoadFailed(error, this);
        }
    }

    @Override
    public void onBannerAdClicked() {
        if (this.mBannerLayoutListener != null) {
            this.mBannerLayoutListener.onBannerAdClicked(this);
        }
    }

    @Override
    public void onBannerAdScreenPresented() {
        if (this.mBannerLayoutListener != null) {
            this.mBannerLayoutListener.onBannerAdScreenPresented(this);
        }
    }

    @Override
    public void onBannerAdScreenDismissed() {
        if (this.mBannerLayoutListener != null) {
            this.mBannerLayoutListener.onBannerAdScreenDismissed(this);
        }
    }

    @Override
    public void onBannerAdLeftApplication() {
        if (this.mBannerLayoutListener != null) {
            this.mBannerLayoutListener.onBannerAdLeftApplication(this);
        }
    }

    @Override
    public void onBannerInitSuccess() {
        this.stopInitTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.INIT_PENDING) {
            this.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
            if (this.mBannerManagerListener != null) {
                this.mBannerManagerListener.onBannerInitSuccess(this);
            }
        }
    }

    @Override
    public void onBannerInitFailed(IronSourceError error) {
        this.stopInitTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.INIT_PENDING) {
            this.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
            if (this.mBannerManagerListener != null) {
                this.mBannerManagerListener.onBannerInitFailed(error, this);
            }
        }
    }

    @Override
    public void attachSmashToBanner(View bannerView) {
        if (this.mBannerManagerListener != null) {
            this.mBannerLayoutListener.attachSmashToBanner(this, bannerView);
        }
    }
}

