/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.text.TextUtils;
import com.ironsource.environment.NetworkStateReceiver;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdUnitManager;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.RewardedVideoSmash;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.RewardedVideoApi;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoManagerListener;
import com.ironsource.mediationsdk.server.Server;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

class RewardedVideoManager
extends AbstractAdUnitManager
implements RewardedVideoApi,
RewardedVideoManagerListener,
NetworkStateReceiver.NetworkStateReceiverListener {
    private final String TAG = this.getClass().getSimpleName();
    private RewardedVideoListener mListenersWrapper;
    private boolean mPauseSmartLoadDueToNetworkUnavailability = false;
    private boolean mIsUltraEventsEnabled = false;
    private NetworkStateReceiver mNetworkStateReceiver;
    private Placement mCurrentPlacement;
    private List<AbstractSmash.MEDIATION_STATE> mStatesToIgnore = Arrays.asList(AbstractSmash.MEDIATION_STATE.INIT_FAILED, AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION, AbstractSmash.MEDIATION_STATE.EXHAUSTED);

    RewardedVideoManager() {
    }

    @Override
    public void setRewardedVideoListener(RewardedVideoListener listener) {
        this.mListenersWrapper = listener;
    }

    @Override
    public synchronized void initRewardedVideo(Activity activity, String appKey, String userId) {
        AbstractAdapter lastLoadedAdapter;
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, this.TAG + ":initRewardedVideo(appKey: " + appKey + ", userId: " + userId + ")", 1);
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mActivity = activity;
        for (int i = 0; i < this.mSmartLoadAmount && i < this.mSmashArray.size() && (lastLoadedAdapter = this.loadNextAdapter()) != null; ++i) {
        }
    }

    @Override
    public synchronized void showRewardedVideo(String placementName) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, this.TAG + ":showRewardedVideo(placementName: " + placementName + ")", 1);
        if (!IronSourceUtils.isNetworkConnected((Context)this.mActivity)) {
            this.mListenersWrapper.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoInternetConnectionShowFailError("Rewarded Video"));
            return;
        }
        this.sendShowCheckAvailabilityEvents(placementName);
        int capped = 0;
        int notAvailable = 0;
        for (int i = 0; i < this.mSmashArray.size(); ++i) {
            if (((AbstractSmash)this.mSmashArray.get(i)).getMediationState() == AbstractSmash.MEDIATION_STATE.AVAILABLE) {
                if (((RewardedVideoSmash)this.mSmashArray.get(i)).isRewardedVideoAvailable()) {
                    this.showAdapter((AbstractSmash)this.mSmashArray.get(i), i);
                    if (this.mCanShowPremium && !((AbstractSmash)this.mSmashArray.get(i)).equals(this.getPremiumSmash())) {
                        this.disablePremiumForCurrentSession();
                    }
                    if (((AbstractSmash)this.mSmashArray.get(i)).isCappedPerSession()) {
                        this.completeAdapterCap((AbstractSmash)this.mSmashArray.get(i));
                    } else if (((AbstractSmash)this.mSmashArray.get(i)).isExhausted()) {
                        this.loadNextAdapter();
                        this.completeIterationRound();
                    }
                    return;
                }
                this.onRewardedVideoAvailabilityChanged(false, (RewardedVideoSmash)this.mSmashArray.get(i));
                Exception e = new Exception("FailedToShowVideoException");
                this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.INTERNAL, ((AbstractSmash)this.mSmashArray.get(i)).getInstanceName() + " Failed to show video", e);
                continue;
            }
            if (((AbstractSmash)this.mSmashArray.get(i)).getMediationState() == AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION) {
                ++capped;
                continue;
            }
            if (((AbstractSmash)this.mSmashArray.get(i)).getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
            ++notAvailable;
        }
        if (this.isBackFillAvailable()) {
            this.showAdapter(this.getBackfillSmash(), this.mSmashArray.size());
        } else if (capped + notAvailable == this.mSmashArray.size()) {
            if (capped > 0) {
                this.mListenersWrapper.onRewardedVideoAdShowFailed(ErrorBuilder.buildCappedPerSessionError("Rewarded Video"));
            } else {
                this.mListenersWrapper.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError("Rewarded Video"));
            }
        }
    }

    @Override
    public synchronized boolean isRewardedVideoAvailable() {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, this.TAG + ":isRewardedVideoAvailable()", 1);
        if (this.mPauseSmartLoadDueToNetworkUnavailability) {
            return false;
        }
        for (AbstractSmash smash : this.mSmashArray) {
            if (!((RewardedVideoSmash)smash).isRewardedVideoAvailable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error, RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAdShowFailed(" + error + ")", 1);
        this.mListenersWrapper.onRewardedVideoAdShowFailed(error);
    }

    @Override
    public void onRewardedVideoAdOpened(RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAdOpened()", 1);
        EventData event = new EventData(5, IronSourceUtils.getProviderAdditionalData(smash));
        RewardedVideoEventsManager.getInstance().log(event);
        this.mListenersWrapper.onRewardedVideoAdOpened();
    }

    @Override
    public void onRewardedVideoAdClosed(RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAdClosed()", 1);
        EventData event = new EventData(6, IronSourceUtils.getProviderAdditionalData(smash));
        RewardedVideoEventsManager.getInstance().log(event);
        this.mListenersWrapper.onRewardedVideoAdClosed();
        this.notifyIsAdAvailableForStatistics();
        for (AbstractSmash asmash : this.mSmashArray) {
            if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
            try {
                if (asmash.getInstanceName().equals(smash.getInstanceName())) continue;
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, asmash.getInstanceName() + ":reload smash", 1);
                ((RewardedVideoSmash)asmash).fetchRewardedVideo();
            }
            catch (Throwable t) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, asmash.getInstanceName() + " Failed to call fetchVideo(), " + t.getLocalizedMessage(), 1);
            }
        }
    }

    @Override
    public synchronized void onRewardedVideoAvailabilityChanged(boolean available, RewardedVideoSmash smash) {
        if (!this.mPauseSmartLoadDueToNetworkUnavailability) {
            try {
                JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
                try {
                    data.put("status", (Object)String.valueOf(available));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                EventData event = new EventData(7, data);
                RewardedVideoEventsManager.getInstance().log(event);
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAvailabilityChanged(available:" + available + ")", 1);
                if (smash.equals(this.getBackfillSmash())) {
                    if (this.shouldNotifyAvailabilityChanged(available)) {
                        this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
                    }
                    return;
                }
                if (smash.equals(this.getPremiumSmash())) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + " is a Premium adapter, canShowPremium: " + this.canShowPremium(), 1);
                    if (!this.canShowPremium()) {
                        smash.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION);
                        if (this.shouldNotifyAvailabilityChanged(false)) {
                            this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
                        }
                        return;
                    }
                }
                if (smash.isMediationAvailable()) {
                    if (available) {
                        if (this.shouldNotifyAvailabilityChanged(true)) {
                            this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
                        }
                    } else {
                        if (this.shouldNotifyAvailabilityChanged(false)) {
                            this.notifyAvailabilityChange();
                        }
                        this.loadNextAdapter();
                        this.completeIterationRound();
                    }
                }
            }
            catch (Throwable e) {
                this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onRewardedVideoAvailabilityChanged(available:" + available + ", " + "provider:" + smash.getName() + ")", e);
            }
        }
    }

    @Override
    public void onRewardedVideoAdStarted(RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAdStarted()", 1);
        EventData event = new EventData(8, IronSourceUtils.getProviderAdditionalData(smash));
        RewardedVideoEventsManager.getInstance().log(event);
        this.mListenersWrapper.onRewardedVideoAdStarted();
    }

    @Override
    public void onRewardedVideoAdEnded(RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAdEnded()", 1);
        EventData event = new EventData(9, IronSourceUtils.getProviderAdditionalData(smash));
        RewardedVideoEventsManager.getInstance().log(event);
        this.mListenersWrapper.onRewardedVideoAdEnded();
    }

    @Override
    public void onRewardedVideoAdRewarded(RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAdRewarded()", 1);
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            data.put("placement", (Object)this.mCurrentPlacement.getPlacementName());
            data.put("rewardName", (Object)this.mCurrentPlacement.getRewardName());
            data.put("rewardAmount", this.mCurrentPlacement.getRewardAmount());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        EventData event = new EventData(10, data);
        if (!TextUtils.isEmpty((CharSequence)this.mAppKey)) {
            String strToTransId = "" + Long.toString(event.getTimeStamp()) + this.mAppKey + smash.getName();
            String transId = IronSourceUtils.getTransId(strToTransId);
            event.addToAdditionalData("transId", transId);
            if (!TextUtils.isEmpty((CharSequence)IronSourceObject.getInstance().getDynamicUserId())) {
                event.addToAdditionalData("dynamicUserId", IronSourceObject.getInstance().getDynamicUserId());
            }
        }
        RewardedVideoEventsManager.getInstance().log(event);
        this.mListenersWrapper.onRewardedVideoAdRewarded(this.mCurrentPlacement);
    }

    @Override
    public void onNetworkAvailabilityChanged(boolean connected) {
        if (this.mShouldTrackNetworkState) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Network Availability Changed To: " + connected, 0);
            if (this.shouldNotifyNetworkAvailabilityChanged(connected)) {
                this.mPauseSmartLoadDueToNetworkUnavailability = !connected;
                this.mListenersWrapper.onRewardedVideoAvailabilityChanged(connected);
            }
        }
    }

    @Override
    void shouldTrackNetworkState(Context context, boolean track) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, this.TAG + " Should Track Network State: " + track, 0);
        this.mShouldTrackNetworkState = track;
        if (this.mShouldTrackNetworkState) {
            if (this.mNetworkStateReceiver == null) {
                this.mNetworkStateReceiver = new NetworkStateReceiver(context, this);
            }
            context.registerReceiver((BroadcastReceiver)this.mNetworkStateReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        } else if (this.mNetworkStateReceiver != null) {
            context.unregisterReceiver((BroadcastReceiver)this.mNetworkStateReceiver);
        }
    }

    private boolean shouldNotifyNetworkAvailabilityChanged(boolean networkState) {
        boolean shouldNotify = false;
        if (networkState && !this.mLastMediationAvailabilityState.booleanValue() && this.hasAvailableSmash()) {
            this.mLastMediationAvailabilityState = true;
            shouldNotify = true;
        } else if (!networkState && this.mLastMediationAvailabilityState.booleanValue()) {
            this.mLastMediationAvailabilityState = false;
            shouldNotify = true;
        }
        return shouldNotify;
    }

    void setIsUltraEventsEnabled(boolean enabled) {
        this.mIsUltraEventsEnabled = enabled;
    }

    private void reportFalseImpressionsOnHigherPriority(int priority, int placementId) {
        for (int i = 0; i < priority && i < this.mSmashArray.size(); ++i) {
            if (this.mStatesToIgnore.contains((Object)((AbstractSmash)this.mSmashArray.get(i)).getMediationState())) continue;
            this.reportImpression(((RewardedVideoSmash)this.mSmashArray.get(i)).getRequestUrl(), false, placementId);
        }
    }

    private synchronized void reportImpression(String adapterUrl, boolean hit, int placementId) {
        String url = "";
        try {
            url = url + adapterUrl;
            url = url + "&sdkVersion=" + IronSourceUtils.getSDKVersion();
            Server.callAsyncRequestURL(url, hit, placementId);
        }
        catch (Throwable e) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.NETWORK, "reportImpression:(providerURL:" + url + ", " + "hit:" + hit + ")", e);
        }
    }

    void setCurrentPlacement(Placement currentPlacement) {
        this.mCurrentPlacement = currentPlacement;
    }

    @Override
    protected synchronized void disablePremiumForCurrentSession() {
        super.disablePremiumForCurrentSession();
        for (AbstractSmash smash : this.mSmashArray) {
            if (!smash.equals(this.getPremiumSmash())) continue;
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION);
            this.loadNextAdapter();
            break;
        }
    }

    private synchronized AbstractAdapter startAdapter(RewardedVideoSmash smash) {
        AbstractAdapter providerAdapter;
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, this.TAG + ":startAdapter(" + smash.getInstanceName() + ")", 1);
        try {
            providerAdapter = this.getLoadedAdapterOrFetchByReflection(smash);
            if (providerAdapter == null) {
                return null;
            }
            IronSourceObject.getInstance().addToRVAdaptersList(providerAdapter);
            providerAdapter.setLogListener(this.mLoggerManager);
            smash.setAdapterForSmash(providerAdapter);
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
            this.setCustomParams(smash);
            smash.initRewardedVideo(this.mActivity, this.mAppKey, this.mUserId);
        }
        catch (Throwable e) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, this.TAG + ":startAdapter(" + smash.getName() + ")", e);
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
            if (this.shouldNotifyAvailabilityChanged(false)) {
                this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
            }
            IronSourceError error = ErrorBuilder.buildInitFailedError(smash.getName() + " initialization failed - please verify that required dependencies are in you build path.", "Rewarded Video");
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, error.toString(), 2);
            return null;
        }
        return providerAdapter;
    }

    private AbstractAdapter loadNextAdapter() {
        AbstractAdapter initiatedAdapter = null;
        int activeAdapters = 0;
        for (int i = 0; i < this.mSmashArray.size() && initiatedAdapter == null; ++i) {
            if (((AbstractSmash)this.mSmashArray.get(i)).getMediationState() == AbstractSmash.MEDIATION_STATE.AVAILABLE || ((AbstractSmash)this.mSmashArray.get(i)).getMediationState() == AbstractSmash.MEDIATION_STATE.INITIATED) {
                if (++activeAdapters < this.mSmartLoadAmount) continue;
                break;
            }
            if (((AbstractSmash)this.mSmashArray.get(i)).getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_INITIATED || (initiatedAdapter = this.startAdapter((RewardedVideoSmash)this.mSmashArray.get(i))) != null) continue;
            ((AbstractSmash)this.mSmashArray.get(i)).setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
        }
        return initiatedAdapter;
    }

    private synchronized boolean showAdapter(AbstractSmash smash, int index) {
        CappingManager.incrementShowCounter((Context)this.mActivity, this.mCurrentPlacement);
        if (this.mIsUltraEventsEnabled) {
            this.reportImpression(((RewardedVideoSmash)smash).getRequestUrl(), true, this.mCurrentPlacement.getPlacementId());
            this.reportFalseImpressionsOnHigherPriority(index, this.mCurrentPlacement.getPlacementId());
        }
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            data.put("placement", (Object)this.mCurrentPlacement.getPlacementName());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        EventData event = new EventData(2, data);
        RewardedVideoEventsManager.getInstance().log(event);
        this.sendShowChanceEvents(smash, index, this.mCurrentPlacement.getPlacementName());
        ((RewardedVideoSmash)smash).showRewardedVideo();
        return true;
    }

    private synchronized void notifyIsAdAvailableForStatistics() {
        boolean mediationStatus = false;
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            mediationStatus = true;
            break;
        }
        JSONObject data = IronSourceUtils.getMediationAdditionalData();
        try {
            data.put("status", (Object)String.valueOf(mediationStatus));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        EventData event = new EventData(3, data);
        RewardedVideoEventsManager.getInstance().log(event);
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() == AbstractSmash.MEDIATION_STATE.AVAILABLE) {
                JSONObject availableData = IronSourceUtils.getProviderAdditionalData(smash);
                try {
                    availableData.put("status", (Object)"true");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                EventData availableEvent = new EventData(3, availableData);
                RewardedVideoEventsManager.getInstance().log(availableEvent);
                continue;
            }
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED) continue;
            JSONObject notAvailableData = IronSourceUtils.getProviderAdditionalData(smash);
            try {
                notAvailableData.put("status", (Object)"false");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            EventData notAvailableEvent = new EventData(3, notAvailableData);
            RewardedVideoEventsManager.getInstance().log(notAvailableEvent);
        }
        if (this.getBackfillSmash() != null && this.getBackfillSmash().getAdapter() != null) {
            JSONObject backFillData = IronSourceUtils.getProviderAdditionalData(this.getBackfillSmash());
            try {
                backFillData.put("status", (Object)(this.isBackFillAvailable() ? "true" : "false"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            EventData backFillEvent = new EventData(3, backFillData);
            RewardedVideoEventsManager.getInstance().log(backFillEvent);
        }
    }

    private synchronized boolean shouldNotifyAvailabilityChanged(boolean adapterAvailability) {
        boolean shouldNotify = false;
        if (this.mLastMediationAvailabilityState == null) {
            if (adapterAvailability) {
                this.mLastMediationAvailabilityState = true;
                shouldNotify = true;
            } else if (!this.isBackFillAvailable() && this.isAllLoaded()) {
                this.mLastMediationAvailabilityState = false;
                shouldNotify = true;
            }
        } else if (adapterAvailability && !this.mLastMediationAvailabilityState.booleanValue()) {
            this.mLastMediationAvailabilityState = true;
            shouldNotify = true;
        } else if (!adapterAvailability && this.mLastMediationAvailabilityState.booleanValue() && !this.hasAvailableSmash() && !this.isBackFillAvailable()) {
            this.mLastMediationAvailabilityState = false;
            shouldNotify = true;
        }
        return shouldNotify;
    }

    private synchronized boolean isAllLoaded() {
        boolean allLoaded = true;
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_INITIATED) continue;
            allLoaded = false;
            break;
        }
        return allLoaded;
    }

    private synchronized boolean hasAvailableSmash() {
        boolean hasAvailableSmash = false;
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            hasAvailableSmash = true;
            break;
        }
        return hasAvailableSmash;
    }

    private synchronized boolean isBackFillAvailable() {
        if (this.getBackfillSmash() != null) {
            return ((RewardedVideoSmash)this.getBackfillSmash()).isRewardedVideoAvailable();
        }
        return false;
    }

    private void sendShowCheckAvailabilityEvents(String placementName) {
        for (int i = 0; i < this.mSmashArray.size(); ++i) {
            if (((AbstractSmash)this.mSmashArray.get(i)).getMediationState() == AbstractSmash.MEDIATION_STATE.AVAILABLE) {
                this.createAndSendShowCheckAvailabilityEvent((AbstractSmash)this.mSmashArray.get(i), i, placementName, true);
                continue;
            }
            if (((AbstractSmash)this.mSmashArray.get(i)).getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
            this.createAndSendShowCheckAvailabilityEvent((AbstractSmash)this.mSmashArray.get(i), i, placementName, false);
        }
        if (this.getBackfillSmash() != null && this.getBackfillSmash().getAdapter() != null) {
            this.createAndSendShowCheckAvailabilityEvent(this.getBackfillSmash(), this.mSmashArray.size(), placementName, this.isBackFillAvailable());
        }
    }

    private void sendShowChanceEvents(AbstractSmash selectedSmash, int priority, String placementName) {
        this.sendShowChanceEvent(selectedSmash, priority, placementName, true);
        for (int i = 0; i < this.mSmashArray.size() && i < priority; ++i) {
            AbstractSmash smash = (AbstractSmash)this.mSmashArray.get(i);
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
            this.sendShowChanceEvent(smash, i, placementName, false);
        }
    }

    private void createAndSendShowCheckAvailabilityEvent(AbstractSmash smash, int priority, String placementName, boolean status) {
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            data.put("placement", (Object)placementName);
            data.put("status", (Object)(status ? "true" : "false"));
            data.put("providerPriority", priority);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        EventData event = new EventData(19, data);
        RewardedVideoEventsManager.getInstance().log(event);
    }

    private void sendShowChanceEvent(AbstractSmash smash, int priority, String placementName, boolean status) {
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            data.put("placement", (Object)placementName);
            data.put("status", (Object)(status ? "true" : "false"));
            data.put("providerPriority", priority);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        EventData event = new EventData(119, data);
        RewardedVideoEventsManager.getInstance().log(event);
    }

    private synchronized void notifyAvailabilityChange() {
        if (this.getBackfillSmash() != null && !this.mBackFillInitStarted) {
            this.mBackFillInitStarted = true;
            AbstractAdapter backfillAdapter = this.startAdapter((RewardedVideoSmash)this.getBackfillSmash());
            if (backfillAdapter == null) {
                this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
            }
        } else if (this.isBackFillAvailable()) {
            if (this.shouldNotifyAvailabilityChanged(true)) {
                this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
            }
        } else {
            this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
        }
    }

    private synchronized void completeAdapterCap(AbstractSmash smash) {
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            data.put("status", (Object)"false");
            data.put("reason", 2);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        EventData event = new EventData(7, data);
        RewardedVideoEventsManager.getInstance().log(event);
        if (this.loadNextAdapter() == null) {
            int cappedOrNotAvailable = 0;
            for (int i = 0; i < this.mSmashArray.size(); ++i) {
                if (((AbstractSmash)this.mSmashArray.get(i)).getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE && ((AbstractSmash)this.mSmashArray.get(i)).getMediationState() != AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION) continue;
                ++cappedOrNotAvailable;
            }
            if (cappedOrNotAvailable == this.mSmashArray.size()) {
                if (this.shouldNotifyAvailabilityChanged(false)) {
                    this.notifyAvailabilityChange();
                }
                JSONObject mediationData = IronSourceUtils.getMediationAdditionalData();
                try {
                    mediationData.put("status", (Object)"false");
                    mediationData.put("reason", 2);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                EventData mediationEvent = new EventData(7, mediationData);
                RewardedVideoEventsManager.getInstance().log(mediationEvent);
            } else {
                this.completeIterationRound();
            }
        }
    }

    private synchronized void completeIterationRound() {
        if (this.isIterationRoundComplete()) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Reset Iteration", 0);
            boolean isAvailable = false;
            for (AbstractSmash smash : this.mSmashArray) {
                if (smash.getMediationState() == AbstractSmash.MEDIATION_STATE.EXHAUSTED) {
                    smash.completeIteration();
                }
                if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
                isAvailable = true;
            }
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "End of Reset Iteration", 0);
            if (this.shouldNotifyAvailabilityChanged(isAvailable)) {
                this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
            }
        }
    }

    private synchronized boolean isIterationRoundComplete() {
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_INITIATED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            return false;
        }
        return true;
    }
}

