/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.RewardedVideoManagerListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashApi;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class RewardedVideoSmash
extends AbstractSmash
implements RewardedVideoSmashListener,
RewardedVideoSmashApi {
    private JSONObject mRewardedVideoAdapterConfigs;
    private RewardedVideoManagerListener mRewardedVideoManagerListener;
    private String mRequestUrl;
    private int mTimeout;
    private final String REQUEST_URL_KEY = "requestUrl";

    RewardedVideoSmash(ProviderSettings adapterConfigs, int timeout) {
        super(adapterConfigs);
        this.mRewardedVideoAdapterConfigs = adapterConfigs.getRewardedVideoSettings();
        this.mMaxAdsPerIteration = this.mRewardedVideoAdapterConfigs.optInt("maxAdsPerIteration", 99);
        this.mMaxAdsPerSession = this.mRewardedVideoAdapterConfigs.optInt("maxAdsPerSession", 99);
        this.mRequestUrl = this.mRewardedVideoAdapterConfigs.optString("requestUrl");
        this.mTimeout = timeout;
    }

    @Override
    void completeIteration() {
        this.mIterationShowCounter = 0;
        this.setMediationState(this.isRewardedVideoAvailable() ? AbstractSmash.MEDIATION_STATE.AVAILABLE : AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
    }

    @Override
    void startInitTimer() {
        try {
            this.mInitTimerTask = new TimerTask(){

                @Override
                public void run() {
                    if (RewardedVideoSmash.this.mRewardedVideoManagerListener != null) {
                        RewardedVideoSmash.this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, "Timeout for " + RewardedVideoSmash.this.getInstanceName(), 0);
                        RewardedVideoSmash.this.setMediationState(AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
                        RewardedVideoSmash.this.mRewardedVideoManagerListener.onRewardedVideoAvailabilityChanged(false, RewardedVideoSmash.this);
                    }
                }
            };
            Timer timer = new Timer();
            if (this.mInitTimerTask != null) {
                timer.schedule(this.mInitTimerTask, this.mTimeout * 1000);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    void startLoadTimer() {
    }

    @Override
    public void initRewardedVideo(Activity activity, String appKey, String userId) {
        this.startInitTimer();
        if (this.mAdapter != null) {
            this.mAdapter.addRewardedVideoListener(this);
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":initRewardedVideo()", 1);
            this.mAdapter.initRewardedVideo(activity, appKey, userId, this.mRewardedVideoAdapterConfigs, this);
        }
    }

    @Override
    public void fetchRewardedVideo() {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":fetchRewardedVideo()", 1);
            this.mAdapter.fetchRewardedVideo(this.mRewardedVideoAdapterConfigs);
        }
    }

    @Override
    public void showRewardedVideo() {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":showRewardedVideo()", 1);
            this.postShow();
            this.mAdapter.showRewardedVideo(this.mRewardedVideoAdapterConfigs, this);
        }
    }

    @Override
    public boolean isRewardedVideoAvailable() {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":isRewardedVideoAvailable()", 1);
            return this.mAdapter.isRewardedVideoAvailable(this.mRewardedVideoAdapterConfigs);
        }
        return false;
    }

    @Override
    public void setRewardedVideoManagerListener(RewardedVideoManagerListener listener) {
        this.mRewardedVideoManagerListener = listener;
    }

    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error) {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdShowFailed(error, this);
        }
    }

    @Override
    public void onRewardedVideoAdOpened() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdOpened(this);
        }
    }

    @Override
    public void onRewardedVideoAdClosed() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdClosed(this);
        }
        this.fetchRewardedVideo();
    }

    @Override
    public void onRewardedVideoAvailabilityChanged(boolean available) {
        this.stopInitTimer();
        if (this.isMediationAvailable() && (available && this.mMediationState != AbstractSmash.MEDIATION_STATE.AVAILABLE || !available && this.mMediationState != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE)) {
            this.setMediationState(available ? AbstractSmash.MEDIATION_STATE.AVAILABLE : AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
            if (this.mRewardedVideoManagerListener != null) {
                this.mRewardedVideoManagerListener.onRewardedVideoAvailabilityChanged(available, this);
            }
        }
    }

    @Override
    public void onRewardedVideoAdStarted() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdStarted(this);
        }
    }

    @Override
    public void onRewardedVideoAdEnded() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdEnded(this);
        }
    }

    @Override
    public void onRewardedVideoAdRewarded() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdRewarded(this);
        }
    }

    String getRequestUrl() {
        return this.mRequestUrl;
    }
}

