/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.InterstitialManagerListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashApi;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialListener;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialManagerListener;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialSmashApi;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class InterstitialSmash
extends AbstractSmash
implements InterstitialSmashListener,
RewardedInterstitialListener,
InterstitialSmashApi,
RewardedInterstitialSmashApi {
    private JSONObject mInterstitialAdapterConfigs;
    private InterstitialManagerListener mInterstitialManagerListener;
    private RewardedInterstitialManagerListener mRewardedInterstitialManagerListener;
    private int mTimeout;

    InterstitialSmash(ProviderSettings adapterConfigs, int timeout) {
        super(adapterConfigs);
        this.mInterstitialAdapterConfigs = adapterConfigs.getInterstitialSettings();
        this.mMaxAdsPerIteration = this.mInterstitialAdapterConfigs.optInt("maxAdsPerIteration", 99);
        this.mMaxAdsPerSession = this.mInterstitialAdapterConfigs.optInt("maxAdsPerSession", 99);
        this.mIsMultipleInstances = adapterConfigs.isMultipleInstances();
        this.mSpId = adapterConfigs.getSubProviderId();
        this.mTimeout = timeout;
    }

    @Override
    void completeIteration() {
        this.mIterationShowCounter = 0;
        this.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
    }

    @Override
    void startInitTimer() {
        try {
            this.mInitTimerTask = new TimerTask(){

                @Override
                public void run() {
                    if (InterstitialSmash.this.mMediationState == AbstractSmash.MEDIATION_STATE.INIT_PENDING && InterstitialSmash.this.mInterstitialManagerListener != null) {
                        InterstitialSmash.this.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
                        InterstitialSmash.this.mInterstitialManagerListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError("Timeout", "Interstitial"), InterstitialSmash.this);
                    }
                }
            };
            Timer timer = new Timer();
            if (this.mInitTimerTask != null) {
                timer.schedule(this.mInitTimerTask, this.mTimeout * 1000);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    void startLoadTimer() {
        try {
            this.mLoadTimerTask = new TimerTask(){

                @Override
                public void run() {
                    if (InterstitialSmash.this.mMediationState == AbstractSmash.MEDIATION_STATE.LOAD_PENDING && InterstitialSmash.this.mInterstitialManagerListener != null) {
                        InterstitialSmash.this.setMediationState(AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
                        InterstitialSmash.this.mInterstitialManagerListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError("Timeout"), InterstitialSmash.this);
                    }
                }
            };
            Timer timer = new Timer();
            if (this.mLoadTimerTask != null) {
                timer.schedule(this.mLoadTimerTask, this.mTimeout * 1000);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initInterstitial(Activity activity, String appKey, String userId) {
        this.startInitTimer();
        if (this.mAdapter != null) {
            this.mAdapter.addInterstitialListener(this);
            if (this.mRewardedInterstitialManagerListener != null) {
                this.mAdapter.setRewardedInterstitialListener(this);
            }
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":initInterstitial()", 1);
            this.mAdapter.initInterstitial(activity, appKey, userId, this.mInterstitialAdapterConfigs, this);
        }
    }

    @Override
    public void loadInterstitial() {
        this.startLoadTimer();
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":loadInterstitial()", 1);
            this.mAdapter.loadInterstitial(this.mInterstitialAdapterConfigs, this);
        }
    }

    @Override
    public void showInterstitial() {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":showInterstitial()", 1);
            this.postShow();
            this.mAdapter.showInterstitial(this.mInterstitialAdapterConfigs, this);
        }
    }

    @Override
    public boolean isInterstitialReady() {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":isInterstitialReady()", 1);
            return this.mAdapter.isInterstitialReady(this.mInterstitialAdapterConfigs);
        }
        return false;
    }

    @Override
    public void setInterstitialManagerListener(InterstitialManagerListener listener) {
        this.mInterstitialManagerListener = listener;
    }

    @Override
    public void setRewardedInterstitialManagerListener(RewardedInterstitialManagerListener listener) {
        this.mRewardedInterstitialManagerListener = listener;
    }

    @Override
    public void onInterstitialInitSuccess() {
        this.stopInitTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.INIT_PENDING) {
            this.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
            if (this.mInterstitialManagerListener != null) {
                this.mInterstitialManagerListener.onInterstitialInitSuccess(this);
            }
        }
    }

    @Override
    public void onInterstitialInitFailed(IronSourceError error) {
        this.stopInitTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.INIT_PENDING) {
            this.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
            if (this.mInterstitialManagerListener != null) {
                this.mInterstitialManagerListener.onInterstitialInitFailed(error, this);
            }
        }
    }

    @Override
    public void onInterstitialAdReady() {
        this.stopLoadTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.LOAD_PENDING && this.mInterstitialManagerListener != null) {
            this.mInterstitialManagerListener.onInterstitialAdReady(this);
        }
    }

    @Override
    public void onInterstitialAdLoadFailed(IronSourceError error) {
        this.stopLoadTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.LOAD_PENDING && this.mInterstitialManagerListener != null) {
            this.mInterstitialManagerListener.onInterstitialAdLoadFailed(error, this);
        }
    }

    @Override
    public void onInterstitialAdOpened() {
        if (this.mInterstitialManagerListener != null) {
            this.mInterstitialManagerListener.onInterstitialAdOpened(this);
        }
    }

    @Override
    public void onInterstitialAdClosed() {
        if (this.mInterstitialManagerListener != null) {
            this.mInterstitialManagerListener.onInterstitialAdClosed(this);
        }
    }

    @Override
    public void onInterstitialAdShowSucceeded() {
        if (this.mInterstitialManagerListener != null) {
            this.mInterstitialManagerListener.onInterstitialAdShowSucceeded(this);
        }
    }

    @Override
    public void onInterstitialAdShowFailed(IronSourceError error) {
        if (this.mInterstitialManagerListener != null) {
            this.mInterstitialManagerListener.onInterstitialAdShowFailed(error, this);
        }
    }

    @Override
    public void onInterstitialAdClicked() {
        if (this.mInterstitialManagerListener != null) {
            this.mInterstitialManagerListener.onInterstitialAdClicked(this);
        }
    }

    @Override
    public void onInterstitialAdRewarded() {
        if (this.mRewardedInterstitialManagerListener != null) {
            this.mRewardedInterstitialManagerListener.onInterstitialAdRewarded(this);
        }
    }
}

