/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.environment;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import com.ironsource.environment.ApplicationContext;
import java.util.List;

public class LocationService {
    public static Location getLastLocation(Context context) {
        Location bestLocation = null;
        long bestLocationTime = Long.MIN_VALUE;
        if (!ApplicationContext.isPermissionGranted(context, "android.permission.ACCESS_FINE_LOCATION")) {
            return bestLocation;
        }
        LocationManager locationManager = (LocationManager)context.getApplicationContext().getSystemService("location");
        List providers = locationManager.getAllProviders();
        for (String provider : providers) {
            long currentTime;
            Location location = locationManager.getLastKnownLocation(provider);
            if (location == null || (currentTime = location.getTime()) <= bestLocationTime) continue;
            bestLocation = location;
        }
        return bestLocation;
    }
}

