/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.model;

import android.text.TextUtils;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.ArrayList;

public class ProviderSettingsHolder {
    private ArrayList<ProviderSettings> mProviderSettingsArrayList = new ArrayList();
    private static ProviderSettingsHolder mInstance;

    public static synchronized ProviderSettingsHolder getProviderSettingsHolder() {
        if (mInstance == null) {
            mInstance = new ProviderSettingsHolder();
        }
        return mInstance;
    }

    private ProviderSettingsHolder() {
    }

    public void addProviderSettings(ProviderSettings providerSettings) {
        if (providerSettings != null) {
            this.mProviderSettingsArrayList.add(providerSettings);
        }
    }

    public ProviderSettings getProviderSettings(String providerName) {
        for (ProviderSettings providerSettings : this.mProviderSettingsArrayList) {
            if (!providerSettings.getProviderName().equals(providerName)) continue;
            return providerSettings;
        }
        ProviderSettings ps = new ProviderSettings(providerName);
        this.addProviderSettings(ps);
        return ps;
    }

    public boolean containsProviderSettings(String providerName) {
        for (ProviderSettings providerSettings : this.mProviderSettingsArrayList) {
            if (!providerSettings.getProviderName().equals(providerName)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<ProviderSettings> getProviderSettingsArrayList() {
        return this.mProviderSettingsArrayList;
    }

    public void fillSubProvidersDetails() {
        for (ProviderSettings providerSettings : this.mProviderSettingsArrayList) {
            boolean isSubProvider = providerSettings.isMultipleInstances() && !TextUtils.isEmpty((CharSequence)providerSettings.getProviderTypeForReflection());
            if (!isSubProvider) continue;
            ProviderSettings commonProviderSettings = this.getProviderSettings(providerSettings.getProviderTypeForReflection());
            providerSettings.setInterstitialSettings(IronSourceUtils.mergeJsons(providerSettings.getInterstitialSettings(), commonProviderSettings.getInterstitialSettings()));
            providerSettings.setRewardedVideoSettings(IronSourceUtils.mergeJsons(providerSettings.getRewardedVideoSettings(), commonProviderSettings.getRewardedVideoSettings()));
            providerSettings.setBannerSettings(IronSourceUtils.mergeJsons(providerSettings.getBannerSettings(), commonProviderSettings.getBannerSettings()));
        }
    }
}

