/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.server;

import android.util.Log;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.logger.ThreadExceptionHandler;
import com.ironsource.mediationsdk.server.HttpFunctions;
import com.ironsource.mediationsdk.server.ServerURL;
import org.json.JSONObject;

public class Server {
    private static String UniqueUsersURL = "https://ua.supersonicads.com/api/rest/v1.1/uniqueusers?";

    static String getUniqueUsersBaseURL() {
        return UniqueUsersURL;
    }

    public static void notifyUniqueUser(final String applicationKey, final String applicationUserId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String json = HttpFunctions.getStringFromURL(ServerURL.getUniqueUsersURL(applicationKey, applicationUserId));
                    JSONObject jSONObject = new JSONObject(json);
                }
                catch (Throwable e) {
                    StringBuilder logMessage = new StringBuilder("notifyUniqueUser(appKey:");
                    if (applicationKey != null) {
                        logMessage.append(applicationKey);
                    } else {
                        logMessage.append("null");
                    }
                    logMessage.append(", userId:");
                    if (applicationUserId != null) {
                        logMessage.append(applicationUserId);
                    } else {
                        logMessage.append("null");
                    }
                    logMessage.append(")");
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.NETWORK, logMessage.toString() + ", e:" + Log.getStackTraceString((Throwable)e), 0);
                }
            }
        }).start();
    }

    private static void callRequestURL(String requestUrl, boolean hit, int placementId) {
        try {
            String url = ServerURL.getRequestURL(requestUrl, hit, placementId);
            String json = HttpFunctions.getStringFromURL(url);
            JSONObject obj = new JSONObject(json);
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.NETWORK, "callRequestURL(reqUrl:" + requestUrl + ", " + "hit:" + hit + ")", 1);
        }
        catch (Throwable e) {
            StringBuilder builder = new StringBuilder("callRequestURL(reqUrl:");
            if (requestUrl == null) {
                builder.append("null");
            } else {
                builder.append(requestUrl);
            }
            builder.append(", hit:").append(hit).append(")");
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.NETWORK, builder.toString() + ", e:" + Log.getStackTraceString((Throwable)e), 0);
        }
    }

    public static void callAsyncRequestURL(final String requestUrl, final boolean hit, final int placementId) {
        Thread asyncRequestURL = new Thread(new Runnable(){

            @Override
            public void run() {
                Server.callRequestURL(requestUrl, hit, placementId);
            }
        }, "callAsyncRequestURL");
        asyncRequestURL.setUncaughtExceptionHandler(new ThreadExceptionHandler());
        asyncRequestURL.start();
    }
}

