/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.supersonicads;

import android.text.TextUtils;
import com.ironsource.mediationsdk.config.AbstractAdapterConfig;
import com.ironsource.mediationsdk.config.ConfigValidationResult;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.ArrayList;
import org.json.JSONObject;

public class DemandSourceConfig
extends AbstractAdapterConfig {
    private final String TAG = DemandSourceConfig.class.getSimpleName();
    private static final String CUSTOM_PARAM_PREFIX = "custom_";
    private final String APPLICATION_KEY = "applicationKey";
    private final String USER_ID = "userId";
    static final String CLIENT_SIDE_CALLBACKS = "useClientSideCallbacks";
    static final String APPLICATION_USER_GENDER = "applicationUserGender";
    static final String APPLICATION_USER_AGE_GROUP = "applicationUserAgeGroup";
    private final String AGE = "age";
    private final String GENDER = "gender";
    static final String LANGUAGE = "language";
    private final String APPLICATION_PRIVATE_KEY = "privateKey";
    static final String MAX_VIDEO_LENGTH = "maxVideoLength";
    static final String ITEM_NAME = "itemName";
    static final String ITEM_COUNT = "itemCount";
    private final String SDK_PLUGIN_TYPE = "SDKPluginType";
    static final String CAMPAIGN_ID = "campaignId";
    static final String CUSTOM_SEGMENT = "custom_Segment";
    private final String DYNAMIC_CONTROLLER_URL = "controllerUrl";
    private final String DYNAMIC_CONTROLLER_DEBUG_MODE = "debugMode";
    private final String DYNAMIC_CONTROLLER_CONFIG = "controllerConfig";
    private String mProviderName;

    public DemandSourceConfig(String providerName) {
        super(providerName);
        this.mProviderName = providerName;
    }

    String getRVUserAgeGroup() {
        return this.mProviderSettings.getRewardedVideoSettings().optString(APPLICATION_USER_AGE_GROUP);
    }

    String getISUserAgeGroup() {
        return this.mProviderSettings.getInterstitialSettings().optString(APPLICATION_USER_AGE_GROUP);
    }

    String getRVDynamicControllerUrl() {
        return this.mProviderSettings.getRewardedVideoSettings().optString("controllerUrl");
    }

    String getISDynamicControllerUrl() {
        return this.mProviderSettings.getInterstitialSettings().optString("controllerUrl");
    }

    public int getRVDebugMode() {
        int mode = 0;
        if (this.mProviderSettings.getRewardedVideoSettings().has("debugMode")) {
            mode = this.mProviderSettings.getRewardedVideoSettings().optInt("debugMode");
        }
        return mode;
    }

    public int getISDebugMode() {
        int mode = 0;
        if (this.mProviderSettings.getInterstitialSettings().has("debugMode")) {
            mode = this.mProviderSettings.getInterstitialSettings().optInt("debugMode");
        }
        return mode;
    }

    public String getRVControllerConfig() {
        String config = "";
        if (this.mProviderSettings != null && this.mProviderSettings.getRewardedVideoSettings() != null && this.mProviderSettings.getRewardedVideoSettings().has("controllerConfig")) {
            config = this.mProviderSettings.getRewardedVideoSettings().optString("controllerConfig");
        }
        return config;
    }

    public String getISControllerConfig() {
        String config = "";
        if (this.mProviderSettings != null && this.mProviderSettings.getInterstitialSettings() != null && this.mProviderSettings.getInterstitialSettings().has("controllerConfig")) {
            config = this.mProviderSettings.getInterstitialSettings().optString("controllerConfig");
        }
        return config;
    }

    public String getMaxVideoLength() {
        return this.mProviderSettings.getRewardedVideoSettings().optString(MAX_VIDEO_LENGTH);
    }

    public String getLanguage() {
        return this.mProviderSettings.getRewardedVideoSettings().optString(LANGUAGE);
    }

    public String getPrivateKey() {
        return this.mProviderSettings.getRewardedVideoSettings().optString("privateKey");
    }

    public String getItemName() {
        return this.mProviderSettings.getRewardedVideoSettings().optString(ITEM_NAME);
    }

    public int getItemCount() {
        int itemCount = -1;
        try {
            String itemCountString = this.mProviderSettings.getRewardedVideoSettings().optString(ITEM_COUNT);
            if (!TextUtils.isEmpty((CharSequence)itemCountString)) {
                itemCount = Integer.valueOf(itemCountString);
            }
        }
        catch (NumberFormatException e) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, this.TAG + ":getItemCount()", e);
        }
        return itemCount;
    }

    String getCampaignId() {
        return this.mProviderSettings.getRewardedVideoSettings().optString(CAMPAIGN_ID);
    }

    String getMediationSegment() {
        return this.mProviderSettings.getRewardedVideoSettings().optString(CUSTOM_SEGMENT);
    }

    int getMaxVideos() {
        return this.getMaxVideosToPresent();
    }

    int getMaxRVAdsPerIteration() {
        return this.getMaxRVAdsPerIterationToPresent();
    }

    int getMaxISAdsPerIteration() {
        return this.getMaxISAdsPerIterationToPresent();
    }

    String getRVUserGender() {
        return this.mProviderSettings.getRewardedVideoSettings().optString(APPLICATION_USER_GENDER);
    }

    String getISUserGender() {
        return this.mProviderSettings.getInterstitialSettings().optString(APPLICATION_USER_GENDER);
    }

    public void setMediationSegment(String segment) {
        this.mProviderSettings.setRewardedVideoSettings(CUSTOM_SEGMENT, segment);
    }

    void setUserAgeGroup(int age) {
        String ageGroup = "0";
        if (age >= 13 && age <= 17) {
            ageGroup = "1";
        } else if (age >= 18 && age <= 20) {
            ageGroup = "2";
        } else if (age >= 21 && age <= 24) {
            ageGroup = "3";
        } else if (age >= 25 && age <= 34) {
            ageGroup = "4";
        } else if (age >= 35 && age <= 44) {
            ageGroup = "5";
        } else if (age >= 45 && age <= 54) {
            ageGroup = "6";
        } else if (age >= 55 && age <= 64) {
            ageGroup = "7";
        } else if (age > 65 && age <= 120) {
            ageGroup = "8";
        }
        this.mProviderSettings.setRewardedVideoSettings(APPLICATION_USER_AGE_GROUP, ageGroup);
        this.mProviderSettings.setInterstitialSettings(APPLICATION_USER_AGE_GROUP, ageGroup);
    }

    void setUserGender(String gender) {
        this.mProviderSettings.setRewardedVideoSettings(APPLICATION_USER_GENDER, gender);
        this.mProviderSettings.setInterstitialSettings(APPLICATION_USER_GENDER, gender);
    }

    @Override
    protected ArrayList<String> initializeMandatoryFields() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("controllerUrl");
        return result;
    }

    @Override
    protected ArrayList<String> initializeOptionalFields() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(CLIENT_SIDE_CALLBACKS);
        result.add(APPLICATION_USER_GENDER);
        result.add(APPLICATION_USER_AGE_GROUP);
        result.add(LANGUAGE);
        result.add("maxAdsPerSession");
        result.add("maxAdsPerIteration");
        result.add("privateKey");
        result.add(MAX_VIDEO_LENGTH);
        result.add(ITEM_NAME);
        result.add(ITEM_COUNT);
        result.add("SDKPluginType");
        result.add("controllerConfig");
        result.add("debugMode");
        result.add("requestUrl");
        result.add(CUSTOM_SEGMENT);
        return result;
    }

    @Override
    protected void validateOptionalField(JSONObject config, String key, ConfigValidationResult result) {
        try {
            if ("maxAdsPerSession".equals(key)) {
                int maxVideos = config.optInt(key);
                this.validateMaxVideos(maxVideos, result);
            } else if (!("maxAdsPerIteration".equals(key) || "debugMode".equals(key) || "controllerConfig".equals(key))) {
                String value = (String)config.get(key);
                if (CLIENT_SIDE_CALLBACKS.equals(key)) {
                    this.validateClientSideCallbacks(value, result);
                } else if (APPLICATION_USER_GENDER.equals(key)) {
                    this.validateGender(value, result);
                } else if (APPLICATION_USER_AGE_GROUP.equals(key)) {
                    this.validateAgeGroup(value, result);
                } else if (LANGUAGE.equals(key)) {
                    this.validateLanguage(value, result);
                } else if (MAX_VIDEO_LENGTH.equals(key)) {
                    this.validateMaxVideoLength(value, result);
                } else if ("privateKey".equals(key)) {
                    this.validatePrivateKey(value, result);
                } else if (ITEM_NAME.equals(key)) {
                    this.validateItemName(value, result);
                } else if (ITEM_COUNT.equals(key)) {
                    this.validateItemCount(value, result);
                }
            }
        }
        catch (Throwable e) {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError(key, this.mProviderName, null));
        }
    }

    private void validateItemCount(String value, ConfigValidationResult result) {
        try {
            value = value.trim();
            int itemCount = Integer.parseInt(value);
            if (itemCount < 1 || itemCount > 100000) {
                result.setInvalid(ErrorBuilder.buildInvalidKeyValueError(ITEM_COUNT, this.mProviderName, "itemCount value should be between 1-100000"));
            }
        }
        catch (NumberFormatException e) {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError(ITEM_COUNT, this.mProviderName, "itemCount value should be between 1-100000"));
        }
    }

    private void validateItemName(String value, ConfigValidationResult result) {
        if (value != null) {
            if (value.length() < 1 || value.length() > 50) {
                result.setInvalid(ErrorBuilder.buildInvalidKeyValueError(ITEM_NAME, this.mProviderName, "itemNamelength should be between 1-50 characters"));
            }
        } else {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError(ITEM_NAME, this.mProviderName, "itemNamelength should be between 1-50 characters"));
        }
    }

    private void validatePrivateKey(String value, ConfigValidationResult result) {
        if (value != null) {
            if (value.length() >= 5 && value.length() <= 30) {
                String pattern = "^[a-zA-Z0-9]*$";
                if (!value.matches(pattern)) {
                    result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("privateKey", this.mProviderName, "privateKey should contains only characters and numbers"));
                }
            } else {
                result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("privateKey", this.mProviderName, "privateKey length should be between 5-30 characters"));
            }
        } else {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("privateKey", this.mProviderName, "privateKey length should be between 5-30 characters"));
        }
    }

    private void validateMaxVideoLength(String value, ConfigValidationResult result) {
        try {
            value = value.trim();
            int age = Integer.parseInt(value);
            if (age < 1 || age > 1000) {
                result.setInvalid(ErrorBuilder.buildInvalidKeyValueError(MAX_VIDEO_LENGTH, this.mProviderName, "maxVideoLength value should be between 1-1000"));
            }
        }
        catch (NumberFormatException e) {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError(MAX_VIDEO_LENGTH, this.mProviderName, "maxVideoLength value should be between 1-1000"));
        }
    }

    private void validateLanguage(String value, ConfigValidationResult result) {
        if (value != null) {
            String pattern;
            if (!(value = value.trim()).matches(pattern = "^[a-zA-Z]*$") || value.length() != 2) {
                result.setInvalid(ErrorBuilder.buildInvalidKeyValueError(LANGUAGE, this.mProviderName, "language value should be two letters format."));
            }
        } else {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError(LANGUAGE, this.mProviderName, "language value should be two letters format."));
        }
    }

    private void validateAgeGroup(String value, ConfigValidationResult result) {
        try {
            value = value.trim();
            int age = Integer.parseInt(value);
            if (age < 0 || age > 8) {
                result.setInvalid(ErrorBuilder.buildInvalidKeyValueError(APPLICATION_USER_AGE_GROUP, this.mProviderName, "applicationUserAgeGroup value should be between 0-8"));
            }
        }
        catch (NumberFormatException e) {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError(APPLICATION_USER_AGE_GROUP, this.mProviderName, "applicationUserAgeGroup value should be between 0-8"));
        }
    }

    private void validateGender(String gender, ConfigValidationResult result) {
        try {
            if (!(gender == null || "male".equals(gender = gender.toLowerCase().trim()) || "female".equals(gender) || "unknown".equals(gender))) {
                result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("gender", this.mProviderName, "gender value should be one of male/female/unknown."));
            }
        }
        catch (Exception e) {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("gender", this.mProviderName, "gender value should be one of male/female/unknown."));
        }
    }

    private void validateClientSideCallbacks(String value, ConfigValidationResult result) {
        this.validateBoolean(CLIENT_SIDE_CALLBACKS, value, result);
    }

    @Override
    protected void validateMandatoryField(JSONObject config, String key, ConfigValidationResult result) {
        try {
            String value = config.optString(key);
            if ("applicationKey".equals(key)) {
                this.validateApplicationKey(value, result);
            } else if ("userId".equals(key)) {
                this.validateUserId(value, result);
            } else if ("controllerUrl".equals(key)) {
                this.validateDynamicUrl(value, result);
            }
        }
        catch (Throwable e) {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError(key, this.mProviderName, null));
        }
    }

    @Override
    protected void adapterPostValidation(JSONObject config, ConfigValidationResult result) {
        try {
            this.validatePrivateKeyItemNameCountCombination(config, result);
        }
        catch (Exception e) {
            result.setInvalid(ErrorBuilder.buildGenericError(""));
        }
    }

    private void validatePrivateKeyItemNameCountCombination(JSONObject config, ConfigValidationResult result) {
        if (!(!config.has("privateKey") && !config.has(ITEM_NAME) && !config.has(ITEM_COUNT) || config.has("privateKey") && config.has(ITEM_NAME) && config.has(ITEM_COUNT))) {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("itemName, itemCount or privateKey", this.mProviderName, "configure itemName/itemCount requires the following configurations: itemName, itemCount and privateKey"));
        }
    }

    private void validateUserId(String value, ConfigValidationResult result) {
        if (value != null) {
            if (value.length() < 1 || value.length() > 64) {
                result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("userId", this.mProviderName, "userId value should be between 1-64 characters"));
            }
        } else {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("userId", this.mProviderName, "userId is missing"));
        }
    }

    private void validateDynamicUrl(String value, ConfigValidationResult result) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("controllerUrl", this.mProviderName, "controllerUrl is missing"));
        }
    }

    private void validateApplicationKey(String value, ConfigValidationResult result) {
        if (value != null) {
            if ((value = value.trim()).length() >= 5 && value.length() <= 10) {
                String pattern = "^[a-zA-Z0-9]*$";
                if (!value.matches(pattern)) {
                    result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("applicationKey", this.mProviderName, "applicationKey value should contains only english characters and numbers"));
                }
            } else {
                result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("applicationKey", this.mProviderName, "applicationKey length should be between 5-10 characters"));
            }
        } else {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("applicationKey", this.mProviderName, "applicationKey value is missing"));
        }
    }
}

