/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.service;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.sdk.Events.ISNEventParams;
import com.ironsource.sdk.Events.ISNEventsTracker;
import com.ironsource.sdk.Events.SDK5Events;
import com.ironsource.sdk.utils.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class PackagesInstallationService {
    private static final String TAG = PackagesInstallationService.class.getSimpleName();
    private static final ArrayList<String> googlePlayAppPackageNames = new ArrayList<String>(){
        {
            this.add("com.google.market");
            this.add("com.android.vending");
        }
    };

    private static JSONObject getGooglePlayAppPackagesInstallationData(Context context) {
        return PackagesInstallationService.checkInstalledPackages(context, googlePlayAppPackageNames);
    }

    public static boolean isGooglePlayInstalled(Context context) {
        JSONObject googlePlayPackagesInstallationData = PackagesInstallationService.getGooglePlayAppPackagesInstallationData(context);
        Iterator googlePlayPackagesKeys = googlePlayPackagesInstallationData.keys();
        while (googlePlayPackagesKeys.hasNext()) {
            String packageName = (String)googlePlayPackagesKeys.next();
            JSONObject packageData = googlePlayPackagesInstallationData.optJSONObject(packageName);
            if (packageData == null || !packageData.optBoolean("isInstalled")) continue;
            return true;
        }
        return false;
    }

    public static JSONObject checkInstalledPackage(Context context, final String packageToCheck) {
        return PackagesInstallationService.checkInstalledPackages(context, new ArrayList<String>(){
            {
                this.add(packageToCheck);
            }
        });
    }

    private static JSONObject checkInstalledPackages(Context context, ArrayList<String> packagesToCheck) {
        JSONObject result = new JSONObject();
        try {
            ArrayList<String> packagesOnDevice = PackagesInstallationService.getInstalledPackageNamesOnDevice(context);
            for (String packageToCheck : packagesToCheck) {
                boolean isInstalled = packagesOnDevice.contains(packageToCheck.trim().toLowerCase());
                result.put(packageToCheck, (Object)PackagesInstallationService.buildAppPackageInstallationObject(isInstalled));
            }
        }
        catch (Exception e2) {
            ISNEventParams params = new ISNEventParams().addPair("callfailreason", e2.getMessage()).addPair("generalmessage", packagesToCheck.toString());
            ISNEventsTracker.logEvent(SDK5Events.extractInstalledPackagesFailed, params.getData());
            Logger.d(TAG, "Error while extracting packages installation data");
        }
        return result;
    }

    private static JSONObject buildAppPackageInstallationObject(final boolean isInstalled) throws JSONException {
        return new JSONObject(){
            {
                this.put("isInstalled", isInstalled);
            }
        };
    }

    private static ArrayList<String> getInstalledPackageNamesOnDevice(Context context) {
        List<ApplicationInfo> packages = DeviceStatus.getInstalledApplications(context);
        ArrayList<String> packagesOnDevice = new ArrayList<String>();
        for (ApplicationInfo packageInfo : packages) {
            if (packageInfo == null) continue;
            packagesOnDevice.add(packageInfo.packageName.toLowerCase());
        }
        return packagesOnDevice;
    }
}

