/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import android.content.Context;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.sdk.controller.WebController;
import com.ironsource.sdk.data.SSAObj;
import com.ironsource.sdk.utils.Logger;
import com.ironsource.sdk.utils.SDKUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceDataJSAdapter {
    private Context mContext;
    private static final String TAG = DeviceDataJSAdapter.class.getSimpleName();
    private static final String GET_DEVICE_DATA = "getDeviceData";
    private static final String DEVICE_DATA_FUNCTION_PROPERTY_NAME = "deviceDataFunction";
    private static final String DEVICE_DATA_PARAMS_PROPERTY_NAME = "deviceDataParams";
    private static final String SUCCESS_JS_CALLBACK_NAME = "success";
    private static final String FAIL_JS_CALLBACK_NAME = "fail";

    public DeviceDataJSAdapter(Context context) {
        this.mContext = context;
    }

    void call(String params, WebController.NativeAPI.JSCallbackTask callback) throws Exception {
        FunctionCall fCall = this.fetchFunctionCall(params);
        if (GET_DEVICE_DATA.equals(fCall.name)) {
            callback.sendMessage(true, fCall.successCallback, this.getDeviceData());
        } else {
            Logger.i(TAG, "unhandled API request " + params);
        }
    }

    private SSAObj getDeviceData() {
        SSAObj deviceData = new SSAObj();
        deviceData.put(SDKUtils.encodeString("sdCardAvailable"), SDKUtils.encodeString(String.valueOf(DeviceStatus.isExternalMemoryAvailableWritable())));
        deviceData.put(SDKUtils.encodeString("totalDeviceRAM"), SDKUtils.encodeString(String.valueOf(DeviceStatus.getTotalDeviceRAM(this.mContext))));
        deviceData.put(SDKUtils.encodeString("isCharging"), SDKUtils.encodeString(String.valueOf(DeviceStatus.isCharging(this.mContext))));
        deviceData.put(SDKUtils.encodeString("chargingType"), SDKUtils.encodeString(String.valueOf(DeviceStatus.chargingType(this.mContext))));
        deviceData.put(SDKUtils.encodeString("airplaneMode"), SDKUtils.encodeString(String.valueOf(DeviceStatus.isAirplaneMode(this.mContext))));
        deviceData.put(SDKUtils.encodeString("stayOnWhenPluggedIn"), SDKUtils.encodeString(String.valueOf(DeviceStatus.isStayOnWhenPluggedIn(this.mContext))));
        return deviceData;
    }

    private FunctionCall fetchFunctionCall(String params) throws JSONException {
        JSONObject functionData = new JSONObject(params);
        FunctionCall res = new FunctionCall();
        res.name = functionData.optString(DEVICE_DATA_FUNCTION_PROPERTY_NAME);
        res.params = functionData.optJSONObject(DEVICE_DATA_PARAMS_PROPERTY_NAME);
        res.successCallback = functionData.optString(SUCCESS_JS_CALLBACK_NAME);
        res.failCallback = functionData.optString(FAIL_JS_CALLBACK_NAME);
        return res;
    }

    private static class FunctionCall {
        String name;
        JSONObject params;
        String successCallback;
        String failCallback;

        private FunctionCall() {
        }
    }
}

