/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.network;

import android.net.Uri;
import android.util.Log;
import android.util.Pair;
import com.ironsource.network.Response;
import com.ironsource.network.Utils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;

public class ISHttpService {
    private static final String HTTP_METHOD_POST = "POST";
    private static final String HTTP_METHOD_GET = "GET";
    private static final String TAG = "ISHttpService";

    public static Response sendGETRequest(String endpoint, String data, List<Pair<String, String>> headers) throws Exception {
        Uri.Builder builder = Uri.parse((String)endpoint).buildUpon();
        Uri uri = builder.encodedQuery(data).build();
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.setEndpoint(uri.toString()).setData(data).setMethod(HTTP_METHOD_GET).addHeaders(headers);
        return ISHttpService.sendRequest(requestBuilder.build());
    }

    public static Response sendPOSTRequest(String endpoint, String data, List<Pair<String, String>> headers) throws Exception {
        Request.Builder builder = new Request.Builder();
        builder.setEndpoint(endpoint).setData(data).setMethod(HTTP_METHOD_POST).addHeaders(headers);
        return ISHttpService.sendRequest(builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response sendRequest(Request request) throws Exception {
        Response response;
        block11: {
            if (!ISHttpService.areRequestParametersValid(request.endpoint, request.data)) {
                throw new InvalidParameterException("not valid params");
            }
            response = new Response();
            HttpURLConnection connection = null;
            InputStream stream = null;
            try {
                connection = ISHttpService.createConnection(request);
                ISHttpService.setHeaders(connection, request.headers);
                if (request.allowRequestBody()) {
                    ISHttpService.writeRequestBody(connection, request);
                }
                stream = connection.getInputStream();
                response.responseCode = connection.getResponseCode();
                if (stream != null) {
                    response.data = Utils.getBytes(stream);
                }
            }
            catch (IOException e2) {
                if (connection != null && (response.responseCode = connection.getResponseCode()) >= 400) {
                    Log.d((String)TAG, (String)("Failed post to " + request.endpoint + " StatusCode: " + response.responseCode));
                    break block11;
                }
                throw e2;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return response;
    }

    private static void setHeaders(HttpURLConnection connection, List<Pair<String, String>> headers) throws ProtocolException {
        for (Pair<String, String> header : headers) {
            connection.setRequestProperty((String)header.first, (String)header.second);
        }
    }

    private static void writeRequestBody(HttpURLConnection connection, Request request) throws Exception {
        connection.setDoOutput(true);
        try (DataOutputStream out = new DataOutputStream(connection.getOutputStream());){
            out.write(request.data.getBytes(request.encoding));
            out.flush();
            out.close();
            out = null;
        }
    }

    private static boolean areRequestParametersValid(String endpoint, String data) {
        return endpoint != null && !endpoint.isEmpty() && data != null && !data.isEmpty();
    }

    private static HttpURLConnection createConnection(Request request) throws IOException {
        URL url = new URL(request.endpoint);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(request.connectTimeOut);
        connection.setReadTimeout(request.readTimeOut);
        connection.setRequestMethod(request.method);
        return connection;
    }

    public static class Request {
        private static final int DEFAULT_READ_TIMEOUT_MILLIS = 15000;
        private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 15000;
        private static final String DEFAULT_ENCODING = "UTF-8";
        final String endpoint;
        final String method;
        final String data;
        final int connectTimeOut;
        final int readTimeOut;
        final String encoding;
        ArrayList<Pair<String, String>> headers;

        public Request(Builder builder) {
            this.endpoint = builder.endpoint;
            this.method = builder.method;
            this.data = builder.data;
            this.headers = new ArrayList<Pair<String, String>>(builder.headers);
            this.connectTimeOut = builder.connectTimeOut;
            this.readTimeOut = builder.readTimeOut;
            this.encoding = builder.encoding;
        }

        boolean allowRequestBody() {
            return ISHttpService.HTTP_METHOD_POST.equals(this.method);
        }

        static class Builder {
            List<Pair<String, String>> headers = new ArrayList<Pair<String, String>>();
            String endpoint;
            String method = "POST";
            String data;
            int connectTimeOut = 15000;
            int readTimeOut = 15000;
            String encoding = "UTF-8";

            Builder() {
            }

            Builder setData(String data) {
                this.data = data;
                return this;
            }

            Builder setEncoding(String encoding) {
                this.encoding = encoding;
                return this;
            }

            Builder setReadTimeOut(int readTimeOut) {
                this.readTimeOut = readTimeOut;
                return this;
            }

            Builder setConnectTimeOut(int connectTimeOut) {
                this.connectTimeOut = connectTimeOut;
                return this;
            }

            Builder setEndpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            Builder addHeader(Pair<String, String> header) {
                this.headers.add(header);
                return this;
            }

            Builder addHeaders(List<Pair<String, String>> headers) {
                this.headers.addAll(headers);
                return this;
            }

            Builder setMethod(String method) {
                this.method = method;
                return this;
            }

            Request build() {
                return new Request(this);
            }
        }
    }
}

