/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.model;

import com.ironsource.mediationsdk.model.ApplicationEvents;
import com.ironsource.mediationsdk.model.InterstitialPlacement;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import java.util.ArrayList;

public class InterstitialConfigurations {
    private ArrayList<InterstitialPlacement> mISPlacements = new ArrayList();
    private ApplicationEvents mISEvents;
    private int mISAdaptersSmartLoadAmount;
    private boolean mISAdvancedLoading;
    private int mISAdaptersTimeoutInSeconds;
    private int mISDelayLoadFailureNotificationInSeconds;
    private String mBackFillProviderName;
    private String mPremiumProviderName;
    private AuctionSettings mISAuctionSettings;
    private static final int DEFAULT_IS_PLACEMENT_ID = 0;
    private InterstitialPlacement mDefaultISPlacement;

    public InterstitialConfigurations() {
        this.mISEvents = new ApplicationEvents();
    }

    public InterstitialConfigurations(int adaptersSmartLoadAmount, boolean advancedLoading, int adaptersSmartLoadTimeout, ApplicationEvents events, AuctionSettings auctionSettings, int delayLoadFailure) {
        this.mISAdaptersSmartLoadAmount = adaptersSmartLoadAmount;
        this.mISAdvancedLoading = advancedLoading;
        this.mISAdaptersTimeoutInSeconds = adaptersSmartLoadTimeout;
        this.mISEvents = events;
        this.mISAuctionSettings = auctionSettings;
        this.mISDelayLoadFailureNotificationInSeconds = delayLoadFailure;
    }

    public void addInterstitialPlacement(InterstitialPlacement placement) {
        if (placement != null) {
            this.mISPlacements.add(placement);
            if (this.mDefaultISPlacement == null) {
                this.mDefaultISPlacement = placement;
            } else if (placement.getPlacementId() == 0) {
                this.mDefaultISPlacement = placement;
            }
        }
    }

    public InterstitialPlacement getInterstitialPlacement(String placementName) {
        for (InterstitialPlacement placement : this.mISPlacements) {
            if (!placement.getPlacementName().equals(placementName)) continue;
            return placement;
        }
        return null;
    }

    public InterstitialPlacement getDefaultInterstitialPlacement() {
        for (InterstitialPlacement placement : this.mISPlacements) {
            if (!placement.isDefault()) continue;
            return placement;
        }
        return this.mDefaultISPlacement;
    }

    public int getInterstitialAdaptersSmartLoadAmount() {
        return this.mISAdaptersSmartLoadAmount;
    }

    public boolean getInterstitialAdvancedLoading() {
        return this.mISAdvancedLoading;
    }

    public int getInterstitialAdaptersSmartLoadTimeout() {
        return this.mISAdaptersTimeoutInSeconds;
    }

    public ApplicationEvents getInterstitialEventsConfigurations() {
        return this.mISEvents;
    }

    public String getBackFillProviderName() {
        return this.mBackFillProviderName;
    }

    public void setBackFillProviderName(String backFillProviderName) {
        this.mBackFillProviderName = backFillProviderName;
    }

    public String getPremiumProviderName() {
        return this.mPremiumProviderName;
    }

    public void setPremiumProviderName(String premiumProviderName) {
        this.mPremiumProviderName = premiumProviderName;
    }

    public AuctionSettings getInterstitialAuctionSettings() {
        return this.mISAuctionSettings;
    }

    public int getISDelayLoadFailure() {
        return this.mISDelayLoadFailureNotificationInSeconds;
    }
}

