/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.logger;

import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;

public enum IronLog {
    API(IronSourceLogger.IronSourceTag.API),
    CALLBACK(IronSourceLogger.IronSourceTag.CALLBACK),
    ADAPTER_API(IronSourceLogger.IronSourceTag.ADAPTER_API),
    ADAPTER_CALLBACK(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK),
    NETWORK(IronSourceLogger.IronSourceTag.NETWORK),
    INTERNAL(IronSourceLogger.IronSourceTag.INTERNAL),
    NATIVE(IronSourceLogger.IronSourceTag.NATIVE),
    EVENT(IronSourceLogger.IronSourceTag.EVENT);

    IronSourceLogger.IronSourceTag mTag;

    private IronLog(IronSourceLogger.IronSourceTag tag) {
        this.mTag = tag;
    }

    public void verbose(String message) {
        IronSourceLoggerManager.getLogger().log(this.mTag, this.createLogMessage(message), 0);
    }

    public void info(String message) {
        IronSourceLoggerManager.getLogger().log(this.mTag, this.createLogMessage(message), 1);
    }

    public void warning(String message) {
        IronSourceLoggerManager.getLogger().log(this.mTag, this.createLogMessage(message), 2);
    }

    public void error(String message) {
        IronSourceLoggerManager.getLogger().log(this.mTag, this.createLogMessage(message), 3);
    }

    private String createLogMessage(String message) {
        if (message.isEmpty()) {
            return this.getLogPrefix();
        }
        return String.format("%s - %s", this.getLogPrefix(), message);
    }

    private String getLogPrefix() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int depth = 5;
        String className = this.getClassName(stackTrace, depth);
        String methodName = this.getMethodName(stackTrace, depth);
        return String.format("%s %s", className, methodName);
    }

    private String getClassName(StackTraceElement[] stackTrace, int depth) {
        String[] classPackage = stackTrace[depth].getClassName().split("\\.");
        String className = classPackage[classPackage.length - 1];
        if (className.contains("$")) {
            className = className.split("\\$")[0];
        }
        return className;
    }

    private String getMethodName(StackTraceElement[] stackTrace, int depth) {
        String methodName;
        String[] classPackageSplitted = stackTrace[depth].getClassName().split("\\.");
        String className = classPackageSplitted[classPackageSplitted.length - 1];
        if (className.contains("$")) {
            String[] classNameSplitted = className.split("\\$");
            methodName = classNameSplitted[1] + "." + stackTrace[depth].getMethodName();
        } else {
            String[] classNameSplitted;
            methodName = stackTrace[depth].getMethodName().contains("$") ? ((classNameSplitted = stackTrace[depth + 1].getClassName().split("\\$")).length > 1 ? classNameSplitted[1] + "." + stackTrace[depth + 1].getMethodName() : stackTrace[depth + 1].getMethodName()) : stackTrace[depth].getMethodName();
        }
        return methodName;
    }
}

