/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import android.app.Activity;
import android.content.Context;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import com.ironsource.sdk.ISNAdView.ISNAdView;
import com.ironsource.sdk.controller.BannerJSAdapter;
import com.ironsource.sdk.controller.CommandExecutor;
import com.ironsource.sdk.controller.ControllerEventListener;
import com.ironsource.sdk.controller.DemandSourceManager;
import com.ironsource.sdk.controller.DeviceDataJSAdapter;
import com.ironsource.sdk.controller.IronSourceController;
import com.ironsource.sdk.controller.NativeController;
import com.ironsource.sdk.controller.OMIDJSAdapter;
import com.ironsource.sdk.controller.PermissionsJSAdapter;
import com.ironsource.sdk.controller.TokenJSAdapter;
import com.ironsource.sdk.controller.WebController;
import com.ironsource.sdk.data.DemandSource;
import com.ironsource.sdk.data.SSAEnums;
import com.ironsource.sdk.listeners.OnOfferWallListener;
import com.ironsource.sdk.listeners.internals.DSBannerListener;
import com.ironsource.sdk.listeners.internals.DSInterstitialListener;
import com.ironsource.sdk.listeners.internals.DSRewardedVideoListener;
import com.ironsource.sdk.service.TokenService;
import com.ironsource.sdk.utils.Logger;
import java.util.Map;
import org.json.JSONObject;

public class ControllerManager
implements ControllerEventListener {
    private String TAG = ControllerManager.class.getSimpleName();
    private IronSourceController mController;
    private SSAEnums.ControllerState mControllerState = SSAEnums.ControllerState.None;
    private CountDownTimer mGlobalControllerTimer;
    private CommandExecutor mCommandExecutor = new CommandExecutor();
    private CommandExecutor mControllerCommandsExecuter = new CommandExecutor();
    private static final Handler mUiHandler = new Handler(Looper.getMainLooper());

    public ControllerManager(Activity activity, TokenService tokenService, DemandSourceManager demandSourceManager) {
        this.createController(activity, tokenService, demandSourceManager);
    }

    private void createController(final Activity activity, final TokenService tokenService, final DemandSourceManager demandSourceManager) {
        mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    ControllerManager.this.createWebController(activity, tokenService, demandSourceManager);
                }
                catch (Exception webControllerException) {
                    webControllerException.printStackTrace();
                    ControllerManager.this.createNativeController(webControllerException.getMessage());
                }
            }
        });
    }

    private void createWebController(Activity activity, TokenService tokenService, DemandSourceManager demandSourceManager) throws Exception {
        this.mController = new WebController(activity, demandSourceManager, this);
        WebController controller = (WebController)this.mController;
        controller.addTokenJSInterface(new TokenJSAdapter(activity.getApplicationContext(), tokenService));
        controller.addOmidJSInterface(new OMIDJSAdapter(activity.getApplicationContext()));
        controller.addPermissionsJSInterface(new PermissionsJSAdapter(activity.getApplicationContext()));
        controller.addBannerJSInterface(new BannerJSAdapter());
        controller.addDeviceDataJSInterface(new DeviceDataJSAdapter(activity.getApplicationContext()));
        this.mGlobalControllerTimer = new CountDownTimer(200000L, 1000L){

            public void onTick(long millisUntilFinished) {
                Logger.i(ControllerManager.this.TAG, "Global Controller Timer Tick " + millisUntilFinished);
            }

            public void onFinish() {
                Logger.i(ControllerManager.this.TAG, "Global Controller Timer Finish");
                ControllerManager.this.destroyWebControllerIfExist();
                mUiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ControllerManager.this.createNativeController("Controller download timeout");
                    }
                });
            }
        }.start();
        controller.downloadController();
        this.mCommandExecutor.setReady();
        this.mCommandExecutor.purgeDelayedCommands();
    }

    private void destroyWebControllerIfExist() {
        if (this.mController != null) {
            this.mController.destroy();
        }
    }

    private void createNativeController(String errorReason) {
        this.mController = new NativeController(this);
        ((NativeController)this.mController).setFailedControllerReason(errorReason);
        this.mCommandExecutor.setReady();
        this.mCommandExecutor.purgeDelayedCommands();
    }

    private boolean isControllerStateReady() {
        return SSAEnums.ControllerState.Ready.equals((Object)this.mControllerState);
    }

    public void executeCommand(Runnable runnable) {
        this.mCommandExecutor.executeCommand(runnable);
    }

    @Override
    public void handleControllerStageLoaded() {
        this.mControllerState = SSAEnums.ControllerState.Loaded;
    }

    @Override
    public void handleControllerStageReady() {
        this.mControllerState = SSAEnums.ControllerState.Ready;
        if (this.mGlobalControllerTimer != null) {
            this.mGlobalControllerTimer.cancel();
        }
        this.mControllerCommandsExecuter.setReady();
        this.mControllerCommandsExecuter.purgeDelayedCommands();
        this.mController.restoreSavedState();
    }

    @Override
    public void handleControllerStageFailed(final String failureReason) {
        if (this.mGlobalControllerTimer != null) {
            this.mGlobalControllerTimer.cancel();
        }
        this.destroyWebControllerIfExist();
        mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.createNativeController(failureReason);
            }
        });
    }

    public void initOfferWall(final String applicationKey, final String userId, final Map<String, String> extraParameters, final OnOfferWallListener listener) {
        this.mControllerCommandsExecuter.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.initOfferWall(applicationKey, userId, extraParameters, listener);
            }
        });
    }

    public void showOfferWall(final Map<String, String> extraParameters) {
        this.mControllerCommandsExecuter.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.showOfferWall(extraParameters);
            }
        });
    }

    public void getOfferWallCredits(final String applicationKey, final String userId, final OnOfferWallListener listener) {
        this.mControllerCommandsExecuter.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.getOfferWallCredits(applicationKey, userId, listener);
            }
        });
    }

    public void initRewardedVideo(final String applicationKey, final String userId, final DemandSource demandSource, final DSRewardedVideoListener listener) {
        this.mControllerCommandsExecuter.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.initRewardedVideo(applicationKey, userId, demandSource, listener);
            }
        });
    }

    public void showRewardedVideo(final JSONObject showParams, final DSRewardedVideoListener listener) {
        this.mControllerCommandsExecuter.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.showRewardedVideo(showParams, listener);
            }
        });
    }

    public void initInterstitial(final String applicationKey, final String userId, final DemandSource demandSource, final DSInterstitialListener listener) {
        this.mControllerCommandsExecuter.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.initInterstitial(applicationKey, userId, demandSource, listener);
            }
        });
    }

    public void loadInterstitial(final String demandSourceName, final DSInterstitialListener listener) {
        this.mControllerCommandsExecuter.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.loadInterstitial(demandSourceName, listener);
            }
        });
    }

    public void loadInterstitial(final DemandSource demandSource, final Map<String, String> loadParams, final DSInterstitialListener listener) {
        this.mControllerCommandsExecuter.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.loadInterstitial(demandSource, loadParams, listener);
            }
        });
    }

    public void showInterstitial(final JSONObject showParams, final DSInterstitialListener listener) {
        this.mControllerCommandsExecuter.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.showInterstitial(showParams, listener);
            }
        });
    }

    public void showInterstitial(final DemandSource demandSource, final Map<String, String> showParams, final DSInterstitialListener listener) {
        this.mControllerCommandsExecuter.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.showInterstitial(demandSource, showParams, listener);
            }
        });
    }

    public boolean isInterstitialAdAvailable(String demandSourceName) {
        if (!this.isControllerStateReady()) {
            return false;
        }
        return this.mController.isInterstitialAdAvailable(demandSourceName);
    }

    public void initBanner(final String applicationKey, final String userId, final DemandSource demandSource, final DSBannerListener listener) {
        this.mControllerCommandsExecuter.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.initBanner(applicationKey, userId, demandSource, listener);
            }
        });
    }

    public void loadBanner(final JSONObject loadParams, final DSBannerListener listener) {
        this.mControllerCommandsExecuter.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.loadBanner(loadParams, listener);
            }
        });
    }

    public void updateConsentInfo(final JSONObject consentParams) {
        this.mControllerCommandsExecuter.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.updateConsentInfo(consentParams);
            }
        });
    }

    public void enterForeground() {
        if (this.isControllerStateReady()) {
            this.mController.enterForeground();
        }
    }

    public void enterBackground() {
        if (this.isControllerStateReady()) {
            this.mController.enterBackground();
        }
    }

    public void registerConnectionReceiver(Activity activity) {
        if (this.isControllerStateReady()) {
            this.mController.registerConnectionReceiver((Context)activity);
        }
    }

    public void unregisterConnectionReceiver(Activity activity) {
        if (this.isControllerStateReady()) {
            this.mController.unregisterConnectionReceiver((Context)activity);
        }
    }

    public void destroy() {
        if (this.mGlobalControllerTimer != null) {
            this.mGlobalControllerTimer.cancel();
        }
        this.mGlobalControllerTimer = null;
        mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.destroy();
                ControllerManager.this.mController = null;
            }
        });
    }

    public IronSourceController getController() {
        return this.mController;
    }

    public void setCommunicationWithAdView(ISNAdView isnAdView) {
        if (this.mController != null) {
            this.mController.setCommunicationWithAdView(isnAdView);
        }
    }
}

